/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.ve.internal.java.codegen.java.BeanPartFactory;
import org.eclipse.ve.internal.java.codegen.java.ExpressionRefFactory;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.ICodeDelta;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class CodeSnippetMergelet {
    ICodeDelta fBDMDelta;
    String fElementContent = null;
    String fElementHandle = null;
    boolean fisMethod;
    IBeanDeclModel fBeanModel = null;
    HashMap fExpressionsByMethod = new HashMap();

    public CodeSnippetMergelet(ICodeDelta delta, String elementContent, String elementHandle, boolean isMethodElement) {
        this.fBDMDelta = delta;
        this.fElementContent = elementContent;
        this.fElementHandle = elementHandle;
        this.fisMethod = isMethodElement;
    }

    private CodeMethodRef getOriginalMethodElement() throws CodeGenException {
        if (!this.fisMethod) {
            throw new CodeGenException("Invalid Context");
        }
        return this.fBeanModel.getMethodInitializingABean(this.fElementHandle);
    }

    private List getExpressions(CodeMethodRef m) {
        ArrayList l = (ArrayList)this.fExpressionsByMethod.get(m);
        if (l == null) {
            l = new ArrayList();
            this.fExpressionsByMethod.put(m, l);
            Iterator itr = m.getAllExpressions();
            while (itr.hasNext()) {
                l.add(itr.next());
            }
        }
        return l;
    }

    private CodeExpressionRef getOriginal(CodeExpressionRef exp) throws CodeGenException {
        if (!this.fisMethod) {
            throw new CodeGenException("Invalid Context");
        }
        CodeMethodRef m = this.getOriginalMethodElement();
        if (m == null) {
            return null;
        }
        Iterator itr = this.getExpressions(m).iterator();
        CodeExpressionRef result = null;
        while (itr.hasNext()) {
            CodeExpressionRef e = (CodeExpressionRef)itr.next();
            if (e == exp) {
                result = e;
                break;
            }
            int eqv = e.isEquivalent(exp);
            if (eqv < 0) continue;
            if (eqv == 1) {
                result = e;
                break;
            }
            if (result != null) continue;
            result = e;
        }
        if (result != null) {
            this.getExpressions(m).remove(result);
            return result;
        }
        return null;
    }

    private BeanPart getOriginal(BeanPart b) {
        Iterator itr = this.fBeanModel.getBeans().iterator();
        while (itr.hasNext()) {
            BeanPart bean = (BeanPart)itr.next();
            if (!bean.isEquivalent(b) || !bean.getUniqueName().equals(b.getUniqueName())) continue;
            return bean;
        }
        return null;
    }

    private CodeExpressionRef createNewExpression(CodeExpressionRef e, CodeMethodRef m, boolean decode) throws CodeGenException {
        if (this.getOriginal(e) != null) {
            throw new CodeGenException("duplicate Expression");
        }
        BeanPart b = this.getOriginal(e.getBean());
        if (b == null) {
            throw new CodeGenException("No Bean Part");
        }
        ExpressionRefFactory gen = new ExpressionRefFactory(b, null);
        CodeExpressionRef newe = gen.createFromSource(e, m);
        newe.setState(4, e.isStateSet(4));
        newe.setState(4096, e.isStateSet(4096));
        if (decode && !newe.decodeExpression()) {
            newe.dispose();
            newe = null;
        }
        return newe;
    }

    private CodeEventRef createNewEventExpression(CodeEventRef e, CodeMethodRef m, boolean decode) throws CodeGenException {
        if (this.getOriginal(e) != null) {
            throw new CodeGenException("duplicate Expression");
        }
        BeanPart b = this.getOriginal(e.getBean());
        if (b == null) {
            throw new CodeGenException("No Bean Part");
        }
        CodeEventRef newe = new CodeEventRef(m, b);
        newe.setState(4, e.isStateSet(4));
        newe.setState(4096, e.isStateSet(4096));
        newe.setState(128, true);
        newe.setExprStmt(e.getExprStmt());
        newe.setContent(e.getContentParser());
        newe.setOffset(e.getOffset());
        newe.setEventInvocation(e.getEventInvocation());
        if (decode && !newe.decodeExpression()) {
            newe.dispose();
            newe = null;
        }
        return newe;
    }

    private boolean processExpressionDelta(CodeExpressionRef dExp, CodeExpressionRef oExp, CodeMethodRef oMethod, int status) throws CodeGenException {
        boolean updated = false;
        if (oExp != null && dExp != null && !dExp.isStateSet(256)) {
            if (oExp.isEquivalent(dExp) < 0) {
                throw new CodeGenException("No the same Expressions");
            }
            oExp.setExprStmt(dExp.getExprStmt());
        }
        if (oExp != null && dExp != null) {
            oExp.updateLimboState(dExp);
        }
        if (oExp == null && status != 4 && status != 32 && JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("CodeSnippetMergelent.processExpressionDelta(): could not find" + dExp), (Level)Level.FINE);
        }
        switch (status) {
            case 32: {
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                    JavaVEPlugin.log((Object)("CodeSnippetMergelent.processExpressionDelta() In Limbo: " + oExp), (Level)Level.FINE);
                }
                if (oExp == null) break;
                oExp.setState(256, true);
                break;
            }
            case 16: {
                oExp.setOffset(dExp.getOffset());
                if (dExp instanceof CodeEventRef) break;
                oExp.refreshFromJOM(dExp);
                break;
            }
            case 1: {
                if (oExp == null) break;
                oExp.setContent(dExp.getContentParser());
                break;
            }
            case 8: {
                if (oExp == null) break;
                if (oExp.isStateSet(4096)) {
                    this.fBeanModel.setState(1, true);
                    return false;
                }
                if (oExp.getOffset() != dExp.getOffset()) {
                    oExp.setOffset(dExp.getOffset());
                }
                oExp.refreshFromJOM(dExp);
                updated = true;
                break;
            }
            case 2: {
                if (oExp == null) break;
                if (oExp.isStateSet(4096)) {
                    this.fBeanModel.setState(1, true);
                    return false;
                }
                oExp.dispose();
                updated = true;
                break;
            }
            case 4: {
                try {
                    if (dExp.isStateSet(4096)) {
                        this.fBeanModel.setState(1, true);
                        return false;
                    }
                    CodeExpressionRef newExp = this.createNewExpression(dExp, oMethod, !dExp.isStateSet(4));
                    if (newExp == null && dExp instanceof CodeEventRef) {
                        newExp = this.createNewEventExpression((CodeEventRef)dExp, oMethod, !dExp.isStateSet(4));
                    }
                    updated = true;
                }
                catch (CodeGenException codeGenException) {}
                break;
            }
            default: {
                throw new CodeGenException("Invalid Status");
            }
        }
        return updated;
    }

    private boolean updateMethodDelta(CodeMethodRef m, List deleteList) throws CodeGenException {
        CodeMethodRef oMethod = this.getOriginalMethodElement();
        boolean updated = false;
        if ((this.fBDMDelta.getElementStatus(m) & 0x20) == 32) {
            ArrayList deltaExpressions = new ArrayList();
            ArrayList oldExpressions = new ArrayList();
            Iterator newItr = m.getExpressions();
            Iterator oldItr = oMethod.getExpressions();
            while (newItr.hasNext()) {
                deltaExpressions.add(newItr.next());
            }
            while (oldItr.hasNext()) {
                oldExpressions.add(oldItr.next());
            }
            newItr = deltaExpressions.iterator();
            oldItr = oldExpressions.iterator();
            while (newItr.hasNext() && oldItr.hasNext()) {
                CodeExpressionRef dExp = (CodeExpressionRef)newItr.next();
                CodeExpressionRef oExp = (CodeExpressionRef)oldItr.next();
                updated |= this.processExpressionDelta(dExp, oExp, oMethod, this.fBDMDelta.getElementStatus(dExp));
            }
        } else {
            CodeExpressionRef oExp;
            CodeExpressionRef dExp;
            Iterator itr;
            if (deleteList != null) {
                itr = deleteList.iterator();
                while (itr.hasNext()) {
                    oExp = dExp = (CodeExpressionRef)itr.next();
                    updated |= this.processExpressionDelta(dExp, oExp, oMethod, this.fBDMDelta.getElementStatus(dExp));
                    if (!this.fBeanModel.isStateSet(1)) continue;
                    return updated;
                }
            }
            itr = m.getAllExpressions();
            while (itr.hasNext() && !this.fBeanModel.isStateSet(1)) {
                dExp = (CodeExpressionRef)itr.next();
                oExp = this.getOriginal(dExp);
                updated |= this.processExpressionDelta(dExp, oExp, oMethod, this.fBDMDelta.getElementStatus(dExp));
            }
        }
        return updated;
    }

    public boolean updateBDM(IBeanDeclModel model) throws CodeGenException {
        boolean modelUpdated;
        block10: {
            block9: {
                if (model == null || this.fElementHandle == null) {
                    throw new CodeGenException("Invalid Arg");
                }
                this.fBeanModel = model;
                modelUpdated = false;
                CodeMethodRef mref = this.fBDMDelta.getDeltaMethod();
                if (mref == null) break block9;
                switch (this.fBDMDelta.getElementStatus(mref)) {
                    case 1: {
                        break block10;
                    }
                    case 4: {
                        this.fBeanModel.setState(1, true);
                        modelUpdated = true;
                        break block10;
                    }
                    case 2: {
                        this.fBeanModel.setState(1, true);
                        modelUpdated = true;
                        break block10;
                    }
                    case 8: 
                    case 16: 
                    case 32: {
                        modelUpdated |= this.updateMethodDelta(mref, this.fBDMDelta.getDeletedElements(mref));
                        if (this.fBeanModel.isStateSet(1)) {
                            return modelUpdated;
                        }
                        CodeMethodRef oriMref = this.getOriginalMethodElement();
                        BeanPartFactory.fixOffsetIfNeeded(this.fElementContent, oriMref);
                        break block10;
                    }
                    default: {
                        throw new CodeGenException("Invalid State");
                    }
                }
            }
            if (JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) {
                JavaVEPlugin.log((Object)"CodeSnippetMerglent.updateBDM() : no CodeMethodRef", (Level)Level.WARNING);
            }
        }
        return modelUpdated;
    }
}

