/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.ve.internal.java.codegen.java.CodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.IEventDecoder;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.AbstractEventInvocation;
import org.eclipse.ve.internal.jcm.Callback;
import org.eclipse.ve.internal.jcm.PropertyEvent;

public class EventDecoderAdapter
implements ICodeGenAdapter {
    AbstractEventInvocation fTarget = null;
    IEventDecoder fDecoder;

    public EventDecoderAdapter(IEventDecoder decoder) {
        this.fDecoder = decoder;
    }

    public ICodeGenSourceRange getBDMSourceRange() throws CodeGenException {
        return new CodeGenSourceRange(this.fDecoder.getExprRef().getOffset(), this.fDecoder.getExprRef().getLen());
    }

    public ICodeGenSourceRange getHighlightSourceRange() throws CodeGenException {
        return this.getJavaSourceRange();
    }

    public ICodeGenSourceRange getJavaSourceRange() throws CodeGenException {
        return this.fDecoder.getExprRef().getTargetSourceRange();
    }

    public Notifier getTarget() {
        return this.fTarget;
    }

    public boolean isAdapterForType(Object type) {
        return JVE_CODE_GEN_TYPE.equals(type) || JVE_CODEGEN_EXPRESSION_SOURCE_RANGE.equals(type) || JVE_CODEGEN_EVENT_ADAPTER.equals(type);
    }

    protected void processMany(Notification msg) {
        if (msg.getEventType() == 5) {
            List al = (List)msg.getNewValue();
            int i = 0;
            Iterator aitr = al.iterator();
            int pos = msg.getPosition();
            while (aitr.hasNext()) {
                int mpos = pos < 0 ? pos : pos + i++;
                Object o = aitr.next();
                this.notifyChanged((Notification)new ENotificationImpl((InternalEObject)msg.getNotifier(), 3, (EStructuralFeature)msg.getFeature(), null, o, mpos));
            }
        } else {
            List rl = (List)msg.getOldValue();
            Iterator ritr = rl.iterator();
            int pos = msg.getPosition();
            while (ritr.hasNext()) {
                Object o = ritr.next();
                this.notifyChanged((Notification)new ENotificationImpl((InternalEObject)msg.getNotifier(), 4, (EStructuralFeature)msg.getFeature(), o, null, pos));
            }
        }
    }

    public void notifyChanged(Notification msg) {
        if (this.fDecoder.getBeanModel() == null || this.fDecoder.getBeanPart().getModel().isStateSet(4) || this.fDecoder.getBeanPart().getModel().isStateSet(8) || msg.getEventType() == 8) {
            return;
        }
        switch (msg.getEventType()) {
            case 5: 
            case 6: {
                this.processMany(msg);
                return;
            }
        }
        try {
            EObject val = (EObject)(msg.getNewValue() == null ? msg.getOldValue() : msg.getNewValue());
            if (val == null) {
                return;
            }
            switch (msg.getEventType()) {
                case 3: 
                case 4: {
                    if (val instanceof Callback) {
                        if (msg.getEventType() == 4) {
                            this.fDecoder.removeCallBack((Callback)msg.getOldValue());
                            break;
                        }
                        if (msg.getEventType() != 3) break;
                        this.fDecoder.addCallBack((Callback)msg.getNewValue());
                        break;
                    }
                    if (val instanceof PropertyEvent) {
                        if (msg.getEventType() == 4) {
                            this.fDecoder.removePropertyEvent((PropertyEvent)msg.getOldValue());
                            break;
                        }
                        if (msg.getEventType() != 3) break;
                        this.fDecoder.addPropertyEvent((PropertyEvent)msg.getNewValue());
                        break;
                    }
                    this.fDecoder.reflectMOFchange();
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    this.fDecoder.reflectMOFchange();
                }
            }
        }
        catch (Throwable t) {
            JavaVEPlugin.log((Throwable)t, (Level)Level.WARNING);
        }
    }

    public void setTarget(Notifier arg0) {
        this.fTarget = (AbstractEventInvocation)arg0;
    }

    public IEventDecoder getDecoder() {
        return this.fDecoder;
    }

    public String toString() {
        return "\tEventDecoderAdapter:" + this.fDecoder;
    }

    public ICodeGenAdapter getCallBackSourceRangeAdapter(final Callback cb) {
        return new ICodeGenAdapter(){

            public ICodeGenSourceRange getHighlightSourceRange() throws CodeGenException {
                return this.getJavaSourceRange();
            }

            public ICodeGenSourceRange getJavaSourceRange() throws CodeGenException {
                return EventDecoderAdapter.this.fDecoder.getCallBackSourceRange(cb);
            }

            public ICodeGenSourceRange getBDMSourceRange() throws CodeGenException {
                return null;
            }

            public void notifyChanged(Notification notification) {
            }

            public Notifier getTarget() {
                return EventDecoderAdapter.this.getTarget();
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return JVE_CODE_GEN_TYPE.equals(type);
            }
        };
    }

    public ICodeGenAdapter getPropertyEventSourceRangeAdapter(final PropertyEvent pe) {
        return new ICodeGenAdapter(){

            public ICodeGenSourceRange getHighlightSourceRange() throws CodeGenException {
                return this.getJavaSourceRange();
            }

            public ICodeGenSourceRange getJavaSourceRange() throws CodeGenException {
                return EventDecoderAdapter.this.fDecoder.getPropertyEventSourceRange(pe);
            }

            public ICodeGenSourceRange getBDMSourceRange() throws CodeGenException {
                return null;
            }

            public void notifyChanged(Notification notification) {
            }

            public Notifier getTarget() {
                return this.getTarget();
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return JVE_CODE_GEN_TYPE.equals(type);
            }
        };
    }
}

