/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.impl.JavaClassImpl;
import org.eclipse.ve.internal.java.codegen.java.CodeGenJavaMessages;
import org.eclipse.ve.internal.java.codegen.java.ISourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IThisReferenceRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.BeanPartDecleration;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class ExpressionVisitor
extends SourceVisitor {
    CodeMethodRef fMethod = null;
    CodeExpressionRef fExpression = null;

    public void initialize(CodeMethodRef method, Statement stmt, IBeanDeclModel model, List reTryList) {
        super.initialize((ASTNode)stmt, model, reTryList);
        this.fMethod = method;
        try {
            this.fExpression = new CodeExpressionRef(stmt, this.fMethod);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BeanPart getBeanPart(String name, CodeMethodRef m) {
        return CodeGenUtil.getBeanPart(this.fModel, name, m, this.fExpression.getOffset());
    }

    BeanPart processSingleNameReference(MethodInvocation stmt) {
        String name = ((SimpleName)stmt.getExpression()).getIdentifier();
        return this.getBeanPart(name, this.fMethod);
    }

    BeanPart processRefToMessageSend(MethodInvocation stmt) {
        String selector = ((MethodInvocation)stmt.getExpression()).getName().getIdentifier();
        BeanPart b = null;
        if (selector != null && (b = this.fModel.getBeanReturned(selector)) == null && this.fReTryLater != null) {
            this.fReTryLater.add(this);
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                JavaVEPlugin.log((Object)("\t[Expression] - postponing: " + stmt), (Level)Level.FINE);
            }
        }
        return b;
    }

    BeanPart processRefToThis(MethodInvocation stmt) {
        IThisReferenceRule thisRule;
        BeanPart bean = this.fModel.getABean("this");
        if (bean != null && (thisRule = (IThisReferenceRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleIThisReference")) != null) {
            ISourceVisitor override = thisRule.overideThisReferenceVisit(this.fMethod.getDeclMethod(), stmt, this.fModel);
            if (override != null) {
                override.visit();
                return null;
            }
            if (thisRule.shouldProcess(this.fMethod.getDeclMethod(), stmt, this.fModel.getClassHierarchy())) {
                bean.addInitMethod(this.fMethod);
                return bean;
            }
        }
        return null;
    }

    protected BeanPart processFieldAccess(MethodInvocation stmt) {
        FieldAccess f = (FieldAccess)stmt.getExpression();
        if (f.getExpression() instanceof ThisExpression) {
            String name = f.getName().getIdentifier();
            return this.getBeanPart(name, this.fMethod);
        }
        return null;
    }

    protected BeanPart[] processCreateMethod(MethodInvocation stmt, boolean canRetry) {
        ArrayList<BeanPart> beans = new ArrayList<BeanPart>();
        List l = this.fModel.getBeans();
        int i = 0;
        while (i < l.size()) {
            BeanPart bp = (BeanPart)l.get(i);
            if (bp.getInitMethod() != null) {
                String iMethod = bp.getInitMethod().getMethodName();
                if (iMethod.equals(stmt.getName().getIdentifier())) {
                    beans.add(bp);
                }
            } else if (canRetry) {
                return new BeanPart[0];
            }
            ++i;
        }
        return beans.toArray(new BeanPart[beans.size()]);
    }

    protected boolean isSetStatement(MethodInvocation stmt) {
        return stmt.arguments() != null && stmt.arguments().size() == 1 && stmt.getName().getIdentifier().startsWith("set");
    }

    protected void processAMessageSend() {
        MethodInvocation stmt = (MethodInvocation)((ExpressionStatement)this.fExpression.getExprStmt()).getExpression();
        if (stmt == null) {
            return;
        }
        BeanPart bean = null;
        if (stmt.getExpression() instanceof SimpleName) {
            bean = this.processSingleNameReference(stmt);
        } else if (stmt.getExpression() instanceof MethodInvocation) {
            bean = this.processRefToMessageSend(stmt);
            if (bean == null && this.fReTryLater != null) {
                return;
            }
        } else if (stmt.getExpression() instanceof FieldAccess) {
            bean = this.processFieldAccess(stmt);
        } else if (stmt.getExpression() instanceof ThisExpression || this.isSetStatement(stmt)) {
            bean = this.processRefToThis(stmt);
        } else if (stmt.getExpression() == null) {
            BeanPart[] bs = this.processCreateMethod(stmt, this.fReTryLater != null);
            if (bs.length == 0) {
                if (this.fReTryLater != null) {
                    this.fReTryLater.add(this);
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                        JavaVEPlugin.log((Object)("\t[Expression] - postponing: " + stmt), (Level)Level.FINE);
                    }
                    return;
                }
                bean = this.processRefToThis(stmt);
            } else {
                int i = 0;
                while (i < bs.length) {
                    bs[i].addParentExpression(this.fExpression);
                    ++i;
                }
            }
        }
        if (bean != null) {
            this.fExpression.setBean(bean);
            bean.addRefExpression(this.fExpression);
        } else if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("\t[Expression] Visitor.processAMessageSend() did not process: " + stmt), (Level)Level.FINE);
        }
    }

    protected boolean isStaticCall(String resolvedReciever, String selector, int argc) {
        EClassifier rClass = CodeGenUtil.getMetaClass(resolvedReciever, this.fModel.getCompositionModel());
        if (rClass != null && rClass instanceof JavaClassImpl) {
            JavaClassImpl Clazz = (JavaClassImpl)rClass;
            Iterator itr = Clazz.getPublicMethods().iterator();
            while (itr.hasNext()) {
                Method element = (Method)itr.next();
                if (!element.getName().equals(selector) || !element.isStatic()) continue;
                if (element.getReturnType() == null) {
                    return false;
                }
                if (element.getParameters().size() != argc) continue;
                return true;
            }
        }
        return false;
    }

    protected BeanPart getBeanWithNoInitExpression(String name, CodeMethodRef m) {
        BeanPartDecleration d = this.fModel.getModelDecleration(BeanPartDecleration.createDeclerationHandle(m, name));
        BeanPart b = null;
        if (d == null) {
            d = this.fModel.getModelDecleration(BeanPartDecleration.createDeclerationHandle(null, name));
        }
        if (d != null) {
            b = d.getBeanPartWithNoInitExpression();
        }
        if (d != null && b == null) {
            b = d.createAnotherBeanPartInstance(m);
        }
        return b;
    }

    protected void processAssignmment() {
        Assignment stmt = (Assignment)((ExpressionStatement)this.fExpression.getExprStmt()).getExpression();
        Expression lhs = stmt.getLeftHandSide();
        if (lhs instanceof SimpleName || lhs instanceof FieldAccess && ((FieldAccess)lhs).getExpression() instanceof ThisExpression) {
            String name = lhs instanceof SimpleName ? ((SimpleName)lhs).getIdentifier() : ((FieldAccess)lhs).getName().getIdentifier();
            BeanPart bean = this.getBeanWithNoInitExpression(name, this.fMethod);
            if (bean != null) {
                this.fExpression.setBean(bean);
                boolean initExpr = true;
                if (initExpr) {
                    bean.addInitMethod(this.fMethod);
                    this.fExpression.setState(2, true);
                    this.fExpression.setState(4096, true);
                } else if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                    JavaVEPlugin.log((Object)("\t[Expression] Visitor.processAssignmment() did not process: " + stmt), (Level)Level.FINE);
                }
            }
        } else if (stmt.getLeftHandSide() instanceof QualifiedName) {
            String bName = ((QualifiedName)stmt.getLeftHandSide()).getQualifier().toString();
            BeanPart bean = this.getBeanPart(bName, this.fMethod);
            if (bean != null) {
                this.fExpression.setBean(bean);
                bean.addRefExpression(this.fExpression);
                bean.getModel().addMethodInitializingABean(this.fMethod);
            }
        } else if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("\t[Expression] Visitor.processAssignmment() did not process: " + stmt), (Level)Level.FINE);
        }
    }

    protected void processLocalDeclarations() {
        VariableDeclarationStatement stmt = (VariableDeclarationStatement)this.fExpression.getExprStmt();
        VariableDeclaration dec = (VariableDeclaration)stmt.fragments().get(0);
        String name = dec.getName().getIdentifier();
        BeanPart bean = this.getBeanWithNoInitExpression(name, this.fMethod);
        this.fExpression.setBean(bean);
        bean.addInitMethod(this.fMethod);
        this.fExpression.setState(2, true);
        this.fExpression.setState(4096, true);
        bean.addRefExpression(this.fExpression);
        bean.getModel().addMethodInitializingABean(this.fMethod);
    }

    public void visit() {
        this.getProgressMonitor().subTask(MessageFormat.format(CodeGenJavaMessages.ExpressionVisitor_TypeMethodExpression, this.fMethod.getTypeRef().getSimpleName(), this.fMethod.getMethodName(), this.fExpression.getCodeContent()));
        if (this.fExpression.getExprStmt() instanceof ExpressionStatement) {
            Expression exp = ((ExpressionStatement)this.fExpression.getExprStmt()).getExpression();
            if (exp instanceof MethodInvocation) {
                this.processAMessageSend();
            } else if (exp instanceof Assignment) {
                this.processAssignmment();
            } else if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                JavaVEPlugin.log((Object)("\t[Expression] Visitor: *** did not process Expression:" + this.fVisitedNode), (Level)Level.FINE);
            }
        } else if (this.fExpression.getExprStmt() instanceof VariableDeclarationStatement) {
            this.processLocalDeclarations();
        } else if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("\t[Expression] Visitor: *** did not process Expression:" + this.fVisitedNode), (Level)Level.FINE);
        }
    }
}

