/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.TimerTests;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.codegen.core.IVEModelInstance;
import org.eclipse.ve.internal.java.codegen.java.CodeGenJavaMessages;
import org.eclipse.ve.internal.java.codegen.java.EventHandlerVisitor;
import org.eclipse.ve.internal.java.codegen.java.EventsParser;
import org.eclipse.ve.internal.java.codegen.java.ISourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.JavaSourceSynchronizer;
import org.eclipse.ve.internal.java.codegen.java.TypeVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IVisitorFactoryRule;
import org.eclipse.ve.internal.java.codegen.model.BeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.JavaElementInfo;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenSyntaxError;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.IWorkingCopyProvider;
import org.eclipse.ve.internal.java.codegen.util.TypeResolver;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class JavaBeanModelBuilder {
    public static final String ASTNODE_SOURCE_PROPERTY = "org.eclipse.ve.codegen.source";
    String fFileName = null;
    char[] fFileContent = null;
    char[][] fPackageName = null;
    boolean errors = false;
    CompilationUnit fastCU = null;
    IBeanDeclModel fModel = null;
    ICompilationUnit fCU = null;
    IWorkingCopyProvider fWCP = null;
    IVEModelInstance fDiagram = null;
    EditDomain fDomain = null;
    JavaSourceSynchronizer fSync = null;
    IProgressMonitor fMonitor = null;

    public JavaBeanModelBuilder(EditDomain d, String fileName, char[][] packageName, IProgressMonitor monitor) {
        this.fFileName = fileName;
        this.fPackageName = packageName;
        this.fDomain = d;
        this.fMonitor = monitor;
    }

    public void setDiagram(IVEModelInstance diag) {
        this.fDiagram = diag;
    }

    public JavaBeanModelBuilder(EditDomain d, JavaSourceSynchronizer sync, IWorkingCopyProvider wcp, String filePath, char[][] packageName, IProgressMonitor monitor) {
        this(d, filePath, packageName, monitor);
        this.fCU = wcp.getWorkingCopy(false);
        this.fWCP = wcp;
        this.fSync = sync;
    }

    protected char[] getFileContents() throws CodeGenException {
        char[] result = null;
        try {
            if (this.fCU == null) {
                throw new CodeGenException("Could not get a valid source text");
            }
            result = this.fCU.getSource().toCharArray();
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    protected CompilationUnit ParseJavaCode(IProgressMonitor pm) throws CodeGenException {
        TimerTests.basicTest.startStep("AST creation");
        try {
            IProblem[] problems;
            CompilationUnit result;
            ASTParser parser;
            String sourceBeingParsed = null;
            if (this.fCU != null) {
                if (this.fCU.isConsistent()) {
                    parser = ASTParser.newParser((int)2);
                    parser.setSource(this.fCU);
                    result = (CompilationUnit)parser.createAST(pm);
                } else {
                    result = this.fCU.reconcile(2, false, null, pm);
                }
                try {
                    sourceBeingParsed = this.fCU.getSource();
                }
                catch (JavaModelException jme) {
                    JavaVEPlugin.log((Throwable)jme, (Level)Level.WARNING);
                }
            } else {
                parser = ASTParser.newParser((int)2);
                this.fFileContent = this.getFileContents();
                sourceBeingParsed = new String(this.fFileContent);
                parser.setSource(this.fFileContent);
                result = (CompilationUnit)parser.createAST(pm);
            }
            if (result != null && result.types() != null && result.types().size() > 0) {
                ((TypeDeclaration)result.types().get(0)).setProperty(ASTNODE_SOURCE_PROPERTY, (Object)sourceBeingParsed);
            }
            if ((problems = result.getProblems()) != null) {
                int i = 0;
                while (i < problems.length) {
                    if (problems[i].isError()) {
                        throw new CodeGenSyntaxError("JVE Parsing Error: " + problems[i].getMessage() + " - Line: " + Integer.toString(problems[i].getSourceLineNumber()));
                    }
                    ++i;
                }
            }
            TimerTests.basicTest.stopStep("AST creation");
            return result;
        }
        catch (CodeGenSyntaxError e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenSyntaxError("JVE Parsing Error: " + e.getMessage());
        }
    }

    protected void CreateBeanDeclModel() throws CodeGenException {
        this.fModel = this.createDefaultModel(this.fDomain);
        this.fModel.setWorkingCopyProvider(this.fWCP);
        if (this.fastCU.types().size() == 0) {
            throw new CodeGenException("No Type to work on");
        }
        this.fModel.setTypeDecleration((TypeDeclaration)this.fastCU.types().get(0));
        this.fModel.setCompositionModel(this.fDiagram);
    }

    protected IBeanDeclModel createDefaultModel(EditDomain d) {
        BeanDeclModel m = new BeanDeclModel();
        m.setDomain(d);
        CodeGenUtil.getDecoderFactory(m).setResourceSet(this.fDiagram.getModelResourceSet());
        CodeGenUtil.getMethodTextFactory(m).setResourceSet(this.fDiagram.getModelResourceSet());
        return m;
    }

    void setLineSeperator() {
        this.fModel.setLineSeperator(System.getProperty("line.separator"));
        if (this.fCU == null || this.fModel.getWorkingCopyProvider() != null && this.fModel.getWorkingCopyProvider().getDocument() == null) {
            return;
        }
        this.fModel.setLineSeperator(TextUtilities.getDefaultLineDelimiter((IDocument)this.fModel.getWorkingCopyProvider().getDocument()));
    }

    protected void cleanModel() {
        this.fMonitor.subTask(CodeGenJavaMessages.JavaBeanModelBuilder_Task_CleanModel);
        Iterator itr = this.fModel.getBeans().iterator();
        ArrayList<BeanPart> err = new ArrayList<BeanPart>();
        while (itr.hasNext()) {
            BeanPart bean = (BeanPart)itr.next();
            boolean removeFlag = false;
            if (!bean.getSimpleName().equals("this") && bean.getInitExpression() == null && !bean.isInstanceInstantiation()) {
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                    JavaVEPlugin.log((Object)("*Discarting a beanPart " + bean), (Level)Level.FINE);
                }
                removeFlag = true;
            }
            if (!removeFlag) continue;
            err.add(bean);
            Iterator bItr = bean.getChildren();
            if (bItr == null) continue;
            while (bItr.hasNext()) {
                err.add((BeanPart)bItr.next());
            }
        }
        int i = 0;
        while (i < err.size()) {
            ((BeanPart)err.get(i)).dispose();
            ++i;
        }
    }

    private String getSharedHandlerName(CodeEventRef eRef) {
        MethodInvocation ms;
        String result = null;
        String name = null;
        Expression s = ((ExpressionStatement)eRef.getExprStmt()).getExpression();
        if (s instanceof MethodInvocation && (ms = (MethodInvocation)s).arguments().size() == 1 && ms.arguments().get(0) instanceof SimpleName) {
            name = ((SimpleName)ms.arguments().get(0)).getIdentifier();
        }
        if (name != null && this.fastCU != null && this.fastCU.types().size() > 0 && ((TypeDeclaration)this.fastCU.types().get(0)).getFields() != null) {
            FieldDeclaration[] fields = ((TypeDeclaration)this.fastCU.types().get(0)).getFields();
            int i = 0;
            while (i < fields.length) {
                VariableDeclaration f = (VariableDeclaration)fields[i].fragments().get(0);
                if (f.getName().getIdentifier().equals(name)) {
                    result = fields[i].getType().toString();
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    protected List mineForSharedListeners() {
        ArrayList<String> l = new ArrayList<String>();
        Iterator itr = this.fModel.getAllMethods();
        while (itr.hasNext()) {
            CodeMethodRef m = (CodeMethodRef)itr.next();
            Iterator exp = m.getEventExpressions();
            while (exp.hasNext()) {
                CodeEventRef eRef = (CodeEventRef)exp.next();
                String instance = this.getSharedHandlerName(eRef);
                if (l.contains(instance)) continue;
                l.add(instance);
            }
        }
        return l;
    }

    protected List getInnerTypes() {
        ArrayList l = new ArrayList();
        if (this.fastCU.types().size() > 0) {
            List body = ((TypeDeclaration)this.fastCU.types().get(0)).bodyDeclarations();
            int i = 0;
            while (i < body.size()) {
                if (body.get(i) instanceof TypeDeclaration) {
                    l.add(body.get(i));
                }
                ++i;
            }
        }
        return l;
    }

    protected void analyzeEvents(IVisitorFactoryRule visitorFactoryRule) {
        TimerTests.basicTest.startStep("Parse Events");
        this.fMonitor.subTask(CodeGenJavaMessages.JavaBeanModelBuilder_Task_AnalyzeEvents);
        Iterator itr = this.fModel.getBeans().iterator();
        EventsParser p = new EventsParser(this.fModel, this.fastCU);
        p.setProgressMonitor(this.fMonitor);
        while (itr.hasNext()) {
            if (this.fMonitor.isCanceled()) {
                return;
            }
            BeanPart b = (BeanPart)itr.next();
            p.addEvents(b, visitorFactoryRule);
        }
        List sharedListeners = this.mineForSharedListeners();
        List innerTypes = this.getInnerTypes();
        int i = 0;
        while (i < innerTypes.size()) {
            if (this.fMonitor.isCanceled()) {
                return;
            }
            String name = ((TypeDeclaration)innerTypes.get(i)).getName().getIdentifier();
            if (sharedListeners.contains(name)) {
                EventHandlerVisitor visitor = visitorFactoryRule.getEventHandlerVisitor();
                visitor.initialize((TypeDeclaration)innerTypes.get(i), this.fModel, false, visitorFactoryRule);
                visitor.setProgressMonitor(this.fMonitor);
                visitor.visit();
                break;
            }
            ++i;
        }
        TimerTests.basicTest.stopStep("Parse Events");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBeanDeclModel build() throws CodeGenException {
        block20: {
            IBeanDeclModel iBeanDeclModel;
            block19: {
                IBeanDeclModel iBeanDeclModel2;
                block18: {
                    IBeanDeclModel iBeanDeclModel3;
                    block17: {
                        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                            JavaVEPlugin.log((Object)"JavaBeanModelBuilder.build() starting .... ", (Level)Level.FINE);
                        }
                        this.fMonitor.beginTask(CodeGenJavaMessages.JavaBeanModelBuilder_Task_BuildingModel, this.determineWorkAmount());
                        this.fMonitor.subTask(CodeGenJavaMessages.JavaBeanModelBuilder_Task_ParsingSource);
                        JavaElementInfo[] jdtMethods = null;
                        if (this.fSync != null) {
                            this.fastCU = this.ParseJavaCode((IProgressMonitor)new SubProgressMonitor(this.fMonitor, 100));
                            jdtMethods = this.fCU != null ? CodeGenUtil.getMethodsInfo(this.fCU) : (JavaElementInfo[])null;
                        } else {
                            this.fastCU = this.ParseJavaCode((IProgressMonitor)new SubProgressMonitor(this.fMonitor, 100));
                        }
                        if (this.fMonitor.isCanceled()) {
                            this.fMonitor.done();
                            this.errors = true;
                            return null;
                        }
                        this.CreateBeanDeclModel();
                        this.setLineSeperator();
                        if (this.fMonitor.isCanceled()) {
                            this.fMonitor.done();
                            this.errors = true;
                            return null;
                        }
                        try {
                            try {
                                ArrayList tryAgain = new ArrayList();
                                TypeDeclaration mainType = (TypeDeclaration)this.fastCU.types().get(0);
                                IVisitorFactoryRule visitorFactoryRule = this.determineVisitorFactoryRule(mainType);
                                this.visitType(mainType, this.fModel, jdtMethods, tryAgain, this.fMonitor, visitorFactoryRule);
                                if (this.fMonitor.isCanceled()) {
                                    this.fMonitor.done();
                                    this.errors = true;
                                    iBeanDeclModel3 = null;
                                    Object var7_9 = null;
                                    break block17;
                                }
                                int i = 0;
                                while (true) {
                                    if (i >= tryAgain.size()) {
                                        if (!this.fMonitor.isCanceled()) break;
                                        this.fMonitor.done();
                                        this.errors = true;
                                        iBeanDeclModel2 = null;
                                        break block18;
                                    }
                                    ISourceVisitor visitor = (ISourceVisitor)tryAgain.get(i);
                                    visitor.setNoRetry();
                                    visitor.visit();
                                    ++i;
                                }
                                this.analyzeEvents(visitorFactoryRule);
                                this.fMonitor.worked(100);
                                if (this.fMonitor.isCanceled()) {
                                    this.fMonitor.done();
                                    this.errors = true;
                                    iBeanDeclModel = null;
                                    break block19;
                                }
                                Iterator itr = this.fModel.getBeans().iterator();
                                while (true) {
                                    if (!itr.hasNext()) {
                                        this.cleanModel();
                                        this.fMonitor.worked(100);
                                        break block20;
                                    }
                                    BeanPart bean = (BeanPart)itr.next();
                                    bean.setModel(this.fModel);
                                }
                            }
                            catch (Exception e) {
                                this.errors = true;
                                JavaVEPlugin.log((Throwable)e);
                                break block20;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_12 = null;
                            JavaVEPlugin.log((Object)"JavaBeanModelBuilder.build(), Done.", (Level)Level.FINE);
                            this.fMonitor.done();
                            throw throwable;
                        }
                    }
                    JavaVEPlugin.log((Object)"JavaBeanModelBuilder.build(), Done.", (Level)Level.FINE);
                    this.fMonitor.done();
                    return iBeanDeclModel3;
                }
                Object var7_10 = null;
                JavaVEPlugin.log((Object)"JavaBeanModelBuilder.build(), Done.", (Level)Level.FINE);
                this.fMonitor.done();
                return iBeanDeclModel2;
            }
            Object var7_11 = null;
            JavaVEPlugin.log((Object)"JavaBeanModelBuilder.build(), Done.", (Level)Level.FINE);
            this.fMonitor.done();
            return iBeanDeclModel;
        }
        Object var7_13 = null;
        JavaVEPlugin.log((Object)"JavaBeanModelBuilder.build(), Done.", (Level)Level.FINE);
        this.fMonitor.done();
        if (this.fMonitor.isCanceled()) {
            this.fModel = null;
            this.errors = true;
        }
        return this.fModel;
    }

    private IVisitorFactoryRule determineVisitorFactoryRule(TypeDeclaration declaration) {
        TypeResolver.ResolvedType resolved;
        IVisitorFactoryRule visitorFactory = (IVisitorFactoryRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleVisitorFactory");
        Name superClassName = declaration.getSuperclass();
        String superClassFQN = "java.lang.Object";
        if (superClassName != null && (resolved = this.fModel.getResolver().resolveType(superClassName)) != null) {
            superClassFQN = ((TypeResolver.Resolved)resolved).getName();
        }
        JavaHelpers superClassEClass = JavaRefFactory.eINSTANCE.reflectType(superClassFQN, EMFEditDomainHelper.getResourceSet((EditDomain)this.fModel.getDomain()));
        visitorFactory.setClassifier((EClassifier)superClassEClass);
        return visitorFactory;
    }

    private int determineWorkAmount() {
        int amount = 0;
        if (this.fastCU != null) {
            TypeDeclaration type = (TypeDeclaration)this.fastCU.types().get(0);
            MethodDeclaration[] methods = type.getMethods();
            amount = (methods == null ? 0 : methods.length) * 100 + 100 + 100;
        }
        return amount;
    }

    protected void visitType(TypeDeclaration type, IBeanDeclModel model, JavaElementInfo[] mthds, List tryAgain, IProgressMonitor monitor, IVisitorFactoryRule visitorFactoryRule) {
        TimerTests.basicTest.startStep("Creating Instance Var. BeanParts");
        if (visitorFactoryRule != null) {
            TypeVisitor v = visitorFactoryRule.getTypeVisitor();
            v.initialize(type, model, tryAgain, false, visitorFactoryRule);
            v.setJDTMethods(mthds);
            v.setProgressMonitor(monitor);
            v.visit();
        }
        TimerTests.basicTest.stopStep("Creating Instance Var. BeanParts");
    }

    public boolean isErrors() {
        return this.errors;
    }
}

