/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ve.internal.java.codegen.core.EditorUpdateState;
import org.eclipse.ve.internal.java.codegen.core.IEditorUpdateState;
import org.eclipse.ve.internal.java.codegen.core.JavaSourceTranslator;
import org.eclipse.ve.internal.java.codegen.java.SnippetParseJob;
import org.eclipse.ve.internal.java.codegen.util.IWorkingCopyProvider;
import org.eclipse.ve.internal.java.codegen.util.ReverseParserJob;

public class JavaSourceSynchronizer
implements ISynchronizable {
    public static final int DEFAULT_SYNC_DELAY = 1000;
    public static final String RELOAD_HANDLE = "Reload Request";
    private int snippetDelay = 1000;
    IWorkingCopyProvider workingCopyProvider;
    Display curDisplay = null;
    EditorUpdateState updateStatus = null;
    Object bdmLock = null;
    private List documentEventList = null;
    DocListener docListener = null;
    JavaSourceTranslator srcTranslator = null;
    boolean stalled = false;

    public JavaSourceSynchronizer(IWorkingCopyProvider wcp, JavaSourceTranslator st) {
        this.workingCopyProvider = wcp;
        this.srcTranslator = st;
        this.curDisplay = this.getDisplay();
        this.updateStatus = new EditorUpdateState();
        this.documentEventList = new ArrayList();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void driveNewEvent(Object event) {
        EditorUpdateState editorUpdateState = this.updateStatus;
        synchronized (editorUpdateState) {
            if (event != null) {
                this.documentEventList.add(event);
            }
            if (this.updateStatus.isCollectingDeltas()) {
                this.updateStatus.setBottomUpProcessing(false);
                Job[] jobs = ReverseParserJob.getReverseParserJobs(this.workingCopyProvider.getFile());
                int i = 0;
                while (i < jobs.length) {
                    if (jobs[i].getState() != 4 && jobs[i] instanceof SnippetParseJob) {
                        jobs[i].sleep();
                        jobs[i].wakeUp((long)this.getDelay());
                    }
                    ++i;
                }
                return;
            }
            if (this.stalled || this.documentEventList.isEmpty()) {
                this.updateStatus.setBottomUpProcessing(false);
                return;
            }
            this.updateStatus.setCollectingDeltas(true);
        }
        this.srcTranslator.fireSnippetProcessing(true);
        SnippetParseJob job = new SnippetParseJob(this.workingCopyProvider.getFile(), this.srcTranslator.createSharedToLocalUpdater(), this.getDisplay(), this.workingCopyProvider.getWorkingCopy(false), this.updateStatus, this.documentEventList);
        job.setEditDomain(this.srcTranslator.getEditDomain());
        job.schedule(this.getDelay());
    }

    public void appendReloadRequest() {
        this.driveNewEvent(RELOAD_HANDLE);
    }

    private Display getDisplay() {
        if (this.curDisplay != null) {
            return this.curDisplay;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            int i = 0;
            while (i < windows.length) {
                if (windows[i].getShell() != null && windows[i].getShell().getDisplay() != null) {
                    this.curDisplay = windows[i].getShell().getDisplay();
                    break;
                }
                ++i;
            }
        }
        return this.curDisplay;
    }

    public void setDelay(int delay) {
        if (delay < 1000) {
            throw new IllegalArgumentException("invalid delay value");
        }
        this.snippetDelay = delay;
    }

    public int getDelay() {
        return this.snippetDelay;
    }

    public boolean isWorkQueued() {
        boolean result = false;
        if (this.documentEventList.size() > 0) {
            result = true;
        }
        return result;
    }

    public void suspendDocListener() {
        if (this.docListener != null) {
            this.workingCopyProvider.getDocument().removeDocumentListener((IDocumentListener)this.docListener);
        }
    }

    public void resumeDocListener() {
        if (this.docListener != null) {
            this.workingCopyProvider.getDocument().addDocumentListener((IDocumentListener)this.docListener);
        }
    }

    public synchronized void disconnect() {
        if (this.docListener != null) {
            this.workingCopyProvider.getDocument().removeDocumentListener((IDocumentListener)this.docListener);
            this.docListener = null;
            this.bdmLock = null;
        }
        this.clearOutstandingWork();
    }

    public synchronized void connect() {
        if (this.docListener == null) {
            this.docListener = new DocListener();
            this.workingCopyProvider.getDocument().addDocumentListener((IDocumentListener)this.docListener);
            this.bdmLock = new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearOutstandingWork() {
        EditorUpdateState editorUpdateState = this.updateStatus;
        synchronized (editorUpdateState) {
            this.documentEventList.clear();
            this.updateStatus.setCollectingDeltas(false);
        }
        Job[] jobs = ReverseParserJob.getReverseParserJobs(this.workingCopyProvider.getFile());
        int i = 0;
        while (i < jobs.length) {
            if (jobs[i] instanceof SnippetParseJob) {
                jobs[i].cancel();
            }
            ++i;
        }
    }

    public IEditorUpdateState getUpdateStatus() {
        return this.updateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stallProcessing() {
        Job[] jobs;
        JavaSourceSynchronizer javaSourceSynchronizer = this;
        synchronized (javaSourceSynchronizer) {
            this.stalled = true;
            jobs = ReverseParserJob.getReverseParserJobs(this.workingCopyProvider.getFile());
        }
        int i = 0;
        while (i < jobs.length) {
            if (jobs[i] instanceof SnippetParseJob) {
                try {
                    jobs[i].join();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
    }

    public synchronized void resumeProcessing() {
        this.stalled = false;
        this.updateStatus.setBottomUpProcessing(true);
        this.driveNewEvent(null);
    }

    public void setLockObject(Object lockObject) {
        this.bdmLock = lockObject;
    }

    public Object getLockObject() {
        return this.bdmLock;
    }

    public String toString() {
        String listener = this.docListener == null ? "null" : "listening";
        return "Stalled=" + this.stalled + ", updateStatus=" + this.updateStatus + ", delay=" + this.getDelay() + ", docListener=" + listener;
    }

    class DocListener
    implements IDocumentListener {
        DocListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            JavaSourceSynchronizer.this.updateStatus.setBottomUpProcessing(true);
        }

        public void documentChanged(DocumentEvent event) {
            JavaSourceSynchronizer.this.driveNewEvent(event);
        }
    }
}

