/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.logging.Level;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class MethodParser {
    String fSeperator;
    IMethod fMethod = null;
    int fSrcOffset = -1;
    String fSource = null;
    CompilationUnit fCU = null;
    static final String foo = "Foo";
    static final String classTemplatePre = "public class Foo {\n";
    static final String classTemplatePost = "\n}";

    public MethodParser(IMethod method, String seperator) {
        this.fMethod = method;
        this.fSeperator = seperator;
    }

    CompilationUnit getCU() {
        if (this.fCU != null) {
            return this.fCU;
        }
        try {
            StringBuffer sb = new StringBuffer(classTemplatePre);
            sb.replace(classTemplatePre.indexOf(foo), classTemplatePre.indexOf(foo) + foo.length(), this.fMethod.getDeclaringType().getElementName());
            this.fSrcOffset = sb.length();
            this.fSource = String.valueOf(sb.toString()) + this.fMethod.getSource() + classTemplatePost;
        }
        catch (JavaModelException javaModelException) {}
        if (this.fSource != null) {
            ASTParser parser = ASTParser.newParser((int)2);
            parser.setSource(this.fSource.toCharArray());
            this.fCU = (CompilationUnit)parser.createAST(null);
        }
        return this.fCU;
    }

    public boolean addMethodCallIfNeeded(final String methodName) {
        final boolean[] result = new boolean[1];
        final ASTNode[] SuperBlock = new ASTNode[2];
        this.getCU();
        this.fCU.getRoot().accept(new ASTVisitor(){

            public boolean visit(Block node) {
                if (SuperBlock[1] == null) {
                    SuperBlock[1] = node;
                }
                return true;
            }

            public boolean visit(SuperConstructorInvocation node) {
                if (node.getStartPosition() > 0) {
                    SuperBlock[0] = node;
                }
                return true;
            }

            public boolean visit(MethodInvocation node) {
                if (methodName.equals(node.getName().getIdentifier())) {
                    result[0] = true;
                }
                return false;
            }
        });
        if (!result[0]) {
            int insertOffset = -1;
            if (SuperBlock[0] != null) {
                insertOffset = SuperBlock[0].getStartPosition() + SuperBlock[0].getLength();
            } else if (SuperBlock[1] != null) {
                insertOffset = SuperBlock[1].getStartPosition() + SuperBlock[1].getLength();
            }
            if (insertOffset >= 0) {
                try {
                    this.fMethod.getCompilationUnit().getBuffer().replace(this.fMethod.getSourceRange().getOffset() + insertOffset - this.fSrcOffset, 0, String.valueOf(this.fSeperator) + "\t\t" + methodName + "();");
                }
                catch (JavaModelException javaModelException) {}
                this.fCU = null;
                return true;
            }
            JavaVEPlugin.log((Object)"MethodParser.addMethodCallIfNedded(): Could not insert", (Level)Level.FINE);
        }
        return false;
    }
}

