/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.TypeResolver;

public class BeanPartDecleration {
    ASTNode fieldDecl = null;
    String fieldDeclHandle = null;
    String declerationHandle = null;
    String name = null;
    String type = null;
    boolean typeResolved = false;
    CodeMethodRef declaredMethod = null;
    boolean inModel = false;
    IBeanDeclModel model = null;
    List beanParts = new ArrayList();

    public BeanPartDecleration(String name) {
        this.name = name;
    }

    public BeanPartDecleration(String name, String type) {
        this(name);
        this.setType(type);
    }

    public BeanPartDecleration(FieldDeclaration fd) {
        this(((VariableDeclaration)fd.fragments().get(0)).getName().getIdentifier());
        this.setFieldDecl((ASTNode)fd);
        this.setType(fd.getType());
        this.setDeclaringMethod(null);
    }

    public BeanPartDecleration(String name, CodeMethodRef method) {
        this(name);
        this.setDeclaringMethod(method);
    }

    public BeanPartDecleration(VariableDeclarationStatement vd) {
        this(((VariableDeclaration)vd.fragments().get(0)).getName().getIdentifier());
        this.setFieldDecl((ASTNode)vd);
        this.setType(vd.getType());
    }

    public ASTNode getFieldDecl() {
        return this.fieldDecl;
    }

    public void setFieldDecl(ASTNode fieldDecl) {
        this.fieldDecl = fieldDecl;
    }

    public String getType() {
        return this.type;
    }

    protected void resolveType(Name ast) {
        if (this.model != null && this.type != null && !this.typeResolved) {
            TypeResolver.ResolvedType rt;
            if (this.type.equals("")) {
                this.typeResolved = true;
            } else if (this.model.getCompilationUnit() != null && (rt = ast == null ? this.getModel().getResolver().resolveType(this.type) : this.getModel().getResolver().resolveType(ast)) != null) {
                this.type = ((TypeResolver.Resolved)rt).getName();
                this.typeResolved = true;
            }
        }
    }

    public void setType(String t) {
        if (this.type == null) {
            this.type = t;
            this.resolveType(null);
        }
    }

    public void setType(Name t) {
        if (this.type == null) {
            this.type = t.getFullyQualifiedName();
            this.resolveType(t);
        }
    }

    public void setType(Type t) {
        if (t instanceof SimpleType) {
            this.setType(((SimpleType)t).getName());
        } else if (t instanceof PrimitiveType) {
            this.setType(((PrimitiveType)t).getPrimitiveTypeCode().toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public void addBeanPart(BeanPart bp) {
        if (!bp.getSimpleName().equals(this.name)) {
            throw new IllegalArgumentException();
        }
        if (!this.beanParts.contains(bp)) {
            this.beanParts.add(bp);
        }
    }

    public void refreshDeclerationSource() {
        int i = 0;
        while (i < this.beanParts.size()) {
            CodeExpressionRef e = ((BeanPart)this.beanParts.get(i)).getInitExpression();
            if (e != null) {
                e.getExpressionDecoder().reflectMOFchange();
            }
            ++i;
        }
    }

    public void removeBeanPart(BeanPart bp) {
        this.beanParts.remove(bp);
        if (this.beanParts.size() == 0) {
            this.setModel(null);
        }
    }

    public BeanPart[] getBeanParts() {
        return this.beanParts.toArray(new BeanPart[this.beanParts.size()]);
    }

    public int getBeanPartIndex(BeanPart bp) {
        CodeExpressionRef bpInitExp = bp.getInitExpression();
        int bpInitExpOffset = bpInitExp == null ? Integer.MAX_VALUE : bpInitExp.getOffset();
        BeanPart[] bps = this.getBeanParts();
        int bpIndex = 0;
        int i = 0;
        while (i < bps.length) {
            if (bp != bps[i]) {
                int bpsInitExpOffset;
                CodeExpressionRef bpsInitExp = bps[i].getInitExpression();
                int n = bpsInitExpOffset = bpsInitExp == null ? Integer.MAX_VALUE : bpsInitExp.getOffset();
                if (bpsInitExpOffset < bpInitExpOffset) {
                    ++bpIndex;
                }
            }
            ++i;
        }
        return bpIndex;
    }

    public boolean isInstanceVar() {
        return this.declaredMethod == null;
    }

    public void setDeclaringMethod(CodeMethodRef method) {
        this.declaredMethod = method;
        this.declerationHandle = BeanPartDecleration.createDeclerationHandle(method, this.name);
    }

    public String getFieldDeclHandle() {
        return this.fieldDeclHandle;
    }

    public void setFieldDeclHandle(String fieldDeclHandle) {
        this.fieldDeclHandle = fieldDeclHandle;
    }

    public IBeanDeclModel getModel() {
        return this.model;
    }

    public void setModel(IBeanDeclModel model) {
        if (this.model == model) {
            return;
        }
        IBeanDeclModel currentModel = this.model;
        this.model = model;
        if (model == null) {
            if (currentModel != null) {
                currentModel.removeBeanDecleration(this);
            }
        } else {
            this.resolveType(null);
            if (!this.isInModel()) {
                model.addBeanDecleration(this);
            }
        }
    }

    public boolean isInModel() {
        return this.model != null && this.model.getModelDecleration(this) == this;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (!this.isInModel()) {
            b.append("*Shadow* ");
        }
        if (this.isInstanceVar()) {
            b.append("InstanceVar: ");
        } else {
            b.append(">");
            b.append(this.declaredMethod.getMethodName());
            b.append("()<: ");
        }
        b.append(String.valueOf(this.beanParts.size()) + " BeanParts ");
        b.append("[" + this.name + " (" + this.type + ")]");
        return b.toString();
    }

    public String getDeclerationHandle() {
        if (this.declerationHandle == null) {
            throw new IllegalAccessError();
        }
        return this.declerationHandle;
    }

    private static String createDeclerationHandle(String methodHandle, String simpleName) {
        if (methodHandle != null) {
            return String.valueOf(methodHandle) + "^" + simpleName;
        }
        return simpleName;
    }

    public static String createDeclerationHandle(IMethod method, String simpleName) {
        return BeanPartDecleration.createDeclerationHandle(method == null ? null : method.getHandleIdentifier(), simpleName);
    }

    public static String createDeclerationHandle(CodeMethodRef method, String simpleName) {
        return BeanPartDecleration.createDeclerationHandle(method == null ? null : method.getMethodHandle(), simpleName);
    }

    public String getUniqueHandle(BeanPart bp) {
        return this.getDeclerationHandle();
    }

    public BeanPart getBeanPart(CodeMethodRef m, int off) {
        BeanPart bp;
        CodeExpressionRef exp = null;
        int i = 0;
        while (i < this.beanParts.size()) {
            BeanPart b = (BeanPart)this.beanParts.get(i);
            CodeExpressionRef e = b.getInitExpression();
            if (e != null) {
                if (e.isStateSet(16384)) {
                    exp = e;
                } else if (e.getMethod().getMethodName().equals(m.getMethodName()) && e.getOffset() < off) {
                    if (exp == null) {
                        exp = e;
                    } else if (e.getOffset() > exp.getOffset()) {
                        exp = e;
                    }
                }
            }
            ++i;
        }
        BeanPart beanPart = bp = exp == null ? null : exp.getBean();
        if (bp != null && !bp.isActive()) {
            bp.activate();
        }
        return bp;
    }

    public BeanPart getBeanPartWithNoInitExpression() {
        int i = 0;
        while (i < this.beanParts.size()) {
            BeanPart b = (BeanPart)this.beanParts.get(i);
            CodeExpressionRef e = b.getInitExpression();
            if (e == null) {
                return b;
            }
            ++i;
        }
        return null;
    }

    public BeanPart createAnotherBeanPartInstance(CodeMethodRef initMethod) {
        int index = this.beanParts.size();
        BeanPart bp = new BeanPart(this);
        bp.setUniqueIndex(index);
        bp.addInitMethod(initMethod);
        this.model.addBean(bp);
        return bp;
    }

    public boolean isSingleDecleration() {
        return this.beanParts.size() <= 1;
    }
}

