/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.ve.internal.java.codegen.model.AbstractCodeRef;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.ICodeDelta;

public class DefaultCodeDelta
implements ICodeDelta {
    protected CodeMethodRef method = null;
    protected BeanPart beanPart = null;
    protected Hashtable table = new Hashtable();

    public void addDeltaMethod(CodeMethodRef method) {
        this.method = method;
        this.setElementStatus(method, 1);
    }

    public void addDelataField(BeanPart beanPart) {
        this.beanPart = beanPart;
        this.setElementStatus(this.beanPart, 1);
    }

    public List getDeletedElements(AbstractCodeRef element) {
        ArrayList deleted = new ArrayList();
        if (this.table.containsKey(element)) {
            Enumeration keys = this.table.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (key instanceof BeanPart) {
                    // empty if block
                }
                if (!(key instanceof AbstractCodeRef) || this.getElementStatus((AbstractCodeRef)key) != 2) continue;
                deleted.add(key);
            }
        }
        return deleted;
    }

    public CodeMethodRef getDeltaMethod() {
        return this.method;
    }

    public BeanPart getDeltaField() {
        return this.beanPart;
    }

    public int getElementStatus(AbstractCodeRef element) {
        return this.getStatus(element);
    }

    public int getElementStatus(BeanPart element) {
        return this.getStatus(element);
    }

    protected int getStatus(Object key) {
        if (this.table.containsKey(key)) {
            Integer status = (Integer)this.table.get(key);
            return status;
        }
        return -1;
    }

    public void setElementStatus(AbstractCodeRef code, int status) {
        this.setStatus(code, status);
    }

    public void setElementStatus(BeanPart bean, int status) {
        this.setStatus(bean, status);
    }

    protected void setStatus(Object object, int status) {
        this.table.put(object, new Integer(status));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.beanPart + " : " + this.method + "\n");
        Enumeration e = this.table.keys();
        while (e.hasMoreElements()) {
            String status;
            Object key = e.nextElement();
            sb.append(key);
            switch (this.getStatus(key)) {
                case 1: {
                    status = " NO Change";
                    break;
                }
                case 2: {
                    status = " Deleted";
                    break;
                }
                case 4: {
                    status = " Added";
                    break;
                }
                case 8: {
                    status = " Changed";
                    break;
                }
                case 16: {
                    status = " Offset Changed";
                    break;
                }
                case 32: {
                    status = " Undetermined";
                    break;
                }
                default: {
                    status = "???";
                }
            }
            sb.append(status);
        }
        return sb.toString();
    }
}

