/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;

public class JavaElementInfo {
    String handle;
    int offset;
    int length;
    String name;
    String content;

    public JavaElementInfo(IJavaElement element) {
        this.handle = element.getHandleIdentifier();
        if (element instanceof ISourceReference) {
            ISourceReference sr = (ISourceReference)element;
            try {
                this.offset = sr.getSourceRange().getOffset();
                this.length = sr.getSourceRange().getLength();
                this.content = sr.getSource();
            }
            catch (JavaModelException javaModelException) {
                this.offset = -1;
                this.length = -1;
                this.content = null;
            }
        } else {
            this.offset = -1;
            this.length = -1;
            this.content = null;
        }
        this.name = element.getElementName();
    }

    public String getContent() {
        return this.content;
    }

    public String getHandle() {
        return this.handle;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public int getOffset() {
        return this.offset;
    }

    public ISourceRange getSourceRange() {
        return new ISourceRange(){

            public int getLength() {
                return JavaElementInfo.this.length;
            }

            public int getOffset() {
                return JavaElementInfo.this.offset;
            }
        };
    }
}

