/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.templates.TemplateObjectFactory;
import org.eclipse.ve.internal.java.vce.templates.TemplateUtil;
import org.eclipse.ve.internal.java.vce.templates.TemplatesException;

public abstract class AbstractClassGenerator {
    public static final String JAVAJET_EXT = ".javajet";
    protected String fNL = System.getProperties().getProperty("line.separator");
    protected String[] fComments = null;
    protected String fPackageName = null;
    protected String fClassName = null;
    protected IJavaProject fProject = null;
    protected boolean fFormatTemplate = true;
    protected Map fProjectOptions = null;
    protected IClassTemplate fTemplate = null;

    public AbstractClassGenerator(String className, String pkgName) {
        this.fClassName = className;
        this.fPackageName = pkgName;
    }

    protected abstract IClassTemplate getClassTemplate();

    protected abstract ClassInfo getTemplateInfo();

    protected abstract String getBasePlugin();

    protected abstract String getTemplateDirPath();

    public String toString() {
        return "ClassGenerator for: " + this.fClassName;
    }

    protected IClassTemplate getClassTemplate(String templateFileName, String className) {
        if (this.fTemplate != null) {
            return this.fTemplate;
        }
        try {
            List list = TemplateUtil.getPluginAndPreReqJarPath((String)this.getBasePlugin());
            list.addAll(TemplateUtil.getPlatformJREPath());
            String[] classPath = list.toArray(new String[list.size()]);
            String templatePath = TemplateUtil.getPathForBundleFile((String)this.getBasePlugin(), (String)this.getTemplateDirPath());
            this.fTemplate = (IClassTemplate)TemplateObjectFactory.getClassInstance((String[])classPath, (String[])new String[]{templatePath}, (String)templateFileName, (ClassLoader)TemplateUtil.getClassLoader((String)this.getBasePlugin()), (String)className, null);
        }
        catch (TemplatesException e) {
            JavaVEPlugin.log((Throwable)e);
        }
        return this.fTemplate;
    }

    public void setComments(String[] comments) {
        this.fComments = comments;
    }

    protected IPackageFragment generatePackageIfNeeded(IProgressMonitor monitor) throws CodeGenException {
        if (this.fPackageName != null) {
            IPackageFragment pkg = null;
            try {
                IPackageFragment[] pkgs = this.fProject.getPackageFragments();
                int i = 0;
                while (i < pkgs.length) {
                    if (pkgs[i].getElementName().equals(this.fPackageName)) {
                        pkg = pkgs[i];
                        break;
                    }
                    ++i;
                }
                if (pkg == null) {
                    IPackageFragmentRoot root = null;
                    IPackageFragmentRoot[] all = this.fProject.getAllPackageFragmentRoots();
                    int i2 = 0;
                    while (i2 < all.length) {
                        if (all[i2].getKind() == 1) {
                            root = all[i2];
                            break;
                        }
                        ++i2;
                    }
                    if (root != null) {
                        pkg = root.createPackageFragment(this.fPackageName, true, monitor);
                    }
                }
            }
            catch (JavaModelException e) {
                throw new CodeGenException(e.getMessage());
            }
            return pkg;
        }
        return null;
    }

    public void setProject(IJavaProject project) {
        this.fProject = project;
        this.fProjectOptions = project.getOptions(true);
    }

    public void setFormatTemplate(boolean formatTemplate) {
        this.fFormatTemplate = formatTemplate;
    }

    public static interface IClassTemplate {
        public String generateClassContent(ClassInfo var1);
    }

    public class ClassInfo {
        public String fSeperator;
        public String[] fComments;
        public String fPackageName;
        public String fClassName;

        public ClassInfo() {
            this.fSeperator = AbstractClassGenerator.this.fNL;
            this.fComments = AbstractClassGenerator.this.fComments;
            this.fPackageName = AbstractClassGenerator.this.fPackageName;
            this.fClassName = AbstractClassGenerator.this.fClassName;
        }
    }
}

