/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.impl.JavaClassImpl;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.IExpressionTemplate;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.templates.TemplateObjectFactory;
import org.eclipse.ve.internal.java.vce.templates.TemplateUtil;
import org.eclipse.ve.internal.java.vce.templates.TemplatesException;

public abstract class AbstractExpressionGenerator {
    public static final String JAVAJET_EXT = ".javajet";
    protected IBeanDeclModel fModel;
    protected EObject fComponent;
    protected String fComment = null;
    protected String finitbeanConstructionString = null;
    protected String finitbeanType = null;
    protected String finitbeanName = null;
    protected String[] finitbeanArgs = null;
    protected String fIndent = "\t";
    protected IExpressionTemplate fTemplate = null;

    public AbstractExpressionGenerator(EObject component, IBeanDeclModel model) {
        this.fModel = model;
        this.fComponent = component;
    }

    protected abstract IExpressionTemplate getExpressionTemplate();

    protected abstract ExprInfo getInfo();

    public String toString() {
        return String.valueOf(super.toString()) + ": " + this.finitbeanName;
    }

    protected IExpressionTemplate getMethodTemplate(String name, String className) {
        if (this.fTemplate != null) {
            return this.fTemplate;
        }
        try {
            List list = TemplateUtil.getPluginAndPreReqJarPath((String)this.getBasePlugin());
            list.addAll(TemplateUtil.getPlatformJREPath());
            String[] classPath = list.toArray(new String[list.size()]);
            String templatePath = TemplateUtil.getPathForBundleFile((String)this.getBasePlugin(), (String)this.getTemplatePath());
            this.fTemplate = (IExpressionTemplate)TemplateObjectFactory.getClassInstance((String[])classPath, (String[])new String[]{templatePath}, (String)name, (ClassLoader)TemplateUtil.getClassLoader((String)this.getBasePlugin()), (String)className, null);
        }
        catch (TemplatesException e) {
            JavaVEPlugin.log((Throwable)e);
        }
        return this.fTemplate;
    }

    public String[] getBeanInitArgs() {
        return this.finitbeanArgs;
    }

    public void setBeanInitArgs(String[] beanInitArgs) {
        this.finitbeanArgs = beanInitArgs;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    protected abstract String getBasePlugin();

    protected abstract String getTemplatePath();

    public String getIndent() {
        return this.fIndent;
    }

    public void setIndent(String indent) {
        this.fIndent = indent;
    }

    public String getInitbeanConstructionString() {
        return this.finitbeanConstructionString;
    }

    public void setInitbeanConstructionString(String finitbeanConstructionString) {
        this.finitbeanConstructionString = finitbeanConstructionString;
    }

    public String getInitbeanName() {
        return this.finitbeanName;
    }

    public void setInitbeanName(String finitbeanName) {
        this.finitbeanName = finitbeanName;
    }

    public void setInitbeanType(String type) {
        this.finitbeanType = type;
    }

    public class ExprInfo {
        public String fSeperator;
        public String fComment;
        public String finitBeanName;
        public String finitBeanType;
        public String finitbeanConstructionString;
        public String[] finitBeanArgs;
        public String fIndent;

        public ExprInfo() {
            this.fSeperator = AbstractExpressionGenerator.this.fModel.getLineSeperator();
            this.finitBeanType = AbstractExpressionGenerator.this.finitbeanType == null ? ((JavaClassImpl)AbstractExpressionGenerator.this.fComponent.eClass()).getQualifiedName() : AbstractExpressionGenerator.this.finitbeanType;
            this.finitBeanName = AbstractExpressionGenerator.this.finitbeanName;
            this.finitBeanArgs = AbstractExpressionGenerator.this.finitbeanArgs;
            this.fIndent = AbstractExpressionGenerator.this.fIndent;
            this.finitbeanConstructionString = AbstractExpressionGenerator.this.finitbeanConstructionString;
        }
    }
}

