/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.instantiation.base.FeatureValueProvider;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.java.impl.JavaClassImpl;
import org.eclipse.ve.internal.java.codegen.java.BeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ExpressionRefFactory;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.BeanPartDecleration;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.DefaultClassGenerator;
import org.eclipse.ve.internal.java.codegen.util.IMethodTemplate;
import org.eclipse.ve.internal.java.codegen.util.IMethodTextGenerator;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.templates.TemplateObjectFactory;
import org.eclipse.ve.internal.java.vce.templates.TemplateUtil;
import org.eclipse.ve.internal.java.vce.templates.TemplatesException;

public abstract class AbstractMethodTextGenerator
implements IMethodTextGenerator {
    public static final String JAVAJET_EXT = ".javajet";
    public static final String DEFAULT_METHOD_PREFIX = "get";
    protected IBeanDeclModel fModel;
    protected EObject fComponent;
    protected String fmethodName = null;
    protected String[] fComments = null;
    protected String[] fmethodArgs = null;
    protected String finitbeanName = null;
    protected String finitbeanInitString = null;
    protected String finitBeanType = null;
    protected IMethodTemplate fMethodTemplate = null;
    protected EStructuralFeature[] fignoreSFlist = null;
    protected boolean fGenerateComments = false;

    public AbstractMethodTextGenerator(EObject component, IBeanDeclModel model) {
        this.fModel = model;
        this.fComponent = component;
    }

    protected abstract IMethodTemplate getMethodTemplate();

    protected abstract MethodInfo getInfo();

    public String toString() {
        return String.valueOf(super.toString()) + ": " + this.fmethodName;
    }

    public String generateMethod(CodeMethodRef method, String methodName, String beanName, List imports) throws CodeGenException {
        this.fmethodName = methodName;
        this.finitbeanName = beanName;
        IJavaObjectInstance obj = (IJavaObjectInstance)this.fComponent;
        this.setBeanInitString(CodeGenUtil.getInitString((IJavaInstance)obj, this.fModel, imports, null));
        if (imports != null) {
            this.setInitBeanType(obj.getJavaType().getSimpleName());
        }
        String content = this.getMethodTemplate().generateMethod(this.getInfo());
        Map options = this.fModel.getCompilationUnit().getJavaProject().getOptions(true);
        return DefaultClassGenerator.format(content, 4, options, this.fModel.getLineSeperator());
    }

    protected IMethodTemplate getMethodTemplate(String name, String className) {
        if (this.fMethodTemplate != null) {
            return this.fMethodTemplate;
        }
        try {
            List list = TemplateUtil.getPluginAndPreReqJarPath((String)this.getBasePlugin());
            list.addAll(TemplateUtil.getPlatformJREPath());
            String[] classPath = list.toArray(new String[list.size()]);
            String templatePath = TemplateUtil.getPathForBundleFile((String)this.getBasePlugin(), (String)this.getTemplatePath());
            this.fMethodTemplate = (IMethodTemplate)TemplateObjectFactory.getClassInstance((String[])classPath, (String[])new String[]{templatePath}, (String)name, (ClassLoader)TemplateUtil.getClassLoader((String)this.getBasePlugin()), (String)className, null);
        }
        catch (TemplatesException e) {
            JavaVEPlugin.log((Throwable)e);
        }
        return this.fMethodTemplate;
    }

    public String getBeanInitString() {
        return this.finitbeanInitString;
    }

    public void setBeanInitString(String str) {
        this.finitbeanInitString = str;
    }

    public String[] getMethodArguments() {
        return this.fmethodArgs;
    }

    public void setMethodArguments(String[] methodArguments) {
        this.fmethodArgs = methodArguments;
    }

    public void setComments(String[] comments) {
        this.fComments = comments;
    }

    protected abstract String getBasePlugin();

    protected abstract String getTemplatePath();

    protected abstract String[] getIgnoreSFnameList();

    private EStructuralFeature[] getIgnoreSFlist() {
        if (this.fignoreSFlist != null) {
            return this.fignoreSFlist;
        }
        String[] list = this.getIgnoreSFnameList();
        if (list == null) {
            return null;
        }
        EStructuralFeature[] sfList = new EStructuralFeature[list.length];
        EClass c = this.fComponent.eClass();
        int i = 0;
        while (i < sfList.length) {
            sfList[i] = c.getEStructuralFeature(list[i]);
            ++i;
        }
        this.fignoreSFlist = sfList;
        return this.fignoreSFlist;
    }

    protected boolean ignoreSF(EStructuralFeature sf) {
        EStructuralFeature[] ignore = this.getIgnoreSFlist();
        if (sf == null || ignore == null || sf.isTransient()) {
            return true;
        }
        int i = 0;
        while (i < ignore.length) {
            if (sf.equals(ignore[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected CodeExpressionRef primGenerateAttribute(EStructuralFeature sf, BeanPart bean, Object[] arg) throws CodeGenException {
        ExpressionRefFactory egen = new ExpressionRefFactory(bean, sf);
        CodeExpressionRef exp = egen.createFromJVEModel(arg);
        exp.insertContentToDocument();
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
            JavaVEPlugin.log((Object)("\tAdding: " + exp.getContent()), (Level)Level.FINE);
        }
        return exp;
    }

    protected CodeExpressionRef[] generateAttribute(EStructuralFeature sf, BeanPart bean) throws CodeGenException {
        if (!sf.isMany()) {
            return new CodeExpressionRef[]{this.primGenerateAttribute(sf, bean, null)};
        }
        List values = (List)bean.getEObject().eGet(sf);
        ArrayList<CodeExpressionRef> exprs = new ArrayList<CodeExpressionRef>();
        int i = 0;
        while (i < values.size()) {
            exprs.add(this.primGenerateAttribute(sf, bean, new Object[]{values.get(i)}));
            ++i;
        }
        return exprs.toArray(new CodeExpressionRef[exprs.size()]);
    }

    protected void generateForSetFeatures(BeanPart bean) throws CodeGenException {
        BeanPart.IBeanSourceGenerator gen = new BeanPart.IBeanSourceGenerator(){

            public void generateFromFeatures(BeanPart bp) throws CodeGenException {
                BeanDecoderAdapter a;
                EObject obj = bp.getEObject();
                CodeGenException exp = (CodeGenException)((Object)FeatureValueProvider.FeatureValueProviderHelper.visitSetFeatures((EObject)obj, (FeatureValueProvider.Visitor)new FeatureValueProvider.Visitor(this, a = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)obj, (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER), bp){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ BeanDecoderAdapter val$a;
                    private final /* synthetic */ BeanPart val$bp;
                    {
                        this.this$1 = var1_1;
                        this.val$a = beanDecoderAdapter;
                        this.val$bp = beanPart;
                    }

                    public Object isSet(EStructuralFeature feature, Object value) {
                        try {
                            if (1.access$0(this.this$1).ignoreSF(feature)) {
                                return null;
                            }
                            if (this.val$a.getSettingAdapters(feature) != null && this.val$a.getSettingAdapters(feature).length > 0) {
                                return null;
                            }
                            1.access$0(this.this$1).generateAttribute(feature, this.val$bp);
                            return null;
                        }
                        catch (CodeGenException e) {
                            return e;
                        }
                    }
                }));
                if (exp != null) {
                    throw exp;
                }
            }

            static /* synthetic */ AbstractMethodTextGenerator access$0(1 var0) {
                return var0.AbstractMethodTextGenerator.this;
            }
        };
        if (bean.getInitExpression() == null) {
            bean.setGenerator(gen);
        } else {
            gen.generateFromFeatures(bean);
        }
    }

    public void generateExpressionsContent() throws CodeGenException {
        BeanPart b = this.fModel.getABean(this.fComponent);
        this.generateForSetFeatures(b);
    }

    public String getMethodPrefix() {
        return DEFAULT_METHOD_PREFIX;
    }

    protected CodeExpressionRef createInitExpression(BeanPart bean) {
        ExpressionRefFactory eg = new ExpressionRefFactory(bean, null);
        return eg.createInitExpression();
    }

    public void generateInLine(CodeMethodRef method, String beanName, List kids) throws CodeGenException {
        BeanPart bp = this.fModel.getABean(beanName);
        if (bp == null) {
            bp = this.fModel.getABean(BeanPartDecleration.createDeclerationHandle(method, beanName));
        }
        CodeExpressionRef initExp = this.createInitExpression(bp);
        initExp.setState(128, false);
        if (!initExp.isStateSet(8)) {
            initExp.setOffset(-1);
            try {
                method.updateExpressionOrder();
            }
            catch (Throwable e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.SEVERE);
                return;
            }
            if (method.getMethodHandle() != null) {
                initExp.insertContentToDocument();
            } else {
                initExp.setState(512, true);
            }
        }
        this.generateForSetFeatures(bp);
    }

    public String generateMain(String className) {
        return null;
    }

    public void setInitBeanType(String type) {
        this.finitBeanType = type;
    }

    public class MethodInfo {
        public String fSeperator;
        public String[] fComments;
        public String fmethodName;
        public String freturnType;
        public String[] fmethodArguments;
        public String finitBeanName;
        public String finitBeanType;
        public String finitbeanInitString;

        public MethodInfo(boolean generateReturn) {
            this.fSeperator = AbstractMethodTextGenerator.this.fModel.getLineSeperator();
            this.fmethodName = AbstractMethodTextGenerator.this.fmethodName;
            this.finitBeanType = AbstractMethodTextGenerator.this.finitBeanType == null ? ((JavaClassImpl)AbstractMethodTextGenerator.this.fComponent.eClass()).getQualifiedName() : AbstractMethodTextGenerator.this.finitBeanType;
            this.finitBeanName = AbstractMethodTextGenerator.this.finitbeanName;
            AbstractMethodTextGenerator.this.fGenerateComments = AbstractMethodTextGenerator.this.fGenerateComments;
            this.fComments = AbstractMethodTextGenerator.this.fComments == null ? new String[]{"This method initializes " + this.finitBeanName} : AbstractMethodTextGenerator.this.fComments;
            this.freturnType = generateReturn ? this.finitBeanType : null;
            this.finitbeanInitString = AbstractMethodTextGenerator.this.finitbeanInitString;
            AbstractMethodTextGenerator.this.fmethodArgs = AbstractMethodTextGenerator.this.fmethodArgs;
        }
    }
}

