/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ve.internal.java.vce.VCEPreferences;

public class ExpressionTemplate {
    public static final String SEMICOL = ";";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    public static final String COMMENT = "  //";
    public static final String COMMENT_GENERATED = "  // Generated";
    public static final String DOT = ".";
    public static final String EQL = "=";
    public static final int DEFAULT_INDENT = 5;
    String[] fComments;
    String fSelector;
    String fMethod;
    String[] fArguments;
    int fIndent = 5;
    String fLineSeperator = System.getProperty("line.separator");
    boolean fisMethod = true;
    boolean fGenerateComments = false;

    public ExpressionTemplate(String sel, String method, String[] args, String[] comments, int indent) {
        this.fComments = comments;
        this.fSelector = sel;
        this.fArguments = args;
        this.fIndent = indent;
        this.fMethod = method;
        Preferences store = VCEPreferences.getPlugin().getPluginPreferences();
        this.fGenerateComments = store.getBoolean("GENERATE_EXPRESSION_COMMENT");
    }

    public void setComments(String[] c) {
        this.fComments = c;
    }

    public void setComment(String c) {
        this.fComments = new String[]{c};
    }

    public void setSelector(String s) {
        this.fSelector = s;
    }

    public void setArguments(String[] args) {
        this.fArguments = args;
    }

    public void setAnArg(String arg) {
        this.fArguments = new String[]{arg};
    }

    public void setMethod(String m) {
        this.fMethod = m;
    }

    public void setIndent(int i) {
        this.fIndent = i;
    }

    public void setFieldAccess(boolean flag) {
        this.fisMethod = !flag;
    }

    public void setLineSeperator(String sep) {
        this.fLineSeperator = sep;
    }

    public String toString() {
        StringBuffer st = new StringBuffer();
        if (this.fSelector != null) {
            st.append(this.getExpression());
            st.append(SEMICOL);
        } else {
            int i = 0;
            while (i < this.fIndent) {
                st.append(SPACE);
                ++i;
            }
        }
        if (this.fComments != null) {
            st.append("  // ");
            st.append(this.fComments[0]);
        } else if (this.fGenerateComments) {
            st.append(COMMENT_GENERATED);
        }
        st.append(this.fLineSeperator);
        return st.toString();
    }

    public String getExpression() {
        if (this.fSelector == null) {
            return "?????";
        }
        StringBuffer st = new StringBuffer();
        int i = 0;
        while (i < this.fIndent) {
            st.append(SPACE);
            ++i;
        }
        st.append(this.fSelector);
        st.append(DOT + this.fMethod);
        if (this.fisMethod) {
            st.append(LPAREN);
            if (this.fArguments != null) {
                i = 0;
                while (i < this.fArguments.length) {
                    if (i > 0) {
                        st.append(", ");
                    }
                    st.append(this.fArguments[i]);
                    ++i;
                }
            }
            st.append(RPAREN);
        } else {
            st.append(" = ");
            st.append(this.fArguments[0]);
        }
        return st.toString();
    }

    public static String getExpressionWithFiller(String stmt) {
        int right = stmt.lastIndexOf(59);
        if (right > 0 && stmt.substring(right).indexOf(34) < 0 && stmt.substring(right).indexOf(39) < 0) {
            while (stmt.charAt(--right) == ' ' && right > 0) {
            }
            return stmt.substring(0, right + 1);
        }
        return stmt;
    }

    public static String getExpression(String stmt) {
        String s = ExpressionTemplate.getExpressionWithFiller(stmt);
        int i = 0;
        while (i < s.length()) {
            if (!Character.isWhitespace(s.charAt(i))) break;
            ++i;
        }
        return s.substring(i);
    }
}

