/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.eclipse.ve.internal.java.codegen.core.IVEModelInstance;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.Messages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.JCMFactory;
import org.eclipse.ve.internal.jcm.JavaCacheData;

public class VEModelCacheUtility {
    private static final Map XML_CACHE_SAVE_OPTIONS = new HashMap(4);
    private static JEMUtilPlugin.CleanResourceChangeListener cacheResourceListener;
    protected static final IPath VE_PROJECT_MODEL_CACHE_ROOT;

    static {
        XML_CACHE_SAVE_OPTIONS.put("ENCODING", "UTF-8");
        XML_CACHE_SAVE_OPTIONS.put("PROCESS_DANGLING_HREF", "RECORD");
        XML_CACHE_SAVE_OPTIONS.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        String option = String.valueOf(JavaVEPlugin.getPlugin().getBundle().getSymbolicName()) + "/debug/logtrace";
        if ("true".equalsIgnoreCase(Platform.getDebugOption((String)option))) {
            XML_CACHE_SAVE_OPTIONS.put("LINE_WIDTH", new Integer(100));
        } else {
            XML_CACHE_SAVE_OPTIONS.put("FORMATTED", Boolean.FALSE);
        }
        VE_PROJECT_MODEL_CACHE_ROOT = JavaVEPlugin.VE_CACHE_ROOT_NAME.append("emfmodel");
    }

    public static IPath getCacheDirectory(IFile f) {
        VEModelCacheUtility.addCacheResourceListener();
        IProject p = f.getProject();
        IPath projectCachePath = VEModelCacheUtility.getEMFModelCacheDestination(p);
        File dir = projectCachePath.toFile();
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                return projectCachePath;
            }
            return null;
        }
        return projectCachePath;
    }

    public static boolean isValidCache(IFile f) {
        File dest = VEModelCacheUtility.getCachedPath(f).toFile();
        return dest.canRead() && dest.lastModified() > f.getLocalTimeStamp();
    }

    protected static IPath getCachedPath(IFile f) {
        IPath savedPath = VEModelCacheUtility.getCacheDirectory(f).append(f.getProjectRelativePath());
        return savedPath.removeFileExtension().addFileExtension("xmi");
    }

    public static URI getCacheURI(IFile f) {
        return URI.createFileURI((String)VEModelCacheUtility.getCachedPath(f).toString());
    }

    public static Resource doLoadFromCache(IVEModelInstance model, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        Resource r = null;
        monitor.beginTask(String.valueOf(Messages.VEModelCacheUtility_2) + model.getFile().getName(), 3);
        if (VEModelCacheUtility.isValidCache(model.getFile())) {
            monitor.worked(1);
            try {
                URI uri = VEModelCacheUtility.getCacheURI(model.getFile());
                monitor.worked(1);
                r = model.getModelResourceSet().getResource(uri, true);
            }
            catch (Exception e) {
                VEModelCacheUtility.getCachedPath(model.getFile()).toFile().delete();
                JavaVEPlugin.log((Throwable)e);
            }
        }
        monitor.done();
        return r;
    }

    public static void annotateEMFModelWithCache(IBeanDeclModel bdm) {
        IVEModelInstance model = bdm.getCompositionModel();
        JavaCacheData cache = JCMFactory.eINSTANCE.createJavaCacheData();
        Iterator itr = bdm.getBeans().iterator();
        while (itr.hasNext()) {
            BeanPart bp = (BeanPart)itr.next();
            cache.getNamesToBeans().put((Object)bp.getUniqueName(), (Object)bp.getEObject());
        }
        Resource r = model.getModelResource();
        r.getContents().add((Object)cache);
    }

    public static JavaCacheData getJavaCacheData(IVEModelInstance model) {
        Resource r = model.getModelResource();
        int i = r.getContents().size() - 1;
        while (i >= 0) {
            Object next = r.getContents().get(i);
            if (next instanceof JavaCacheData) {
                return (JavaCacheData)next;
            }
            --i;
        }
        return null;
    }

    public static void removeCacheAnnotationFromEMFModel(IVEModelInstance model) {
        Resource r = model.getModelResource();
        r.getContents().remove((Object)VEModelCacheUtility.getJavaCacheData(model));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doSaveCache(IBeanDeclModel bdm, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.VEModelCacheUtility_3, 3);
        monitor.worked(1);
        if (bdm != null && bdm.getCompositionModel() != null) {
            IVEModelInstance model = bdm.getCompositionModel();
            try {
                block8: {
                    try {
                        VEModelCacheUtility.annotateEMFModelWithCache(bdm);
                        monitor.worked(1);
                        if (model.getModelResource().getURI().equals((Object)VEModelCacheUtility.getCacheURI(model.getFile()))) {
                            monitor.worked(1);
                            model.getModelResource().save(XML_CACHE_SAVE_OPTIONS);
                            break block8;
                        }
                        File f = VEModelCacheUtility.getCachedPath(model.getFile()).toFile();
                        monitor.worked(1);
                        monitor.subTask(String.valueOf(Messages.VEModelCacheUtility_4) + f.getName());
                        FileOutputStream os = new FileOutputStream(f);
                        model.getModelResource().save((OutputStream)os, XML_CACHE_SAVE_OPTIONS);
                        os.close();
                    }
                    catch (Exception e) {
                        VEModelCacheUtility.getCachedPath(model.getFile()).toFile().delete();
                        JavaVEPlugin.log((Throwable)e);
                    }
                }
                Object var5_8 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                VEModelCacheUtility.removeCacheAnnotationFromEMFModel(model);
                throw throwable;
            }
            VEModelCacheUtility.removeCacheAnnotationFromEMFModel(model);
        }
        monitor.done();
    }

    public static void removeCache(IVEModelInstance model) {
        if (model != null) {
            VEModelCacheUtility.removeCache(model.getFile());
        }
    }

    public static void removeCache(IFile file) {
        if (file != null) {
            VEModelCacheUtility.getCachedPath(file).toFile().delete();
        }
    }

    public static void addCacheResourceListener() {
        if (cacheResourceListener == null) {
            cacheResourceListener = new CacheResourceListener();
            JEMUtilPlugin.addCleanResourceChangeListener((JEMUtilPlugin.CleanResourceChangeListener)cacheResourceListener, (int)1);
        }
    }

    public static void removeCacheListener() {
        if (cacheResourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)cacheResourceListener);
            cacheResourceListener = null;
        }
    }

    protected static IPath getEMFModelCacheDestination(IProject p) {
        return p.getWorkingLocation(JavaVEPlugin.getPlugin().getBundle().getSymbolicName()).append(VE_PROJECT_MODEL_CACHE_ROOT);
    }

    private static class CacheResourceListener
    extends JEMUtilPlugin.CleanResourceChangeListener
    implements IResourceDeltaVisitor {
        public CacheResourceListener() {
            Job cleanup = new Job(this, Messages.VEModelCacheUtility_VEModelCache_ReconcileJob){
                final /* synthetic */ CacheResourceListener this$1;
                {
                    this.this$1 = cacheResourceListener;
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    Thread currentThread = Thread.currentThread();
                    int oldPrio = currentThread.getPriority();
                    try {
                        currentThread.setPriority(1);
                        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        monitor.beginTask("", projects.length);
                        int i = 0;
                        while (true) {
                            block5: {
                                if (i < projects.length) break block5;
                                monitor.done();
                                break;
                            }
                            IProject project = projects[i];
                            if (project.isOpen()) {
                                this.processDir(VEModelCacheUtility.getEMFModelCacheDestination(project).toFile(), (IContainer)project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            monitor.worked(1);
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        currentThread.setPriority(oldPrio);
                        throw throwable;
                    }
                    {
                        Object var7_9 = null;
                        currentThread.setPriority(oldPrio);
                        return Status.OK_STATUS;
                    }
                }

                private void processDir(File dir, IContainer folder, IProgressMonitor monitor) {
                    if (dir.canRead()) {
                        File[] files = dir.listFiles();
                        monitor.beginTask("", files.length);
                        int i = 0;
                        while (i < files.length) {
                            File file = files[i];
                            if (file.isDirectory()) {
                                IResource resource = folder.findMember(file.getName());
                                if (resource != null && resource.getType() == 2) {
                                    this.processDir(file, (IContainer)resource, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                } else {
                                    JEMUtilPlugin.deleteDirectoryContent((File)file, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                            } else {
                                IResource resource;
                                Path path = new Path(file.getName());
                                if ("xmi".equals(path.getFileExtension()) && ((resource = folder.findMember(path.removeFileExtension().addFileExtension("java"))) == null || resource.getType() != 1)) {
                                    JEMUtilPlugin.deleteDirectoryContent((File)file, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                            }
                            monitor.worked(1);
                            ++i;
                        }
                        monitor.done();
                    }
                }
            };
            cleanup.setPriority(30);
            cleanup.schedule(60000L);
        }

        protected void cleanProject(IProject project) {
            File projectCacheDir = VEModelCacheUtility.getEMFModelCacheDestination(project).toFile();
            JEMUtilPlugin.deleteDirectoryContent((File)projectCacheDir, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    try {
                        delta.accept((IResourceDeltaVisitor)this);
                    }
                    catch (CoreException e) {
                        JavaVEPlugin.log((Throwable)e);
                    }
                }
            } else {
                super.resourceChanged(event);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    return false;
                }
                case 2: {
                    switch (res.getType()) {
                        case 4: {
                            return false;
                        }
                        case 2: {
                            JEMUtilPlugin.deleteDirectoryContent((File)VEModelCacheUtility.getEMFModelCacheDestination(res.getProject()).append(res.getProjectRelativePath()).toFile(), (boolean)true, (IProgressMonitor)new NullProgressMonitor());
                            return false;
                        }
                        case 1: {
                            if ("java".equals(res.getFileExtension())) {
                                JEMUtilPlugin.deleteDirectoryContent((File)VEModelCacheUtility.getEMFModelCacheDestination(res.getProject()).append(res.getProjectRelativePath()).removeFileExtension().addFileExtension("xmi").toFile(), (boolean)true, (IProgressMonitor)new NullProgressMonitor());
                            }
                            return false;
                        }
                    }
                    break;
                }
            }
            return true;
        }
    }
}

