/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.wizards;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ve.internal.java.codegen.wizards.CategoryModel;
import org.eclipse.ve.internal.java.codegen.wizards.CodegenWizardsMessages;
import org.eclipse.ve.internal.java.codegen.wizards.StatusInfo;
import org.eclipse.ve.internal.java.codegen.wizards.StyleTreeContentProvider;
import org.eclipse.ve.internal.java.codegen.wizards.StyleTreeLabelProvider;
import org.eclipse.ve.internal.java.codegen.wizards.VisualElementModel;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class NewVisualClassWizardPage
extends NewClassWizardPage {
    TreeViewer styleTreeViewer;
    CategoryModel treeRoot;
    boolean isSettingSuperclass;
    private VisualElementModel selectedElement = null;
    private static final String DEFAULT_ELEMENT_KEY = "org.eclipse.ve.core.other-Object-java.lang.Object";
    private boolean useSuperClass;
    private boolean isSelectingTemplate = false;
    private IStatus fContributorStatus = StatusInfo.OK_STATUS;
    private IStatus fSourceFolderStatus = StatusInfo.OK_STATUS;
    protected SelectionButtonDialogFieldGroup fMethodStubsButtonsField;
    protected StringButtonDialogField localSuperclassButtonDialogField;

    protected void setTreeState() {
        Object[] topLevel = this.treeRoot.getChildren();
        if (topLevel != null) {
            int i = 0;
            while (i < topLevel.length) {
                if (topLevel[i] instanceof CategoryModel) {
                    this.styleTreeViewer.setExpandedState(topLevel[i], ((CategoryModel)topLevel[i]).getDefaultExpand());
                }
                ++i;
            }
        }
    }

    protected void createTreeClassComposite(Composite composite, int nColumns) {
        Composite labelGroup = this.createComposite(composite, 5);
        ((GridLayout)labelGroup.getLayout()).marginHeight = 0;
        GridData labelData = (GridData)labelGroup.getLayoutData();
        labelData.horizontalSpan = 5;
        this.createLabel(labelGroup, CodegenWizardsMessages.NewVisualClassWizardPage_Style_Label);
        this.styleTreeViewer = new TreeViewer(composite, 2052);
        GridData treeGridData = new GridData(768);
        treeGridData.verticalSpan = 4;
        treeGridData.widthHint = this.convertWidthInCharsToPixels(23);
        treeGridData.heightHint = this.convertHeightInCharsToPixels(12);
        this.styleTreeViewer.getTree().setLayoutData((Object)treeGridData);
        this.styleTreeViewer.setContentProvider((IContentProvider)new StyleTreeContentProvider());
        this.styleTreeViewer.setInput((Object)this.getInitalStyleInput());
        this.styleTreeViewer.setLabelProvider((IBaseLabelProvider)new StyleTreeLabelProvider());
        this.styleTreeViewer.setSorter((ViewerSorter)new TreePrioritySorter());
        this.setTreeState();
        if (this.selectedElement != null) {
            this.styleTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedElement), true);
        }
        this.styleTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    NewVisualClassWizardPage.this.selectedElement = null;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    NewVisualClassWizardPage.this.isSelectingTemplate = true;
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        Object domain = iterator.next();
                        if (domain instanceof VisualElementModel) {
                            NewVisualClassWizardPage.this.selectedElement = (VisualElementModel)domain;
                            NewVisualClassWizardPage.this.fContributorStatus = NewVisualClassWizardPage.this.selectedElement.getStatus(NewVisualClassWizardPage.this.getContainerRoot());
                            NewVisualClassWizardPage.this.setSuperClass(((VisualElementModel)domain).getSuperClass());
                            NewVisualClassWizardPage.this.handleFieldChanged(null);
                            continue;
                        }
                        NewVisualClassWizardPage.this.fContributorStatus = StatusInfo.OK_STATUS;
                        NewVisualClassWizardPage.this.handleFieldChanged(null);
                    }
                    NewVisualClassWizardPage.this.isSelectingTemplate = false;
                }
            }
        });
    }

    protected IResource getContainerRoot() {
        return this.getWorkspaceRoot().findMember(this.getPackageFragmentRootText());
    }

    protected void createSuperClassControls(Composite composite, int nColumns) {
        this.createTreeClassComposite(composite, nColumns);
        Composite controlsComp = this.createComposite(composite, nColumns);
        ((GridLayout)controlsComp.getLayout()).marginHeight = 0;
        GridData griddata = (GridData)controlsComp.getLayoutData();
        griddata.horizontalSpan = 3;
        griddata.horizontalIndent = 20;
        super.createSuperClassControls(controlsComp, nColumns);
        super.createSuperInterfacesControls(controlsComp, nColumns);
    }

    protected void createSuperInterfacesControls(Composite composite, int nColumns) {
    }

    private CategoryModel findParentStyle(String category, CategoryModel treeRoot) {
        Object[] iterator = treeRoot.getChildren();
        int i = 0;
        while (i < iterator.length) {
            if (iterator[i] instanceof CategoryModel && ((CategoryModel)iterator[i]).getId().equalsIgnoreCase(category)) {
                return (CategoryModel)iterator[i];
            }
            ++i;
        }
        return null;
    }

    private CategoryModel getInitalStyleInput() {
        String[] previousSelectedElementData = null;
        if (!this.useSuperClass) {
            Preferences preferences = JavaVEPlugin.getPlugin().getPluginPreferences();
            if (!preferences.getDefaultString("VISUAL_CLASS_WIZARD_SELECTED_ELEMENT_KEY").equals(DEFAULT_ELEMENT_KEY)) {
                preferences.setDefault("VISUAL_CLASS_WIZARD_SELECTED_ELEMENT_KEY", DEFAULT_ELEMENT_KEY);
            }
            String previousSelectedElement = preferences.getString("VISUAL_CLASS_WIZARD_SELECTED_ELEMENT_KEY");
            previousSelectedElementData = previousSelectedElement.split("-");
        }
        this.treeRoot = new CategoryModel();
        IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint(JavaVEPlugin.getPlugin().getBundle().getSymbolicName(), "newStyleComponent");
        IExtension[] extensions = exp.getExtensions();
        CategoryModel parentStyle = null;
        if (extensions != null && extensions.length > 0) {
            int ec = 0;
            while (ec < extensions.length) {
                IConfigurationElement[] configElms = extensions[ec].getConfigurationElements();
                int cc = 0;
                while (cc < configElms.length) {
                    IConfigurationElement celm = configElms[cc];
                    if (celm.getName().equalsIgnoreCase("Category")) {
                        this.treeRoot.addStyle(new CategoryModel(celm));
                    }
                    if (celm.getName().equalsIgnoreCase("visualElement")) {
                        parentStyle = this.findParentStyle(celm.getAttribute("category"), this.treeRoot);
                        VisualElementModel vem = new VisualElementModel(celm);
                        if (parentStyle != null) {
                            parentStyle.addVisualElement(vem);
                        } else {
                            this.treeRoot.addVisualElement(vem);
                        }
                        if (this.useSuperClass) {
                            if (vem.getSuperClass().equals(this.getSuperClass()) && vem.getStatus(this.getContainerRoot()).isOK()) {
                                this.selectedElement = vem;
                            }
                        } else if (vem.getCategory().equals(previousSelectedElementData[0]) && vem.getName().equals(previousSelectedElementData[1]) && vem.getStatus(this.getContainerRoot()).isOK()) {
                            this.selectedElement = vem;
                            this.setSuperClass(previousSelectedElementData[2], true);
                        }
                    }
                    ++cc;
                }
                ++ec;
            }
        }
        return this.treeRoot;
    }

    protected void updateStatus(IStatus[] statusArg) {
        IStatus[] status = new IStatus[statusArg.length + 2];
        System.arraycopy(statusArg, 0, status, 1, statusArg.length);
        status[status.length - 1] = this.fSourceFolderStatus;
        status[0] = this.fContributorStatus;
        super.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    public void setSuperClass(String name) {
        this.useSuperClass = true;
        super.setSuperClass(name, true);
    }

    protected SelectionButtonDialogFieldGroup getMethodStubsButtonsField() {
        if (this.fMethodStubsButtonsField == null) {
            try {
                Class<?> newClassWizardPage = Class.forName("org.eclipse.jdt.ui.wizards.NewClassWizardPage");
                Field field = newClassWizardPage.getDeclaredField("fMethodStubsButtons");
                field.setAccessible(true);
                this.fMethodStubsButtonsField = (SelectionButtonDialogFieldGroup)field.get((Object)this);
            }
            catch (Exception exc) {
                JavaVEPlugin.log((Throwable)exc, (Level)Level.FINEST);
            }
        }
        return this.fMethodStubsButtonsField;
    }

    protected StringButtonDialogField getSuperclassButtonDialogField() {
        if (this.localSuperclassButtonDialogField == null) {
            try {
                Class<?> newClassWizardPage = Class.forName("org.eclipse.jdt.ui.wizards.NewTypeWizardPage");
                Field field = newClassWizardPage.getDeclaredField("fSuperClassDialogField");
                field.setAccessible(true);
                this.localSuperclassButtonDialogField = (StringButtonDialogField)field.get((Object)this);
            }
            catch (Exception exc) {
                JavaVEPlugin.log((Throwable)exc, (Level)Level.FINEST);
            }
        }
        return this.localSuperclassButtonDialogField;
    }

    protected void handleFieldChanged(String fieldName) {
        if (fieldName == "NewContainerWizardPage.container") {
            this.fSourceFolderStatus = StatusInfo.OK_STATUS;
            try {
                JavaProject javaProject;
                IProject project;
                if (this.getContainerRoot() != null && (project = this.getContainerRoot().getProject()) != null && (javaProject = (JavaProject)project.getNature("org.eclipse.jdt.core.javanature")) != null && ProxyPlugin.isPDEProject((IJavaProject)javaProject)) {
                    if (!javaProject.isOnClasspath((IJavaElement)this.getPackageFragmentRoot())) {
                        this.fSourceFolderStatus = new StatusInfo(4, "", "org.eclipse.ve.java.core");
                    } else {
                        boolean uiIncluded;
                        HashMap plugins = new HashMap();
                        ProxyPlugin.getPlugin().getIDsFound((IJavaProject)javaProject, new HashMap(), new HashMap(), plugins, new HashMap());
                        boolean bl = uiIncluded = plugins.get("org.eclipse.ui") != null;
                        if (!uiIncluded) {
                            this.fSourceFolderStatus = new StatusInfo(4, "", "org.eclipse.ve.java.core");
                        }
                    }
                }
            }
            catch (CoreException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.FINEST);
            }
            if (this.selectedElement != null) {
                this.fContributorStatus = this.selectedElement.getStatus(this.getContainerRoot());
            }
        } else if (fieldName == "NewTypeWizardPage.superclass") {
            if (!this.isSelectingTemplate && this.styleTreeViewer != null) {
                this.handleSuperclassChanged();
            }
        } else if (fieldName == "NewTypeWizardPage.enclosing.selection") {
            String ERROR_MESSAGE = CodegenWizardsMessages.NewVisualClassWizardPage_EnclosedType_ERROR_;
            if (this.getEnclosingType() != null) {
                this.fContributorStatus = new Status(4, "org.eclipse.ve.java.core", 4, ERROR_MESSAGE, null);
            } else if (this.fContributorStatus != null && this.fContributorStatus.getSeverity() == 4 && this.fContributorStatus.getMessage().equals(ERROR_MESSAGE)) {
                this.fContributorStatus = StatusInfo.OK_STATUS;
            }
        }
        super.handleFieldChanged(fieldName);
    }

    private void handleSuperclassChanged() {
        String textSuperString;
        boolean superCheckNeeded = true;
        if (this.selectedElement != null) {
            String selectedSuperString = this.selectedElement.getSuperClass();
            textSuperString = this.getSuperClass();
            if (textSuperString != null) {
                boolean bl = superCheckNeeded = !textSuperString.equals(selectedSuperString);
            }
        }
        if (superCheckNeeded) {
            boolean setProperly = false;
            if (this.treeRoot != null) {
                textSuperString = this.getSuperClass();
                Object[] styles = this.treeRoot.getStyles();
                if (styles != null) {
                    VisualElementModel toSelectVisualElement = null;
                    int stylesCount = 0;
                    while (stylesCount < styles.length) {
                        Object[] children = ((CategoryModel)styles[stylesCount]).getChildren();
                        if (children != null) {
                            int childCount = 0;
                            while (childCount < children.length) {
                                VisualElementModel childElementModel = (VisualElementModel)children[childCount];
                                if (textSuperString.equals(childElementModel.getSuperClass())) {
                                    toSelectVisualElement = childElementModel;
                                    break;
                                }
                                ++childCount;
                            }
                        }
                        if (toSelectVisualElement != null) break;
                        ++stylesCount;
                    }
                    if (toSelectVisualElement != null) {
                        setProperly = true;
                        this.styleTreeViewer.setSelection((ISelection)new StructuredSelection(toSelectVisualElement), true);
                    }
                }
            }
            if (!setProperly) {
                this.styleTreeViewer.setSelection(null);
            }
        }
    }

    protected Composite createComposite(Composite aParent, int numColumns) {
        Composite group = new Composite(aParent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.marginWidth = 1;
        group.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    protected Group createGroup(Composite aParent, String title, int numColumns) {
        Group group = new Group(aParent, 0);
        if (title != null) {
            group.setText(title);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        group.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    protected void createLabel(Composite parent, String text) {
        Label spacer = new Label(parent, 0);
        if (text != null) {
            spacer.setText(text);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        spacer.setLayoutData((Object)data);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createMethodStubSelectionControls(parent, 2);
    }

    private void createMethodStubSelectionControls(Composite composite, int nColumns) {
        SelectionButtonDialogFieldGroup fg = this.getMethodStubsButtonsField();
        if (fg == null) {
            return;
        }
        Label labelControl = fg.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, (int)nColumns);
        LayoutUtil.setHorizontalIndent((Control)labelControl, (int)20);
        Composite buttonGroup = fg.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)nColumns);
        LayoutUtil.setHorizontalIndent((Control)buttonGroup, (int)60);
    }

    public HashMap getArgumentMatrix() {
        HashMap<String, String> argumentMatrix = new HashMap<String, String>();
        argumentMatrix.put("createMain", this.isCreateMain() ? "true" : "false");
        argumentMatrix.put("createSuperConstructors", this.isCreateConstructors() ? "true" : "false");
        argumentMatrix.put("createInheritedAbstract", this.isCreateInherited() ? "true" : "false");
        argumentMatrix.put("targetPackageName", this.getPackageText());
        return argumentMatrix;
    }

    public VisualElementModel getSelectedElement() {
        return this.selectedElement;
    }

    public class TreePrioritySorter
    extends ViewerSorter {
        public int category(Object element) {
            if (element instanceof CategoryModel) {
                return ((CategoryModel)element).getPriority();
            }
            return 20000;
        }
    }
}

