/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.swt;

import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.swt.DisplayManager;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.swt.SwtPlugin;

public final class JavaStandardSWTBeanConstants {
    public static final Object REGISTRY_KEY = new Object();
    IBeanTypeProxy environmentBeanTypeProxy;
    IBeanProxy displayProxy;
    IBeanProxy environmentProxy;
    final IFieldProxy pointXProxy;
    final IFieldProxy pointYProxy;
    final IFieldProxy rectangleHeightProxy;
    final IFieldProxy rectangleWidthProxy;
    final IFieldProxy rectangleXProxy;
    final IFieldProxy rectangleYProxy;

    public static JavaStandardSWTBeanConstants getConstants(ProxyFactoryRegistry registry) {
        JavaStandardSWTBeanConstants constants = (JavaStandardSWTBeanConstants)registry.getConstants(REGISTRY_KEY);
        if (constants == null) {
            constants = new JavaStandardSWTBeanConstants(registry, registry.getBeanProxyFactoryExtension("standard-java.SWT") != null);
            registry.registerConstants(REGISTRY_KEY, (Object)constants);
        }
        return constants;
    }

    /*
     * WARNING - void declaration
     */
    public JavaStandardSWTBeanConstants(ProxyFactoryRegistry registry, boolean isRegistered) {
        void var6_6;
        String envTypeName;
        IStandardBeanTypeProxyFactory typeFactory = registry.getBeanTypeProxyFactory();
        IBeanTypeProxy pointTypeProxy = typeFactory.getBeanTypeProxy("org.eclipse.swt.graphics.Point");
        this.pointXProxy = pointTypeProxy.getFieldProxy("x");
        this.pointYProxy = pointTypeProxy.getFieldProxy("y");
        IBeanTypeProxy rectangleTypeProxy = typeFactory.getBeanTypeProxy("org.eclipse.swt.graphics.Rectangle");
        this.rectangleHeightProxy = rectangleTypeProxy.getFieldProxy("height");
        this.rectangleWidthProxy = rectangleTypeProxy.getFieldProxy("width");
        this.rectangleXProxy = rectangleTypeProxy.getFieldProxy("x");
        this.rectangleYProxy = rectangleTypeProxy.getFieldProxy("y");
        if ("win32".equals(Platform.getOS())) {
            envTypeName = "org.eclipse.ve.internal.swt.targetvm.win32.Environment";
        } else if ("gtk".equals(Platform.getWS())) {
            envTypeName = "org.eclipse.ve.internal.swt.targetvm.unix.Environment";
        } else {
            return;
        }
        this.environmentBeanTypeProxy = typeFactory.getBeanTypeProxy((String)var6_6);
    }

    public IFieldProxy getPointXFieldProxy() {
        return this.pointXProxy;
    }

    public IFieldProxy getPointYFieldProxy() {
        return this.pointYProxy;
    }

    public IFieldProxy getRectangleHeightFieldProxy() {
        return this.rectangleHeightProxy;
    }

    public IFieldProxy getRectangleWidthFieldProxy() {
        return this.rectangleWidthProxy;
    }

    public IFieldProxy getRectangleXFieldProxy() {
        return this.rectangleXProxy;
    }

    public IFieldProxy getRectangleYFieldProxy() {
        return this.rectangleYProxy;
    }

    public IBeanProxy getEnvironmentProxy() {
        if (this.environmentProxy == null) {
            try {
                IConstructorProxy newEnvProxy = this.environmentBeanTypeProxy.getConstructorProxy(new String[]{"org.eclipse.jem.internal.proxy.common.IVMServer"});
                this.environmentProxy = newEnvProxy.newInstance(new IBeanProxy[]{newEnvProxy.getProxyFactoryRegistry().getBeanProxyFactory().getIVMServerProxy()});
            }
            catch (ThrowableProxy e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
        }
        return this.environmentProxy;
    }

    public IBeanProxy getDisplayProxy() {
        if (this.displayProxy == null) {
            this.displayProxy = this.environmentBeanTypeProxy.getMethodProxy("getDisplay").invokeCatchThrowableExceptions(this.getEnvironmentProxy());
        }
        return this.displayProxy;
    }

    public static Object invokeSyncExec(ProxyFactoryRegistry registry, DisplayManager.DisplayRunnable runnable) throws ThrowableProxy, DisplayManager.DisplayRunnable.RunnableException {
        JavaStandardSWTBeanConstants constants = JavaStandardSWTBeanConstants.getConstants(registry);
        return DisplayManager.syncExec(constants.getDisplayProxy(), runnable);
    }

    public static Object invokeSyncExec(IBeanProxy displayProxy, DisplayManager.DisplayRunnable runnable) throws ThrowableProxy, DisplayManager.DisplayRunnable.RunnableException {
        return DisplayManager.syncExec(displayProxy, runnable);
    }

    public static Object invokeSyncExec(ProxyFactoryRegistry registry, DisplayManager.ExpressionDisplayRunnable runnable) throws ThrowableProxy, DisplayManager.DisplayRunnable.RunnableException {
        JavaStandardSWTBeanConstants constants = JavaStandardSWTBeanConstants.getConstants(registry);
        return DisplayManager.syncExec(constants.getDisplayProxy(), runnable);
    }

    public static Object invokeSyncExec(IBeanProxy displayProxy, DisplayManager.ExpressionDisplayRunnable runnable) throws ThrowableProxy, DisplayManager.DisplayRunnable.RunnableException {
        return DisplayManager.syncExec(displayProxy, runnable);
    }

    public static Object invokeSyncExecCatchThrowableExceptions(ProxyFactoryRegistry registry, DisplayManager.DisplayRunnable runnable) {
        try {
            return JavaStandardSWTBeanConstants.invokeSyncExec(registry, runnable);
        }
        catch (ThrowableProxy e) {
            SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
        }
        catch (DisplayManager.DisplayRunnable.RunnableException e) {
            SwtPlugin.getDefault().getLogger().log(e.getCause(), Level.WARNING);
        }
        return null;
    }

    public static Object invokeSyncExecCatchThrowableExceptions(IBeanProxy displayProxy, DisplayManager.DisplayRunnable runnable) {
        try {
            return JavaStandardSWTBeanConstants.invokeSyncExec(displayProxy, runnable);
        }
        catch (ThrowableProxy e) {
            SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
        }
        catch (DisplayManager.DisplayRunnable.RunnableException e) {
            SwtPlugin.getDefault().getLogger().log(e.getCause(), Level.WARNING);
        }
        return null;
    }

    public static Object invokeSyncExecCatchThrowableExceptions(ProxyFactoryRegistry registry, DisplayManager.ExpressionDisplayRunnable runnable) {
        try {
            return JavaStandardSWTBeanConstants.invokeSyncExec(registry, runnable);
        }
        catch (ThrowableProxy e) {
            SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
        }
        catch (DisplayManager.DisplayRunnable.RunnableException e) {
            SwtPlugin.getDefault().getLogger().log(e.getCause(), Level.WARNING);
        }
        return null;
    }

    public static Object invokeSyncExecCatchThrowableExceptions(IBeanProxy displayProxy, DisplayManager.ExpressionDisplayRunnable runnable) {
        try {
            return JavaStandardSWTBeanConstants.invokeSyncExec(displayProxy, runnable);
        }
        catch (ThrowableProxy e) {
            SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
        }
        catch (DisplayManager.DisplayRunnable.RunnableException e) {
            SwtPlugin.getDefault().getLogger().log(e.getCause(), Level.WARNING);
        }
        return null;
    }
}

