/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.commands.NoOpCommand;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.swt.CBannerContainerPolicy;
import org.eclipse.ve.internal.swt.CBannerLayoutFeedback;
import org.eclipse.ve.internal.swt.CBannerLayoutPolicyHelper;
import org.eclipse.ve.internal.swt.CustomLayoutRegionFeedback;
import org.eclipse.ve.internal.swt.SWTConstants;

public class CBannerLayoutEditPolicy
extends LayoutEditPolicy {
    protected static VisualContainerPolicy fPolicy;
    protected CBannerLayoutPolicyHelper fLayoutPolicyHelper;
    protected CBannerLayoutFeedback fCBannerLayoutFeedback = null;
    protected CustomLayoutRegionFeedback fRegionFeedback = null;
    protected Rectangle fCurrentRectangle = null;

    public CBannerLayoutEditPolicy(EditDomain anEditDomain) {
        fPolicy = new CBannerContainerPolicy(anEditDomain);
        this.fLayoutPolicyHelper = new CBannerLayoutPolicyHelper();
        this.fLayoutPolicyHelper.setContainerPolicy(fPolicy);
    }

    public void activate() {
        super.activate();
        fPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        fPolicy.setContainer(null);
    }

    public EditPolicy createChildEditPolicy(EditPart aChild) {
        return new NonResizableEditPolicy();
    }

    protected Point getLocationFromRequest(Request request) {
        if (request instanceof CreateRequest) {
            return ((CreateRequest)request).getLocation();
        }
        if (request instanceof ChangeBoundsRequest) {
            return ((ChangeBoundsRequest)request).getLocation();
        }
        return null;
    }

    private void addRegionFeedback(Request request) {
        Point position = this.getLocationFromRequest(request).getCopy();
        this.getHostFigure().translateToRelative((Translatable)position);
        String str = this.fCBannerLayoutFeedback.getCurrentConstraint(position);
        if (this.fLayoutPolicyHelper.isRegionAvailable(str)) {
            Rectangle r = this.fCBannerLayoutFeedback.getCurrentRectangle(position);
            if (!(r == null || this.fCurrentRectangle != null && r.equals((Object)this.fCurrentRectangle))) {
                if (this.fRegionFeedback != null) {
                    this.removeFeedback((IFigure)this.fRegionFeedback);
                }
                this.fCurrentRectangle = r;
                CustomLayoutRegionFeedback rf = new CustomLayoutRegionFeedback();
                rf.setLabel(CBannerLayoutFeedback.getDisplayConstraint(str));
                this.fRegionFeedback = rf;
                this.fRegionFeedback.setBounds(r);
                this.addFeedback((IFigure)this.fRegionFeedback);
            }
        } else if (this.fRegionFeedback != null) {
            this.removeFeedback((IFigure)this.fRegionFeedback);
            this.fRegionFeedback = null;
            this.fCurrentRectangle = null;
        }
    }

    protected Command createAddCommand(EditPart childEditPart, Object constraint) {
        if (constraint == null || !(constraint instanceof String)) {
            return UnexecutableCommand.INSTANCE;
        }
        ArrayList<IJavaObjectInstance> children = new ArrayList<IJavaObjectInstance>(1);
        IJavaObjectInstance child = (IJavaObjectInstance)childEditPart.getModel();
        children.add(child);
        UnexecutableCommand addCmd = UnexecutableCommand.INSTANCE;
        if (this.fLayoutPolicyHelper.isRegionAvailable((String)constraint)) {
            addCmd = this.fLayoutPolicyHelper.getAddChildrenCommand(children, Collections.singletonList(constraint), null);
        }
        return addCmd;
    }

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint) {
        return this.fLayoutPolicyHelper.getChangeConstraintCommand(Collections.singletonList(childEditPart.getModel()), Collections.singletonList(constraint));
    }

    protected Command createCreateCommand(Object child, String aConstraint) {
        UnexecutableCommand addCmd = UnexecutableCommand.INSTANCE;
        if (this.fLayoutPolicyHelper.isRegionAvailable(aConstraint)) {
            addCmd = this.fLayoutPolicyHelper.getCreateChildCommand(child, aConstraint, null);
        }
        return addCmd;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.fCBannerLayoutFeedback != null) {
            this.removeFeedback((IFigure)this.fCBannerLayoutFeedback);
            this.fCBannerLayoutFeedback = null;
        }
        if (this.fRegionFeedback != null) {
            this.removeFeedback((IFigure)this.fRegionFeedback);
            this.fRegionFeedback = null;
            this.fCurrentRectangle = null;
        }
    }

    protected Command getAddCommand(Request request) {
        ChangeBoundsRequest cbReq = (ChangeBoundsRequest)request;
        if (cbReq.getEditParts().size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        EditPart child = (EditPart)cbReq.getEditParts().get(0);
        Point p = cbReq.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)p);
        String constraint = null;
        if (this.fCBannerLayoutFeedback != null) {
            constraint = this.fCBannerLayoutFeedback.getCurrentConstraint(p);
        }
        if (constraint != null) {
            return this.createAddCommand(child, constraint);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Figure getCBannerLayoutFeedback(Request request) {
        if (this.fCBannerLayoutFeedback == null) {
            CBannerLayoutFeedback bf = new CBannerLayoutFeedback();
            bf.setLineStyle(3);
            this.fCBannerLayoutFeedback = bf;
            IFigure f = ((GraphicalEditPart)this.getHost()).getContentPane();
            Rectangle r = f.getBounds().getCopy();
            r.shrink(2, 2);
            this.fCBannerLayoutFeedback.setBounds(r);
            if (request.getType() != "move") {
                this.fCBannerLayoutFeedback.setFilledRegions(this.fLayoutPolicyHelper.getFilledRegions());
            } else {
                this.fCBannerLayoutFeedback.setFilledRegions(null);
            }
            this.addFeedback((IFigure)this.fCBannerLayoutFeedback);
        }
        this.addRegionFeedback(request);
        return this.fCBannerLayoutFeedback;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Point p = request.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)p);
        String constraint = null;
        if (this.fCBannerLayoutFeedback != null) {
            constraint = this.fCBannerLayoutFeedback.getCurrentConstraint(p);
        }
        if (constraint != null) {
            return this.createCreateCommand(request.getNewObject(), constraint);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected void showLayoutTargetFeedback(Request request) {
        this.getCBannerLayoutFeedback(request);
    }

    protected Command getDeleteDependantCommand(Request request) {
        Command deleteContributionCmd = fPolicy.getCommand(request);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Object getConstraintFor(Point point) {
        if (this.fCBannerLayoutFeedback != null) {
            Point relativePoint = point.getCopy();
            this.getHostFigure().translateToRelative((Translatable)relativePoint);
            return this.fCBannerLayoutFeedback.getCurrentConstraint(relativePoint);
        }
        return null;
    }

    protected Command getMoveChildrenCommand(Request generic) {
        EObject parent = (EObject)fPolicy.getContainer();
        EStructuralFeature sfLeftControl = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)parent), (URI)SWTConstants.SF_CBANNER_LEFT);
        EStructuralFeature sfRightControl = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)parent), (URI)SWTConstants.SF_CBANNER_RIGHT);
        EStructuralFeature sfBottomControl = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)parent), (URI)SWTConstants.SF_CBANNER_BOTTOM);
        IJavaInstance left = (IJavaInstance)parent.eGet(sfLeftControl);
        IJavaInstance right = (IJavaInstance)parent.eGet(sfRightControl);
        IJavaInstance bottom = (IJavaInstance)parent.eGet(sfBottomControl);
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List sources = request.getEditParts();
        if (sources.size() > 1) {
            return null;
        }
        EditPart child = (EditPart)sources.iterator().next();
        String newConstraint = (String)this.getConstraintFor(request.getLocation());
        Command moveControl = null;
        CommandBuilder cBld = new CommandBuilder("");
        EStructuralFeature moveFrom = null;
        EStructuralFeature moveTo = null;
        if (left != null && left.equals(child.getModel())) {
            moveFrom = sfLeftControl;
        } else if (right != null && right.equals(child.getModel())) {
            moveFrom = sfRightControl;
        } else if (bottom != null && bottom.equals(child.getModel())) {
            moveFrom = sfBottomControl;
        }
        if (left == null && ((String)CBannerLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(0)).equals(newConstraint)) {
            moveTo = sfLeftControl;
        } else if (right == null && ((String)CBannerLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(1)).equals(newConstraint)) {
            moveTo = sfRightControl;
        } else if (bottom == null && ((String)CBannerLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(2)).equals(newConstraint)) {
            moveTo = sfBottomControl;
        }
        if (moveFrom != null && moveTo != null) {
            cBld.applyAttributeSetting(parent, moveFrom, null);
            cBld.applyAttributeSetting(parent, moveTo, child.getModel(), null);
            moveControl = cBld.getCommand();
        }
        if (moveControl == null || !moveControl.canExecute()) {
            return NoOpCommand.INSTANCE;
        }
        return moveControl;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        Command orphanContributionCmd = fPolicy.getCommand(request);
        if (orphanContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return orphanContributionCmd;
    }

    public static boolean isSimple() {
        EStructuralFeature isSimple;
        EObject parent = (EObject)fPolicy.getContainer();
        IJavaDataTypeInstance simple = (IJavaDataTypeInstance)parent.eGet(isSimple = JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)parent), (URI)SWTConstants.SF_CBANNER_SIMPLE));
        if (simple != null) {
            return ((IBooleanBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)simple)).booleanValue();
        }
        return true;
    }
}

