/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IErrorNotifier;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.cde.emf.EditPartAdapterRunnable;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.swt.CTabFolderContainerPolicy;
import org.eclipse.ve.internal.swt.CTabFolderProxyAdapter;
import org.eclipse.ve.internal.swt.CompositeGraphicalEditPart;
import org.eclipse.ve.internal.swt.ControlGraphicalEditPart;
import org.eclipse.ve.internal.swt.SWTConstants;
import org.eclipse.ve.internal.swt.UnknownLayoutInputPolicy;

public class CTabFolderGraphicalEditPart
extends CompositeGraphicalEditPart {
    private EReference sf_items;
    private EReference sf_ctabItemControl;
    protected CTabFolderProxyAdapter ctabFolderProxyAdapter;
    private EditPartListener pageListener;
    protected IJavaObjectInstance fSelectedItem;
    private Adapter containerAdapter = new EditPartAdapterRunnable((EditPart)this){

        protected void doRun() {
            if (CTabFolderGraphicalEditPart.this.fSelectedItem != null) {
                EditPart currentPage = CTabFolderGraphicalEditPart.this.getEditPartFromModel(CTabFolderGraphicalEditPart.this.fSelectedItem);
                CTabFolderGraphicalEditPart.this.setPageVisible(currentPage, false);
            }
            CTabFolderGraphicalEditPart.this.refreshChildren();
            List children = CTabFolderGraphicalEditPart.this.getChildren();
            int s = children.size();
            int i = 0;
            while (i < s) {
                EditPart ep = (EditPart)children.get(i);
                try {
                    CTabFolderGraphicalEditPart.this.setupControl((ControlGraphicalEditPart)ep, (EObject)ep.getModel());
                }
                catch (ClassCastException classCastException) {}
                ++i;
            }
            EditPart page = CTabFolderGraphicalEditPart.this.getEditPartFromModel(CTabFolderGraphicalEditPart.this.fSelectedItem);
            if (page == null && s > 0) {
                page = (EditPart)children.get(0);
            }
            CTabFolderGraphicalEditPart.this.setPageVisible(page, true);
            CTabFolderGraphicalEditPart.this.pageSelected(page);
            CTabFolderGraphicalEditPart.this.getCTabFolderProxyAdapter().revalidateBeanProxy();
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == CTabFolderGraphicalEditPart.this.sf_items) {
                this.queueExec((EditPart)CTabFolderGraphicalEditPart.this, "ITEMS");
            }
        }
    };
    static /* synthetic */ Class class$0;

    public CTabFolderGraphicalEditPart(Object model) {
        super(model);
    }

    public void activate() {
        this.setListener(this.createPageListener());
        super.activate();
        ((EObject)this.getModel()).eAdapters().add((Object)this.containerAdapter);
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart page = (EditPart)children.get(i);
            this.addPageListenerToChildren(page);
            if (i == 0) {
                this.setPageVisible(page, true);
                this.pageSelected((EditPart)this.getChildren().get(0));
            } else {
                this.setPageVisible(page, false);
            }
            ++i;
        }
    }

    public void deactivate() {
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            this.removePageListenerFromChildren((EditPart)children.next());
        }
        ((EObject)this.getModel()).eAdapters().remove((Object)this.containerAdapter);
        this.setListener(null);
        super.deactivate();
    }

    protected void createLayoutEditPolicy() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new UnknownLayoutInputPolicy(new CTabFolderContainerPolicy(EditDomain.getEditDomain((EditPart)this))));
    }

    protected void setPageVisible(EditPart page, boolean bool) {
        if (page != null) {
            ((GraphicalEditPart)page).getFigure().setVisible(bool);
            IFigure fig = ((GraphicalEditPart)page).getFigure();
            Iterator children = page.getChildren().iterator();
            while (children.hasNext()) {
                ((GraphicalEditPart)children.next()).getFigure().setVisible(bool);
            }
            fig.revalidate();
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        ResourceSet rset = ((EObject)model).eResource().getResourceSet();
        this.sf_items = JavaInstantiation.getReference((ResourceSet)rset, (URI)SWTConstants.SF_CTABFOLDER_ITEMS);
        this.sf_ctabItemControl = JavaInstantiation.getReference((ResourceSet)rset, (URI)SWTConstants.SF_CTABITEM_CONTROL);
    }

    protected List getModelChildren() {
        List tabitems = (List)((EObject)this.getModel()).eGet((EStructuralFeature)this.sf_items);
        ArrayList<Object> children = new ArrayList<Object>(tabitems.size());
        Iterator itr = tabitems.iterator();
        while (itr.hasNext()) {
            EObject tabitem = (EObject)itr.next();
            if (tabitem.eGet((EStructuralFeature)this.sf_ctabItemControl) == null) continue;
            children.add(tabitem.eGet((EStructuralFeature)this.sf_ctabItemControl));
        }
        return children;
    }

    protected void setListener(EditPartListener listener) {
        if (this.pageListener != null) {
            this.removeEditPartListener(this.pageListener);
        }
        this.pageListener = listener;
        if (this.pageListener != null) {
            this.addEditPartListener(this.pageListener);
        }
    }

    protected void removePageListenerFromChildren(EditPart ep) {
        ep.removeEditPartListener(this.pageListener);
        Iterator childen = ep.getChildren().iterator();
        while (childen.hasNext()) {
            this.removePageListenerFromChildren((EditPart)childen.next());
        }
    }

    protected void pageSelected(EditPart page) {
        if (page != null) {
            if (this.fSelectedItem != null) {
                EditPart currentPage = this.getEditPartFromModel(this.fSelectedItem);
                this.setPageVisible(currentPage, false);
            }
            this.setPageVisible(page, true);
            this.fSelectedItem = (IJavaObjectInstance)page.getModel();
            this.getCTabFolderProxyAdapter().setSelection(this.getTabForChild((EObject)this.fSelectedItem));
        }
    }

    protected void switchToTab(Point p) {
        if (p != null) {
            ResourceSet rset = EMFEditDomainHelper.getResourceSet((EditDomain)EditDomain.getEditDomain((EditPart)this));
            IJavaObjectInstance point = (IJavaObjectInstance)BeanUtilities.createJavaObject((String)"org.eclipse.swt.graphics.Point", (ResourceSet)rset, (String)("new org.eclipse.swt.graphics.Point(" + p.x + "," + p.y + ")"));
            int newTab = this.getCTabFolderProxyAdapter().getCTabItemFromLocation(point);
            if (newTab == -1) {
                return;
            }
            List children = this.getChildren();
            if (children != null && newTab < children.size()) {
                this.pageSelected((EditPart)children.get(newTab));
            }
        }
    }

    protected EditPart getPageOfSelectedEditpart(EditPart ep) {
        if (ep == null || ep.getParent() == this) {
            return ep;
        }
        return this.getPageOfSelectedEditpart(ep.getParent());
    }

    protected CTabFolderProxyAdapter getCTabFolderProxyAdapter() {
        if (this.ctabFolderProxyAdapter == null) {
            IBeanProxyHost ctabFolderProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getModel()));
            this.ctabFolderProxyAdapter = (CTabFolderProxyAdapter)ctabFolderProxyHost;
        }
        return this.ctabFolderProxyAdapter;
    }

    protected EditPart getEditPartFromModel(IJavaObjectInstance pageModel) {
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            EditPart page = (EditPart)children.next();
            if ((IJavaObjectInstance)page.getModel() != pageModel) continue;
            return page;
        }
        return null;
    }

    protected EditPartListener createPageListener() {
        return new EditPartListener.Stub(){

            public void childAdded(EditPart editpart, int index) {
                CTabFolderGraphicalEditPart.this.addPageListenerToChildren(editpart);
            }

            public void removingChild(EditPart editpart, int index) {
                CTabFolderGraphicalEditPart.this.removePageListenerFromChildren(editpart);
            }

            public void selectedStateChanged(EditPart editpart) {
                EditPart page;
                if (editpart == null || editpart == CTabFolderGraphicalEditPart.this) {
                    return;
                }
                if (editpart != null && (editpart.getSelected() == 1 || editpart.getSelected() == 2) && (page = CTabFolderGraphicalEditPart.this.getPageOfSelectedEditpart(editpart)) != null && page.getModel() != CTabFolderGraphicalEditPart.this.fSelectedItem) {
                    EditPart currentPage = CTabFolderGraphicalEditPart.this.getEditPartFromModel(CTabFolderGraphicalEditPart.this.fSelectedItem);
                    CTabFolderGraphicalEditPart.this.setPageVisible(currentPage, false);
                    CTabFolderGraphicalEditPart.this.setPageVisible(page, true);
                    CTabFolderGraphicalEditPart.this.pageSelected(page);
                }
            }
        };
    }

    protected void addPageListenerToChildren(EditPart ep) {
        ep.addEditPartListener(this.pageListener);
        Iterator childen = ep.getChildren().iterator();
        while (childen.hasNext()) {
            this.addPageListenerToChildren((EditPart)childen.next());
        }
    }

    protected void setupControl(ControlGraphicalEditPart childEP, EObject child) {
        IJavaObjectInstance tab = this.getTabForChild(child);
        if (childEP != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            childEP.setPropertySource((IPropertySource)EcoreUtil.getRegisteredAdapter((EObject)tab, (Object)clazz));
            childEP.setErrorNotifier((IErrorNotifier)EcoreUtil.getExistingAdapter((Notifier)tab, (Object)IErrorNotifier.ERROR_NOTIFIER_TYPE));
        } else {
            childEP.setPropertySource(null);
            childEP.setErrorNotifier(null);
        }
    }

    protected IJavaObjectInstance getTabForChild(EObject child) {
        return (IJavaObjectInstance)InverseMaintenanceAdapter.getIntermediateReference((EObject)((EObject)this.getModel()), (EReference)this.sf_items, (EReference)this.sf_ctabItemControl, (Notifier)child);
    }

    public int getCurrentPageIndex() {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (((EditPart)children.get(i)).getModel() == this.fSelectedItem) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectNextPage() {
        if (this.fSelectedItem != null) {
            List children = this.getChildren();
            int cp = this.getCurrentPageIndex();
            if (++cp < children.size()) {
                EditPart nextpage = (EditPart)children.get(cp);
                this.pageSelected(nextpage);
            }
        }
    }

    public void selectPreviousPage() {
        if (this.fSelectedItem != null) {
            List children = this.getChildren();
            int cp = this.getCurrentPageIndex();
            if (--cp >= 0) {
                EditPart prevpage = (EditPart)children.get(cp);
                this.pageSelected(prevpage);
            }
        }
    }

    public DragTracker getDragTracker(Request request) {
        DragEditPartsTracker tracker = new DragEditPartsTracker((EditPart)this){

            protected boolean handleButtonUp(int button) {
                if (this.getState() == 2 && this.getState() != 4) {
                    Rectangle bounds = CTabFolderGraphicalEditPart.this.getFigure().getBounds();
                    Point mouseLocation = this.getLocation().getCopy();
                    CTabFolderGraphicalEditPart.this.getFigure().translateToRelative((Translatable)mouseLocation);
                    mouseLocation.translate(0 - bounds.x, 0 - bounds.y);
                    CTabFolderGraphicalEditPart.this.switchToTab(mouseLocation);
                    return true;
                }
                return super.handleButtonUp(button);
            }
        };
        return tracker;
    }
}

