/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.ColorPropertyEditorMessages;

public class ColorCustomPropertyEditor
extends Composite {
    private List fPropertyChangeListeners;
    private static final String COLOR_PREFIX = "org.eclipse.swt.SWT.COLOR_";
    private static final String[] basicColorNames = new String[]{ColorPropertyEditorMessages.black, ColorPropertyEditorMessages.blue, ColorPropertyEditorMessages.cyan, ColorPropertyEditorMessages.gray, ColorPropertyEditorMessages.green, ColorPropertyEditorMessages.magenta, ColorPropertyEditorMessages.red, ColorPropertyEditorMessages.white, ColorPropertyEditorMessages.yellow, ColorPropertyEditorMessages.darkBlue, ColorPropertyEditorMessages.darkCyan, ColorPropertyEditorMessages.darkGray, ColorPropertyEditorMessages.darkGreen, ColorPropertyEditorMessages.darkMagenta, ColorPropertyEditorMessages.darkRed, ColorPropertyEditorMessages.darkYellow};
    private static final String[] basicColorConstants = new String[]{"BLACK", "BLUE", "CYAN", "GRAY", "GREEN", "MAGENTA", "RED", "WHITE", "YELLOW", "DARK_BLUE", "DARK_CYAN", "DARK_GRAY", "DARK_GREEN", "DARK_MAGENTA", "DARK_RED", "DARK_YELLOW"};
    private static final int[] basicColorConstantValues = new int[]{2, 9, 13, 15, 5, 11, 3, 1, 7, 10, 14, 16, 6, 12, 4, 8};
    private static Color[] basicColorValues = new Color[basicColorConstantValues.length];
    private Image[] basicColorImages = new Image[basicColorValues.length];
    private static final String[] systemColorNames = new String[]{ColorPropertyEditorMessages.infoBackground, ColorPropertyEditorMessages.infoForeground, ColorPropertyEditorMessages.listBackground, ColorPropertyEditorMessages.listForeground, ColorPropertyEditorMessages.listSeletion, ColorPropertyEditorMessages.listSelectionText, ColorPropertyEditorMessages.titleBackground, ColorPropertyEditorMessages.titleBackgroundGradient, ColorPropertyEditorMessages.titleForeground, ColorPropertyEditorMessages.titleInactiveBackground, ColorPropertyEditorMessages.titleInactiveBackgroundGradient, ColorPropertyEditorMessages.titleInactiveForeground, ColorPropertyEditorMessages.widgetBackground, ColorPropertyEditorMessages.widgetBorder, ColorPropertyEditorMessages.widgetDarkShadow, ColorPropertyEditorMessages.widgetForeground, ColorPropertyEditorMessages.widgetHighlightShadow, ColorPropertyEditorMessages.widgetLightShadow, ColorPropertyEditorMessages.widgetNormalShadow};
    private static final String[] systemColorConstants = new String[]{"INFO_BACKGROUND", "INFO_FOREGROUND", "LIST_BACKGROUND", "LIST_FOREGROUND", "LIST_SELECTION", "LIST_SELECTION_TEXT", "TITLE_BACKGROUND", "TITLE_BACKGROUND_GRADIENT", "TITLE_FOREGROUND", "TITLE_INACTIVE_BACKGROUND", "TITLE_INACTIVE_BACKGROUND_GRADIENT", "TITLE_INACTIVE_FOREGROUND", "WIDGET_BACKGROUND", "WIDGET_BORDER", "WIDGET_DARK_SHADOW", "WIDGET_FOREGROUND", "WIDGET_HIGHLIGHT_SHADOW", "WIDGET_LIGHT_SHADOW", "WIDGET_NORMAL_SHADOW"};
    private static final int[] systemColorConstantValues = new int[]{29, 28, 25, 24, 26, 27, 31, 32, 30, 34, 35, 33, 22, 23, 17, 21, 20, 19, 18};
    private static Color[] systemColorValues = new Color[systemColorConstantValues.length];
    private Image[] systemColorImages = new Image[systemColorValues.length];
    private static final String[] jfaceColorNames = new String[]{ColorPropertyEditorMessages.hyperlink, ColorPropertyEditorMessages.active_hyperlink, ColorPropertyEditorMessages.error};
    private static final String[] jfaceColorConstantValues = new String[]{"HYPERLINK_COLOR", "ACTIVE_HYPERLINK_COLOR", "ERROR_COLOR"};
    protected static final String[] jfaceColorInitStrings = new String[]{"org.eclipse.jface.preference.JFacePreferences.HYPERLINK_COLOR", "org.eclipse.jface.preference.JFacePreferences.ACTIVE_HYPERLINK_COLOR", "org.eclipse.jface.preference.JFacePreferences.ERROR_COLOR"};
    private static Color[] jfaceColorValues = new Color[jfaceColorConstantValues.length];
    private Image[] jfaceColorImages = new Image[jfaceColorValues.length];
    private IJavaObjectInstance fExistingValue;
    private TabFolder tabFolder = null;
    private Composite namedValueComposite = null;
    private Composite rgbComposite = null;
    private Composite rgbPanel = null;
    private Composite preview = null;
    private Table basicTable;
    private Table systemTable;
    private Spinner redSpinner;
    private Spinner greenSpinner;
    private Spinner blueSpinner;
    private Scale redScale;
    private Scale greenScale;
    private Scale blueScale;
    private Label blueL;
    private Label greenL;
    private Label redL;
    private Button externalChooser;
    private Group basicGroup;
    private Group systemGroup;
    private Color black;
    private Color value;
    private boolean isNamed = false;
    private boolean isBasic = false;
    private boolean isSystem = false;
    private boolean changeInProcess = false;
    private boolean isJFace = false;
    private int basicColorSelection;
    private int systemColorSelection;
    private int jfaceColorSelection;
    private static final int NAMED_SWATCH_SIZE = 10;
    private static final int NAMED_LIST_HEIGHT = 175;
    private static final int NAMED_LIST_WIDTH = 175;
    private Composite jfaceColorComposite = null;
    private Table jfaceColorTable = null;
    private Label initStringLabel = null;
    private EditDomain fEditDomain;
    private Group previewGroup;
    private Canvas previewCanvas;
    private Color initialColor;
    private Color white;
    private static final int spacing = 5;
    private static final int bigRect = 25;
    private static final int medRect = 15;
    private static final int smRect = 5;
    private static final int swatchWidth = 50;
    private static final int swatchHeight = 25;
    private final String previewText = ColorPropertyEditorMessages.previewText;
    private boolean lookupIsJFaceProject = true;
    private boolean isJFaceProject = false;

    public ColorCustomPropertyEditor(Composite parent, int style, Color value, IJavaObjectInstance existingValue, EditDomain editDomain) {
        super(parent, style);
        this.value = value;
        this.fEditDomain = editDomain;
        this.fExistingValue = existingValue;
        this.initialize();
    }

    private void initialize() {
        GridData gridData3 = new GridData();
        this.setSize(new Point(433, 340));
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        grid.verticalSpacing = 5;
        this.setLayout((Layout)grid);
        this.createColorFromProxy((Control)this);
        this.black = this.getDisplay().getSystemColor(2);
        if (this.value == null) {
            this.setColor(this.getDisplay().getSystemColor(6), true);
            this.isBasic = true;
        }
        this.createTabFolder();
        if (!this.isNamed) {
            this.tabFolder.setSelection(1);
        }
        this.createPreviewPanel();
        GridData previewGD = new GridData();
        previewGD.verticalAlignment = 2;
        previewGD.horizontalAlignment = 4;
        previewGD.grabExcessHorizontalSpace = true;
        previewGD.grabExcessVerticalSpace = false;
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 2;
        this.preview.setLayoutData((Object)previewGD);
        this.initStringLabel = new Label((Composite)this, 0);
        this.initStringLabel.setText("");
        this.initStringLabel.setLayoutData((Object)gridData3);
        this.initStringLabel.setForeground(Display.getCurrent().getSystemColor(9));
        this.updateSelections();
    }

    private void updateSelections() {
        ParseTreeAllocation ptAlloc;
        PTExpression exp;
        if (this.fExistingValue != null && this.fExistingValue.getAllocation() instanceof ParseTreeAllocation && (exp = (ptAlloc = (ParseTreeAllocation)this.fExistingValue.getAllocation()).getExpression()) instanceof PTMethodInvocation && ((PTMethodInvocation)exp).getReceiver() instanceof PTMethodInvocation) {
            PTExpression arg = (PTExpression)((PTMethodInvocation)exp).getArguments().get(0);
            String methodName = ((PTMethodInvocation)((PTMethodInvocation)exp).getReceiver()).getName();
            if (methodName.equals("getColorRegistry") && this.isJFaceProject()) {
                int i = 0;
                while (i < jfaceColorValues.length) {
                    if (jfaceColorValues[i].equals((Object)this.value)) {
                        this.jfaceColorTable.setSelection(i);
                        this.isJFace = true;
                        this.tabFolder.setSelection(2);
                        break;
                    }
                    ++i;
                }
            } else if ((methodName.equals("getDefault") || methodName.equals("getCurrent")) && arg instanceof PTFieldAccess) {
                int selection = -1;
                String fieldname = ((PTFieldAccess)arg).getField().replaceAll("COLOR_", "");
                int i = 0;
                while (selection == -1 && i < basicColorConstants.length) {
                    if (fieldname.equals(basicColorConstants[i])) {
                        selection = i;
                        this.basicTable.setSelection(selection);
                        this.basicColorSelection = i;
                        this.isNamed = true;
                        this.isBasic = true;
                    }
                    ++i;
                }
                i = 0;
                while (selection == -1 && i < systemColorConstants.length) {
                    if (fieldname.equals(systemColorConstants[i])) {
                        selection = i;
                        this.systemTable.setSelection(selection);
                        this.systemColorSelection = i;
                        this.isNamed = true;
                        this.isSystem = true;
                    }
                    ++i;
                }
                if (this.isNamed) {
                    this.tabFolder.setSelection(0);
                }
            }
        }
        this.updateLabelInitializationString();
    }

    private void createTabFolder() {
        GridData tabGD = new GridData();
        this.tabFolder = new TabFolder((Composite)this, 0);
        this.createNamedValueComposite();
        this.createRGBComposite();
        TabItem namedPage = new TabItem(this.tabFolder, 0);
        TabItem rgbPage = new TabItem(this.tabFolder, 0);
        tabGD.verticalAlignment = 4;
        tabGD.horizontalAlignment = 4;
        tabGD.grabExcessHorizontalSpace = true;
        tabGD.grabExcessVerticalSpace = true;
        this.tabFolder.setLayoutData((Object)tabGD);
        namedPage.setText(ColorPropertyEditorMessages.namedTabTitle);
        namedPage.setControl((Control)this.namedValueComposite);
        rgbPage.setText(ColorPropertyEditorMessages.rgbTabTitle);
        rgbPage.setControl((Control)this.rgbComposite);
        if (this.isJFaceProject()) {
            this.createJfaceColorComposite();
            TabItem tabItem1 = new TabItem(this.tabFolder, 0);
            tabItem1.setControl((Control)this.jfaceColorComposite);
            tabItem1.setText(ColorPropertyEditorMessages.jfaceTabTitle);
        }
    }

    private void createNamedValueComposite() {
        RowLayout rowLayout = new RowLayout();
        this.namedValueComposite = new Composite((Composite)this.tabFolder, 0);
        this.namedValueComposite.setLayout((Layout)rowLayout);
        rowLayout.wrap = false;
        rowLayout.pack = true;
        rowLayout.justify = true;
        this.initializeColorImages((Device)this.namedValueComposite.getDisplay());
        this.basicGroup = new Group(this.namedValueComposite, 0);
        this.basicGroup.setText(ColorPropertyEditorMessages.basicColorsGroupTitle);
        this.basicGroup.setLayout((Layout)new RowLayout());
        this.basicTable = new Table((Composite)this.basicGroup, 68356);
        this.basicTable.setHeaderVisible(false);
        this.basicTable.setLinesVisible(false);
        int i = 0;
        while (i < basicColorNames.length) {
            TableItem ti = new TableItem(this.basicTable, 0);
            ti.setText(basicColorNames[i]);
            ti.setData((Object)new Integer(i));
            ti.setImage(this.basicColorImages[i]);
            ++i;
        }
        RowData bRD = new RowData();
        bRD.width = 175;
        bRD.height = 175;
        this.basicTable.setLayoutData((Object)bRD);
        this.basicTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.changeSelection((Table)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.changeSelection((Table)e.widget);
            }

            private void changeSelection(Table t) {
                int value;
                TableItem[] items = t.getSelection();
                if (items.length > 0 && (value = ((Integer)items[0].getData()).intValue()) < basicColorValues.length) {
                    ColorCustomPropertyEditor.this.changeInProcess = true;
                    ColorCustomPropertyEditor.this.setColor(basicColorValues[value], true);
                    ColorCustomPropertyEditor.this.basicColorSelection = value;
                    ColorCustomPropertyEditor.this.systemTable.deselectAll();
                    ColorCustomPropertyEditor.this.deSelectJFaceColorTable();
                    ColorCustomPropertyEditor.this.updateSpinnersFromColor();
                    ColorCustomPropertyEditor.this.isBasic = true;
                    ColorCustomPropertyEditor.this.changeInProcess = false;
                    ColorCustomPropertyEditor.this.updateLabelInitializationString();
                }
            }
        });
        this.systemGroup = new Group(this.namedValueComposite, 0);
        this.systemGroup.setText(ColorPropertyEditorMessages.SystemColorsGroupTitle);
        this.systemGroup.setLayout((Layout)new RowLayout());
        this.systemTable = new Table((Composite)this.systemGroup, 68356);
        this.systemTable.setHeaderVisible(false);
        this.systemTable.setLinesVisible(false);
        int i2 = 0;
        while (i2 < systemColorNames.length) {
            TableItem ti = new TableItem(this.systemTable, 0);
            ti.setText(systemColorNames[i2]);
            ti.setData((Object)new Integer(i2));
            ti.setImage(this.systemColorImages[i2]);
            ++i2;
        }
        RowData sRD = new RowData();
        sRD.width = 175;
        sRD.height = 175;
        this.systemTable.setLayoutData((Object)sRD);
        this.systemTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.changeSelection((Table)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.changeSelection((Table)e.widget);
            }

            private void changeSelection(Table t) {
                int value;
                TableItem[] items = t.getSelection();
                if (items.length > 0 && (value = ((Integer)items[0].getData()).intValue()) < systemColorValues.length) {
                    ColorCustomPropertyEditor.this.changeInProcess = true;
                    ColorCustomPropertyEditor.this.setColor(systemColorValues[value], true);
                    ColorCustomPropertyEditor.this.systemColorSelection = value;
                    ColorCustomPropertyEditor.this.basicTable.deselectAll();
                    ColorCustomPropertyEditor.this.deSelectJFaceColorTable();
                    ColorCustomPropertyEditor.this.updateSpinnersFromColor();
                    ColorCustomPropertyEditor.this.isSystem = true;
                    ColorCustomPropertyEditor.this.changeInProcess = false;
                    ColorCustomPropertyEditor.this.updateLabelInitializationString();
                }
            }
        });
        this.namedValueComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image img;
                int i = 0;
                while (i < ColorCustomPropertyEditor.this.basicColorImages.length) {
                    img = ColorCustomPropertyEditor.this.basicColorImages[i];
                    if (img != null && !img.isDisposed()) {
                        img.dispose();
                        img = null;
                    }
                    ++i;
                }
                i = 0;
                while (i < ColorCustomPropertyEditor.this.systemColorImages.length) {
                    img = ColorCustomPropertyEditor.this.systemColorImages[i];
                    if (img != null && !img.isDisposed()) {
                        img.dispose();
                        img = null;
                    }
                    ++i;
                }
            }
        });
    }

    private void createRGBComposite() {
        GridLayout grid = new GridLayout();
        this.rgbComposite = new Composite((Composite)this.tabFolder, 0);
        grid.numColumns = 1;
        grid.verticalSpacing = 5;
        grid.marginHeight = 5;
        grid.marginWidth = 5;
        this.rgbComposite.setLayout((Layout)grid);
        this.createRGBPanel();
        this.externalChooser = new Button(this.rgbComposite, 8);
        this.externalChooser.setText(ColorPropertyEditorMessages.advancedButton);
        GridData GD2 = new GridData();
        GD2.grabExcessHorizontalSpace = true;
        GD2.grabExcessVerticalSpace = true;
        GD2.horizontalAlignment = 3;
        GD2.verticalAlignment = 3;
        this.externalChooser.setLayoutData((Object)GD2);
        this.externalChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = e.widget.getDisplay().getActiveShell();
                ColorDialog c = new ColorDialog(shell, 65536);
                RGB result = c.open();
                if (result != null) {
                    ColorCustomPropertyEditor.this.redSpinner.setSelection(result.red);
                    ColorCustomPropertyEditor.this.greenSpinner.setSelection(result.green);
                    ColorCustomPropertyEditor.this.blueSpinner.setSelection(result.blue);
                }
            }
        });
    }

    private void createRGBPanel() {
        GridLayout grid2 = new GridLayout();
        GridData GD1 = new GridData();
        this.rgbPanel = new Composite(this.rgbComposite, 0);
        this.rgbPanel.setLayoutData((Object)GD1);
        this.rgbPanel.setLayout((Layout)grid2);
        GD1.grabExcessHorizontalSpace = true;
        GD1.grabExcessVerticalSpace = true;
        GD1.horizontalAlignment = 2;
        GD1.verticalAlignment = 2;
        this.redL = new Label(this.rgbPanel, 0);
        this.redScale = new Scale(this.rgbPanel, 0);
        this.redSpinner = new Spinner(this.rgbPanel, 2048);
        this.greenL = new Label(this.rgbPanel, 0);
        this.greenScale = new Scale(this.rgbPanel, 0);
        this.greenSpinner = new Spinner(this.rgbPanel, 2048);
        this.blueL = new Label(this.rgbPanel, 0);
        this.blueScale = new Scale(this.rgbPanel, 0);
        this.blueSpinner = new Spinner(this.rgbPanel, 2048);
        grid2.numColumns = 3;
        grid2.verticalSpacing = 5;
        grid2.horizontalSpacing = 10;
        grid2.marginHeight = 5;
        grid2.marginWidth = 5;
        this.redL.setText(ColorPropertyEditorMessages.redSliderLabel);
        this.redScale.setMinimum(0);
        this.redScale.setMaximum(255);
        this.redScale.setPageIncrement(51);
        this.redScale.setSelection(this.value.getRed());
        this.redSpinner.setMinimum(0);
        this.redSpinner.setMaximum(255);
        this.redSpinner.setSelection(this.value.getRed());
        this.greenL.setText(ColorPropertyEditorMessages.greenSliderLabel);
        this.greenScale.setMinimum(0);
        this.greenScale.setMaximum(255);
        this.greenScale.setPageIncrement(51);
        this.greenScale.setSelection(this.value.getGreen());
        this.greenSpinner.setMinimum(0);
        this.greenSpinner.setMaximum(255);
        this.greenSpinner.setSelection(this.value.getGreen());
        this.blueL.setText(ColorPropertyEditorMessages.blueSliderLabel);
        this.blueScale.setMinimum(0);
        this.blueScale.setMaximum(255);
        this.blueScale.setPageIncrement(51);
        this.blueScale.setSelection(this.value.getBlue());
        this.blueSpinner.setMinimum(0);
        this.blueSpinner.setMaximum(255);
        this.blueSpinner.setSelection(this.value.getBlue());
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Spinner s = (Spinner)e.widget;
                if (s == ColorCustomPropertyEditor.this.redSpinner) {
                    ColorCustomPropertyEditor.this.redScale.setSelection(ColorCustomPropertyEditor.this.redSpinner.getSelection());
                } else if (s == ColorCustomPropertyEditor.this.greenSpinner) {
                    ColorCustomPropertyEditor.this.greenScale.setSelection(ColorCustomPropertyEditor.this.greenSpinner.getSelection());
                } else if (s == ColorCustomPropertyEditor.this.blueSpinner) {
                    ColorCustomPropertyEditor.this.blueScale.setSelection(ColorCustomPropertyEditor.this.blueSpinner.getSelection());
                }
                s.setEnabled(true);
                if (!ColorCustomPropertyEditor.this.changeInProcess) {
                    ColorCustomPropertyEditor.this.updateColorFromSpinners();
                    ColorCustomPropertyEditor.this.basicTable.deselectAll();
                    ColorCustomPropertyEditor.this.systemTable.deselectAll();
                }
            }
        };
        this.redSpinner.addModifyListener(modifyListener);
        this.greenSpinner.addModifyListener(modifyListener);
        this.blueSpinner.addModifyListener(modifyListener);
        SelectionAdapter scaleListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == ColorCustomPropertyEditor.this.redScale) {
                    ColorCustomPropertyEditor.this.redSpinner.setSelection(ColorCustomPropertyEditor.this.redScale.getSelection());
                    ColorCustomPropertyEditor.this.redSpinner.setEnabled(true);
                } else if (e.widget == ColorCustomPropertyEditor.this.greenScale) {
                    ColorCustomPropertyEditor.this.greenSpinner.setSelection(ColorCustomPropertyEditor.this.greenScale.getSelection());
                    ColorCustomPropertyEditor.this.greenSpinner.setEnabled(true);
                } else if (e.widget == ColorCustomPropertyEditor.this.blueScale) {
                    ColorCustomPropertyEditor.this.blueSpinner.setSelection(ColorCustomPropertyEditor.this.blueScale.getSelection());
                    ColorCustomPropertyEditor.this.blueSpinner.setEnabled(true);
                }
            }
        };
        this.redScale.addSelectionListener((SelectionListener)scaleListener);
        this.blueScale.addSelectionListener((SelectionListener)scaleListener);
        this.greenScale.addSelectionListener((SelectionListener)scaleListener);
    }

    private void updateSpinnersFromColor() {
        Color c = (Color)this.getValue();
        this.redSpinner.setSelection(c.getRed());
        this.greenSpinner.setSelection(c.getGreen());
        this.blueSpinner.setSelection(c.getBlue());
    }

    private void initializeColorConstants(Device d) {
        if (basicColorValues[0] == null || basicColorValues[0].isDisposed()) {
            int i = 0;
            while (i < basicColorConstantValues.length) {
                ColorCustomPropertyEditor.basicColorValues[i] = d.getSystemColor(basicColorConstantValues[i]);
                ++i;
            }
            i = 0;
            while (i < systemColorConstantValues.length) {
                ColorCustomPropertyEditor.systemColorValues[i] = d.getSystemColor(systemColorConstantValues[i]);
                ++i;
            }
        }
    }

    private void initializeColorImages(Device d) {
        this.initializeColorConstants(d);
        int i = 0;
        while (i < this.basicColorImages.length) {
            this.basicColorImages[i] = this.makeSwatchIcon(d, basicColorValues[i]);
            ++i;
        }
        i = 0;
        while (i < this.systemColorImages.length) {
            this.systemColorImages[i] = this.makeSwatchIcon(d, systemColorValues[i]);
            ++i;
        }
    }

    private void initializeJfaceColorValues(Device d) {
        if (jfaceColorValues[0] == null || jfaceColorValues[0].isDisposed()) {
            ColorRegistry registry = JFaceResources.getColorRegistry();
            int i = 0;
            while (i < jfaceColorConstantValues.length) {
                ColorCustomPropertyEditor.jfaceColorValues[i] = new Color(d, registry.getRGB(jfaceColorConstantValues[i]));
                ++i;
            }
        }
    }

    private void initializeJfaceColorImages(Device d) {
        this.initializeJfaceColorValues(d);
        int i = 0;
        while (i < this.jfaceColorImages.length) {
            this.jfaceColorImages[i] = this.makeSwatchIcon(d, jfaceColorValues[i]);
            ++i;
        }
    }

    private Image makeSwatchIcon(Device d, Color c) {
        Rectangle swatchBounds = new Rectangle(0, 0, 10, 10);
        Image img = new Image(d, swatchBounds);
        GC draw = new GC((Drawable)img);
        draw.setBackground(c);
        draw.fillRectangle(swatchBounds);
        draw.setForeground(this.black);
        draw.drawRectangle(swatchBounds);
        draw.dispose();
        return img;
    }

    private void updateColorFromSpinners() {
        Color c = new Color((Device)this.getDisplay(), this.redSpinner.getSelection(), this.greenSpinner.getSelection(), this.blueSpinner.getSelection());
        this.setColor(c, false);
        this.updateLabelInitializationString();
    }

    public Color getColor() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setColor(Color c, boolean named) {
        if (this.value != null && !this.value.isDisposed() && !this.isNamed) {
            Color color = this.value;
            synchronized (color) {
                this.value.dispose();
            }
        }
        this.value = c;
        this.isNamed = named;
        this.isBasic = false;
        this.isSystem = false;
        this.isJFace = false;
        if (this.preview != null) {
            this.paintPreviewPanel();
        }
        if (this.fPropertyChangeListeners != null) {
            Iterator iter = this.fPropertyChangeListeners.iterator();
            while (iter.hasNext()) {
                ((PropertyChangeListener)iter.next()).propertyChange(new PropertyChangeEvent((Object)this, "value", c, null));
            }
        }
    }

    private void createPreviewPanel() {
        this.preview = new Composite((Composite)this, 0);
        GridData previewGD = new GridData();
        previewGD.verticalAlignment = 2;
        previewGD.horizontalAlignment = 4;
        previewGD.grabExcessHorizontalSpace = true;
        previewGD.grabExcessVerticalSpace = false;
        this.preview.setLayoutData((Object)previewGD);
        this.preview.setLayout((Layout)new FillLayout());
        this.previewGroup = new Group(this.preview, 0);
        this.previewGroup.setText(ColorPropertyEditorMessages.previewGroupTitle);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = true;
        rowLayout.justify = true;
        this.previewGroup.setLayout((Layout)rowLayout);
        this.previewCanvas = new Canvas((Composite)this.previewGroup, 0);
        this.black = this.previewCanvas.getDisplay().getSystemColor(2);
        this.white = this.previewCanvas.getDisplay().getSystemColor(1);
        this.previewCanvas.setLayoutData((Object)new RowData(this.computePreviewDrawingSize()));
        this.previewCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ColorCustomPropertyEditor.this.paintPreviewPanel();
            }
        });
        this.initialColor = new Color((Device)this.previewGroup.getDisplay(), this.getColor().getRGB());
        this.previewGroup.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ColorCustomPropertyEditor.this.initialColor != null && !ColorCustomPropertyEditor.this.initialColor.isDisposed()) {
                    ColorCustomPropertyEditor.this.initialColor.dispose();
                    ColorCustomPropertyEditor.this.initialColor = null;
                }
            }
        });
        this.paintPreviewPanel();
    }

    private Point computePreviewDrawingSize() {
        GC surface = new GC((Drawable)this.previewCanvas);
        Point previewSize = surface.stringExtent(this.previewText);
        surface.dispose();
        int width = 150 + previewSize.x + 5;
        int textHeight = (previewSize.y + 5) * 3 + 10;
        int shapesHeight = 55;
        int height = textHeight > shapesHeight ? textHeight : shapesHeight;
        return new Point(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintPreviewPanel() {
        Color current;
        int x = 0;
        int y = 0;
        Color color = current = this.getColor();
        synchronized (color) {
            if (current == null || current.isDisposed()) {
                return;
            }
            GC surface = new GC((Drawable)this.previewCanvas);
            surface.setBackground(this.white);
            surface.fillRectangle(x, y, 25, 25);
            surface.setBackground(current);
            surface.fillRectangle(x + 5, y + 5, 15, 15);
            surface.setBackground(this.white);
            surface.fillRectangle(x + 10, y + 10, 5, 5);
            x = x + 25 + 5;
            surface.setBackground(this.black);
            surface.fillRectangle(x, y, 25, 25);
            surface.setBackground(current);
            surface.fillRectangle(x + 5, y + 5, 15, 15);
            surface.setBackground(this.white);
            surface.fillRectangle(x + 10, y + 10, 5, 5);
            x = x + 25 + 5;
            surface.setBackground(this.white);
            surface.fillRectangle(x, y, 25, 25);
            surface.setBackground(current);
            surface.fillRectangle(x + 5, y + 5, 15, 15);
            surface.setBackground(this.black);
            surface.fillRectangle(x + 10, y + 10, 5, 5);
            x = 0;
            y = y + 25 + 5;
            surface.setBackground(current);
            surface.fillRectangle(x, y, 25, 25);
            x = x + 25 + 5;
            surface.setBackground(this.white);
            surface.fillRectangle(x, y, 25, 25);
            surface.setBackground(current);
            surface.fillRectangle(x + 5, y + 5, 15, 15);
            x = x + 25 + 5;
            surface.setBackground(this.black);
            surface.fillRectangle(x, y, 25, 25);
            surface.setBackground(current);
            surface.fillRectangle(x + 5, y + 5, 15, 15);
            x = x + 25 + 5;
            y = 0;
            Point textSize = surface.stringExtent(this.previewText);
            surface.setForeground(current);
            surface.drawText(this.previewText, x + 3, y + 3, true);
            y = y + textSize.y + 10;
            surface.setBackground(current);
            surface.fillRectangle(x, y, textSize.x + 5, textSize.y + 5);
            surface.setForeground(this.black);
            surface.drawText(this.previewText, x + 3, y + 3, true);
            y = y + textSize.y + 10;
            surface.setBackground(this.white);
            surface.fillRectangle(x, y, textSize.x + 5, textSize.y + 5);
            surface.setForeground(current);
            surface.drawText(this.previewText, x + 3, y + 3, true);
            x = x + textSize.x + 5 + 5;
            y = 0;
            surface.setBackground(this.initialColor);
            surface.fillRectangle(x, y, 50, 25);
            surface.setBackground(current);
            surface.fillRectangle(x, y += 25, 50, 25);
            surface.dispose();
        }
    }

    public void createColorFromProxy(Control control) {
        if (this.fExistingValue == null || this.value != null) {
            return;
        }
        try {
            IBeanProxy colorProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.fExistingValue);
            if (colorProxy != null) {
                Color color;
                IBeanTypeProxy colorType = colorProxy.getTypeProxy();
                IMethodProxy getBlue = colorType.getMethodProxy("getBlue");
                IMethodProxy getGreen = colorType.getMethodProxy("getGreen");
                IMethodProxy getRed = colorType.getMethodProxy("getRed");
                int blue = ((IIntegerBeanProxy)getBlue.invoke(colorProxy)).intValue();
                int green = ((IIntegerBeanProxy)getGreen.invoke(colorProxy)).intValue();
                int red = ((IIntegerBeanProxy)getRed.invoke(colorProxy)).intValue();
                this.value = color = new Color((Device)control.getDisplay(), red, green, blue);
            }
        }
        catch (ThrowableProxy throwableProxy) {}
    }

    public void setValue(Object value) {
        if (value instanceof Color) {
            this.value = (Color)value;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.fPropertyChangeListeners == null) {
            this.fPropertyChangeListeners = new ArrayList(1);
        }
        this.fPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.fPropertyChangeListeners != null) {
            this.fPropertyChangeListeners.remove(listener);
        }
    }

    public void setJavaObjectInstanceValue(IJavaObjectInstance value) {
        this.fExistingValue = value;
        this.value = null;
    }

    public String getJavaInitializationString() {
        String result = "null";
        if (this.value == null) {
            return result;
        }
        if (this.value != null) {
            if (!this.isNamed) {
                result = "new org.eclipse.swt.graphics.Color(org.eclipse.swt.widgets.Display.getCurrent(), " + this.value.getRed() + ", " + this.value.getGreen() + ", " + this.value.getBlue() + ")";
            } else if (this.isBasic) {
                result = "org.eclipse.swt.widgets.Display.getCurrent().getSystemColor(org.eclipse.swt.SWT.COLOR_" + basicColorConstants[this.basicColorSelection] + ")";
            } else if (this.isSystem) {
                result = "org.eclipse.swt.widgets.Display.getCurrent().getSystemColor(org.eclipse.swt.SWT.COLOR_" + systemColorConstants[this.systemColorSelection] + ")";
            } else if (this.isJFace) {
                return "org.eclipse.jface.resource.JFaceResources.getColorRegistry().get(" + jfaceColorInitStrings[this.jfaceColorSelection] + ")";
            }
        }
        return result;
    }

    private void createJfaceColorComposite() {
        this.jfaceColorComposite = new Composite((Composite)this.tabFolder, 0);
        this.initializeJfaceColorImages((Device)this.jfaceColorComposite.getDisplay());
        this.createJFaceColorTable();
        this.jfaceColorComposite.setLayout((Layout)new RowLayout());
    }

    private void createJFaceColorTable() {
        RowData rowData2 = new RowData();
        this.jfaceColorTable = new Table(this.jfaceColorComposite, 68356);
        rowData2.height = 175;
        rowData2.width = 175;
        this.jfaceColorTable.setLayoutData((Object)rowData2);
        int i = 0;
        while (i < jfaceColorNames.length) {
            TableItem ti = new TableItem(this.jfaceColorTable, 0);
            ti.setText(jfaceColorNames[i]);
            ti.setData((Object)new Integer(i));
            ti.setImage(this.jfaceColorImages[i]);
            this.value.equals((Object)jfaceColorValues[i]);
            ++i;
        }
        this.jfaceColorTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.changeSelection((Table)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.changeSelection((Table)e.widget);
            }

            private void changeSelection(Table t) {
                int index;
                TableItem[] items = t.getSelection();
                if (items.length > 0 && (index = ((Integer)items[0].getData()).intValue()) < jfaceColorValues.length) {
                    ColorCustomPropertyEditor.this.changeInProcess = true;
                    ColorCustomPropertyEditor.this.setColor(jfaceColorValues[index], true);
                    ColorCustomPropertyEditor.this.basicTable.deselectAll();
                    ColorCustomPropertyEditor.this.systemTable.deselectAll();
                    ColorCustomPropertyEditor.this.updateSpinnersFromColor();
                    ColorCustomPropertyEditor.this.isJFace = true;
                    ColorCustomPropertyEditor.this.jfaceColorSelection = index;
                    ColorCustomPropertyEditor.this.changeInProcess = false;
                    ColorCustomPropertyEditor.this.updateLabelInitializationString();
                }
            }
        });
    }

    private void deSelectJFaceColorTable() {
        if (this.isJFaceProject()) {
            this.jfaceColorTable.deselectAll();
        }
    }

    private void updateLabelInitializationString() {
        if (this.value == null) {
            return;
        }
        String result = "null";
        String SWT_PREFIX = "SWT.";
        if (!this.isNamed) {
            result = "new Color(Display.getCurrent(), " + this.value.getRed() + ", " + this.value.getGreen() + ", " + this.value.getBlue() + ")";
        } else if (this.isBasic) {
            result = "Display.getCurrent().getSystemColor(" + SWT_PREFIX + basicColorConstants[this.basicColorSelection] + ")";
        } else if (this.isSystem) {
            result = "Display.getCurrent().getSystemColor(" + SWT_PREFIX + systemColorConstants[this.systemColorSelection] + ")";
        } else if (this.isJFace) {
            String jfaceConstantName = jfaceColorInitStrings[this.jfaceColorSelection].replaceAll("org.eclipse.jface.preference.JFacePreferences", "JFacePreferences");
            result = "JFaceResources.getColorRegistry().get(" + jfaceConstantName + ")";
        }
        this.initStringLabel.setText(result);
        this.initStringLabel.setToolTipText(result);
    }

    protected boolean isJFaceProject() {
        if (this.lookupIsJFaceProject) {
            this.isJFaceProject = BeanSWTUtilities.isJFaceProject(this.fEditDomain);
        }
        return this.isJFaceProject;
    }
}

