/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.beans.PropertyChangeListener;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.swt.ColorCustomPropertyEditor;
import org.eclipse.ve.internal.swt.ColorJavaClassLabelProvider;
import org.eclipse.ve.internal.swt.PropertyEditor;

public class ColorPropertyEditor
implements PropertyEditor,
INeedData {
    private ColorCustomPropertyEditor customColorEditor;
    private IJavaObjectInstance fExistingValue;
    private Color color;
    private EditDomain fEditDomain;

    public ColorPropertyEditor() {
    }

    public ColorPropertyEditor(Color initialColor) {
        this.setValue(initialColor);
    }

    public Control createControl(Composite parent, int style) {
        if (this.customColorEditor == null || this.customColorEditor.isDisposed()) {
            this.customColorEditor = new ColorCustomPropertyEditor(parent, style, this.color, this.fExistingValue, this.fEditDomain);
        }
        return this.customColorEditor;
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
    }

    public void setValue(Object value) {
        if (this.customColorEditor != null) {
            this.customColorEditor.setValue(value);
        }
        if (value != null && value instanceof Color) {
            this.color = (Color)value;
        }
    }

    public Object getValue() {
        return this.customColorEditor != null ? this.customColorEditor.getValue() : null;
    }

    public String getJavaInitializationString() {
        String result = "null";
        if (this.customColorEditor != null) {
            result = this.customColorEditor.getJavaInitializationString();
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.customColorEditor != null) {
            this.customColorEditor.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.customColorEditor != null) {
            this.customColorEditor.removePropertyChangeListener(listener);
        }
    }

    public String getText() {
        if (this.fExistingValue != null) {
            return ColorJavaClassLabelProvider.getText((IJavaInstance)this.fExistingValue);
        }
        return "";
    }

    public void setJavaObjectInstanceValue(IJavaObjectInstance value) {
        this.fExistingValue = value;
        if (this.customColorEditor != null) {
            this.customColorEditor.setJavaObjectInstanceValue(value);
        }
    }
}

