/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ve.internal.swt.CursorJavaClassLabelProvider;
import org.eclipse.ve.internal.swt.PropertyEditor;

public class CursorPropertyEditor
implements PropertyEditor {
    private static final String BUNDLE_NAME = "org.eclipse.ve.internal.swt.cursorpropertyeditor";
    private static ResourceBundle messages = ResourceBundle.getBundle("org.eclipse.ve.internal.swt.cursorpropertyeditor");
    private List fPropertyChangeListeners;
    private Composite control;
    private IJavaObjectInstance fCursorInstance = null;
    private PreviewPanel preview;
    private Cursor cursorValue;
    private int cursorConstant;
    private static final String CURSOR_CLASS_PREFIX = "org.eclipse.swt.graphics.Cursor(";
    private static final String CURSOR_PREFIX = "org.eclipse.swt.SWT.CURSOR_";
    public static final String[] cursorNames = new String[]{messages.getString("appStarting"), messages.getString("arrow"), messages.getString("cross"), messages.getString("hand"), messages.getString("help"), messages.getString("iBeam"), messages.getString("no"), messages.getString("sizeAll"), messages.getString("sizeE"), messages.getString("sizeN"), messages.getString("sizeNE"), messages.getString("sizeNESW"), messages.getString("sizeNS"), messages.getString("sizeNW"), messages.getString("sizeNWSE"), messages.getString("sizeS"), messages.getString("sizeSE"), messages.getString("sizeSW"), messages.getString("sizeW"), messages.getString("sizeWE"), messages.getString("upArrow"), messages.getString("wait")};
    public static final String[] cursorConstants = new String[]{"APPSTARTING", "ARROW", "CROSS", "HAND", "HELP", "IBEAM", "NO", "SIZEALL", "SIZEE", "SIZEN", "SIZENE", "SIZENESW", "SIZENS", "SIZENW", "SIZENWSE", "SIZES", "SIZESE", "SIZESW", "SIZEW", "SIZEWE", "UPARROW", "WAIT"};
    private static final int[] cursorConstantValues;
    private Button standardButton;
    private Button customButton;
    private Combo constantsSelect;
    private Label sourceLabel;
    private Label maskLabel;
    private Text sourceText;
    private Text maskText;
    private Button sourceBrowse;
    private Button maskBrowse;
    private Group hotspotGroup;
    private Group canvasGroup;
    private Canvas hotspotCanvas;
    private Label xLabel;
    private Text xText;
    private Label yLabel;
    private Text yText;
    private Point canvasSize;
    private ImageData sourceImageData;
    private ImageData maskImageData;
    private ImageData sourceTransData;
    private ImageData maskTransData;
    private int x;
    private int y;
    private int ratio = 1;
    private Color red = Display.getDefault().getSystemColor(3);
    private boolean inModify = false;

    static {
        int[] nArray = new int[22];
        nArray[0] = 3;
        nArray[2] = 2;
        nArray[3] = 21;
        nArray[4] = 4;
        nArray[5] = 19;
        nArray[6] = 20;
        nArray[7] = 5;
        nArray[8] = 12;
        nArray[9] = 10;
        nArray[10] = 14;
        nArray[11] = 6;
        nArray[12] = 7;
        nArray[13] = 17;
        nArray[14] = 8;
        nArray[15] = 11;
        nArray[16] = 15;
        nArray[17] = 16;
        nArray[18] = 13;
        nArray[19] = 9;
        nArray[20] = 18;
        nArray[21] = 1;
        cursorConstantValues = nArray;
    }

    public Control createControl(Composite parent, int style) {
        if (this.control == null || this.control.isDisposed()) {
            this.control = new Composite(parent, style);
            RowLayout rowLayout = new RowLayout();
            rowLayout.type = 512;
            rowLayout.fill = true;
            this.control.setLayout((Layout)rowLayout);
            this.standardButton = new Button(this.control, 16);
            this.standardButton.setText(messages.getString("standardCursor"));
            this.standardButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    CursorPropertyEditor.this.radioSwitchStandard(true);
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    CursorPropertyEditor.this.radioSwitchStandard(true);
                }
            });
            this.constantsSelect = new Combo(this.control, 12);
            int i = 0;
            while (i < cursorNames.length) {
                this.constantsSelect.add(cursorNames[i], i);
                ++i;
            }
            this.constantsSelect.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int selection = CursorPropertyEditor.this.constantsSelect.getSelectionIndex();
                    CursorPropertyEditor.this.setCursorFromList(selection);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    int selection = CursorPropertyEditor.this.constantsSelect.getSelectionIndex();
                    CursorPropertyEditor.this.setCursorFromList(selection);
                }
            });
            this.customButton = new Button(this.control, 16);
            this.customButton.setText(messages.getString("customCursor"));
            this.customButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    CursorPropertyEditor.this.radioSwitchStandard(false);
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    CursorPropertyEditor.this.radioSwitchStandard(false);
                }
            });
            this.makeCustomPanel(this.control);
            this.preview = new PreviewPanel();
            Control pcontrol = this.preview.createControl(this.control, 0);
            if (this.cursorConstant != -1) {
                this.cursorValue = new Cursor((Device)pcontrol.getDisplay(), cursorConstantValues[this.cursorConstant]);
                this.constantsSelect.select(this.cursorConstant);
                this.preview.updatePreview(this.cursorValue);
            } else {
                this.constantsSelect.select(-1);
            }
            this.control.pack();
            this.radioSwitchStandard(true);
            this.xText.setText("0");
            this.yText.setText("0");
        }
        return this.control;
    }

    private void makeCustomPanel(Composite parent) {
        Group control = new Group(parent, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 3;
        control.setLayout((Layout)grid);
        this.sourceLabel = new Label((Composite)control, 0);
        this.sourceLabel.setText(messages.getString("sourceLabel"));
        this.sourceText = new Text((Composite)control, 2052);
        this.sourceText.setEditable(false);
        GridData gd1 = new GridData();
        gd1.horizontalAlignment = 4;
        this.sourceText.setLayoutData((Object)gd1);
        this.sourceBrowse = new Button((Composite)control, 8);
        this.sourceBrowse.setText(messages.getString("browseButton"));
        this.sourceBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                this.doPush();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.doPush();
            }

            private void doPush() {
                FileDialog fd = new FileDialog(CursorPropertyEditor.this.sourceBrowse.getShell(), 4096);
                fd.setText(messages.getString("chooseSource"));
                String fileName = fd.open();
                if (fileName != null) {
                    try {
                        CursorPropertyEditor.this.sourceImageData = new ImageData(fileName);
                        CursorPropertyEditor.this.inModify = true;
                        CursorPropertyEditor.this.sourceText.setText(fileName);
                        if (CursorPropertyEditor.this.x >= ((CursorPropertyEditor)CursorPropertyEditor.this).sourceImageData.width) {
                            CursorPropertyEditor.this.x = 0;
                            CursorPropertyEditor.this.xText.setText("0");
                        }
                        if (CursorPropertyEditor.this.y >= ((CursorPropertyEditor)CursorPropertyEditor.this).sourceImageData.height) {
                            CursorPropertyEditor.this.y = 0;
                            CursorPropertyEditor.this.yText.setText("0");
                        }
                        CursorPropertyEditor.this.inModify = false;
                        CursorPropertyEditor.this.updateHotspotImage();
                        CursorPropertyEditor.this.updateCustomPreview();
                    }
                    catch (SWTException e) {
                        if (e.code == 40) {
                            MessageBox mb = new MessageBox(CursorPropertyEditor.this.sourceBrowse.getShell(), 33);
                            mb.setMessage(messages.getString("invalidFormatError"));
                            mb.open();
                        }
                        if (e.code == 39) {
                            MessageBox mb = new MessageBox(CursorPropertyEditor.this.sourceBrowse.getShell(), 33);
                            mb.setMessage(messages.getString("errorReading"));
                            mb.open();
                        }
                        MessageBox mb = new MessageBox(CursorPropertyEditor.this.sourceBrowse.getShell(), 33);
                        mb.setMessage(String.valueOf(messages.getString("errorOpening")) + e.getLocalizedMessage());
                        mb.open();
                    }
                }
                CursorPropertyEditor.this.transformImages();
            }
        });
        this.maskLabel = new Label((Composite)control, 0);
        this.maskLabel.setText(messages.getString("maskImageLabel"));
        this.maskText = new Text((Composite)control, 2052);
        this.maskText.setEditable(false);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 4;
        this.maskText.setLayoutData((Object)gd2);
        this.maskBrowse = new Button((Composite)control, 8);
        this.maskBrowse.setText(messages.getString("browseButton"));
        this.maskBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                this.doPush();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.doPush();
            }

            private void doPush() {
                block6: {
                    FileDialog fd = new FileDialog(CursorPropertyEditor.this.sourceBrowse.getShell(), 4096);
                    fd.setText(messages.getString("chooseMask"));
                    String fileName = fd.open();
                    if (fileName != null) {
                        try {
                            CursorPropertyEditor.this.maskImageData = new ImageData(fileName);
                            CursorPropertyEditor.this.maskText.setText(fileName);
                            CursorPropertyEditor.this.updateHotspotImage();
                            CursorPropertyEditor.this.updateCustomPreview();
                        }
                        catch (SWTException e) {
                            CursorPropertyEditor.this.maskImageData = null;
                            if (e.code == 40) {
                                MessageBox mb = new MessageBox(CursorPropertyEditor.this.sourceBrowse.getShell(), 33);
                                mb.setMessage(messages.getString("invalidFormatError"));
                                mb.open();
                                break block6;
                            }
                            if (e.code == 39) {
                                MessageBox mb = new MessageBox(CursorPropertyEditor.this.sourceBrowse.getShell(), 33);
                                mb.setMessage(messages.getString("errorReading"));
                                mb.open();
                                break block6;
                            }
                            MessageBox mb = new MessageBox(CursorPropertyEditor.this.sourceBrowse.getShell(), 33);
                            mb.setMessage(String.valueOf(messages.getString("errorOpening")) + e.getLocalizedMessage());
                            mb.open();
                        }
                    } else {
                        CursorPropertyEditor.this.maskImageData = null;
                    }
                }
                CursorPropertyEditor.this.transformImages();
            }
        });
        this.hotspotGroup = new Group((Composite)control, 0);
        this.hotspotGroup.setText(messages.getString("cursorHotspot"));
        GridLayout grid2 = new GridLayout();
        grid2.numColumns = 3;
        this.hotspotGroup.setLayout((Layout)grid2);
        GridData gd3 = new GridData();
        gd3.horizontalSpan = 3;
        this.hotspotGroup.setLayoutData((Object)gd3);
        this.canvasGroup = new Group((Composite)this.hotspotGroup, 0);
        this.canvasGroup.setLayout((Layout)new FillLayout());
        GridData gd4 = new GridData();
        gd4.verticalSpan = 2;
        this.canvasGroup.setLayoutData((Object)gd4);
        this.hotspotCanvas = new Canvas((Composite)this.canvasGroup, 0);
        this.canvasSize = new Point(64, 64);
        this.hotspotCanvas.setSize(this.canvasSize);
        this.hotspotCanvas.setToolTipText(messages.getString("setHotspot"));
        this.xLabel = new Label((Composite)this.hotspotGroup, 0);
        this.xLabel.setText(messages.getString("xLabel"));
        this.xText = new Text((Composite)this.hotspotGroup, 2048);
        this.xText.setTextLimit(3);
        this.xText.setText("000");
        this.yLabel = new Label((Composite)this.hotspotGroup, 0);
        this.yLabel.setText(messages.getString("yLabel"));
        this.yText = new Text((Composite)this.hotspotGroup, 2048);
        this.yText.setTextLimit(3);
        this.yText.setText("000");
        NumberVerifier verifier = new NumberVerifier();
        this.xText.addVerifyListener((VerifyListener)verifier);
        this.yText.addVerifyListener((VerifyListener)verifier);
        this.hotspotCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int newX = e.x / CursorPropertyEditor.this.ratio;
                int newY = e.y / CursorPropertyEditor.this.ratio;
                if (CursorPropertyEditor.this.sourceImageData != null) {
                    if (newX <= ((CursorPropertyEditor)CursorPropertyEditor.this).sourceImageData.width && newY <= ((CursorPropertyEditor)CursorPropertyEditor.this).sourceImageData.height) {
                        CursorPropertyEditor.this.inModify = true;
                        CursorPropertyEditor.this.x = newX;
                        CursorPropertyEditor.this.y = newY;
                        CursorPropertyEditor.this.xText.setText(String.valueOf(CursorPropertyEditor.this.x));
                        CursorPropertyEditor.this.yText.setText(String.valueOf(CursorPropertyEditor.this.y));
                        CursorPropertyEditor.this.inModify = false;
                    }
                } else {
                    CursorPropertyEditor.this.inModify = true;
                    CursorPropertyEditor.this.x = newX;
                    CursorPropertyEditor.this.y = newY;
                    CursorPropertyEditor.this.xText.setText(String.valueOf(CursorPropertyEditor.this.x));
                    CursorPropertyEditor.this.yText.setText(String.valueOf(CursorPropertyEditor.this.y));
                    CursorPropertyEditor.this.inModify = false;
                }
                CursorPropertyEditor.this.updateHotspotImage();
                CursorPropertyEditor.this.updateCustomPreview();
            }
        });
        this.hotspotCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                CursorPropertyEditor.this.updateHotspotImage();
            }
        });
        this.xText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (CursorPropertyEditor.this.inModify) {
                    return;
                }
                CursorPropertyEditor.this.inModify = true;
                try {
                    int value = Integer.parseInt(CursorPropertyEditor.this.xText.getText());
                    if (CursorPropertyEditor.this.sourceImageData != null) {
                        if (value >= 0 && value <= ((CursorPropertyEditor)CursorPropertyEditor.this).sourceImageData.width) {
                            CursorPropertyEditor.this.x = value;
                            CursorPropertyEditor.this.updateHotspotImage();
                            CursorPropertyEditor.this.updateCustomPreview();
                        } else {
                            CursorPropertyEditor.this.xText.setText(String.valueOf(CursorPropertyEditor.this.x));
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    CursorPropertyEditor.this.xText.setText(String.valueOf(CursorPropertyEditor.this.x));
                }
                CursorPropertyEditor.this.inModify = false;
            }
        });
        this.yText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (CursorPropertyEditor.this.inModify) {
                    return;
                }
                CursorPropertyEditor.this.inModify = true;
                try {
                    int value = Integer.parseInt(CursorPropertyEditor.this.yText.getText());
                    if (CursorPropertyEditor.this.sourceImageData != null) {
                        if (value >= 0 && value <= ((CursorPropertyEditor)CursorPropertyEditor.this).sourceImageData.height) {
                            CursorPropertyEditor.this.y = value;
                            CursorPropertyEditor.this.updateHotspotImage();
                            CursorPropertyEditor.this.updateCustomPreview();
                        } else {
                            CursorPropertyEditor.this.yText.setText(String.valueOf(CursorPropertyEditor.this.y));
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    CursorPropertyEditor.this.yText.setText(String.valueOf(CursorPropertyEditor.this.y));
                }
                CursorPropertyEditor.this.inModify = false;
            }
        });
    }

    private void radioSwitchStandard(boolean on) {
        this.constantsSelect.setEnabled(on);
        this.sourceLabel.setEnabled(!on);
        this.sourceText.setEnabled(!on);
        this.sourceBrowse.setEnabled(!on);
        this.maskLabel.setEnabled(!on);
        this.maskText.setEnabled(!on);
        this.maskBrowse.setEnabled(!on);
        this.hotspotGroup.setEnabled(!on);
        this.canvasGroup.setEnabled(!on);
        this.hotspotCanvas.setEnabled(!on);
        this.xLabel.setEnabled(!on);
        this.xText.setEnabled(!on);
        this.yLabel.setEnabled(!on);
        this.yText.setEnabled(!on);
        if (on) {
            int selection = this.constantsSelect.getSelectionIndex();
            this.setCursorFromList(selection);
        } else {
            this.updateCustomPreview();
            this.updateHotspotImage();
        }
    }

    private void updateHotspotImage() {
        this.transformImages();
        GC gc = new GC((Drawable)this.hotspotCanvas);
        gc.setBackground(this.hotspotCanvas.getBackground());
        gc.fillRectangle(0, 0, this.canvasSize.x, this.canvasSize.y);
        this.ratio = 1;
        if (this.sourceTransData != null) {
            Image img;
            int max = this.sourceTransData.height > this.sourceTransData.width ? this.sourceTransData.height : this.sourceTransData.width;
            this.ratio = this.canvasSize.x / max;
            ImageData scaledSource = this.sourceTransData.scaledTo(this.sourceTransData.height * this.ratio, this.sourceTransData.width * this.ratio);
            if (this.maskTransData != null) {
                ImageData scaledMask = this.maskTransData.scaledTo(this.maskTransData.height * this.ratio, this.maskTransData.width * this.ratio);
                img = new Image((Device)this.hotspotCanvas.getDisplay(), scaledSource, scaledMask);
            } else {
                img = new Image((Device)this.hotspotCanvas.getDisplay(), scaledSource);
            }
            gc.drawImage(img, 0, 0);
        }
        gc.setBackground(this.red);
        gc.fillRectangle(this.x * this.ratio - 1, this.y * this.ratio - 1, this.ratio + 2, this.ratio + 2);
        gc.dispose();
    }

    private void updateCustomPreview() {
        if (this.sourceImageData != null) {
            try {
                Cursor newValue = this.maskImageData != null ? new Cursor((Device)this.control.getDisplay(), this.sourceImageData, this.maskImageData, this.x, this.y) : new Cursor((Device)this.control.getDisplay(), this.sourceImageData, this.x, this.y);
                this.cursorConstant = -1;
                this.setValue(this.cursorValue);
                this.preview.updatePreview(newValue);
                if (this.cursorValue != null && !this.cursorValue.isDisposed()) {
                    this.cursorValue.dispose();
                }
                this.cursorConstant = -1;
                this.cursorValue = newValue;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void setCursorFromList(int index) {
        if (index < 0 || index >= cursorConstantValues.length) {
            return;
        }
        Cursor newValue = new Cursor((Device)this.control.getDisplay(), cursorConstantValues[index]);
        this.cursorConstant = index;
        this.setValue(newValue);
    }

    private void transformImages() {
        this.sourceTransData = this.sourceImageData != null ? (ImageData)this.sourceImageData.clone() : null;
        this.maskTransData = this.maskImageData != null ? (ImageData)this.maskImageData.clone() : null;
        if (this.sourceImageData != null && this.maskImageData != null) {
            byte[] masks = new byte[8];
            byte current = 1;
            int i = 0;
            while (i < masks.length) {
                masks[i] = current;
                current = (byte)(current << 1);
                ++i;
            }
            byte[] src = this.sourceTransData.data;
            byte[] mask = this.maskTransData.data;
            int i2 = 0;
            while (i2 < src.length) {
                byte s = src[i2];
                byte m = mask[i2];
                int j = 0;
                while (j < 8) {
                    boolean mIs1;
                    byte curMask = masks[j];
                    boolean sIs1 = (s & curMask) == curMask;
                    boolean bl = mIs1 = (m & curMask) == curMask;
                    if (!sIs1 && !mIs1) {
                        m = (byte)(m | curMask);
                    } else if (sIs1 && mIs1) {
                        m = (byte)(m & ~curMask);
                    } else if (!sIs1 && mIs1) {
                        s = (byte)(s | curMask);
                    }
                    ++j;
                }
                src[i2] = s;
                mask[i2] = m;
                ++i2;
            }
            this.sourceTransData.data = src;
            this.maskTransData.data = mask;
        }
    }

    public void setValue(Object value) {
        if (value == null) {
            this.cursorConstant = -1;
        }
        if (value instanceof Cursor) {
            if (this.preview != null) {
                this.preview.updatePreview((Cursor)value);
            }
            if (this.cursorValue != null && !this.cursorValue.isDisposed()) {
                this.cursorValue.dispose();
            }
            this.cursorValue = (Cursor)value;
            if (this.fPropertyChangeListeners != null) {
                Iterator iter = this.fPropertyChangeListeners.iterator();
                while (iter.hasNext()) {
                    ((PropertyChangeListener)iter.next()).propertyChange(new PropertyChangeEvent(this, "value", this.cursorValue, null));
                }
            }
        }
    }

    public void setJavaObjectInstanceValue(IJavaObjectInstance value) {
        this.fCursorInstance = value;
        String cursorName = CursorJavaClassLabelProvider.getText((IJavaInstance)value);
        if (!cursorName.equals("")) {
            int i = 0;
            while (i < cursorNames.length) {
                if (cursorNames[i].equals(cursorName)) {
                    this.cursorConstant = i;
                    break;
                }
                ++i;
            }
        }
    }

    public Object getValue() {
        return this.cursorValue;
    }

    public String getText() {
        if (this.fCursorInstance != null) {
            return CursorJavaClassLabelProvider.getText((IJavaInstance)this.fCursorInstance);
        }
        return "";
    }

    public String getJavaInitializationString() {
        StringBuffer init = new StringBuffer("new org.eclipse.swt.graphics.Cursor(org.eclipse.swt.widgets.Display.getDefault(), ");
        if (this.cursorConstant != -1) {
            init.append(CURSOR_PREFIX + cursorConstants[this.cursorConstant] + ")");
            return init.toString();
        }
        if (this.sourceImageData != null) {
            init.append("new org.eclipse.swt.graphics.ImageData(\"" + this.makeBackslashSafe(this.sourceText.getText()) + "\"), ");
            if (this.maskImageData != null) {
                init.append("new org.eclipse.swt.graphics.ImageData(\"" + this.makeBackslashSafe(this.maskText.getText()) + "\"), ");
            }
            init.append(this.x + ", " + this.y + ")");
            return init.toString();
        }
        return null;
    }

    private String makeBackslashSafe(String input) {
        StringBuffer sb = new StringBuffer(input);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '\\') {
                sb.insert(i, '\\');
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.fPropertyChangeListeners == null) {
            this.fPropertyChangeListeners = new ArrayList(1);
        }
        this.fPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.fPropertyChangeListeners != null) {
            this.fPropertyChangeListeners.remove(listener);
        }
    }

    private class PreviewPanel {
        private Group control;
        private Button previewButton;

        PreviewPanel() {
        }

        public Control createControl(Composite parent, int style) {
            if (this.control == null) {
                this.control = new Group(parent, style);
                this.control.setText(messages.getString("preview"));
                RowLayout rowLayout = new RowLayout();
                rowLayout.type = 512;
                this.control.setLayout((Layout)rowLayout);
                this.control.setToolTipText(messages.getString("hoverTooltip"));
                Composite preview = new Composite((Composite)this.control, 2048);
                preview.setToolTipText(messages.getString("hoverTooltip"));
                preview.setBackground(preview.getDisplay().getSystemColor(1));
                preview.setSize(new Point(150, 150));
                preview.setLayout((Layout)new GridLayout());
                this.previewButton = new Button(preview, 8);
                this.previewButton.setText("...");
                GridData data = new GridData();
                data.horizontalAlignment = 2;
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = true;
                this.previewButton.setLayoutData((Object)data);
                preview.pack();
                this.control.pack();
            }
            return this.control;
        }

        public void updatePreview(Cursor newCursor) {
            this.previewButton.setCursor(newCursor);
        }
    }

    private class NumberVerifier
    implements VerifyListener {
        NumberVerifier() {
        }

        public void verifyText(VerifyEvent arg0) {
            arg0.doit = true;
            try {
                if (arg0.text != null && arg0.text.length() > 0) {
                    Integer.parseInt(arg0.text);
                }
            }
            catch (NumberFormatException numberFormatException) {
                arg0.doit = false;
            }
        }
    }
}

