/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaBeanCustomizeLayoutPage;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;
import org.eclipse.ve.internal.swt.SWTConstants;
import org.eclipse.ve.internal.swt.SWTMessages;

public class FillLayoutLayoutPage
extends JavaBeanCustomizeLayoutPage {
    EditPart fEditPart = null;
    Button typeHorizontalRadio;
    Button typeVerticalRadio;
    Spinner spacingSpinner;
    Spinner heightSpinner;
    Spinner widthSpinner;
    ResourceSet rset;
    protected EReference sfCompositeLayout;
    EStructuralFeature sfSpacing;
    EStructuralFeature sfType;
    EStructuralFeature sfMarginHeight;
    EStructuralFeature sfMarginWidth;
    boolean initialized = false;
    private static final String[] orientationInitStrings = new String[]{"org.eclipse.swt.SWT.HORIZONTAL", "org.eclipse.swt.SWT.VERTICAL"};
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    protected SelectionListener radioSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            FillLayoutLayoutPage.this.radioModified((Button)e.widget);
        }
    };
    protected ModifyListener spinnerModify = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            FillLayoutLayoutPage.this.spinnerModified((Spinner)event.widget);
        }
    };
    private Map sfMap = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected void handleSelectionProviderInitialization(ISelectionProvider selectionProvider) {
    }

    public Control getControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout grid = new GridLayout();
        c.setLayout((Layout)grid);
        Group orientationGroup = new Group(c, 0);
        orientationGroup.setText(SWTMessages.FillLayoutLayoutPage_orientationGroupTitle);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        orientationGroup.setLayoutData((Object)gd);
        grid = new GridLayout();
        orientationGroup.setLayout((Layout)grid);
        this.typeHorizontalRadio = this.makeRadio((Composite)orientationGroup, SWTMessages.FillLayoutLayoutPage_horizontalLabel);
        this.typeVerticalRadio = this.makeRadio((Composite)orientationGroup, SWTMessages.FillLayoutLayoutPage_verticalLabel);
        Group spacingGroup = new Group(c, 0);
        spacingGroup.setText(SWTMessages.FillLayoutLayoutPage_spacingGroupTitle);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        spacingGroup.setLayoutData((Object)gd);
        grid = new GridLayout();
        grid.numColumns = 2;
        spacingGroup.setLayout((Layout)grid);
        this.spacingSpinner = this.makeSpinner((Composite)spacingGroup, SWTMessages.FillLayoutLayoutPage_spacingLabel);
        this.heightSpinner = this.makeSpinner((Composite)spacingGroup, SWTMessages.FillLayoutLayoutPage_heightLabel);
        this.widthSpinner = this.makeSpinner((Composite)spacingGroup, SWTMessages.FillLayoutLayoutPage_widthLabel);
        if (this.fEditPart != null) {
            this.initialized = false;
            this.initializeValues();
        }
        return c;
    }

    private Button makeRadio(Composite parent, String label) {
        Button b = new Button(parent, 16);
        b.setText(label);
        b.addSelectionListener(this.radioSelection);
        return b;
    }

    private Spinner makeSpinner(Composite parent, String labelText) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        Spinner spin = new Spinner(parent, 2048);
        spin.setSelection(0);
        spin.setMaximum(9999);
        spin.addModifyListener(this.spinnerModify);
        return spin;
    }

    protected boolean handleSelectionChanged(ISelection oldSelection) {
        ISelection newSelection = this.getSelection();
        if (newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty()) {
            EditPart firstParent;
            List editparts = ((IStructuredSelection)newSelection).toList();
            boolean enableAll = true;
            if (editparts.size() == 1 && editparts.get(0) instanceof EditPart && this.isValidTarget(firstParent = (EditPart)editparts.get(0))) {
                this.fEditPart = firstParent;
                this.initialized = false;
                this.initializeValues();
                return true;
            }
            if (editparts.get(0) instanceof EditPart && ((EditPart)editparts.get(0)).getParent() != null && this.isValidTarget(firstParent = ((EditPart)editparts.get(0)).getParent())) {
                EditPart ep = (EditPart)editparts.get(0);
                int i = 1;
                while (i < editparts.size()) {
                    if (editparts.get(i) instanceof EditPart) {
                        ep = (EditPart)editparts.get(i);
                        if (ep.getParent() == null || ep.getParent() != firstParent) {
                            enableAll = false;
                            break;
                        }
                    } else {
                        enableAll = false;
                        break;
                    }
                    ++i;
                }
                if (enableAll) {
                    this.fEditPart = firstParent;
                    this.initialized = false;
                    this.initializeValues();
                    return true;
                }
            }
        }
        this.fEditPart = null;
        return false;
    }

    public boolean isValidTarget(EditPart target) {
        IActionFilter af;
        Class<?> clazz;
        if (target instanceof TreeEditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain((EditPart)target);
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz2)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(target.getModel())) != null) {
                target = ep;
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (af = (IActionFilter)target.getAdapter((Class)clazz)) != null && af.testAttribute((Object)target, "EDITPOLICY#LAYOUTPOLICY", "org.eclipse.swt.layout.FillLayout");
    }

    protected boolean selectionIsContainer(ISelection newSelection) {
        EditPart firstParent;
        List editparts;
        return newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty() && (editparts = ((IStructuredSelection)newSelection).toList()).size() == 1 && editparts.get(0) instanceof EditPart && this.isValidTarget(firstParent = (EditPart)editparts.get(0));
    }

    protected void handleEditorPartChanged(IEditorPart oldEditorPart) {
        this.resetVariables();
    }

    private void initializeValues() {
        if (!this.initialized) {
            this.getResourceSet(this.fEditPart);
            if (this.typeHorizontalRadio == null) {
                return;
            }
            int orientationValue = this.getIntValue(this.fEditPart, this.sfType);
            if (orientationValue == 256) {
                this.typeHorizontalRadio.setSelection(true);
                this.typeVerticalRadio.setSelection(false);
            } else if (orientationValue == 512) {
                this.typeVerticalRadio.setSelection(true);
                this.typeHorizontalRadio.setSelection(false);
            }
            this.spacingSpinner.setSelection(this.getIntValue(this.fEditPart, this.sfSpacing));
            this.spacingSpinner.setEnabled(true);
            this.heightSpinner.setSelection(this.getIntValue(this.fEditPart, this.sfMarginHeight));
            this.heightSpinner.setEnabled(true);
            this.widthSpinner.setSelection(this.getIntValue(this.fEditPart, this.sfMarginWidth));
            this.widthSpinner.setEnabled(true);
            this.initialized = true;
        }
    }

    private EStructuralFeature getSFForWidget(Widget w) {
        if (this.sfMap == null) {
            this.sfMap = new HashMap();
            this.sfMap.put(this.spacingSpinner, this.sfSpacing);
            this.sfMap.put(this.heightSpinner, this.sfMarginHeight);
            this.sfMap.put(this.widthSpinner, this.sfMarginWidth);
        }
        return (EStructuralFeature)this.sfMap.get(w);
    }

    private void radioModified(Button b) {
        if (this.initialized) {
            this.execute(this.createOrientationCommand(this.fEditPart, b == this.typeHorizontalRadio ? 0 : 1));
        }
    }

    private void spinnerModified(Spinner s) {
        if (this.initialized) {
            this.execute(this.createSpinnerCommand(this.fEditPart, this.getSFForWidget((Widget)s), s));
        }
    }

    protected Command createOrientationCommand(EditPart editpart, int orientation) {
        CommandBuilder cb = new CommandBuilder();
        EObject control = (EObject)editpart.getModel();
        if (control != null) {
            IJavaInstance layout = (IJavaInstance)control.eGet((EStructuralFeature)this.sfCompositeLayout);
            if (layout == null) {
                return UnexecutableCommand.INSTANCE;
            }
            RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
            String init = orientationInitStrings[orientation];
            IJavaInstance intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)init);
            componentCB.applyAttributeSetting((EObject)layout, this.sfType, (Object)intObject);
            componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfCompositeLayout, (Object)layout);
            cb.append(componentCB.getCommand());
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createSpinnerCommand(EditPart editpart, EStructuralFeature sf, Spinner spinner) {
        CommandBuilder cb = new CommandBuilder();
        EObject control = (EObject)editpart.getModel();
        if (control != null) {
            IJavaInstance layout = (IJavaInstance)control.eGet((EStructuralFeature)this.sfCompositeLayout);
            if (layout == null) {
                return UnexecutableCommand.INSTANCE;
            }
            RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
            String init = String.valueOf(spinner.getSelection());
            IJavaInstance intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)init);
            componentCB.applyAttributeSetting((EObject)layout, sf, (Object)intObject);
            componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfCompositeLayout, (Object)layout);
            cb.append(componentCB.getCommand());
            cb.append((Command)new EnableSpinnerCommand(spinner));
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected int getIntValue(EditPart ep, EStructuralFeature sf) {
        Object intPV;
        IPropertySource gridLayout;
        IPropertySource ps;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ps = (IPropertySource)ep.getAdapter((Class)clazz)) != null && this.getResourceSet(ep) != null && (gridLayout = (IPropertySource)ps.getPropertyValue((Object)this.sfCompositeLayout)) != null && (intPV = gridLayout.getPropertyValue((Object)sf)) != null && intPV instanceof IJavaDataTypeInstance) {
            IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)intPV), (ResourceSet)this.rset);
            return intProxy.intValue();
        }
        return 0;
    }

    protected void execute(Command command) {
        CommandStack cmdStack;
        if (command == null || !command.canExecute()) {
            return;
        }
        IEditorPart iEditorPart = this.getEditorPart();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cmdStack = (CommandStack)iEditorPart.getAdapter((Class)clazz)) != null) {
            cmdStack.execute(command);
        }
    }

    private void resetVariables() {
        this.rset = null;
        this.sfCompositeLayout = null;
        this.sfSpacing = null;
        this.sfType = null;
        this.sfMarginHeight = null;
        this.sfMarginWidth = null;
        this.initialized = false;
    }

    protected ResourceSet getResourceSet(EditPart editpart) {
        if (this.rset == null) {
            this.rset = EMFEditDomainHelper.getResourceSet((EditDomain)EditDomain.getEditDomain((EditPart)editpart));
            this.sfCompositeLayout = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)SWTConstants.SF_COMPOSITE_LAYOUT);
            this.sfSpacing = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_FILL_LAYOUT_SPACING);
            this.sfType = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_FILL_LAYOUT_TYPE);
            this.sfMarginHeight = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_FILL_LAYOUT_MARGIN_HEIGHT);
            this.sfMarginWidth = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_FILL_LAYOUT_MARGIN_WIDTH);
        }
        return this.rset;
    }

    protected class EnableSpinnerCommand
    extends AbstractCommand {
        protected Spinner spinner;

        public EnableSpinnerCommand(Spinner spinner) {
            this.spinner = spinner;
        }

        public void execute() {
            if (this.spinner != null) {
                this.spinner.setEnabled(true);
            }
        }

        public boolean canExecute() {
            return true;
        }
    }
}

