/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ContainerEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTInstanceReference;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.jcm.BeanComposition;
import org.eclipse.ve.internal.jcm.JCMPackage;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class FormToolkitEditPolicy
extends ContainerEditPolicy {
    private EditDomain editDomain;
    private RuledCommandBuilder builder;

    protected Command getCreateCommand(CreateRequest request) {
        try {
            IJavaObjectInstance javaChild = (IJavaObjectInstance)request.getNewObject();
            if (javaChild != null && javaChild.getAllocation() != null) {
                return new EnsureFormToolkitExistsCommand(javaChild);
            }
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public class EnsureFormToolkitExistsCommand
    extends AbstractCommand {
        private IJavaObjectInstance javaChild;
        private boolean changedAllocation;
        private IJavaObjectInstance formToolkit;

        public EnsureFormToolkitExistsCommand(IJavaObjectInstance instance) {
            this.javaChild = instance;
        }

        public void execute() {
            if (this.javaChild.getAllocation() instanceof ParseTreeAllocation) {
                FormToolkitEditPolicy.this.editDomain = EditDomain.getEditDomain((EditPart)FormToolkitEditPolicy.this.getHost());
                PTExpression expression = ((ParseTreeAllocation)this.javaChild.getAllocation()).getExpression();
                if (expression instanceof PTMethodInvocation) {
                    this.visitMethodInvocation((PTMethodInvocation)expression);
                }
                if (this.changedAllocation) {
                    ParseTreeAllocation newAlloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation();
                    newAlloc.setExpression(expression);
                    this.javaChild.setAllocation((JavaAllocation)newAlloc);
                }
            }
        }

        private void visitMethodInvocation(PTMethodInvocation methodInvocation) {
            PTName name;
            if (methodInvocation.getReceiver() instanceof PTName && (name = (PTName)methodInvocation.getReceiver()).getName().equals("{formToolkit}")) {
                this.formToolkit = this.ensureFormToolkitExists();
                PTInstanceReference formToolkitRef = InstantiationFactory.eINSTANCE.createPTInstanceReference();
                formToolkitRef.setObject(this.formToolkit);
                methodInvocation.setReceiver((PTExpression)formToolkitRef);
                this.changedAllocation = true;
            }
        }

        private IJavaObjectInstance ensureFormToolkitExists() {
            BeanComposition beanComposition = (BeanComposition)FormToolkitEditPolicy.this.editDomain.getDiagramData();
            Iterator iter = beanComposition.getComponents().iterator();
            while (iter.hasNext()) {
                IJavaObjectInstance javaComponent;
                Object component = iter.next();
                if (!(component instanceof IJavaObjectInstance) || !(javaComponent = (IJavaObjectInstance)component).getJavaType().getQualifiedName().equals("org.eclipse.ui.forms.widgets.FormToolkit")) continue;
                return javaComponent;
            }
            ArrayList<PTMethodInvocation> args = new ArrayList<PTMethodInvocation>(1);
            PTMethodInvocation getDisplayExpression = InstantiationFactory.eINSTANCE.createPTMethodInvocation((PTExpression)InstantiationFactory.eINSTANCE.createPTName("org.eclipse.swt.widgets.Display"), "getCurrent", null);
            args.add(getDisplayExpression);
            PTClassInstanceCreation formToolkitExpression = InstantiationFactory.eINSTANCE.createPTClassInstanceCreation("org.eclipse.ui.forms.widgets.FormToolkit", args);
            ParseTreeAllocation formToolkitAllocation = InstantiationFactory.eINSTANCE.createParseTreeAllocation((PTExpression)formToolkitExpression);
            IJavaObjectInstance newFormToolkit = (IJavaObjectInstance)BeanUtilities.createJavaObject((String)"org.eclipse.ui.forms.widgets.FormToolkit", (ResourceSet)((IJavaObjectInstance)FormToolkitEditPolicy.this.getHost().getModel()).eResource().getResourceSet(), (JavaAllocation)formToolkitAllocation);
            FormToolkitEditPolicy.this.builder = new RuledCommandBuilder(FormToolkitEditPolicy.this.editDomain);
            FormToolkitEditPolicy.this.builder.applyAttributeSetting((EObject)beanComposition, (EStructuralFeature)JCMPackage.eINSTANCE.getBeanComposition_Components(), (Object)newFormToolkit);
            FormToolkitEditPolicy.this.builder.append(BeanUtilities.getSetEmptyVisualContraintsCommand((IJavaInstance)newFormToolkit, (boolean)false, (EditDomain)FormToolkitEditPolicy.this.editDomain));
            FormToolkitEditPolicy.this.builder.getCommand().execute();
            return newFormToolkit;
        }

        protected boolean prepare() {
            return true;
        }
    }
}

