/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaBeanCustomizeLayoutPage;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.swt.SWTConstants;
import org.eclipse.ve.internal.swt.SWTMessages;

public class GridLayoutComponentPage
extends JavaBeanCustomizeLayoutPage {
    protected IEditorPart fEditorPart;
    private static final String[] resAlignmentValueLabels = new String[]{SWTMessages.AlignmentAction_beginning_beginning_label, SWTMessages.AlignmentAction_beginning_center_label, SWTMessages.AlignmentAction_beginning_end_label, SWTMessages.AlignmentAction_center_beginning_label, SWTMessages.AlignmentAction_center_center_label, SWTMessages.AlignmentAction_center_end_label, SWTMessages.AlignmentAction_end_beginning_label, SWTMessages.AlignmentAction_end_center_label, SWTMessages.AlignmentAction_end_end_label};
    private static final String[] resAlignmentValueTooltips = new String[]{SWTMessages.AlignmentAction_beginning_beginning_tooltip, SWTMessages.AlignmentAction_beginning_center_tooltip, SWTMessages.AlignmentAction_beginning_end_tooltip, SWTMessages.AlignmentAction_center_beginning_tooltip, SWTMessages.AlignmentAction_center_center_tooltip, SWTMessages.AlignmentAction_center_end_tooltip, SWTMessages.AlignmentAction_end_beginning_tooltip, SWTMessages.AlignmentAction_end_center_tooltip, SWTMessages.AlignmentAction_end_end_tooltip};
    private static final String[] resAlignmentValueImages = new String[]{SWTMessages.AlignmentAction_beginning_beginning_image, SWTMessages.AlignmentAction_beginning_center_image, SWTMessages.AlignmentAction_beginning_end_image, SWTMessages.AlignmentAction_center_beginning_image, SWTMessages.AlignmentAction_center_center_image, SWTMessages.AlignmentAction_center_end_image, SWTMessages.AlignmentAction_end_beginning_image, SWTMessages.AlignmentAction_end_center_image, SWTMessages.AlignmentAction_end_end_image};
    private static final String[] resAlignmentValueIDs = new String[]{"AlignmentAction.beginning.beginning", "AlignmentAction.beginning.center", "AlignmentAction.beginning.end", "AlignmentAction.center.beginning", "AlignmentAction.center.center", "AlignmentAction.center.end", "AlignmentAction.end.beginning", "AlignmentAction.end.center", "AlignmentAction.end.end"};
    public static final int BEGINNING = 0;
    public static final int CENTER = 1;
    public static final int END = 2;
    public static final int FILL = 3;
    protected static String[] alignmentInitStrings = new String[]{"org.eclipse.swt.layout.GridData.BEGINNING", "org.eclipse.swt.layout.GridData.CENTER", "org.eclipse.swt.layout.GridData.END", "org.eclipse.swt.layout.GridData.FILL"};
    protected static int[] alignmentSWTValues = new int[]{1, 2, 3, 4};
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected AlignmentAction[] alignmentActions = new AlignmentAction[]{new AlignmentAction(0, 0), new AlignmentAction(1, 0), new AlignmentAction(2, 0), new AlignmentAction(0, 1), new AlignmentAction(1, 1), new AlignmentAction(2, 1), new AlignmentAction(0, 2), new AlignmentAction(1, 2), new AlignmentAction(2, 2)};
    private static final String[] resFillIDs = new String[]{"FillAction.horizontal", "FillAction.vertical"};
    private static final String[] resFillLabels = new String[]{SWTMessages.FillAction_horizontal_label, SWTMessages.FillAction_vertical_label};
    private static final String[] resFillImages = new String[]{SWTMessages.FillAction_horizontal_image, SWTMessages.FillAction_vertical_image};
    private static final String[] resFillTooltips = new String[]{SWTMessages.FillAction_horizontal_tooltip, SWTMessages.FillAction_vertical_tooltip};
    private FillAction[] fillActions = new FillAction[]{new FillAction(0), new FillAction(1)};
    private static final String[] resGrabIDs = new String[]{"GrabAction.horizontal", "GrabAction.vertical"};
    private static final String[] resGrabLabels = new String[]{SWTMessages.GrabAction_horizontal_label, SWTMessages.GrabAction_vertical_label};
    private static final String[] resGrabTooltips = new String[]{SWTMessages.GrabAction_horizontal_tooltip, SWTMessages.GrabAction_vertical_tooltip};
    private static final String[] resGrabImages = new String[]{SWTMessages.GrabAction_horizontal_image, SWTMessages.GrabAction_vertical_image};
    private GrabAction[] grabActions = new GrabAction[]{new GrabAction(0), new GrabAction(1)};
    protected EReference sfControlLayoutData;
    protected EStructuralFeature sfHorizontalAlignment;
    protected EStructuralFeature sfVerticalAlignment;
    protected EStructuralFeature sfHorizontalGrab;
    protected EStructuralFeature sfVerticalGrab;
    protected EStructuralFeature sfHorizontalSpan;
    protected EStructuralFeature sfVerticalSpan;
    protected EStructuralFeature sfHorizontalIndent;
    protected EStructuralFeature sfHeightHint;
    protected EStructuralFeature sfWidthHint;
    protected ResourceSet rset;
    protected AlignmentAction selectedAlignmentAction;
    protected boolean fillVertical = false;
    protected boolean fillHorizontal = false;
    protected Spinner horizontalSpanSpinner;
    protected Spinner verticalSpanSpinner;
    protected Spinner horizontalIndentSpinner;
    protected org.eclipse.ve.internal.java.core.Spinner heightHintSpinner;
    protected org.eclipse.ve.internal.java.core.Spinner widthHintSpinner;
    protected int horizontalSpanValue = 1;
    protected int verticalSpanValue = 1;
    protected int horizontalIndentValue = 0;
    protected int heightHintValue = -1;
    protected int widthHintValue = -1;
    private Button restoreAllButton;
    private boolean hasGridDataValue = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected static int getOffetFromConstant(int constant) {
        int i = 0;
        while (i < alignmentSWTValues.length) {
            if (alignmentSWTValues[i] == constant) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected List getSelectedObjects() {
        if (!(this.getSelection() instanceof IStructuredSelection)) {
            return Collections.EMPTY_LIST;
        }
        return ((IStructuredSelection)this.getSelection()).toList();
    }

    protected Command createAlignmentCommand(List editparts, int horizontalAlign, int verticalAlign) {
        if (!editparts.isEmpty()) {
            CommandBuilder cb = new CommandBuilder();
            int i = 0;
            while (i < editparts.size()) {
                EditPart editpart = (EditPart)editparts.get(i);
                EObject control = (EObject)editpart.getModel();
                if (control != null) {
                    IJavaInstance gridData = (IJavaInstance)control.eGet((EStructuralFeature)this.sfControlLayoutData);
                    if (gridData == null) {
                        gridData = BeanUtilities.createJavaObject((String)"org.eclipse.swt.layout.GridData", (ResourceSet)this.rset, (String)"new org.eclipse.swt.layout.GridData()");
                    }
                    if (gridData != null) {
                        RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
                        String init = this.fillHorizontal ? alignmentInitStrings[3] : alignmentInitStrings[horizontalAlign];
                        IJavaInstance alignObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)init);
                        componentCB.applyAttributeSetting((EObject)gridData, this.sfHorizontalAlignment, (Object)alignObject);
                        init = this.fillVertical ? alignmentInitStrings[3] : alignmentInitStrings[verticalAlign];
                        alignObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)init);
                        componentCB.applyAttributeSetting((EObject)gridData, this.sfVerticalAlignment, (Object)alignObject);
                        componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfControlLayoutData, (Object)gridData);
                        cb.append(componentCB.getCommand());
                    }
                }
                ++i;
            }
            if (!this.restoreAllButton.getEnabled()) {
                this.restoreAllButton.setEnabled(true);
            }
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createGrabCommand(List editparts, int grabType, boolean value) {
        if (!editparts.isEmpty()) {
            CommandBuilder cb = new CommandBuilder();
            int i = 0;
            while (i < editparts.size()) {
                EditPart editpart = (EditPart)editparts.get(i);
                EObject control = (EObject)editpart.getModel();
                if (control != null) {
                    IJavaInstance gridData = (IJavaInstance)control.eGet((EStructuralFeature)this.sfControlLayoutData);
                    if (gridData == null) {
                        gridData = BeanUtilities.createJavaObject((String)"org.eclipse.swt.layout.GridData", (ResourceSet)this.rset, (String)"new org.eclipse.swt.layout.GridData()");
                    }
                    if (gridData != null) {
                        RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
                        String init = String.valueOf(value);
                        IJavaInstance alignObject = BeanUtilities.createJavaObject((String)"boolean", (ResourceSet)this.rset, (String)init);
                        if (grabType == 0) {
                            componentCB.applyAttributeSetting((EObject)gridData, this.sfHorizontalGrab, (Object)alignObject);
                        } else {
                            componentCB.applyAttributeSetting((EObject)gridData, this.sfVerticalGrab, (Object)alignObject);
                        }
                        componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfControlLayoutData, (Object)gridData);
                        cb.append(componentCB.getCommand());
                    }
                }
                ++i;
            }
            if (!this.restoreAllButton.getEnabled()) {
                this.restoreAllButton.setEnabled(true);
            }
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createSpinnerCommand(List editparts, EStructuralFeature sf, int spinnerValue) {
        if (!editparts.isEmpty()) {
            CommandBuilder cb = new CommandBuilder();
            int i = 0;
            while (i < editparts.size()) {
                EditPart editpart = (EditPart)editparts.get(i);
                EObject control = (EObject)editpart.getModel();
                if (control != null) {
                    IJavaInstance gridData = (IJavaInstance)control.eGet((EStructuralFeature)this.sfControlLayoutData);
                    if (gridData == null) {
                        gridData = BeanUtilities.createJavaObject((String)"org.eclipse.swt.layout.GridData", (ResourceSet)this.rset, (String)"new org.eclipse.swt.layout.GridData()");
                    }
                    if (gridData != null) {
                        try {
                            RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
                            String init = String.valueOf(spinnerValue);
                            IJavaInstance intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)init);
                            componentCB.applyAttributeSetting((EObject)gridData, sf, (Object)intObject);
                            componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfControlLayoutData, (Object)gridData);
                            cb.append(componentCB.getCommand());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return UnexecutableCommand.INSTANCE;
                        }
                    }
                }
                ++i;
            }
            if (!this.restoreAllButton.getEnabled()) {
                this.restoreAllButton.setEnabled(true);
            }
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createRestoreDefaultsCommand(List editparts) {
        if (!editparts.isEmpty()) {
            CommandBuilder cb = new CommandBuilder();
            int i = 0;
            while (i < editparts.size()) {
                EditPart editpart = (EditPart)editparts.get(i);
                EObject control = (EObject)editpart.getModel();
                if (control != null && control.eIsSet((EStructuralFeature)this.sfControlLayoutData)) {
                    RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)editpart), null, false);
                    componentCB.cancelAttributeSetting(control, (EStructuralFeature)this.sfControlLayoutData);
                    cb.append(componentCB.getCommand());
                }
                ++i;
            }
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Control getControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(3, false));
        Group alignmentGroup = this.createGroup(mainComposite, SWTMessages.GridLayoutComponentPage_Alignment, 2, 5, 0);
        GridData gd1 = new GridData();
        gd1.verticalSpan = 2;
        gd1.verticalAlignment = 4;
        alignmentGroup.setLayoutData((Object)gd1);
        Composite alignmentGrid = new Composite((Composite)alignmentGroup, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 3;
        grid.horizontalSpacing = 0;
        grid.verticalSpacing = 0;
        grid.marginHeight = 0;
        alignmentGrid.setLayout((Layout)grid);
        int i = 0;
        while (i < this.alignmentActions.length) {
            ActionContributionItem ac = new ActionContributionItem((IAction)this.alignmentActions[i]);
            ac.fill(alignmentGrid);
            ++i;
        }
        Group fillGroup = this.createGroup((Composite)alignmentGroup, SWTMessages.GridLayoutComponentPage_Fill, 1, 0, 0);
        int i2 = 0;
        while (i2 < this.fillActions.length) {
            ActionContributionItem ac = new ActionContributionItem((IAction)this.fillActions[i2]);
            ac.fill((Composite)fillGroup);
            ++i2;
        }
        Label horizontalIndentLabel = new Label((Composite)alignmentGroup, 0);
        horizontalIndentLabel.setText(SWTMessages.GridLayoutComponentPage_HorizontalIndent);
        this.horizontalIndentSpinner = new Spinner((Composite)alignmentGroup, 2048);
        this.horizontalIndentSpinner.setSelection(this.horizontalIndentValue);
        this.horizontalIndentSpinner.setMaximum(9999);
        this.horizontalIndentSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int value = GridLayoutComponentPage.this.horizontalIndentSpinner.getSelection();
                if (value != GridLayoutComponentPage.this.horizontalIndentValue) {
                    GridLayoutComponentPage.this.horizontalIndentValue = value;
                    GridLayoutComponentPage.this.execute(GridLayoutComponentPage.this.createSpinnerCommand(GridLayoutComponentPage.this.getSelectedObjects(), GridLayoutComponentPage.this.sfHorizontalIndent, GridLayoutComponentPage.this.horizontalIndentValue));
                }
            }
        });
        Group spanGroup = this.createGroup(mainComposite, SWTMessages.GridLayoutComponentPage_Span, 2, 4, 4);
        this.createSpanControl(spanGroup);
        Group grabGroup = this.createGroup(mainComposite, SWTMessages.GridLayoutComponentPage_Grab, 2, 0, 0);
        int i3 = 0;
        while (i3 < this.grabActions.length) {
            ActionContributionItem ac = new ActionContributionItem((IAction)this.grabActions[i3]);
            ac.fill((Composite)grabGroup);
            ++i3;
        }
        GridData gd2 = new GridData();
        gd2.verticalSpan = 1;
        gd2.verticalAlignment = 4;
        grabGroup.setLayoutData((Object)gd2);
        Group hintsGroup = this.createGroup(mainComposite, SWTMessages.GridLayoutComponentPage_Hints, 2, 4, 4);
        GridData gd3 = new GridData();
        gd3.horizontalAlignment = 4;
        hintsGroup.setLayoutData((Object)gd3);
        Label horizontalHintLabel = new Label((Composite)hintsGroup, 0);
        horizontalHintLabel.setText(SWTMessages.GridLayoutComponentPage_HeightHint);
        this.heightHintSpinner = new org.eclipse.ve.internal.java.core.Spinner((Composite)hintsGroup, 0, -1);
        this.heightHintSpinner.setMinimum(-1);
        this.heightHintSpinner.setValue(this.heightHintValue);
        this.heightHintSpinner.addModifyListener(new Listener(){

            public void handleEvent(Event e) {
                int value = GridLayoutComponentPage.this.heightHintSpinner.getValue();
                if (value != GridLayoutComponentPage.this.heightHintValue) {
                    GridLayoutComponentPage.this.heightHintValue = value;
                    GridLayoutComponentPage.this.execute(GridLayoutComponentPage.this.createSpinnerCommand(GridLayoutComponentPage.this.getSelectedObjects(), GridLayoutComponentPage.this.sfHeightHint, GridLayoutComponentPage.this.heightHintValue));
                }
            }
        });
        Label verticalHintLabel = new Label((Composite)hintsGroup, 0);
        verticalHintLabel.setText(SWTMessages.GridLayoutComponentPage_WidthHint);
        this.widthHintSpinner = new org.eclipse.ve.internal.java.core.Spinner((Composite)hintsGroup, 0, -1);
        this.widthHintSpinner.setMinimum(-1);
        this.widthHintSpinner.setValue(this.widthHintValue);
        this.widthHintSpinner.addModifyListener(new Listener(){

            public void handleEvent(Event e) {
                int value = GridLayoutComponentPage.this.widthHintSpinner.getValue();
                if (value != GridLayoutComponentPage.this.widthHintValue) {
                    GridLayoutComponentPage.this.widthHintValue = value;
                    GridLayoutComponentPage.this.execute(GridLayoutComponentPage.this.createSpinnerCommand(GridLayoutComponentPage.this.getSelectedObjects(), GridLayoutComponentPage.this.sfWidthHint, GridLayoutComponentPage.this.widthHintValue));
                }
            }
        });
        Label spacer = new Label(mainComposite, 0);
        spacer.setText("");
        this.restoreAllButton = new Button(mainComposite, 0);
        this.restoreAllButton.setEnabled(this.hasGridDataValue);
        this.restoreAllButton.setText(SWTMessages.GridLayoutComponentPage_Button_RestoreDefaults_Text);
        this.restoreAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutComponentPage.this.restoreAllDefaultValues();
            }
        });
        return mainComposite;
    }

    protected void restoreAllDefaultValues() {
        Command cmd;
        List editparts = this.getSelectedObjects();
        if (!editparts.isEmpty() && (cmd = this.createRestoreDefaultsCommand(editparts)) != UnexecutableCommand.INSTANCE) {
            this.execute(this.createRestoreDefaultsCommand(editparts));
            this.refreshAllValues(editparts);
            this.restoreAllButton.setEnabled(false);
        }
    }

    protected Group createGroup(Composite aParent, String title, int numColumns, int verticalSpacing, int horizontalSpacing) {
        Group group = new Group(aParent, 0);
        group.setText(title);
        GridLayout gridLayout = new GridLayout(numColumns, false);
        gridLayout.verticalSpacing = verticalSpacing;
        gridLayout.horizontalSpacing = horizontalSpacing;
        group.setLayout((Layout)gridLayout);
        return group;
    }

    protected void createSpanControl(Group spanGroup) {
        Label horizontalLabel = new Label((Composite)spanGroup, 0);
        horizontalLabel.setText(SWTMessages.GridLayoutComponentPage_SpanHorizontal);
        this.horizontalSpanSpinner = new Spinner((Composite)spanGroup, 2048);
        this.horizontalSpanSpinner.setMinimum(1);
        this.horizontalSpanSpinner.setMaximum(9999);
        this.horizontalSpanSpinner.setSelection(this.horizontalSpanValue);
        Label verticalLabel = new Label((Composite)spanGroup, 0);
        verticalLabel.setText(SWTMessages.GridLayoutComponentPage_SpanVertical);
        this.verticalSpanSpinner = new Spinner((Composite)spanGroup, 2048);
        this.verticalSpanSpinner.setMinimum(1);
        this.verticalSpanSpinner.setMaximum(9999);
        this.verticalSpanSpinner.setSelection(this.verticalSpanValue);
        this.horizontalSpanSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int value = GridLayoutComponentPage.this.horizontalSpanSpinner.getSelection();
                if (value != GridLayoutComponentPage.this.horizontalSpanValue) {
                    GridLayoutComponentPage.this.horizontalSpanValue = value;
                    GridLayoutComponentPage.this.execute(GridLayoutComponentPage.this.createSpinnerCommand(GridLayoutComponentPage.this.getSelectedObjects(), GridLayoutComponentPage.this.sfHorizontalSpan, value));
                }
            }
        });
        this.verticalSpanSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int value = GridLayoutComponentPage.this.verticalSpanSpinner.getSelection();
                if (value != GridLayoutComponentPage.this.verticalSpanValue) {
                    GridLayoutComponentPage.this.verticalSpanValue = value;
                    GridLayoutComponentPage.this.execute(GridLayoutComponentPage.this.createSpinnerCommand(GridLayoutComponentPage.this.getSelectedObjects(), GridLayoutComponentPage.this.sfVerticalSpan, value));
                }
            }
        });
    }

    protected void enableAlignmentActions(boolean enable) {
        int i = 0;
        while (i < this.alignmentActions.length) {
            this.alignmentActions[i].setEnabled(enable);
            if (!enable) {
                this.alignmentActions[i].setChecked(false);
            }
            ++i;
        }
        i = 0;
        while (i < this.fillActions.length) {
            this.fillActions[i].setEnabled(enable);
            if (!enable) {
                this.fillActions[i].setChecked(false);
            }
            ++i;
        }
    }

    protected void enableGrabActions(boolean enable) {
        int i = 0;
        while (i < this.grabActions.length) {
            this.grabActions[i].setEnabled(enable);
            if (!enable) {
                this.grabActions[i].setChecked(false);
            }
            ++i;
        }
    }

    protected void execute(Command command) {
        CommandStack cmdStack;
        if (command == null || !command.canExecute()) {
            return;
        }
        IEditorPart iEditorPart = this.getEditorPart();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cmdStack = (CommandStack)iEditorPart.getAdapter((Class)clazz)) != null) {
            cmdStack.execute(command);
        }
    }

    public Image getImage() {
        return null;
    }

    public String getText() {
        return SWTMessages.GridLayoutComponentPage_Grid;
    }

    public String getToolTipText() {
        return SWTMessages.GridLayoutComponentPage_ToolTipText;
    }

    protected void handleEditorPartChanged(IEditorPart oldEditorPart) {
        IEditorPart newEditorPart = this.getEditorPart();
        int i = 0;
        while (i < this.alignmentActions.length) {
            this.alignmentActions[i].setEditorPart(newEditorPart);
            ++i;
        }
        i = 0;
        while (i < this.grabActions.length) {
            this.grabActions[i].setEditorPart(newEditorPart);
            ++i;
        }
        this.resetVariables();
    }

    protected boolean handleSelectionChanged(ISelection oldSelection) {
        ISelection newSelection = this.getSelection();
        if (newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty()) {
            EditPart firstParent;
            List editparts = ((IStructuredSelection)newSelection).toList();
            boolean enableAll = true;
            if (editparts.get(0) instanceof EditPart && ((EditPart)editparts.get(0)).getParent() != null && this.isValidParent(firstParent = ((EditPart)editparts.get(0)).getParent())) {
                EditPart ep = (EditPart)editparts.get(0);
                int i = 1;
                while (i < editparts.size()) {
                    if (editparts.get(i) instanceof EditPart) {
                        ep = (EditPart)editparts.get(i);
                        if (ep.getParent() == null || ep.getParent() != firstParent) {
                            enableAll = false;
                            break;
                        }
                    } else {
                        enableAll = false;
                        break;
                    }
                    ++i;
                }
                if (enableAll) {
                    this.enableAlignmentActions(true);
                    this.enableGrabActions(true);
                    this.refreshAllValues(editparts);
                    if (this.restoreAllButton != null) {
                        if (this.hasGridData(editparts)) {
                            this.restoreAllButton.setEnabled(true);
                        } else {
                            this.restoreAllButton.setEnabled(false);
                        }
                    }
                    return true;
                }
            }
        }
        this.enableAlignmentActions(false);
        this.enableGrabActions(false);
        return false;
    }

    private void refreshAllValues(List editparts) {
        this.handleSelectionChangedForAlignmentActions(editparts);
        this.handleSelectionChangedForGrabActions(editparts);
        this.handleSelectionChangedForSpinners(editparts);
        this.hasGridDataValue = this.hasGridData(editparts);
    }

    protected void handleSelectionChangedForAlignmentActions(List editparts) {
        boolean setChecked = true;
        int firstHorizontalValue = this.getHorizontalAlignValue((EditPart)editparts.get(0));
        int firstVerticalValue = this.getVerticalAlignValue((EditPart)editparts.get(0));
        int i = 1;
        while (i < editparts.size()) {
            if (firstHorizontalValue != this.getHorizontalAlignValue((EditPart)editparts.get(i)) || firstVerticalValue != this.getVerticalAlignValue((EditPart)editparts.get(i))) {
                setChecked = false;
                break;
            }
            ++i;
        }
        if (setChecked) {
            this.fillHorizontal = firstHorizontalValue == alignmentSWTValues[3];
            this.fillVertical = firstVerticalValue == alignmentSWTValues[3];
            this.fillActions[0].updateAlignmentEnablement();
            this.fillActions[0].setChecked(this.fillHorizontal);
            this.fillActions[1].setChecked(this.fillVertical);
            if (this.fillHorizontal) {
                firstHorizontalValue = alignmentSWTValues[1];
            }
            if (this.fillVertical) {
                firstVerticalValue = alignmentSWTValues[1];
            }
            i = 0;
            while (i < this.alignmentActions.length) {
                if (alignmentSWTValues[i % 3] == firstHorizontalValue && alignmentSWTValues[i / 3] == firstVerticalValue) {
                    this.alignmentActions[i].setChecked(true);
                    this.selectedAlignmentAction = this.alignmentActions[i];
                } else {
                    this.alignmentActions[i].setChecked(false);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.alignmentActions.length) {
                this.alignmentActions[i].setChecked(false);
                ++i;
            }
        }
    }

    protected void handleSelectionChangedForGrabActions(List editparts) {
        boolean setChecked = true;
        boolean firstGrabHorizValue = this.getGrabValue((EditPart)editparts.get(0), 0);
        int i = 1;
        while (i < editparts.size()) {
            if (firstGrabHorizValue != this.getGrabValue((EditPart)editparts.get(i), 0)) {
                setChecked = false;
                break;
            }
            ++i;
        }
        if (setChecked) {
            this.grabActions[0].setChecked(firstGrabHorizValue);
        } else {
            this.grabActions[0].setChecked(false);
        }
        setChecked = true;
        boolean firstGrabVerticalValue = this.getGrabValue((EditPart)editparts.get(0), 1);
        int i2 = 1;
        while (i2 < editparts.size()) {
            if (firstGrabVerticalValue != this.getGrabValue((EditPart)editparts.get(i2), 1)) {
                setChecked = false;
                break;
            }
            ++i2;
        }
        if (setChecked) {
            this.grabActions[1].setChecked(firstGrabVerticalValue);
        } else {
            this.grabActions[1].setChecked(false);
        }
    }

    protected void handleSelectionChangedForSpinners(List editparts) {
        int i = 0;
        while (i < editparts.size()) {
            EditPart ep = (EditPart)editparts.get(i);
            if (ep.getSelected() == 2 && ep.getModel() instanceof IJavaObjectInstance) {
                this.horizontalSpanValue = this.getSpanValue(ep, 0);
                this.verticalSpanValue = this.getSpanValue(ep, 1);
                this.heightHintValue = this.getHintValue(ep, this.sfHeightHint);
                this.widthHintValue = this.getHintValue(ep, this.sfWidthHint);
                this.horizontalIndentValue = this.getHorizontalIndentValue(ep);
                break;
            }
            ++i;
        }
        if (this.horizontalSpanSpinner != null) {
            this.horizontalSpanSpinner.setSelection(this.horizontalSpanValue);
        }
        if (this.verticalSpanSpinner != null) {
            this.verticalSpanSpinner.setSelection(this.verticalSpanValue);
        }
        if (this.heightHintSpinner != null && this.heightHintValue != 0) {
            this.heightHintSpinner.setValue(this.heightHintValue);
        }
        if (this.widthHintSpinner != null && this.widthHintValue != 0) {
            this.widthHintSpinner.setValue(this.widthHintValue);
        }
        if (this.horizontalIndentSpinner != null) {
            this.horizontalIndentSpinner.setSelection(this.horizontalIndentValue);
        }
    }

    protected boolean hasGridData(List editparts) {
        if (!editparts.isEmpty()) {
            int i = 0;
            while (i < editparts.size()) {
                EditPart editpart = (EditPart)editparts.get(i);
                EObject control = (EObject)editpart.getModel();
                if (control != null && control.eIsSet((EStructuralFeature)this.sfControlLayoutData)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected int getHorizontalAlignValue(EditPart ep) {
        Object horizPV;
        IPropertySource gridData;
        IPropertySource ps;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ps = (IPropertySource)ep.getAdapter((Class)clazz)) != null && this.getResourceSet(ep) != null && (gridData = (IPropertySource)ps.getPropertyValue((Object)this.sfControlLayoutData)) != null && (horizPV = gridData.getPropertyValue((Object)this.sfHorizontalAlignment)) != null && horizPV instanceof IJavaDataTypeInstance) {
            IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)horizPV), (ResourceSet)this.rset);
            return intProxy.intValue();
        }
        return 2;
    }

    protected int getVerticalAlignValue(EditPart ep) {
        Object vertPV;
        IPropertySource gridData;
        IPropertySource ps;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ps = (IPropertySource)ep.getAdapter((Class)clazz)) != null && this.getResourceSet(ep) != null && (gridData = (IPropertySource)ps.getPropertyValue((Object)this.sfControlLayoutData)) != null && (vertPV = gridData.getPropertyValue((Object)this.sfVerticalAlignment)) != null && vertPV instanceof IJavaDataTypeInstance) {
            IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)vertPV), (ResourceSet)this.rset);
            return intProxy.intValue();
        }
        return 2;
    }

    protected int getHorizontalIndentValue(EditPart ep) {
        Object horizPV;
        IPropertySource gridData;
        IPropertySource ps;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ps = (IPropertySource)ep.getAdapter((Class)clazz)) != null && this.getResourceSet(ep) != null && (gridData = (IPropertySource)ps.getPropertyValue((Object)this.sfControlLayoutData)) != null && (horizPV = gridData.getPropertyValue((Object)this.sfHorizontalIndent)) != null && horizPV instanceof IJavaDataTypeInstance) {
            IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)horizPV), (ResourceSet)this.rset);
            return intProxy.intValue();
        }
        return 0;
    }

    protected boolean getGrabValue(EditPart ep, int grabType) {
        Object grabPV;
        IPropertySource gridData;
        IPropertySource ps;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ps = (IPropertySource)ep.getAdapter((Class)clazz)) != null && this.getResourceSet(ep) != null && (gridData = (IPropertySource)ps.getPropertyValue((Object)this.sfControlLayoutData)) != null && (grabPV = gridData.getPropertyValue((Object)(grabType == 0 ? this.sfHorizontalGrab : this.sfVerticalGrab))) != null && grabPV instanceof IJavaDataTypeInstance) {
            IBooleanBeanProxy booleanProxy = (IBooleanBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)grabPV), (ResourceSet)this.rset);
            return booleanProxy.booleanValue();
        }
        return false;
    }

    protected int getSpanValue(EditPart ep, int orientation) {
        Object spanPV;
        IPropertySource gridData;
        IPropertySource ps;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ps = (IPropertySource)ep.getAdapter((Class)clazz)) != null && this.getResourceSet(ep) != null && (gridData = (IPropertySource)ps.getPropertyValue((Object)this.sfControlLayoutData)) != null && (spanPV = gridData.getPropertyValue((Object)(orientation == 0 ? this.sfHorizontalSpan : this.sfVerticalSpan))) != null && spanPV instanceof IJavaDataTypeInstance) {
            IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)spanPV), (ResourceSet)this.rset);
            return intProxy.intValue();
        }
        return 1;
    }

    protected int getHintValue(EditPart ep, EStructuralFeature sf) {
        Object hintPV;
        IPropertySource gridData;
        IPropertySource ps;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ps = (IPropertySource)ep.getAdapter((Class)clazz)) != null && this.getResourceSet(ep) != null && (gridData = (IPropertySource)ps.getPropertyValue((Object)this.sfControlLayoutData)) != null && (hintPV = gridData.getPropertyValue((Object)sf)) != null && hintPV instanceof IJavaDataTypeInstance) {
            IIntegerBeanProxy intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaDataTypeInstance)hintPV), (ResourceSet)this.rset);
            return intProxy.intValue();
        }
        return -1;
    }

    private void resetVariables() {
        this.rset = null;
        this.sfControlLayoutData = null;
        this.sfHorizontalAlignment = null;
        this.sfVerticalAlignment = null;
        this.sfHorizontalGrab = null;
        this.sfVerticalGrab = null;
        this.sfHorizontalSpan = null;
        this.sfVerticalSpan = null;
        this.sfHorizontalIndent = null;
        this.sfHeightHint = null;
        this.sfWidthHint = null;
    }

    protected ResourceSet getResourceSet(EditPart editpart) {
        if (this.rset == null) {
            this.rset = EMFEditDomainHelper.getResourceSet((EditDomain)EditDomain.getEditDomain((EditPart)editpart));
            this.sfControlLayoutData = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)SWTConstants.SF_CONTROL_LAYOUTDATA);
            this.sfHorizontalAlignment = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_HORIZONTAL_ALIGN);
            this.sfVerticalAlignment = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_VERTICAL_ALIGN);
            this.sfHorizontalGrab = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_HORIZONTAL_GRAB);
            this.sfVerticalGrab = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_VERTICAL_GRAB);
            this.sfHorizontalSpan = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_HORIZONTAL_SPAN);
            this.sfVerticalSpan = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_VERTICAL_SPAN);
            this.sfHorizontalIndent = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_HORIZONTAL_INDENT);
            this.sfHeightHint = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_HEIGHT_HINT);
            this.sfWidthHint = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_WIDTH_HINT);
        }
        return this.rset;
    }

    protected void handleSelectionProviderInitialization(ISelectionProvider selectionProvider) {
    }

    public boolean isValidParent(EditPart parent) {
        IActionFilter af;
        Class<?> clazz;
        if (parent instanceof TreeEditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain((EditPart)parent);
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz2)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(parent.getModel())) != null) {
                parent = ep;
            }
        }
        if ((clazz = class$3) == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (af = (IActionFilter)parent.getAdapter((Class)clazz)) != null && af.testAttribute((Object)parent, "EDITPOLICY#LAYOUTPOLICY", "org.eclipse.swt.layout.GridLayout");
    }

    public class AlignmentAction
    extends Action {
        protected int fHorizontalAlign;
        protected int fVerticalAlign;

        public AlignmentAction(int horizontalAlign, int verticalAlign) {
            super(null, 2);
            this.fHorizontalAlign = horizontalAlign < 0 || horizontalAlign >= 3 ? 1 : horizontalAlign;
            this.fVerticalAlign = verticalAlign < 0 || verticalAlign >= 3 ? 1 : verticalAlign;
            this.setText(this.getAlignmentValue(resAlignmentValueLabels, this.fHorizontalAlign, this.fVerticalAlign));
            this.setToolTipText(this.getAlignmentValue(resAlignmentValueTooltips, this.fHorizontalAlign, this.fVerticalAlign));
            String graphicName = this.getAlignmentValue(resAlignmentValueImages, this.fHorizontalAlign, this.fVerticalAlign);
            this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)("icons/full/elcl16/" + graphicName)));
            this.setHoverImageDescriptor(this.getImageDescriptor());
            this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)("icons/full/dlcl16/" + graphicName)));
            this.setId(this.getAlignmentValue(resAlignmentValueIDs, this.fHorizontalAlign, this.fVerticalAlign));
            this.setEnabled(true);
        }

        public int getHorizontalAlignment() {
            return this.fHorizontalAlign;
        }

        public int getVerticalAlignment() {
            return this.fVerticalAlign;
        }

        public String getAlignmentValue(String[] array, int horizontalAlign, int verticalAlign) {
            if (horizontalAlign < 0 || horizontalAlign > 2) {
                horizontalAlign = 1;
            }
            if (verticalAlign < 0 || verticalAlign > 2) {
                verticalAlign = 1;
            }
            return array[horizontalAlign * 3 + verticalAlign];
        }

        protected boolean calculateEnabled() {
            return true;
        }

        protected void setEditorPart(IEditorPart part) {
            GridLayoutComponentPage.this.fEditorPart = part;
        }

        public void run() {
            super.run();
            GridLayoutComponentPage.this.execute(GridLayoutComponentPage.this.createAlignmentCommand(GridLayoutComponentPage.this.getSelectedObjects(), this.fHorizontalAlign, this.fVerticalAlign));
            GridLayoutComponentPage.this.selectedAlignmentAction = this;
            int i = 0;
            while (i < GridLayoutComponentPage.this.alignmentActions.length) {
                if (GridLayoutComponentPage.this.alignmentActions[i] != this) {
                    GridLayoutComponentPage.this.alignmentActions[i].setChecked(false);
                } else if (!this.isChecked()) {
                    this.setChecked(true);
                }
                ++i;
            }
        }
    }

    public class FillAction
    extends Action {
        protected int fOrientation;
        protected int previousValue = 1;

        public FillAction(int orientation) {
            super(null, 2);
            this.fOrientation = orientation < 0 || orientation >= resFillLabels.length ? 0 : orientation;
            this.setText(resFillLabels[orientation]);
            this.setToolTipText(resFillTooltips[orientation]);
            String graphicName = resFillImages[orientation];
            this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)("icons/full/elcl16/" + graphicName)));
            this.setHoverImageDescriptor(this.getImageDescriptor());
            this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)("icons/full/dlcl16/" + graphicName)));
            this.setId(resFillIDs[orientation]);
            this.setEnabled(true);
        }

        public String getActionId(int orientation) {
            return orientation >= 0 && orientation < resFillIDs.length ? resFillIDs[orientation] : resFillIDs[0];
        }

        protected boolean calculateEnabled() {
            return true;
        }

        protected void setEditorPart(IEditorPart part) {
            GridLayoutComponentPage.this.fEditorPart = part;
        }

        protected void updateAlignmentEnablement() {
            int i = 0;
            while (i < GridLayoutComponentPage.this.alignmentActions.length) {
                AlignmentAction c = GridLayoutComponentPage.this.alignmentActions[i];
                c.setEnabled(!(GridLayoutComponentPage.this.fillHorizontal && c.getHorizontalAlignment() != 1 || GridLayoutComponentPage.this.fillVertical && c.getVerticalAlignment() != 1));
                ++i;
            }
        }

        public void run() {
            super.run();
            int newValue = -1;
            if (this.fOrientation == 0) {
                GridLayoutComponentPage.this.fillHorizontal = this.isChecked();
            } else {
                GridLayoutComponentPage.this.fillVertical = this.isChecked();
            }
            this.updateAlignmentEnablement();
            if (this.isChecked()) {
                if (GridLayoutComponentPage.this.selectedAlignmentAction != null) {
                    AlignmentAction newSelection;
                    if (this.fOrientation == 0) {
                        this.previousValue = GridLayoutComponentPage.this.selectedAlignmentAction.getHorizontalAlignment();
                        newValue = GridLayoutComponentPage.this.selectedAlignmentAction.getVerticalAlignment();
                        newSelection = GridLayoutComponentPage.this.alignmentActions[3 * newValue + 1];
                    } else {
                        this.previousValue = GridLayoutComponentPage.this.selectedAlignmentAction.getVerticalAlignment();
                        newValue = GridLayoutComponentPage.this.selectedAlignmentAction.getHorizontalAlignment();
                        newSelection = GridLayoutComponentPage.this.alignmentActions[3 + newValue];
                    }
                    if (this.previousValue != 1) {
                        if (newSelection.isEnabled()) {
                            newSelection.setChecked(true);
                            newSelection.run();
                        }
                    } else {
                        GridLayoutComponentPage.this.selectedAlignmentAction.run();
                    }
                }
            } else {
                if (GridLayoutComponentPage.this.selectedAlignmentAction != null) {
                    if (this.previousValue != 1) {
                        AlignmentAction newSelection;
                        if (this.fOrientation == 0) {
                            newValue = GridLayoutComponentPage.this.selectedAlignmentAction.getVerticalAlignment();
                            newSelection = GridLayoutComponentPage.this.alignmentActions[3 * newValue + this.previousValue];
                        } else {
                            newValue = GridLayoutComponentPage.this.selectedAlignmentAction.getHorizontalAlignment();
                            newSelection = GridLayoutComponentPage.this.alignmentActions[3 * this.previousValue + newValue];
                        }
                        if (newSelection.isEnabled()) {
                            newSelection.setChecked(true);
                            newSelection.run();
                        }
                    } else {
                        GridLayoutComponentPage.this.selectedAlignmentAction.run();
                    }
                }
                this.previousValue = 1;
            }
        }
    }

    public class GrabAction
    extends Action {
        protected int fGrabType;

        public GrabAction(int grabType) {
            super(null, 2);
            this.fGrabType = grabType < 0 || grabType >= resGrabLabels.length ? 0 : grabType;
            this.setText(resGrabLabels[this.fGrabType]);
            this.setToolTipText(resGrabTooltips[this.fGrabType]);
            String graphicName = resGrabImages[this.fGrabType];
            this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)("icons/full/elcl16/" + graphicName)));
            this.setHoverImageDescriptor(this.getImageDescriptor());
            this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)("icons/full/dlcl16/" + graphicName)));
            this.setEnabled(true);
            this.setId(this.getActionId(this.fGrabType));
        }

        public String getActionId(int grabType) {
            return grabType >= 0 && grabType < resGrabIDs.length ? resGrabIDs[grabType] : resGrabIDs[0];
        }

        protected boolean calculateEnabled() {
            return true;
        }

        protected void setEditorPart(IEditorPart part) {
            GridLayoutComponentPage.this.fEditorPart = part;
        }

        public void run() {
            super.run();
            GridLayoutComponentPage.this.execute(GridLayoutComponentPage.this.createGrabCommand(GridLayoutComponentPage.this.getSelectedObjects(), this.fGrabType, GridLayoutComponentPage.this.grabActions[this.fGrabType].isChecked()));
        }
    }
}

