/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ForwardedRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.commands.NoOpCommand;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.CustomizeLayoutWindowAction;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.GridController;
import org.eclipse.ve.internal.cde.core.IGridListener;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;
import org.eclipse.ve.internal.cde.core.VisualComponentAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.ControlProxyAdapter;
import org.eclipse.ve.internal.swt.GridLayoutFeedbackFigure;
import org.eclipse.ve.internal.swt.GridLayoutGridFigure;
import org.eclipse.ve.internal.swt.GridLayoutPolicyHelper;
import org.eclipse.ve.internal.swt.GridLayoutSpanFeedbackFigure;
import org.eclipse.ve.internal.swt.GridSpanHandle;
import org.eclipse.ve.internal.swt.NonResizableSpannableEditPolicy;

public class GridLayoutEditPolicy
extends ConstrainedLayoutEditPolicy
implements IGridListener,
IActionFilter {
    public static final String LAYOUT_ID = "org.eclipse.swt.layout.GridLayout";
    public static final String REQ_GRIDLAYOUT_SPAN = "GridLayout span cells";
    boolean fShowGrid = false;
    GridLayoutPolicyHelper helper = new GridLayoutPolicyHelper();
    int[][] layoutDimensions = null;
    private GridLayoutGridFigure fGridLayoutGridFigure;
    private GridLayoutSpanFeedbackFigure fGridLayoutSpanFigure;
    private GridLayoutFeedbackFigure fGridLayoutCellFigure;
    private GridLayoutRowFigure fRowFigure = null;
    private GridLayoutColumnFigure fColumnFigure = null;
    private GridController gridController;
    private IVisualComponentListener fGridComponentListener;
    private ContainerPolicy containerPolicy;
    protected FigureListener hostFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            GridLayoutEditPolicy.this.helper.refresh();
            GridLayoutEditPolicy.this.refreshGridFigure();
        }
    };
    private EditPartListener editPartListener;
    static final int INSERT_COLUMN = 0;
    static final int INSERT_COLUMN_WITHIN_ROW = 1;
    static final int INSERT_ROW = 2;
    static final int ADD_COLUMN = 3;
    static final int ADD_ROW = 4;
    static final int REPLACE_FILLER = 5;
    static final int ADD = 6;
    static final int ADD_TO_EMPTY_CELL = 7;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected IVisualComponentListener getGridComponentListener() {
        if (this.fGridComponentListener == null) {
            this.fGridComponentListener = new GridComponentListener();
        }
        return this.fGridComponentListener;
    }

    public GridLayoutEditPolicy(VisualContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        this.helper.setContainerPolicy(containerPolicy);
    }

    public void setHost(EditPart host) {
        super.setHost(host);
        this.helper.setEditDomain(EditDomain.getEditDomain((EditPart)this.getHost()));
    }

    public void activate() {
        this.gridController = new GridController();
        if (this.gridController != null) {
            this.gridController.addGridListener((IGridListener)this);
            GridController.registerEditPart((EditPart)this.getHost(), (GridController)this.gridController);
            ControlProxyAdapter beanProxy = (ControlProxyAdapter)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getHost().getModel()));
            if (beanProxy != null) {
                beanProxy.addComponentListener(this.getGridComponentListener());
            }
            this.getHostFigure().addFigureListener(this.hostFigureListener);
            if (CDEPlugin.getPlugin().getPluginPreferences().getBoolean("SHOW_GRID_WHEN_SELECTED") && (this.getHost().getSelected() == 1 || this.getHost().getSelected() == 2)) {
                this.gridController.setGridShowing(true);
            }
            this.editPartListener = this.createEditPartListener();
            this.getHost().addEditPartListener(this.editPartListener);
            List children = this.getHost().getChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                ((EditPart)iterator.next()).addEditPartListener(this.editPartListener);
            }
        }
        this.containerPolicy.setContainer(this.getHost().getModel());
        super.activate();
        EditPartViewer editPartViewer = this.getHost().getViewer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.swt.GridLayoutLayoutPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CustomizeLayoutWindowAction.addLayoutCustomizationPage((EditPartViewer)editPartViewer, (Class)clazz);
        EditPartViewer editPartViewer2 = this.getHost().getViewer();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ve.internal.swt.GridLayoutComponentPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CustomizeLayoutWindowAction.addComponentCustomizationPage((EditPartViewer)editPartViewer2, (Class)clazz2);
    }

    public void deactivate() {
        ControlProxyAdapter beanProxy;
        this.containerPolicy.setContainer(null);
        GridController gridController = GridController.getGridController((EditPart)this.getHost());
        this.eraseGridFigure();
        if (gridController != null) {
            gridController.removeGridListener((IGridListener)this);
            GridController.unregisterEditPart((EditPart)this.getHost());
        }
        if ((beanProxy = (ControlProxyAdapter)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getHost().getModel()))) != null) {
            beanProxy.removeComponentListener(this.getGridComponentListener());
        }
        this.getHostFigure().removeFigureListener(this.hostFigureListener);
        if (this.editPartListener != null) {
            this.getHost().removeEditPartListener(this.editPartListener);
            List children = this.getHost().getChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                ((EditPart)iterator.next()).removeEditPartListener(this.editPartListener);
            }
            this.editPartListener = null;
        }
        super.deactivate();
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NonResizableSpannableEditPolicy(this);
    }

    public Command getCommand(Request request) {
        if (REQ_GRIDLAYOUT_SPAN.equals(request.getType())) {
            return this.getSpanChildrenCommand(request);
        }
        return super.getCommand(request);
    }

    protected Command getSpanChildrenCommand(Request generic) {
        Point childCellLocation;
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        if (editParts.isEmpty() || editParts.size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Point spanToPosition = this.getLocationFromRequest((Request)request).getCopy();
        this.getHostFigure().translateToRelative((Translatable)spanToPosition);
        Point spanToCellLocation = this.getGridLayoutGridFigure().getCellLocation(spanToPosition.x, spanToPosition.y);
        Dimension dim = request.getSizeDelta();
        int handleSizeOffset = GridSpanHandle.HANDLE_SIZE / 2;
        Point startPosition = new Point(spanToPosition.x - dim.width - handleSizeOffset, spanToPosition.y - dim.height - handleSizeOffset);
        GraphicalEditPart ep = (GraphicalEditPart)editParts.get(0);
        if (this.helper.getChildrenDimensions() != null) {
            childCellLocation = this.helper.getChildrenDimensions()[this.getHost().getChildren().indexOf(ep)].getLocation();
        } else {
            Point childPosition = ep.getContentPane().getBounds().getLocation();
            childCellLocation = this.getGridLayoutGridFigure().getCellLocation(childPosition.x, childPosition.y);
        }
        Point startCellLocation = this.getGridLayoutGridFigure().getCellLocation(startPosition.x, startPosition.y);
        if (spanToCellLocation.x >= childCellLocation.x && spanToCellLocation.y >= childCellLocation.y && (spanToCellLocation.x != startCellLocation.x || spanToCellLocation.y != startCellLocation.y)) {
            return this.helper.getSpanChildrenCommand((EditPart)editParts.get(0), childCellLocation, spanToCellLocation, request.getResizeDirection());
        }
        return NoOpCommand.INSTANCE;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.startsWith("showgrid") && value.equals("false") && !this.fShowGrid) {
            return true;
        }
        if (name.startsWith("showgrid") && value.equals("true") && this.fShowGrid) {
            return true;
        }
        if (name.startsWith("customizelayout") && value.equals("true")) {
            return true;
        }
        return name.startsWith("LAYOUTPOLICY") && value.equals(LAYOUT_ID);
    }

    protected GridLayoutGridFigure getGridLayoutGridFigure() {
        if (this.fGridLayoutGridFigure == null) {
            IFigure f = ((GraphicalEditPart)this.getHost()).getContentPane();
            int[][] layoutDimensions = null;
            EObject[][] cellContents = null;
            Rectangle layoutSpacing = null;
            Rectangle clientArea = this.helper.getContainerClientArea();
            if (this.helper.getContainer() != null && !this.getHost().getChildren().isEmpty()) {
                layoutDimensions = this.helper.getContainerLayoutDimensions();
                layoutSpacing = this.helper.getContainerLayoutSpacing();
                cellContents = this.helper.getLayoutTable();
            }
            this.fGridLayoutGridFigure = new GridLayoutGridFigure(f.getBounds().getCopy(), layoutDimensions, cellContents, layoutSpacing, clientArea);
        }
        return this.fGridLayoutGridFigure;
    }

    protected void eraseGridFigure() {
        if (this.fGridLayoutGridFigure != null) {
            this.removeFeedback((IFigure)this.fGridLayoutGridFigure);
            this.fGridLayoutGridFigure = null;
        }
        this.fShowGrid = false;
    }

    public void eraseTargetFeedback(Request request) {
        if (!this.fShowGrid && this.fGridLayoutGridFigure != null && this.fGridLayoutGridFigure.getParent() != null) {
            this.removeFeedback((IFigure)this.fGridLayoutGridFigure);
            this.fGridLayoutGridFigure = null;
        }
        if (this.fGridLayoutSpanFigure != null) {
            this.removeFeedback((IFigure)this.fGridLayoutSpanFigure);
            this.fGridLayoutSpanFigure = null;
        }
        if (this.fGridLayoutCellFigure != null) {
            this.removeFeedback((IFigure)this.fGridLayoutCellFigure);
            this.fGridLayoutCellFigure = null;
        }
        if (this.fRowFigure != null) {
            this.removeFeedback((IFigure)this.fRowFigure);
            this.fRowFigure = null;
        }
        if (this.fColumnFigure != null) {
            this.removeFeedback((IFigure)this.fColumnFigure);
            this.fColumnFigure = null;
        }
        super.eraseTargetFeedback(request);
    }

    protected void showGridFigure() {
        if (!this.fShowGrid) {
            this.fShowGrid = true;
            this.addFeedback((IFigure)this.getGridLayoutGridFigure());
        }
        this.fShowGrid = true;
    }

    public void showSpanTargetFeedback(ChangeBoundsRequest request) {
        if (!this.fShowGrid) {
            this.addFeedback((IFigure)this.getGridLayoutGridFigure());
        }
        Point spanToPosition = request.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)spanToPosition);
        GraphicalEditPart ep = (GraphicalEditPart)request.getEditParts().get(0);
        Point childPosition = ep.getContentPane().getBounds().getLocation();
        Rectangle startCellBounds = this.getGridLayoutGridFigure().getCellBounds(childPosition.x, childPosition.y);
        if (request.getResizeDirection() == 16) {
            spanToPosition.y = childPosition.y;
        } else {
            spanToPosition.x = childPosition.x;
        }
        Rectangle endCellBounds = this.getGridLayoutGridFigure().getCellBounds(spanToPosition.x, spanToPosition.y);
        Rectangle spanrect = new Rectangle(startCellBounds.x, startCellBounds.y, endCellBounds.x + endCellBounds.width - startCellBounds.x, endCellBounds.y + endCellBounds.height - startCellBounds.y);
        if (this.fGridLayoutSpanFigure == null) {
            this.fGridLayoutSpanFigure = new GridLayoutSpanFeedbackFigure(request.getResizeDirection());
        }
        this.fGridLayoutSpanFigure.setLayoutFigureBounds(spanrect);
        this.addFeedback((IFigure)this.fGridLayoutSpanFigure);
    }

    protected void refreshGridFigure() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (GridLayoutEditPolicy.this.fShowGrid) {
                    GridLayoutEditPolicy.this.eraseGridFigure();
                    GridLayoutEditPolicy.this.showGridFigure();
                } else {
                    GridLayoutEditPolicy.this.fGridLayoutGridFigure = null;
                }
            }
        });
    }

    public void gridVisibilityChanged(boolean showGrid) {
        if (showGrid) {
            this.showGridFigure();
        } else {
            this.eraseGridFigure();
        }
    }

    public void gridHeightChanged(int gridHeight, int oldGridHeight) {
    }

    public void gridWidthChanged(int gridWidth, int oldGridWidth) {
    }

    public void gridMarginChanged(int gridMargin, int oldGridMargin) {
    }

    private Point getLocationFromRequest(Request request) {
        return ((DropRequest)request).getLocation();
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (!this.fShowGrid) {
            this.addFeedback((IFigure)this.getGridLayoutGridFigure());
        }
        if (this.fRowFigure != null) {
            this.removeFeedback((IFigure)this.fRowFigure);
            this.fRowFigure = null;
        }
        if (this.fColumnFigure != null) {
            this.removeFeedback((IFigure)this.fColumnFigure);
            this.fColumnFigure = null;
        }
        Point position = this.getLocationFromRequest(request).getCopy();
        this.getHostFigure().translateToRelative((Translatable)position);
        GridLayoutRequest gridReq = this.createGridLayoutRequest(position);
        Rectangle cellBounds = this.getGridLayoutGridFigure().getCellBounds(position.x, position.y);
        if (gridReq.type == 0) {
            this.showNewColumnFeedBack(position);
            Rectangle colFigBounds = this.fColumnFigure.getBounds().getCopy();
            cellBounds.width = 40;
            cellBounds.x = colFigBounds.x + colFigBounds.width / 2 - cellBounds.width / 2;
        } else if (gridReq.type == 2) {
            this.showNewRowFeedBack(position);
            Rectangle rowFigBounds = this.fRowFigure.getBounds().getCopy();
            cellBounds.height = 35;
            cellBounds.y = rowFigBounds.y + rowFigBounds.height / 2 - cellBounds.height / 2;
        } else if (gridReq.type == 1) {
            this.showColumnFeedBackWithinARow(cellBounds);
            Rectangle colFigBounds = this.fColumnFigure.getBounds().getCopy();
            cellBounds.width = 40;
            cellBounds.x = colFigBounds.x + colFigBounds.width / 2 - cellBounds.width / 2;
        } else if (gridReq.type == 6 || gridReq.type == 3 || gridReq.type == 4) {
            cellBounds.setLocation(position.x - 6, position.y - 6);
            cellBounds.width = 40;
            cellBounds.height = 35;
        }
        if (this.fGridLayoutCellFigure == null) {
            this.fGridLayoutCellFigure = new GridLayoutFeedbackFigure();
        }
        this.fGridLayoutCellFigure.setBounds(cellBounds);
        this.addFeedback((IFigure)this.fGridLayoutCellFigure);
    }

    private EditPartListener createEditPartListener() {
        return new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart editpart) {
                if (CDEPlugin.getPlugin().getPluginPreferences().getBoolean("SHOW_GRID_WHEN_SELECTED")) {
                    if (!(editpart != null && editpart != GridLayoutEditPolicy.this.getHost() && !GridLayoutEditPolicy.this.isChildEditPart(editpart) || editpart.getSelected() != 1 && editpart.getSelected() != 2)) {
                        if (GridLayoutEditPolicy.this.gridController != null) {
                            GridLayoutEditPolicy.this.gridController.setGridShowing(true);
                        }
                    } else if (GridLayoutEditPolicy.this.gridController != null) {
                        GridLayoutEditPolicy.this.gridController.setGridShowing(false);
                    }
                } else if (GridLayoutEditPolicy.this.gridController != null && GridLayoutEditPolicy.this.gridController.isGridShowing()) {
                    GridLayoutEditPolicy.this.gridController.setGridShowing(false);
                }
            }

            public void childAdded(EditPart editpart, int index) {
                if (GridLayoutEditPolicy.this.editPartListener != null) {
                    editpart.addEditPartListener(GridLayoutEditPolicy.this.editPartListener);
                }
            }

            public void removingChild(EditPart editpart, int index) {
                if (GridLayoutEditPolicy.this.editPartListener != null) {
                    editpart.removeEditPartListener(GridLayoutEditPolicy.this.editPartListener);
                }
            }
        };
    }

    private boolean isChildEditPart(EditPart ep) {
        List children;
        if (ep != null && !(children = this.getHost().getChildren()).isEmpty()) {
            return children.indexOf(ep) != -1;
        }
        return false;
    }

    protected Command getDeleteDependantCommand(Request aRequest) {
        Command cmd = this.containerPolicy.getCommand(aRequest);
        if (cmd != null && aRequest instanceof ForwardedRequest) {
            EditPart editPart = ((ForwardedRequest)aRequest).getSender();
            CommandBuilder cb = new CommandBuilder();
            cb.append(this.helper.getFillerLabelsForDeletedControlCommands((EObject)editPart.getModel()));
            cb.append(cmd);
            return cb.getCommand();
        }
        return cmd != null ? cmd : UnexecutableCommand.INSTANCE;
    }

    protected void showNewRowFeedBack(Point position) {
        Point rowStart = this.fGridLayoutGridFigure.getRowStartPosition(position.y);
        Point rowEnd = this.fGridLayoutGridFigure.getRowEndPosition(position.y);
        Rectangle rect = new Rectangle(rowStart.x - 2, rowStart.y - 3, rowEnd.x - rowStart.x + 4, 6);
        this.fRowFigure = new GridLayoutRowFigure(rect);
        this.addFeedback((IFigure)this.fRowFigure);
    }

    protected void showNewColumnFeedBack(Point position) {
        Point colStart = this.fGridLayoutGridFigure.getColumnStartPosition(position.x);
        Point colEnd = this.fGridLayoutGridFigure.getColumnEndPosition(position.x);
        Rectangle rect = new Rectangle(colStart.x - 3, colStart.y, 6, colEnd.y - colStart.y);
        this.fColumnFigure = new GridLayoutColumnFigure(rect);
        this.addFeedback((IFigure)this.fColumnFigure);
    }

    protected void showColumnFeedBackWithinARow(Rectangle cellBounds) {
        Point colStart = cellBounds.getLocation();
        Point colEnd = new Point(cellBounds.x, cellBounds.y + cellBounds.height);
        Rectangle rect = new Rectangle(colStart.x - 3, colStart.y, 6, colEnd.y - colStart.y);
        this.fColumnFigure = new GridLayoutColumnFigure(rect);
        this.addFeedback((IFigure)this.fColumnFigure);
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Object getConstraintFor(Point point) {
        return null;
    }

    protected Object getConstraintFor(Rectangle rect) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (this.fGridLayoutGridFigure == null) {
            return UnexecutableCommand.INSTANCE;
        }
        List children = this.getHost().getChildren();
        if (children.isEmpty()) {
            return this.containerPolicy.getCreateCommand(request.getNewObject(), null);
        }
        Point position = this.getLocationFromRequest((Request)request).getCopy();
        this.getHostFigure().translateToRelative((Translatable)position);
        GridLayoutRequest gridReq = this.createGridLayoutRequest(position);
        Object editPart = null;
        Point cell = new Point(gridReq.column, gridReq.row);
        int epIndex = this.helper.getChildIndexAtCell(cell);
        if (epIndex != -1) {
            editPart = (GraphicalEditPart)children.get(epIndex);
        }
        CommandBuilder cb = new CommandBuilder();
        if (gridReq.type == 5) {
            cb.append(this.containerPolicy.getCreateCommand(request.getNewObject(), editPart.getModel()));
            cb.append(this.containerPolicy.getDeleteDependentCommand(editPart.getModel()));
        } else if (gridReq.type == 1) {
            cb.append(this.helper.createNumColumnsCommand(this.helper.getNumColumns() + 1));
            cb.append(this.helper.createInsertColumnWithinRowCommands(cell.x, cell.y, request.getNewObject(), (Request)request));
        } else if (gridReq.type == 0 || gridReq.type == 3) {
            boolean isLastColumn = false;
            int column = this.getGridLayoutGridFigure().getNearestColumn(position.x);
            if (column != this.helper.getNumColumns()) {
                epIndex = this.helper.getChildIndexAtCell(new Point(column, cell.y));
                if (epIndex != -1) {
                    editPart = (GraphicalEditPart)children.get(epIndex);
                }
            } else {
                epIndex = this.helper.getChildIndexAtCell(new Point(0, cell.y + 1));
                editPart = epIndex != -1 && epIndex < children.size() ? (GraphicalEditPart)children.get(epIndex) : null;
                column = 0;
                ++cell.y;
                isLastColumn = true;
            }
            cb.append(this.helper.createNumColumnsCommand(this.helper.getNumColumns() + 1));
            cb.append(this.helper.createInsertColumnCommands(request.getNewObject(), (Request)request, column, cell.y, isLastColumn));
        } else if (gridReq.type == 2 || gridReq.type == 4) {
            int row = this.getGridLayoutGridFigure().getNearestRow(position.y);
            cb.append(this.helper.createFillerLabelsForNewRowCommand(request.getNewObject(), row, cell.x, (Request)request));
        } else if (gridReq.type == 7) {
            cb.append(this.helper.createAddToEmptyCellCommand(request.getNewObject(), cell, (Request)request));
        }
        if (cb.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return cb.getCommand();
    }

    private GridLayoutRequest createGridLayoutRequest(Point position) {
        Point cell = this.getGridLayoutGridFigure().getCellLocation(position);
        GridLayoutRequest gridReq = new GridLayoutRequest();
        gridReq.column = cell.x;
        gridReq.row = cell.y;
        if (cell.x == -1 && cell.y == -1) {
            gridReq.type = 6;
        } else if (cell.x == -1) {
            gridReq.type = 3;
        } else if (cell.y == -1) {
            gridReq.type = 4;
        } else if (this.fGridLayoutGridFigure.isPointerNearAColumn(position.x)) {
            gridReq.type = 0;
        } else if (this.fGridLayoutGridFigure.isPointerNearARow(position.y)) {
            gridReq.type = 2;
        } else {
            EditPart editPart = null;
            Point cellLocation = new Point(cell.x, cell.y);
            int indexBeforeEP = this.helper.getChildIndexAtCell(cellLocation);
            if (indexBeforeEP != -1) {
                editPart = (EditPart)this.getHost().getChildren().get(indexBeforeEP);
                if (editPart != null) {
                    gridReq.type = this.helper.isFillerLabelAtCell(cellLocation) ? 5 : 1;
                }
            } else {
                gridReq.type = 7;
            }
        }
        return gridReq;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        Command cmd = this.containerPolicy.getCommand(request);
        if (cmd != null && request instanceof GroupRequest) {
            List editparts = ((GroupRequest)request).getEditParts();
            if (editparts.size() > 1) {
                return UnexecutableCommand.INSTANCE;
            }
            EditPart editPart = (EditPart)editparts.iterator().next();
            CommandBuilder cb = new CommandBuilder();
            cb.append(this.helper.getFillerLabelsForDeletedControlCommands((EObject)editPart.getModel()));
            cb.append(cmd);
            return cb.getCommand();
        }
        return cmd != null ? cmd : UnexecutableCommand.INSTANCE;
    }

    protected Command getAddCommand(Request request) {
        return this.getMoveChildrenCommand(request);
    }

    protected Command getMoveChildrenCommand(Request request) {
        List children = this.getHost().getChildren();
        if (this.fGridLayoutGridFigure == null || !(request instanceof ChangeBoundsRequest)) {
            return UnexecutableCommand.INSTANCE;
        }
        ChangeBoundsRequest req = (ChangeBoundsRequest)request;
        List editparts = req.getEditParts();
        if (editparts.size() > 1) {
            return null;
        }
        Point position = req.getLocation();
        this.getHostFigure().translateToRelative((Translatable)position);
        GridLayoutRequest gridReq = this.createGridLayoutRequest(position);
        Point cell = new Point(gridReq.column, gridReq.row);
        int numColumns = this.helper.getNumColumns();
        EditPart childEP = (EditPart)editparts.iterator().next();
        Object beforeEP = null;
        int childIndex = children.indexOf(childEP);
        int epIndex = this.helper.getChildIndexAtCell(cell);
        if (epIndex != -1) {
            beforeEP = (EditPart)children.get(epIndex);
        }
        CommandBuilder cb = new CommandBuilder();
        if (childEP == beforeEP) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject child = (EObject)childEP.getModel();
        if (childIndex == -1 && children.isEmpty()) {
            return this.containerPolicy.getAddCommand(Collections.singletonList(child), null);
        }
        if (childIndex == -1 && !BeanSWTUtilities.isValidBeanLocation(this.containerPolicy.getEditDomain(), (EObject)((IJavaObjectInstance)child), (EObject)this.containerPolicy.getContainer())) {
            return UnexecutableCommand.INSTANCE;
        }
        if (gridReq.type == 5) {
            cb.append(this.containerPolicy.getMoveChildrenCommand(Collections.singletonList(child), beforeEP.getModel()));
            cb.append(this.containerPolicy.getDeleteDependentCommand(beforeEP.getModel()));
        } else if (gridReq.type == 1) {
            cb.append(this.helper.createNumColumnsCommand(++numColumns));
            cb.append(this.helper.createInsertColumnWithinRowCommands(cell.x, cell.y, child, request));
        } else if (gridReq.type == 0 || gridReq.type == 3) {
            boolean isLastColumn = false;
            int column = this.getGridLayoutGridFigure().getNearestColumn(position.x);
            if (column != this.helper.getNumColumns()) {
                epIndex = this.helper.getChildIndexAtCell(new Point(column, cell.y));
                if (epIndex != -1) {
                    beforeEP = (GraphicalEditPart)children.get(epIndex);
                }
            } else {
                epIndex = this.helper.getChildIndexAtCell(new Point(0, cell.y + 1));
                beforeEP = epIndex != -1 && epIndex < children.size() ? (GraphicalEditPart)children.get(epIndex) : null;
                column = 0;
                ++cell.y;
                isLastColumn = true;
            }
            cb.append(this.helper.createNumColumnsCommand(++numColumns));
            cb.append(this.helper.createInsertColumnCommands(child, request, column, cell.y, isLastColumn));
        } else if (gridReq.type == 2 || gridReq.type == 4) {
            int row = this.getGridLayoutGridFigure().getNearestRow(position.y);
            cb.append(this.helper.createFillerLabelsForNewRowCommand(child, row, cell.x, request));
        } else if (gridReq.type == 7) {
            cb.append(this.helper.createAddToEmptyCellCommand(child, cell, request));
        }
        if (childIndex != -1) {
            Rectangle rect = this.helper.getChildrenDimensions()[childIndex];
            if (rect.width != this.helper.getDefaultHorizontalSpan()) {
                cb.append(this.helper.createHorizontalSpanDefaultCommand(child));
            }
            if (rect.height != this.helper.getDefaultVerticalSpan()) {
                cb.append(this.helper.createVerticalSpanDefaultCommand(child));
            }
            Command rowCmds = null;
            Command columnCmds = null;
            if (rect.y != cell.y && (rowCmds = this.helper.createRemoveRowCommand(rect.y, child)) != null) {
                cb.append(rowCmds);
            }
            if (rect.x != cell.x && (columnCmds = this.helper.createRemoveColumnCommand(rect.x, child, this.helper.getNumColumns())) != null) {
                cb.append(columnCmds);
            }
            if (rowCmds == null && columnCmds == null) {
                if (beforeEP != null) {
                    cb.append(this.helper.createFillerLabelsForMovedControlCommands(child, (EObject)beforeEP.getModel()));
                } else {
                    cb.append(this.containerPolicy.getCreateCommand((Object)this.helper.createFillerLabelObject(), null));
                }
            }
        }
        if (cb.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return cb.getCommand();
    }

    public Rectangle getFullCellBounds(EditPart child) {
        Rectangle bounds = new Rectangle();
        List children = this.getHost().getChildren();
        if (children.isEmpty() || this.fGridLayoutGridFigure == null) {
            return bounds;
        }
        int childIndex = children.indexOf(child);
        if (childIndex != -1) {
            Rectangle[] dims = this.helper.getChildrenDimensions();
            bounds = childIndex < dims.length ? this.getGridLayoutGridFigure().getGridBroundsForCellBounds(dims[childIndex]) : new Rectangle();
        }
        return bounds;
    }

    private class GridComponentListener
    extends VisualComponentAdapter {
        GridComponentListener() {
        }

        public void componentValidated() {
            GridLayoutEditPolicy.this.helper.refresh();
            GridLayoutEditPolicy.this.refreshGridFigure();
        }
    }

    class GridLayoutRowFigure
    extends Figure {
        Rectangle rowBounds;

        public GridLayoutRowFigure(Rectangle rowBounds) {
            this.rowBounds = rowBounds;
            this.bounds = rowBounds.getCopy();
            this.bounds.expand(8, 6);
        }

        public void paintFigure(Graphics g) {
            try {
                g.setAlpha(150);
            }
            catch (SWTException sWTException) {}
            int[] polygonPoints = new int[]{this.bounds.x + 1, this.bounds.y + 1, this.bounds.x + 1, this.bounds.y + this.bounds.height - 1, this.rowBounds.x, this.rowBounds.y + this.rowBounds.height, this.rowBounds.x + this.rowBounds.width, this.rowBounds.y + this.rowBounds.height, this.bounds.x + this.bounds.width - 1, this.bounds.y + this.bounds.height - 1, this.bounds.x + this.bounds.width - 1, this.bounds.y + 1, this.rowBounds.x + this.rowBounds.width, this.rowBounds.y, this.rowBounds.x, this.rowBounds.y, this.bounds.x + 1, this.bounds.y + 1};
            g.setBackgroundColor(ColorConstants.yellow);
            g.fillPolygon(polygonPoints);
            g.setBackgroundColor(ColorConstants.black);
            g.drawPolygon(polygonPoints);
        }
    }

    class GridLayoutColumnFigure
    extends Figure {
        Rectangle columnBounds;

        public GridLayoutColumnFigure(Rectangle columnBounds) {
            this.columnBounds = columnBounds;
            this.bounds = columnBounds.getCopy();
            this.bounds.expand(6, 8);
        }

        public void paintFigure(Graphics g) {
            try {
                g.setAlpha(150);
            }
            catch (SWTException sWTException) {}
            int[] polygonPoints = new int[]{this.bounds.x + 1, this.bounds.y + 1, this.columnBounds.x, this.columnBounds.y, this.columnBounds.x, this.columnBounds.y + this.columnBounds.height, this.bounds.x + 1, this.bounds.y + this.bounds.height - 1, this.bounds.x + this.bounds.width - 1, this.bounds.y + this.bounds.height - 1, this.columnBounds.x + this.columnBounds.width, this.columnBounds.y + this.columnBounds.height, this.columnBounds.x + this.columnBounds.width, this.columnBounds.y, this.bounds.x + this.bounds.width - 1, this.bounds.y + 1, this.bounds.x + 1, this.bounds.y + 1};
            g.setBackgroundColor(ColorConstants.yellow);
            g.fillPolygon(polygonPoints);
            g.setBackgroundColor(ColorConstants.black);
            g.drawPolygon(polygonPoints);
        }
    }

    class GridLayoutRequest {
        int type = 6;
        int column = 0;
        int row = 0;

        GridLayoutRequest() {
        }
    }
}

