/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.FeatureValueProvider;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.swt.DisplayManager;
import org.eclipse.jem.internal.proxy.swt.IStandardSWTBeanProxyFactory;
import org.eclipse.jem.internal.proxy.swt.JavaStandardSWTBeanConstants;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.swt.layout.GridData;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.LayoutPolicyHelper;
import org.eclipse.ve.internal.swt.SWTConstants;

public class GridLayoutPolicyHelper
extends LayoutPolicyHelper
implements IActionFilter {
    protected ResourceSet rset;
    protected EReference sfLayoutData;
    protected EReference sfCompositeControls;
    protected EStructuralFeature sfHorizontalSpan;
    protected EStructuralFeature sfVerticalSpan;
    protected EStructuralFeature sfNumColumns;
    protected EStructuralFeature sfCompositeLayout;
    protected EStructuralFeature sfLabelText;
    protected int defaultHorizontalSpan;
    protected int defaultVerticalSpan;
    protected EObject[][] layoutTable = null;
    protected Rectangle[] childrenDimensions = null;
    protected int numColumns = -1;
    private IBeanProxy fContainerBeanProxy = null;
    private IBeanProxy fLayoutManagerBeanProxy = null;
    protected JavaClass classLabel = null;
    public static final EObject EMPTY = EcoreFactory.eINSTANCE.createEObject();
    private static final AnyFeatureSetVisitor anyFeatureSetVisitor = new AnyFeatureSetVisitor();
    int[] expandableColumns;
    int[] expandableRows;
    private static final String TARGET_VM_VERSION_KEY = "TARGET_VM_VERSION";
    private int targetVMVersion = -1;
    private EditDomain fEditDomain;
    static /* synthetic */ Class class$0;

    protected IBeanProxy getContainerBeanProxy() {
        if (this.fContainerBeanProxy == null || !this.fContainerBeanProxy.isValid()) {
            this.fContainerBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.getContainer());
        }
        return this.fContainerBeanProxy;
    }

    protected IBeanProxy getLayoutManagerBeanProxy() {
        if (this.fLayoutManagerBeanProxy == null && this.getContainerBeanProxy() != null) {
            this.fLayoutManagerBeanProxy = BeanSWTUtilities.invoke_getLayout(this.getContainerBeanProxy());
        }
        return this.fLayoutManagerBeanProxy;
    }

    public GridLayoutPolicyHelper(VisualContainerPolicy ep) {
        super(ep);
        this.initializeDefaults();
    }

    public GridLayoutPolicyHelper() {
        this.initializeDefaults();
    }

    protected void initializeDefaults() {
        GridData gd = new GridData();
        this.defaultHorizontalSpan = gd.horizontalSpan;
        this.defaultVerticalSpan = gd.verticalSpan;
    }

    protected void cancelConstraints(CommandBuilder commandBuilder, List children) {
    }

    public List getDefaultConstraint(List children) {
        return Collections.nCopies(children.size(), null);
    }

    public EObject[][] getLayoutTable() {
        if (this.layoutTable == null) {
            int[][] dimensions = this.getContainerLayoutDimensions();
            this.layoutTable = new EObject[dimensions[0].length][dimensions[1].length];
            this.numColumns = dimensions[0].length;
            if (this.layoutTable.length < 1 || this.layoutTable[0].length < 1) {
                this.childrenDimensions = new Rectangle[0];
                return this.layoutTable;
            }
            int row = 0;
            int col = 0;
            int childNum = 0;
            List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
            this.childrenDimensions = new Rectangle[children.size()];
            Iterator itr = children.iterator();
            while (itr.hasNext()) {
                int verticalSpan;
                int horizontalSpan;
                IJavaObjectInstance child = (IJavaObjectInstance)itr.next();
                IJavaObjectInstance childData = (IJavaObjectInstance)child.eGet((EStructuralFeature)this.sfLayoutData);
                if (childData != null) {
                    try {
                        horizontalSpan = this.getIntValue(this.sfHorizontalSpan, childData);
                        verticalSpan = this.getIntValue(this.sfVerticalSpan, childData);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        horizontalSpan = this.defaultHorizontalSpan;
                        verticalSpan = this.defaultVerticalSpan;
                    }
                } else {
                    horizontalSpan = this.defaultHorizontalSpan;
                    verticalSpan = this.defaultVerticalSpan;
                }
                Rectangle r = new Rectangle();
                while (this.layoutTable[col][row] != null && row < this.layoutTable[0].length) {
                    if (++col < this.numColumns) continue;
                    ++row;
                    col = 0;
                }
                if (col != 0 && col + horizontalSpan - 1 >= this.numColumns) {
                    this.layoutTable[col][row] = EMPTY;
                    ++row;
                    col = 0;
                }
                int i = 0;
                while (i < horizontalSpan) {
                    int j = 0;
                    while (j < verticalSpan) {
                        this.layoutTable[col + i][row + j] = this.classLabel.isInstance((Object)child) && FeatureValueProvider.FeatureValueProviderHelper.visitSetFeatures((EObject)child, (FeatureValueProvider.Visitor)anyFeatureSetVisitor) == null && this.isNoStyleSet(child) ? new FillerLabel((EObject)child) : child;
                        ++j;
                    }
                    ++i;
                }
                r.x = col;
                r.y = row;
                r.width = horizontalSpan;
                r.height = verticalSpan;
                this.childrenDimensions[childNum] = r;
                ++childNum;
                col += horizontalSpan - 1;
            }
            if (this.layoutTable.length > 0 && this.layoutTable[0].length > 0) {
                int lastRow = this.layoutTable[0].length - 1;
                int i = 0;
                while (i < this.layoutTable.length) {
                    if (this.layoutTable[i][lastRow] == null) {
                        this.layoutTable[i][lastRow] = EMPTY;
                    }
                    ++i;
                }
            }
        }
        return this.layoutTable;
    }

    private int getIntValue(EStructuralFeature sf, IJavaObjectInstance object) {
        IIntegerBeanProxy intProxy;
        int value = 1;
        IJavaInstance valueObject = (IJavaInstance)object.eGet(sf);
        if (valueObject != null && (intProxy = (IIntegerBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)valueObject, (ResourceSet)this.rset)) != null) {
            value = intProxy.intValue();
        }
        return value;
    }

    public Rectangle[] getChildrenDimensions() {
        if (this.childrenDimensions == null) {
            this.getLayoutTable();
        }
        return this.childrenDimensions;
    }

    public int getNumColumns() {
        if (this.numColumns == -1) {
            this.getLayoutTable();
        }
        return this.numColumns;
    }

    public boolean isFillerLabelAtCell(Point cell) {
        EObject[][] table = this.getLayoutTable();
        if (cell.x >= 0 && cell.x < table.length && cell.y >= 0 && cell.y < table[0].length) {
            return table[cell.x][cell.y] instanceof FillerLabel;
        }
        return false;
    }

    public int getChildIndexAtCell(Point cell) {
        int value = -1;
        EObject[][] table = this.getLayoutTable();
        if (cell.x < 0 || cell.x >= this.getNumColumns() || cell.y < 0 || cell.y >= table[0].length) {
            return -1;
        }
        EObject childAtCell = table[cell.x][cell.y];
        if (childAtCell == null) {
            int x = cell.x;
            int y = cell.y;
            while (childAtCell == null && (x != 0 || y != 0)) {
                if (x == 0) {
                    --y;
                    x = this.getNumColumns();
                }
                childAtCell = table[--x][y];
            }
        }
        if (this.isFillerLabel(childAtCell)) {
            childAtCell = ((FillerLabel)childAtCell).realObject;
        }
        List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
        int i = 0;
        while (i < children.size()) {
            if (children.get(i).equals(childAtCell)) {
                value = i;
                break;
            }
            ++i;
        }
        return value;
    }

    public int[][] getContainerLayoutDimensions() {
        int[] columnWidths = null;
        int[] rowHeights = null;
        int[][] result = new int[][]{new int[0], new int[0]};
        String targetVMHelperTypeName = null;
        targetVMHelperTypeName = this.getTargetVMSWTVersion() >= 3100 ? "org.eclipse.ve.internal.swt.targetvm.GridLayoutHelper" : "org.eclipse.ve.internal.swt.targetvm.GridLayoutHelper_30";
        IBeanTypeProxy gridLayoutHelperType = this.getLayoutManagerBeanProxy().getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(targetVMHelperTypeName);
        IBeanProxy gridLayoutHelperProxy = null;
        try {
            final IBeanProxy gridLayoutHelperProxyFinal = gridLayoutHelperProxy = gridLayoutHelperType.newInstance();
            final IMethodProxy setCompositeMethodProxy = gridLayoutHelperType.getMethodProxy("setComposite", "org.eclipse.swt.widgets.Composite");
            DisplayManager.DisplayRunnable runnable = new DisplayManager.DisplayRunnable(){

                public Object run(IBeanProxy displayProxy) throws ThrowableProxy, DisplayManager.DisplayRunnable.RunnableException {
                    setCompositeMethodProxy.invoke(gridLayoutHelperProxyFinal, GridLayoutPolicyHelper.this.getContainerBeanProxy());
                    return null;
                }
            };
            JavaStandardSWTBeanConstants.invokeSyncExec(this.getContainerBeanProxy().getProxyFactoryRegistry(), runnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IFieldProxy getColumnWidthsFieldProxy = gridLayoutHelperType.getDeclaredFieldProxy("widths");
        IFieldProxy getRowHeightsFieldProxy = gridLayoutHelperType.getDeclaredFieldProxy("heights");
        try {
            IArrayBeanProxy arrayProxyRowHeights;
            IArrayBeanProxy arrayProxyColumnWidths = (IArrayBeanProxy)getColumnWidthsFieldProxy.get(gridLayoutHelperProxy);
            if (arrayProxyColumnWidths != null) {
                columnWidths = new int[arrayProxyColumnWidths.getLength()];
                int i = 0;
                while (i < arrayProxyColumnWidths.getLength()) {
                    columnWidths[i] = ((IIntegerBeanProxy)arrayProxyColumnWidths.get(i)).intValue();
                    ++i;
                }
                result[0] = columnWidths;
            }
            if ((arrayProxyRowHeights = (IArrayBeanProxy)getRowHeightsFieldProxy.get(gridLayoutHelperProxy)) != null) {
                rowHeights = new int[arrayProxyRowHeights.getLength()];
                int i = 0;
                while (i < arrayProxyRowHeights.getLength()) {
                    rowHeights[i] = ((IIntegerBeanProxy)arrayProxyRowHeights.get(i)).intValue();
                    ++i;
                }
                result[1] = rowHeights;
            }
        }
        catch (ThrowableProxy throwableProxy) {
            return null;
        }
        return result;
    }

    public Rectangle getContainerLayoutSpacing() {
        Rectangle result = null;
        IFieldProxy getMarginHeightFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("marginHeight");
        IFieldProxy getMarginWidthFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("marginWidth");
        IFieldProxy getHorizontalSpacingFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("horizontalSpacing");
        IFieldProxy getVerticalSpacingFieldProxy = this.getLayoutManagerBeanProxy().getTypeProxy().getDeclaredFieldProxy("verticalSpacing");
        try {
            IIntegerBeanProxy intProxyVerticalSpacing;
            IIntegerBeanProxy intProxyHorizontalSpacing;
            IIntegerBeanProxy intProxyMarginWidth;
            result = new Rectangle();
            IIntegerBeanProxy intProxyMarginHeight = (IIntegerBeanProxy)getMarginHeightFieldProxy.get(this.getLayoutManagerBeanProxy());
            if (intProxyMarginHeight != null) {
                result.y = intProxyMarginHeight.intValue();
            }
            if ((intProxyMarginWidth = (IIntegerBeanProxy)getMarginWidthFieldProxy.get(this.getLayoutManagerBeanProxy())) != null) {
                result.x = intProxyMarginWidth.intValue();
            }
            if ((intProxyHorizontalSpacing = (IIntegerBeanProxy)getHorizontalSpacingFieldProxy.get(this.getLayoutManagerBeanProxy())) != null) {
                result.width = intProxyHorizontalSpacing.intValue();
            }
            if ((intProxyVerticalSpacing = (IIntegerBeanProxy)getVerticalSpacingFieldProxy.get(this.getLayoutManagerBeanProxy())) != null) {
                result.height = intProxyVerticalSpacing.intValue();
            }
        }
        catch (ThrowableProxy throwableProxy) {
            return null;
        }
        return result;
    }

    public Rectangle getContainerClientArea() {
        if (this.getContainerBeanProxy() != null) {
            try {
                IRectangleBeanProxy result = (IRectangleBeanProxy)JavaStandardSWTBeanConstants.invokeSyncExec(this.getContainerBeanProxy().getProxyFactoryRegistry(), new DisplayManager.DisplayRunnable(){

                    public Object run(IBeanProxy displayProxy) throws ThrowableProxy, DisplayManager.DisplayRunnable.RunnableException {
                        IBeanProxy aContainerBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)GridLayoutPolicyHelper.this.getContainer());
                        IMethodProxy getContainerClientArea = aContainerBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aContainerBeanProxy.getTypeProxy().getTypeName(), "getClientArea", null);
                        if (getContainerClientArea != null) {
                            IIntegerBeanProxy heightProxy;
                            IIntegerBeanProxy widthProxy;
                            IIntegerBeanProxy yProxy;
                            IStandardBeanProxyFactory fac;
                            IIntegerBeanProxy xProxy;
                            IRectangleBeanProxy trimProxy;
                            IMethodProxy getDecorationsComputeTrim;
                            IRectangleBeanProxy rectangleProxy = (IRectangleBeanProxy)getContainerClientArea.invokeCatchThrowableExceptions(aContainerBeanProxy);
                            IBeanTypeProxy decorationsType = displayProxy.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.swt.widgets.Decorations");
                            if (aContainerBeanProxy.getTypeProxy().isKindOf(decorationsType) && (getDecorationsComputeTrim = aContainerBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aContainerBeanProxy.getTypeProxy().getTypeName(), "computeTrim", new String[]{"int", "int", "int", "int"})) != null && (trimProxy = (IRectangleBeanProxy)getDecorationsComputeTrim.invoke(aContainerBeanProxy, new IBeanProxy[]{xProxy = (fac = aContainerBeanProxy.getProxyFactoryRegistry().getBeanProxyFactory()).createBeanProxyWith(rectangleProxy.getX()), yProxy = fac.createBeanProxyWith(rectangleProxy.getY()), widthProxy = fac.createBeanProxyWith(rectangleProxy.getWidth()), heightProxy = fac.createBeanProxyWith(rectangleProxy.getHeight())})) != null) {
                                IStandardSWTBeanProxyFactory fac2 = (IStandardSWTBeanProxyFactory)aContainerBeanProxy.getProxyFactoryRegistry().getBeanProxyFactoryExtension("standard-java.SWT");
                                IRectangleBeanProxy newRectProxy = fac2.createBeanProxyWith(trimProxy.getX() * -1, trimProxy.getY() * -1, rectangleProxy.getWidth(), rectangleProxy.getHeight());
                                return newRectProxy;
                            }
                            return rectangleProxy;
                        }
                        return null;
                    }
                });
                if (result != null) {
                    return new Rectangle(result.getX(), result.getY(), result.getWidth(), result.getHeight());
                }
            }
            catch (ThrowableProxy throwableProxy) {
            }
            catch (DisplayManager.DisplayRunnable.RunnableException runnableException) {}
        }
        return null;
    }

    public boolean isContainerEmpty() {
        if (this.getContainerBeanProxy() != null) {
            try {
                IArrayBeanProxy result = (IArrayBeanProxy)JavaStandardSWTBeanConstants.invokeSyncExec(this.getContainerBeanProxy().getProxyFactoryRegistry(), new DisplayManager.DisplayRunnable(){

                    public Object run(IBeanProxy displayProxy) throws ThrowableProxy, DisplayManager.DisplayRunnable.RunnableException {
                        IMethodProxy getChildrenMethodProxy;
                        IBeanProxy aContainerBeanProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)GridLayoutPolicyHelper.this.getContainer());
                        if (aContainerBeanProxy != null && (getChildrenMethodProxy = aContainerBeanProxy.getProxyFactoryRegistry().getMethodProxyFactory().getMethodProxy(aContainerBeanProxy.getTypeProxy().getTypeName(), "getChildren", null)) != null) {
                            IArrayBeanProxy childrenProxy = (IArrayBeanProxy)getChildrenMethodProxy.invokeCatchThrowableExceptions(aContainerBeanProxy);
                            return childrenProxy;
                        }
                        return null;
                    }
                });
                if (result != null) {
                    return result.getLength() <= 0;
                }
            }
            catch (ThrowableProxy throwableProxy) {
            }
            catch (DisplayManager.DisplayRunnable.RunnableException runnableException) {}
        }
        return true;
    }

    public boolean isOnSameRow(int child1, int child2) {
        Rectangle[] children = this.getChildrenDimensions();
        Rectangle r1 = children[child1];
        Rectangle r2 = children[child2];
        return r1.y == r2.y;
    }

    public boolean isCellEmptyBefore(int index) {
        if (index == 0) {
            return false;
        }
        Rectangle r = this.getChildrenDimensions()[index];
        if (r.y == 0) {
            return false;
        }
        EObject cell = r.x != 0 ? this.getLayoutTable()[r.x - 1][r.y] : this.getLayoutTable()[this.getNumColumns() - 1][r.y - 1];
        return cell == null;
    }

    public Command getSpanChildrenCommand(EditPart childEditPart, Point childCellLocation, Point endCellLocation, int spanDirection) {
        CommandBuilder cb;
        block27: {
            cb = new CommandBuilder();
            EObject control = (EObject)childEditPart.getModel();
            if (control != null) {
                IJavaObjectInstance gridData = (IJavaObjectInstance)control.eGet((EStructuralFeature)this.sfLayoutData);
                if (gridData == null) {
                    gridData = (IJavaObjectInstance)BeanUtilities.createJavaObject((String)"org.eclipse.swt.layout.GridData", (ResourceSet)this.rset, (String)"new org.eclipse.swt.layout.GridData()");
                }
                try {
                    int newgridDataHeight;
                    int i;
                    int newgridDataWidth;
                    if (gridData == null) break block27;
                    List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
                    int index = children.indexOf(control);
                    Rectangle rect = this.getChildrenDimensions()[index];
                    RuledCommandBuilder componentCB = new RuledCommandBuilder(EditDomain.getEditDomain((EditPart)childEditPart), null, false);
                    if (spanDirection == 16 && (newgridDataWidth = endCellLocation.x - childCellLocation.x + 1) != rect.width) {
                        IJavaInstance widthObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(newgridDataWidth));
                        componentCB.applyAttributeSetting((EObject)gridData, this.sfHorizontalSpan, (Object)widthObject);
                        if (newgridDataWidth > rect.width) {
                            int numColsIncrement = this.createHorizontalSpanWithEmptyColumnCommands((CommandBuilder)componentCB, rect.y, rect.x + rect.width - 1, rect.height, newgridDataWidth - rect.width);
                            if (numColsIncrement > 0) {
                                componentCB.append(this.createNumColumnsCommand(this.numColumns + numColsIncrement));
                                i = 0;
                                while (i < numColsIncrement) {
                                    componentCB.append(this.createInsertColumnWithinRowCommands(endCellLocation.x, rect.y, null, null));
                                    ++i;
                                }
                            }
                        } else {
                            CommandBuilder columncb = new CommandBuilder();
                            int projectedNumCols = this.numColumns;
                            int i2 = 0;
                            while (i2 < rect.width - newgridDataWidth) {
                                Command cmd = this.createRemoveColumnCommand(rect.x + rect.width - 1 - i2, control, projectedNumCols);
                                if (cmd != null) {
                                    columncb.append(cmd);
                                    --projectedNumCols;
                                }
                                ++i2;
                            }
                            if (!columncb.isEmpty()) {
                                componentCB.append(columncb.getCommand());
                            } else {
                                Rectangle childRect = rect.getCopy();
                                int i3 = 0;
                                while (i3 < rect.height) {
                                    EObject beforeObject = this.findNextValidObject(childRect.x + childRect.width, childRect.y + childRect.height - 1);
                                    int j = 0;
                                    while (j < rect.width - newgridDataWidth) {
                                        componentCB.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), (Object)beforeObject));
                                        ++j;
                                    }
                                    --childRect.y;
                                    ++i3;
                                }
                            }
                        }
                    }
                    if (spanDirection == 4 && (newgridDataHeight = endCellLocation.y - childCellLocation.y + 1) != rect.height) {
                        IJavaInstance heightObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(newgridDataHeight));
                        componentCB.applyAttributeSetting((EObject)gridData, this.sfVerticalSpan, (Object)heightObject);
                        if (newgridDataHeight > rect.height) {
                            int numRowsIncrement = this.createVerticalSpanWithEmptyRowCommands((CommandBuilder)componentCB, rect.y + rect.height - 1, rect.x, rect.width, newgridDataHeight - rect.height);
                            if (numRowsIncrement > 0) {
                                ArrayList<Integer> childCols = new ArrayList<Integer>(rect.width);
                                int i4 = 0;
                                while (i4 < rect.width) {
                                    childCols.add(new Integer(rect.x + i4));
                                    ++i4;
                                }
                                i4 = 0;
                                while (i4 < numRowsIncrement) {
                                    componentCB.append(this.createFillerLabelsForSpannedRowCommand(rect.y + rect.height, childCols));
                                    ++i4;
                                }
                            }
                        } else {
                            CommandBuilder rowcb = new CommandBuilder();
                            i = 0;
                            while (i < rect.height - newgridDataHeight) {
                                rowcb.append(this.createRemoveRowCommand(rect.y + rect.height - 1 - i, control));
                                ++i;
                            }
                            if (!rowcb.isEmpty()) {
                                componentCB.append(rowcb.getCommand());
                            } else {
                                Rectangle childRect = rect.getCopy();
                                int i5 = 0;
                                while (i5 < rect.height - newgridDataHeight) {
                                    EObject beforeObject = this.findNextValidObject(childRect.x + 1, childRect.y + childRect.height - 1);
                                    int j = 0;
                                    while (j < rect.width) {
                                        componentCB.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), (Object)beforeObject));
                                        ++j;
                                    }
                                    --childRect.y;
                                    ++i5;
                                }
                            }
                        }
                    }
                    componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfLayoutData, (Object)gridData);
                    cb.append(componentCB.getCommand());
                }
                catch (Exception exception) {
                    return UnexecutableCommand.INSTANCE;
                }
            }
        }
        if (cb.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return cb.getCommand();
    }

    public IJavaInstance createFillerLabelObject() {
        return BeanUtilities.createJavaObject((String)"org.eclipse.swt.widgets.Label", (ResourceSet)this.rset, null);
    }

    public Command createNumColumnsCommand(int numCols) {
        CommandBuilder cb = new CommandBuilder();
        EObject parent = (EObject)this.policy.getContainer();
        if (parent != null) {
            IJavaInstance gridLayout = (IJavaInstance)parent.eGet(this.sfCompositeLayout);
            if (gridLayout == null) {
                return UnexecutableCommand.INSTANCE;
            }
            RuledCommandBuilder componentCB = new RuledCommandBuilder(this.policy.getEditDomain(), null, false);
            IJavaInstance intObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(numCols));
            componentCB.applyAttributeSetting((EObject)gridLayout, this.sfNumColumns, (Object)intObject);
            componentCB.applyAttributeSetting(parent, this.sfCompositeLayout, (Object)gridLayout);
            cb.append(componentCB.getCommand());
            return cb.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command createFillerLabelsForNewRowCommand(Object addedControl, int atRow, int atColumn, Request request) {
        int index;
        EObject child;
        EObject[][] table = this.getLayoutTable();
        if (table[0].length < 1) {
            return null;
        }
        List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
        if (children.isEmpty()) {
            return null;
        }
        if (atColumn == -1) {
            atColumn = this.numColumns - 1;
        }
        if (atRow < table[0].length - 1 && (child = table[atColumn][atRow]) != null && !this.isFillerLabel(child) && (index = children.indexOf(table[atColumn][atRow])) != -1 && this.childrenDimensions[index].y != atRow) {
            return UnexecutableCommand.INSTANCE;
        }
        CommandBuilder cb = new CommandBuilder();
        if (atRow >= table[0].length) {
            int i = 0;
            while (i < table.length) {
                if (table[i][table[0].length - 1] == EMPTY) {
                    cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), null));
                }
                ++i;
            }
        }
        EObject beforeObject = this.findNextValidObject(0, atRow);
        int i = 0;
        while (i < this.numColumns) {
            int index2;
            EObject child2;
            boolean addFiller = true;
            if (i == atColumn) {
                cb.append(this.getCommandForAddCreateMoveChild(request, addedControl, beforeObject));
                addFiller = false;
            } else if (atRow < table[0].length && (child2 = table[i][atRow]) != null && !this.isFillerLabel(child2) && child2 != EMPTY && (index2 = children.indexOf(child2)) != -1 && this.childrenDimensions[index2].y != atRow) {
                cb.append(this.createVerticalSpanCommand(child2, this.childrenDimensions[index2].height + 1));
                addFiller = false;
            }
            if (addFiller) {
                cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), (Object)beforeObject));
            }
            ++i;
        }
        return cb.getCommand();
    }

    private Command createFillerLabelsForSpannedRowCommand(int atRow, List atColumns) {
        EObject[][] table = this.getLayoutTable();
        if (table[0].length < 1) {
            return null;
        }
        List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
        if (children.isEmpty()) {
            return null;
        }
        CommandBuilder cb = new CommandBuilder();
        EObject beforeObject = this.findNextValidObject(0, atRow);
        int i = 0;
        while (i < this.numColumns) {
            boolean addFiller = true;
            if (!atColumns.contains(new Integer(i))) {
                int index;
                EObject child;
                if (atRow < table[0].length && (child = table[i][atRow]) != null && !this.isFillerLabel(child) && child != EMPTY && (index = children.indexOf(child)) != -1 && this.childrenDimensions[index].y != atRow) {
                    cb.append(this.createVerticalSpanCommand(child, this.childrenDimensions[index].height + 1));
                    addFiller = false;
                }
                if (addFiller) {
                    cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), (Object)beforeObject));
                }
            }
            ++i;
        }
        return cb.getCommand();
    }

    public Command createAddToEmptyCellCommand(Object addedControl, Point cell, Request request) {
        CommandBuilder cb = new CommandBuilder();
        EObject[][] table = this.getLayoutTable();
        if (table.length == 0 || table[0].length == 0 || cell.x >= table.length || cell.y >= table[0].length) {
            return null;
        }
        EObject beforeObject = this.findNextValidObject(cell.x, cell.y);
        int i = 0;
        while (i < table.length) {
            if (i == cell.x) {
                cb.append(this.getCommandForAddCreateMoveChild(request, addedControl, beforeObject));
            } else if (table[i][cell.y] == EMPTY) {
                cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), (Object)beforeObject));
            }
            ++i;
        }
        return cb.getCommand();
    }

    public Command createInsertColumnWithinRowCommands(int atColumn, int atRow, Object addedControl, Request request) {
        CommandBuilder cb = new CommandBuilder();
        EObject[][] table = this.getLayoutTable();
        if (table[0].length <= 1) {
            return null;
        }
        List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
        if (children.isEmpty()) {
            return null;
        }
        EObject beforeObject = table[atColumn][atRow];
        if (this.isFillerLabel(beforeObject)) {
            beforeObject = ((FillerLabel)beforeObject).realObject;
        }
        int i = 0;
        while (i < table[0].length) {
            Rectangle rect;
            Object child = table[atColumn][i];
            if (this.isFillerLabel(child)) {
                child = ((FillerLabel)((Object)child)).realObject;
            }
            int index = children.indexOf(child);
            if (i == atRow && addedControl != null && index != -1) {
                rect = this.childrenDimensions[index];
                if (rect.height != this.defaultVerticalSpan && rect.y != i) {
                    child = atColumn + 1 < this.numColumns ? this.findNextValidObject(atColumn + 1, i) : (i + 1 < table[0].length ? this.findNextValidObject(0, i + 1) : null);
                }
                cb.append(this.getCommandForAddCreateMoveChild(request, addedControl, child));
            }
            if (i != atRow && index != -1) {
                rect = this.childrenDimensions[index];
                if (rect.height != this.defaultVerticalSpan && child == beforeObject) {
                    if (rect.y != i) {
                        child = atColumn + 1 < this.numColumns ? this.findNextValidObject(atColumn + 1, i) : (i + 1 < table[0].length ? this.findNextValidObject(0, i + 1) : null);
                    }
                } else if (i + 1 < table[0].length && table[0][i + 1] != EMPTY) {
                    child = table[0][i + 1];
                    if (this.isFillerLabel(child)) {
                        child = ((FillerLabel)((Object)child)).realObject;
                    }
                } else {
                    child = null;
                }
                cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), child));
            }
            ++i;
        }
        return cb.getCommand();
    }

    public Command createInsertColumnCommands(Object addedControl, Request request, int atColumn, int atRow, boolean isLastColumn) {
        CommandBuilder cb = new CommandBuilder();
        EObject[][] table = this.getLayoutTable();
        List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
        if (children.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < table[0].length) {
            if (!isLastColumn || i != 0) {
                if (i == table[0].length - 1) {
                    int j = 0;
                    while (j < table.length) {
                        if (table[j][i] == EMPTY) {
                            cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), null));
                        }
                        ++j;
                    }
                }
                if (table[atColumn][i] != EMPTY) {
                    Rectangle rect;
                    int index;
                    Object child = table[atColumn][i];
                    if (this.isFillerLabel(child)) {
                        child = ((FillerLabel)((Object)child)).realObject;
                    }
                    if (i == atRow) {
                        index = children.indexOf(child);
                        if (index != -1) {
                            rect = this.childrenDimensions[index];
                            if (rect.height != this.defaultVerticalSpan && rect.y != i) {
                                child = atColumn + 1 < this.numColumns ? this.findNextValidObject(atColumn + 1, i) : (i + 1 < table[0].length ? this.findNextValidObject(0, i + 1) : null);
                            }
                            cb.append(this.getCommandForAddCreateMoveChild(request, addedControl, child));
                        }
                    } else {
                        if (this.isFillerLabel(child)) {
                            child = ((FillerLabel)((Object)child)).realObject;
                        }
                        if ((index = children.indexOf(child)) != -1) {
                            rect = this.childrenDimensions[index];
                            if (rect.width == this.defaultHorizontalSpan && rect.height == this.defaultVerticalSpan || rect.width > this.defaultHorizontalSpan && rect.height == this.defaultVerticalSpan && rect.x == atColumn) {
                                cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), child));
                            } else if (rect.width > this.defaultHorizontalSpan && rect.x != atColumn && rect.y == i) {
                                cb.append(this.createHorizontalSpanCommand((EObject)child, rect.width + 1));
                            } else if (rect.height > this.defaultVerticalSpan) {
                                if (rect.y == i) {
                                    cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), child));
                                } else {
                                    EObject nextChild = null;
                                    if (atColumn + 1 < this.numColumns) {
                                        nextChild = this.findNextValidObject(atColumn + 1, i);
                                    } else if (i + 1 < table[0].length) {
                                        nextChild = this.findNextValidObject(0, i + 1);
                                    }
                                    cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), (Object)nextChild));
                                }
                            }
                        } else {
                            cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), child));
                        }
                    }
                }
            }
            ++i;
        }
        if (isLastColumn && atRow >= table[0].length) {
            cb.append(this.getCommandForAddCreateMoveChild(request, addedControl, null));
        }
        return cb.getCommand();
    }

    public Command getFillerLabelsForDeletedControlCommands(EObject deletedChild) {
        Rectangle[] rects;
        List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
        if (children.isEmpty()) {
            return null;
        }
        CommandBuilder cb = new CommandBuilder();
        int index = children.indexOf(deletedChild);
        if (index != -1 && (rects = this.getChildrenDimensions()) != null && index < rects.length) {
            Rectangle rect = rects[index];
            Command rowCmds = this.createRemoveRowCommand(rect.y, deletedChild);
            Command columnCmds = this.createRemoveColumnCommand(rect.x, deletedChild, this.numColumns);
            if (rowCmds != null) {
                cb.append(rowCmds);
            }
            if (columnCmds != null) {
                cb.append(columnCmds);
            }
            if (cb.isEmpty() && index + 1 < children.size()) {
                cb.append(this.createFillerLabelsForDeletedControlCommands(deletedChild));
            }
        }
        if (cb.isEmpty()) {
            return null;
        }
        return cb.getCommand();
    }

    private Command createFillerLabelsForDeletedControlCommands(EObject deletedChild) {
        CommandBuilder cb = new CommandBuilder();
        EObject[][] table = this.getLayoutTable();
        if (table[0].length <= 1) {
            return null;
        }
        List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
        if (children.isEmpty()) {
            return null;
        }
        int index = children.indexOf(deletedChild);
        if (index != -1) {
            Rectangle rect = this.childrenDimensions[index];
            EObject nextChild = null;
            int i = rect.y;
            while (i < rect.y + rect.height && i < table[0].length) {
                if (rect.x + 1 < this.numColumns) {
                    nextChild = this.findNextValidObject(rect.x + 1, i);
                } else if (i + 1 < table[0].length) {
                    nextChild = this.findNextValidObject(0, i + 1);
                }
                int j = 0;
                while (j < rect.width) {
                    cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), (Object)nextChild));
                    ++j;
                }
                ++i;
            }
        }
        return cb.getCommand();
    }

    public Command createFillerLabelsForMovedControlCommands(EObject movedChild, EObject beforeChild) {
        CommandBuilder cb = new CommandBuilder();
        EObject[][] table = this.getLayoutTable();
        if (table[0].length <= 1) {
            return null;
        }
        List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
        if (children.isEmpty()) {
            return null;
        }
        int index = children.indexOf(movedChild);
        if (index != -1) {
            Rectangle rect = this.childrenDimensions[index];
            EObject nextChild = null;
            int i = rect.y;
            while (i < rect.y + rect.height && i < table[0].length) {
                if (rect.x + 1 < this.numColumns) {
                    nextChild = this.findNextValidObject(rect.x + 1, i);
                } else if (i + 1 < table[0].length) {
                    nextChild = this.findNextValidObject(0, i + 1);
                }
                if (nextChild == beforeChild) {
                    nextChild = movedChild;
                }
                int j = 0;
                while (j < rect.width) {
                    cb.append(this.policy.getCreateCommand((Object)this.createFillerLabelObject(), (Object)nextChild));
                    ++j;
                }
                ++i;
            }
        }
        return cb.getCommand();
    }

    private Command createHorizontalSpanCommand(EObject control, int gridWidth) {
        CommandBuilder cb = new CommandBuilder();
        if (control != null) {
            IJavaObjectInstance gridData = (IJavaObjectInstance)control.eGet((EStructuralFeature)this.sfLayoutData);
            if (gridData == null) {
                gridData = (IJavaObjectInstance)BeanUtilities.createJavaObject((String)"org.eclipse.swt.layout.GridData", (ResourceSet)this.rset, (String)"new org.eclipse.swt.layout.GridData()");
            }
            if (gridData != null) {
                RuledCommandBuilder componentCB = new RuledCommandBuilder(this.policy.getEditDomain(), null, false);
                IJavaInstance widthObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(gridWidth));
                componentCB.applyAttributeSetting((EObject)gridData, this.sfHorizontalSpan, (Object)widthObject);
                componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfLayoutData, (Object)gridData);
                cb.append(componentCB.getCommand());
            }
        }
        return cb.getCommand();
    }

    public Command createHorizontalSpanDefaultCommand(EObject control) {
        return this.createHorizontalSpanCommand(control, this.defaultHorizontalSpan);
    }

    private Command createVerticalSpanCommand(EObject control, int gridHeight) {
        CommandBuilder cb = new CommandBuilder();
        if (control != null) {
            IJavaObjectInstance gridData = (IJavaObjectInstance)control.eGet((EStructuralFeature)this.sfLayoutData);
            if (gridData == null) {
                gridData = (IJavaObjectInstance)BeanUtilities.createJavaObject((String)"org.eclipse.swt.layout.GridData", (ResourceSet)this.rset, (String)"new org.eclipse.swt.layout.GridData()");
            }
            if (gridData != null) {
                RuledCommandBuilder componentCB = new RuledCommandBuilder(this.policy.getEditDomain(), null, false);
                IJavaInstance heightObject = BeanUtilities.createJavaObject((String)"int", (ResourceSet)this.rset, (String)String.valueOf(gridHeight));
                componentCB.applyAttributeSetting((EObject)gridData, this.sfVerticalSpan, (Object)heightObject);
                componentCB.applyAttributeSetting(control, (EStructuralFeature)this.sfLayoutData, (Object)gridData);
                cb.append(componentCB.getCommand());
            }
        }
        return cb.getCommand();
    }

    public Command createVerticalSpanDefaultCommand(EObject control) {
        return this.createVerticalSpanCommand(control, this.defaultVerticalSpan);
    }

    public void refresh() {
        this.layoutTable = null;
        this.childrenDimensions = null;
        this.numColumns = -1;
    }

    public void setContainerPolicy(VisualContainerPolicy policy) {
        super.setContainerPolicy(policy);
        if (policy != null) {
            this.rset = JavaEditDomainHelper.getResourceSet((EditDomain)policy.getEditDomain());
            this.sfCompositeControls = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)SWTConstants.SF_COMPOSITE_CONTROLS);
            this.sfLayoutData = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)SWTConstants.SF_CONTROL_LAYOUTDATA);
            this.sfHorizontalSpan = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_HORIZONTAL_SPAN);
            this.sfVerticalSpan = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_DATA_VERTICAL_SPAN);
            this.sfNumColumns = JavaInstantiation.getSFeature((ResourceSet)this.rset, (URI)SWTConstants.SF_GRID_LAYOUT_NUM_COLUMNS);
            this.sfCompositeLayout = JavaInstantiation.getReference((ResourceSet)this.rset, (URI)SWTConstants.SF_COMPOSITE_LAYOUT);
            this.classLabel = Utilities.getJavaClass((String)"org.eclipse.swt.widgets.Label", (ResourceSet)this.rset);
            this.sfLabelText = this.classLabel.getEStructuralFeature("text");
        }
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof EditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain((EditPart)((EditPart)target));
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(((EditPart)target).getModel())) != null && ep.getEditPolicy((Object)"LayoutEditPolicy") instanceof IActionFilter) {
                return ((IActionFilter)ep.getEditPolicy((Object)"LayoutEditPolicy")).testAttribute(target, name, value);
            }
        }
        return false;
    }

    private boolean isFillerLabel(Object control) {
        return control instanceof FillerLabel;
    }

    public Command createRemoveRowCommand(int atRow, EObject ignoreObject) {
        EObject[][] table = this.getLayoutTable();
        CommandBuilder cb = new CommandBuilder();
        boolean empty = true;
        int i = 0;
        while (i < table.length) {
            if (!this.isFillerLabel(table[i][atRow]) && table[i][atRow] != EMPTY && ignoreObject != table[i][atRow]) {
                empty = false;
                break;
            }
            ++i;
        }
        if (empty) {
            i = 0;
            while (i < table.length) {
                if (this.isFillerLabel(table[i][atRow])) {
                    cb.append(this.policy.getDeleteDependentCommand((Object)((FillerLabel)table[i][atRow]).realObject));
                }
                ++i;
            }
            return cb.getCommand();
        }
        return null;
    }

    public Command createRemoveColumnCommand(int atColumn, EObject ignoreObject, int projectNumColumns) {
        EObject[][] table = this.getLayoutTable();
        CommandBuilder cb = new CommandBuilder();
        boolean empty = true;
        int i = 0;
        while (i < table[0].length) {
            if (!this.isFillerLabel(table[atColumn][i]) && table[atColumn][i] != EMPTY && ignoreObject != table[atColumn][i]) {
                empty = false;
                break;
            }
            ++i;
        }
        if (empty) {
            i = 0;
            while (i < table[0].length) {
                if (this.isFillerLabel(table[atColumn][i])) {
                    cb.append(this.policy.getDeleteDependentCommand((Object)((FillerLabel)table[atColumn][i]).realObject));
                }
                ++i;
            }
            if (projectNumColumns != 1) {
                cb.append(this.createNumColumnsCommand(projectNumColumns - 1));
            }
            return cb.getCommand();
        }
        return null;
    }

    private int createHorizontalSpanWithEmptyColumnCommands(CommandBuilder cb, int atRow, int atColumn, int childHeight, int numColsIncrement) {
        EObject[][] table = this.getLayoutTable();
        if (atColumn < table.length && atRow < table[0].length) {
            int i = atColumn;
            while (i < table.length && numColsIncrement != 0) {
                if (this.isHorizontalSpaceAvailable(i, atRow, atRow + childHeight - 1)) {
                    int j = atRow;
                    while (j < atRow + childHeight) {
                        if (this.isFillerLabel(table[i][j])) {
                            cb.append(this.policy.getDeleteDependentCommand((Object)((FillerLabel)table[i][j]).realObject));
                        }
                        ++j;
                    }
                    --numColsIncrement;
                }
                ++i;
            }
        }
        return numColsIncrement;
    }

    private int createVerticalSpanWithEmptyRowCommands(CommandBuilder cb, int atRow, int atColumn, int childWidth, int numRowsIncrement) {
        EObject[][] table = this.getLayoutTable();
        if (atColumn < table.length && atRow < table[0].length && atRow + numRowsIncrement < table[0].length) {
            int i = atRow;
            while (i < table[0].length && numRowsIncrement != 0) {
                if (this.isVerticalSpaceAvailable(i, atColumn, atColumn + childWidth - 1)) {
                    int j = atColumn;
                    while (j < atColumn + childWidth) {
                        if (this.isFillerLabel(table[j][i])) {
                            cb.append(this.policy.getDeleteDependentCommand((Object)((FillerLabel)table[j][i]).realObject));
                        }
                        ++j;
                    }
                    --numRowsIncrement;
                }
                ++i;
            }
        }
        return numRowsIncrement;
    }

    private EObject findNextValidObject(int columnStart, int rowStart) {
        EObject[][] table = this.getLayoutTable();
        if (table.length == 0 || table[0].length == 0) {
            return null;
        }
        List children = (List)this.getContainer().eGet((EStructuralFeature)this.sfCompositeControls);
        if (children.isEmpty()) {
            return null;
        }
        EObject foundObject = null;
        int col = columnStart;
        int row = rowStart;
        boolean firstpass = true;
        int i = row;
        while (i < table[0].length && foundObject == null) {
            int j = col;
            while (j < table.length) {
                if (table[j][i] != EMPTY) {
                    int index;
                    EObject child = table[j][i];
                    if (this.isFillerLabel(child)) {
                        child = ((FillerLabel)child).realObject;
                    }
                    if ((index = children.indexOf(child)) != -1 && this.childrenDimensions[index].y == i) {
                        foundObject = child;
                        break;
                    }
                }
                ++j;
            }
            if (firstpass) {
                col = 0;
            }
            ++i;
        }
        return foundObject;
    }

    private boolean isVerticalSpaceAvailable(int atRow, int columnStart, int columnEnd) {
        boolean result = true;
        EObject[][] table = this.getLayoutTable();
        if (table.length == 0 || table[0].length == 0 || columnStart >= table.length || columnEnd >= table.length || atRow >= table[0].length) {
            return false;
        }
        int i = columnStart;
        while (i <= columnEnd) {
            if (table[i][atRow] != EMPTY && !this.isFillerLabel(table[i][atRow])) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isHorizontalSpaceAvailable(int atCol, int rowStart, int rowEnd) {
        boolean result = true;
        EObject[][] table = this.getLayoutTable();
        if (table.length == 0 || table[0].length == 0 || rowStart >= table[0].length || rowEnd >= table[0].length || atCol >= table.length) {
            return false;
        }
        int i = rowStart;
        while (i <= rowEnd) {
            if (table[atCol][i] != EMPTY && !this.isFillerLabel(table[atCol][i])) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isNoStyleSet(IJavaObjectInstance child) {
        PTExpression secondArg;
        PTClassInstanceCreation classInstanceCreation;
        ParseTreeAllocation ptAlloc;
        PTExpression allocationExpression;
        return child != null && child.getAllocation() instanceof ParseTreeAllocation && (allocationExpression = (ptAlloc = (ParseTreeAllocation)child.getAllocation()).getExpression()) instanceof PTClassInstanceCreation && (classInstanceCreation = (PTClassInstanceCreation)allocationExpression).getArguments().size() == 2 && (secondArg = (PTExpression)classInstanceCreation.getArguments().get(1)) instanceof PTFieldAccess && ((PTFieldAccess)secondArg).getField().equals("NONE");
    }

    private int getTargetVMSWTVersion() {
        if (this.targetVMVersion != -1) {
            return this.targetVMVersion;
        }
        Integer editDomainTargetVMVersion = (Integer)this.fEditDomain.getData((Object)TARGET_VM_VERSION_KEY);
        if (editDomainTargetVMVersion != null) {
            this.targetVMVersion = editDomainTargetVMVersion;
            return this.targetVMVersion;
        }
        ProxyFactoryRegistry proxyFactoryRegistry = this.getLayoutManagerBeanProxy().getProxyFactoryRegistry();
        IExpression expression = proxyFactoryRegistry.getBeanProxyFactory().createExpression();
        IProxyBeanType swtBeanTypeProxy = proxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(expression, "org.eclipse.swt.SWT");
        IProxyMethod getVersionMethodProxy = swtBeanTypeProxy.getMethodProxy(expression, "getVersion");
        ExpressionProxy proxy = expression.createSimpleMethodInvoke(getVersionMethodProxy, (IProxy)swtBeanTypeProxy, null, true);
        proxy.addProxyListener(new ExpressionProxy.ProxyListener(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                GridLayoutPolicyHelper.this.targetVMVersion = ((IIntegerBeanProxy)event.getProxy()).intValue();
                GridLayoutPolicyHelper.this.fEditDomain.setData((Object)GridLayoutPolicyHelper.TARGET_VM_VERSION_KEY, (Object)new Integer(GridLayoutPolicyHelper.this.targetVMVersion));
            }

            public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
            }

            public void proxyVoid(ExpressionProxy.ProxyEvent event) {
            }
        });
        try {
            expression.invokeExpression();
        }
        catch (Exception exception) {
            JavaVEPlugin.log((Object)"Unable to work out target SWT version for GridLayoutHelper", (Level)Level.WARNING);
            this.targetVMVersion = 3100;
        }
        if (this.targetVMVersion == -1) {
            JavaVEPlugin.log((Object)"Unable to work out target SWT version for GridLayoutHelper", (Level)Level.WARNING);
            this.targetVMVersion = 3100;
        }
        return this.targetVMVersion;
    }

    public void setEditDomain(EditDomain editDomain) {
        this.fEditDomain = editDomain;
    }

    public int getDefaultHorizontalSpan() {
        return this.defaultHorizontalSpan;
    }

    public int getDefaultVerticalSpan() {
        return this.defaultVerticalSpan;
    }

    private Command getCommandForAddCreateMoveChild(Request request, Object child, Object beforeObject) {
        CommandBuilder cb = new CommandBuilder();
        if (request instanceof CreateRequest) {
            cb.append(this.policy.getCreateCommand(child, beforeObject));
        } else if (request instanceof ChangeBoundsRequest) {
            if ("add children".equals(request.getType())) {
                cb.append(this.policy.getAddCommand(Collections.singletonList(child), beforeObject));
            } else {
                cb.append(this.policy.getMoveChildrenCommand(Collections.singletonList(child), beforeObject));
            }
        }
        return cb.getCommand();
    }

    static class FillerLabel
    extends EObjectImpl {
        EObject realObject;

        public FillerLabel(EObject realObject) {
            this.realObject = realObject;
        }
    }

    private static class AnyFeatureSetVisitor
    implements FeatureValueProvider.Visitor {
        AnyFeatureSetVisitor() {
        }

        public Object isSet(EStructuralFeature feature, Object value) {
            if (feature.getName().equals("allocation")) {
                return null;
            }
            if (feature.isMany() && ((List)value).isEmpty()) {
                return null;
            }
            return Boolean.TRUE;
        }
    }
}

