/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.VCEPreferences;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;

public class ImageDataCollector
implements ICallback {
    protected IBeanProxy fDataCollectorProxy;
    protected DataCollectedRunnable fDataCollectedRunnable;

    public ImageDataCollector(ProxyFactoryRegistry registry) {
        try {
            IBeanTypeProxy dataCollectorType = null;
            if ("win32".equals(Platform.getOS())) {
                dataCollectorType = registry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.swt.targetvm.win32.ImageCapture");
            } else if ("gtk".equals(Platform.getWS())) {
                dataCollectorType = "ia64".equals(Platform.getOSArch()) || "x86_64".equals(Platform.getOSArch()) ? registry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.swt.targetvm.unix.bits64.ImageCapture") : registry.getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.swt.targetvm.unix.ImageCapture");
            }
            if (dataCollectorType != null) {
                this.fDataCollectorProxy = dataCollectorType.newInstance();
                registry.getCallbackRegistry().registerCallback(this.fDataCollectorProxy, (ICallback)this);
            }
        }
        catch (ThrowableProxy e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            return;
        }
    }

    public void release() {
        if (this.fDataCollectorProxy != null && this.fDataCollectorProxy.isValid()) {
            if (this.isCollectingData()) {
                this.abort(true);
            }
            this.fDataCollectorProxy.getProxyFactoryRegistry().getCallbackRegistry().deregisterCallback(this.fDataCollectorProxy);
            this.fDataCollectorProxy.getProxyFactoryRegistry().getBeanProxyFactory().releaseProxy(this.fDataCollectorProxy);
        }
        this.fDataCollectorProxy = null;
        this.fDataCollectedRunnable = null;
    }

    public boolean abort(boolean wait) {
        if (this.isCollectingData()) {
            return BeanSWTUtilities.invoke_imageCaptureAbort(this.fDataCollectorProxy, wait);
        }
        return true;
    }

    public boolean isCollectingData() {
        return this.fDataCollectedRunnable != null;
    }

    public IBeanProxy getDataCollectorProxy() {
        return this.fDataCollectorProxy;
    }

    public void startComponent(IBeanProxy aComponentProxy, DataCollectedRunnable dc) throws ThrowableProxy {
        this.fDataCollectedRunnable = dc;
        IBooleanBeanProxy r = BeanSWTUtilities.invoke_imageCaptureStartCapture(this.fDataCollectorProxy, aComponentProxy, VCEPreferences.getPlugin().getPluginPreferences().getInt("MAX_AWT_COMPONENT_IMAGE_WIDTH"), VCEPreferences.getPlugin().getPluginPreferences().getInt("MAX_AWT_COMPONENT_IMAGE_HEIGHT"), true);
        if (r == null || !r.booleanValue()) {
            dc.imageNotCollected(0);
            this.fDataCollectedRunnable = null;
        }
    }

    public Object calledBack(int msgId, IBeanProxy p2) {
        switch (msgId) {
            case 2: {
                this.fDataCollectedRunnable.imageException((ThrowableProxy)p2);
                this.fDataCollectedRunnable = null;
            }
        }
        return null;
    }

    public Object calledBack(int p1, Object[] p2) {
        return null;
    }

    public Object calledBack(int p1, Object p2) {
        return null;
    }

    public void calledBackStream(int msgID, InputStream is) {
        switch (msgID) {
            case 1: {
                this.createImageData(new DataInputStream(is));
                break;
            }
            default: {
                if (!JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) break;
                JavaVEPlugin.log((Object)("Invalid callback in ImageDataCollector=" + msgID), (Level)Level.WARNING);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createImageData(DataInputStream is) {
        int width = -1;
        int height = -1;
        int depth = -1;
        int transparentPixel = -1;
        PaletteData palette = null;
        ImageData imageData = null;
        byte[] bytes = null;
        int[] ints = null;
        int y = 0;
        int rowCnt = 0;
        boolean byteMode = false;
        try {
            byte cmd;
            block17: while (true) {
                if (this.fDataCollectedRunnable == null) {
                    return;
                }
                cmd = is.readByte();
                switch (cmd) {
                    case 1: {
                        width = is.readInt();
                        height = is.readInt();
                        continue block17;
                    }
                    case 2: {
                        depth = is.readByte();
                        int rmask = is.readInt();
                        int gmask = is.readInt();
                        int bmask = is.readInt();
                        palette = new PaletteData(rmask, gmask, bmask);
                        continue block17;
                    }
                    case 3: {
                        depth = is.readByte();
                        transparentPixel = is.readInt();
                        int rgbCnt = is.readInt();
                        RGB[] rgbs = new RGB[rgbCnt];
                        int i = 0;
                        while (true) {
                            if (i >= rgbCnt) {
                                palette = new PaletteData(rgbs);
                                continue block17;
                            }
                            rgbs[i] = new RGB(is.readByte() & 0xFF, is.readByte() & 0xFF, is.readByte() & 0xFF);
                            ++i;
                        }
                    }
                    case 4: {
                        if (imageData == null) {
                            imageData = new ImageData(width, height, depth, palette);
                            if (transparentPixel != -1) {
                                imageData.transparentPixel = transparentPixel;
                            }
                        }
                        if (bytes == null) {
                            bytes = new byte[width];
                        }
                        if (rowCnt > 0) {
                            imageData.setPixels(0, y, rowCnt, bytes, 0);
                        }
                        y = is.readInt();
                        rowCnt = 0;
                        byteMode = true;
                        continue block17;
                    }
                    case 5: {
                        if (imageData == null) {
                            imageData = new ImageData(width, height, depth, palette);
                            if (transparentPixel != -1) {
                                imageData.transparentPixel = transparentPixel;
                            }
                        }
                        if (ints == null) {
                            ints = new int[width];
                        }
                        if (rowCnt > 0) {
                            imageData.setPixels(0, y, rowCnt, ints, 0);
                        }
                        y = is.readInt();
                        rowCnt = 0;
                        byteMode = false;
                        continue block17;
                    }
                    case 7: {
                        int count = is.readInt();
                        if (byteMode) {
                            is.readFully(bytes, rowCnt, count);
                        } else {
                            count += rowCnt;
                            int i = rowCnt;
                            while (i < count) {
                                ints[i] = is.readInt();
                                ++i;
                            }
                        }
                        rowCnt = count;
                        continue block17;
                    }
                    case 6: {
                        int count = is.readInt();
                        count += rowCnt;
                        if (byteMode) {
                            Arrays.fill(bytes, rowCnt, count, is.readByte());
                        } else {
                            Arrays.fill(ints, rowCnt, count, is.readInt());
                        }
                        rowCnt = count;
                        continue block17;
                    }
                    case 8: {
                        int status = is.readInt();
                        switch (status) {
                            case 1: 
                            case 2: {
                                if (imageData == null) {
                                    imageData = new ImageData(width, height, depth, palette);
                                    if (transparentPixel != -1) {
                                        imageData.transparentPixel = transparentPixel;
                                    }
                                } else if (rowCnt > 0) {
                                    if (byteMode) {
                                        imageData.setPixels(0, y, rowCnt, bytes, 0);
                                    } else {
                                        imageData.setPixels(0, y, rowCnt, ints, 0);
                                    }
                                }
                                this.fDataCollectedRunnable.imageData(imageData, status);
                                this.fDataCollectedRunnable = null;
                                return;
                            }
                            case 3: {
                                this.fDataCollectedRunnable.imageData(null, status);
                                this.fDataCollectedRunnable = null;
                                return;
                            }
                        }
                        this.fDataCollectedRunnable.imageNotCollected(status);
                        this.fDataCollectedRunnable = null;
                        return;
                    }
                }
                break;
            }
            throw new IOException("Invalid cmd=" + cmd);
        }
        catch (EOFException eOFException) {
            if (!this.isCollectingData()) return;
            this.fDataCollectedRunnable.imageNotCollected(4);
            this.fDataCollectedRunnable = null;
            return;
        }
        catch (IOException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            this.fDataCollectedRunnable.imageNotCollected(4);
            this.fDataCollectedRunnable = null;
        }
    }

    public static interface DataCollectedRunnable {
        public void imageData(ImageData var1, int var2);

        public void imageNotCollected(int var1);

        public void imageException(ThrowableProxy var1);
    }
}

