/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.text.MessageFormat;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.swt.SWTConstants;
import org.eclipse.ve.internal.swt.SWTMessages;

public class ItemChildTreeLabelDecorator
implements ILabelDecorator {
    protected EReference sfItemText;
    private ListenerList listeners = new ListenerList(1);
    private Adapter itemAdapter;
    protected EObject tab;

    public ItemChildTreeLabelDecorator(EObject tab) {
        this.initializeSFs(tab);
        this.tab = tab;
        if (tab != null) {
            tab.eAdapters().add((Object)this.getTabAdapter());
        }
    }

    private Adapter getTabAdapter() {
        if (this.itemAdapter == null) {
            this.itemAdapter = new Adapter(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeature() == ItemChildTreeLabelDecorator.this.sfItemText) {
                        ItemChildTreeLabelDecorator.this.fireLabelProviderChanged();
                    }
                }

                public Notifier getTarget() {
                    return null;
                }

                public void setTarget(Notifier newTarget) {
                }

                public boolean isAdapterForType(Object type) {
                    return false;
                }
            };
        }
        return this.itemAdapter;
    }

    protected void fireLabelProviderChanged() {
        Object[] listeners = this.listeners.getListeners();
        final LabelProviderChangedEvent labelProviderChangeEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        int i = 0;
        while (i < listeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(labelProviderChangeEvent);
                }
            });
            ++i;
        }
    }

    public void initializeSFs(EObject component) {
        ResourceSet rset = component.eResource().getResourceSet();
        if (this.sfItemText == null) {
            this.sfItemText = JavaInstantiation.getReference((ResourceSet)rset, (URI)SWTConstants.SF_ITEM_TEXT);
        }
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public String decorateText(String text, Object element) {
        String title;
        IJavaObjectInstance tabTitle;
        if (element == null) {
            return "";
        }
        if (!(element instanceof IJavaObjectInstance)) {
            return element.toString();
        }
        IJavaObjectInstance component = (IJavaObjectInstance)element;
        if (this.tab != null && BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component).isBeanProxyInstantiated() && (tabTitle = (IJavaObjectInstance)this.tab.eGet((EStructuralFeature)this.sfItemText)) != null && (title = BeanProxyUtilities.getBeanProxy((IJavaInstance)tabTitle).toBeanString()) != null) {
            text = MessageFormat.format(SWTMessages.ItemChildTreeLabelDecorator_Tab_Text, text, title);
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void dispose() {
        if (this.tab != null) {
            this.tab.eAdapters().remove((Object)this.getTabAdapter());
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }
}

