/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ve.internal.swt.SWTContainer;
import org.eclipse.ve.internal.swt.SWTMessages;

public class SWTContainerWizardContent
extends Composite {
    private Button jFaceCheckButton = null;
    private Group group = null;
    private Button ideRadio = null;
    private Button pdeRadio = null;
    private Button customRadio = null;
    private Text customDir = null;
    private Label platformVersion = null;
    private Label pdeVersion = null;
    private Button browseButton = null;
    private WizardPage wizard = null;
    private SWTContainer.ContainerType containerType = null;

    private void createGroup() {
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.numColumns = 2;
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 2;
        gridData1.horizontalIndent = 20;
        this.group = new Group((Composite)this, 0);
        this.group.setText(SWTMessages.SWTContainerWizardContent_0);
        this.group.setLayoutData((Object)gridData2);
        this.group.setLayout((Layout)gridLayout4);
        this.ideRadio = new Button((Composite)this.group, 16);
        this.ideRadio.setText(SWTMessages.SWTContainerWizardContent_1);
        this.ideRadio.setToolTipText(SWTMessages.SWTContainerWizardContent_2);
        this.platformVersion = new Label((Composite)this.group, 0);
        this.pdeRadio = new Button((Composite)this.group, 16);
        this.pdeRadio.setText(SWTMessages.SWTContainerWizardContent_3);
        this.pdeRadio.setToolTipText(SWTMessages.SWTContainerWizardContent_4);
        this.pdeVersion = new Label((Composite)this.group, 0);
        this.customRadio = new Button((Composite)this.group, 16);
        this.customRadio.setText(SWTMessages.SWTContainerWizardContent_5);
        this.customRadio.setToolTipText(SWTMessages.SWTContainerWizardContent_6);
        new Label((Composite)this.group, 0);
        this.customDir = new Text((Composite)this.group, 2048);
        this.customDir.setToolTipText(SWTMessages.SWTContainerWizardContent_7);
        this.customDir.setEditable(false);
        this.customDir.setLayoutData((Object)gridData1);
        this.browseButton = new Button((Composite)this.group, 0);
        this.browseButton.setText(SWTMessages.SWTContainerWizardContent_8);
        this.browseButton.setEnabled(false);
        this.pdeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SWTContainerWizardContent.this.pdeRadio.getSelection()) {
                    SWTContainerWizardContent.this.setPDE(false);
                    SWTContainerWizardContent.this.containerType.setPathType(2, true);
                }
            }
        });
        this.ideRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SWTContainerWizardContent.this.ideRadio.getSelection()) {
                    SWTContainerWizardContent.this.setPlatform(false);
                    SWTContainerWizardContent.this.containerType.setPathType(4, true);
                }
            }
        });
        this.customRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTContainerWizardContent.this.browseButton.setEnabled(SWTContainerWizardContent.this.customRadio.getSelection());
                if (SWTContainerWizardContent.this.customRadio.getSelection()) {
                    SWTContainerWizardContent.this.setCustom(false);
                    SWTContainerWizardContent.this.containerType.setPathType(1, true);
                }
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Path[] current = new Path[]{new Path(SWTContainerWizardContent.this.containerType.getCustomPath())};
                IPath[] paths = BuildPathDialogAccess.chooseVariableEntries((Shell)SWTContainerWizardContent.this.getShell(), (IPath[])current);
                if (paths != null && paths.length > 0) {
                    SWTContainerWizardContent.this.containerType.setCustomPath(paths[0].toPortableString());
                    SWTContainerWizardContent.this.setCustom(false);
                }
            }
        });
        this.customDir.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SWTContainerWizardContent.this.containerType.setCustomPath(SWTContainerWizardContent.this.customDir.getText());
            }
        });
    }

    public SWTContainerWizardContent(Composite parent, int style, WizardPage page) {
        super(parent, style);
        this.wizard = page;
        this.initialize();
    }

    private void initialize() {
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 1;
        gridData3.verticalAlignment = 2;
        this.setLayout((Layout)new GridLayout());
        this.createGroup();
        this.setSize(new Point(300, 200));
        this.jFaceCheckButton = new Button((Composite)this, 32);
        this.jFaceCheckButton.setText(SWTMessages.SWTContainerWizardPage_includeJFaceCheck);
        this.jFaceCheckButton.setToolTipText(SWTMessages.SWTContainerWizardContent_9);
        this.jFaceCheckButton.setLayoutData((Object)gridData3);
        this.jFaceCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTContainerWizardContent.this.containerType.setPathType(16, SWTContainerWizardContent.this.jFaceCheckButton.getSelection());
            }
        });
    }

    public SWTContainer.ContainerType getContainerType() {
        return this.containerType;
    }

    protected void setPlatform(boolean setSelection) {
        if (setSelection) {
            this.ideRadio.setSelection(true);
        }
        this.platformVersion.setText(this.containerType.getPlatformVersion());
        this.customDir.setText(this.containerType.getPlatformPath());
        this.customDir.setToolTipText(this.containerType.getPlatformPath());
        this.jFaceCheckButton.setSelection(this.containerType.includeJFace());
        this.jFaceCheckButton.setEnabled(true);
        this.setError(null);
        this.wizard.setMessage(SWTMessages.SWTContainerWizardContent_10, 1);
        this.group.layout();
    }

    protected void setPDE(boolean setSelection) {
        if (setSelection) {
            this.pdeRadio.setSelection(true);
        }
        this.pdeVersion.setText(this.containerType.getPdeVersion());
        this.customDir.setText(this.containerType.getPdePath());
        this.customDir.setToolTipText(this.containerType.getPdePath());
        this.jFaceCheckButton.setSelection(this.containerType.includeJFace());
        this.jFaceCheckButton.setEnabled(true);
        this.setError(null);
        this.wizard.setMessage(SWTMessages.SWTContainerWizardContent_11, 1);
        this.group.layout();
    }

    protected void setError(String err) {
        if (err == null) {
            this.wizard.setPageComplete(true);
            this.wizard.setErrorMessage(null);
        } else {
            this.wizard.setPageComplete(false);
            this.wizard.setErrorMessage(err);
        }
    }

    protected void setCustom(boolean setSelection) {
        File f;
        IPath resolvedPath;
        if (setSelection) {
            this.customRadio.setSelection(true);
        }
        if ((resolvedPath = JavaCore.getResolvedVariablePath((IPath)new Path(this.containerType.getCustomPath()))) == null) {
            resolvedPath = new Path("");
        }
        if ((f = resolvedPath.toFile()).exists() && f.isDirectory()) {
            this.setError(null);
            this.wizard.setMessage(SWTMessages.SWTContainerWizardContent_13, 1);
        } else {
            this.setError(SWTMessages.SWTContainerWizardContent_14);
        }
        this.jFaceCheckButton.setSelection(false);
        this.jFaceCheckButton.setEnabled(false);
        this.customDir.setText(resolvedPath.toOSString());
        this.customDir.setToolTipText(resolvedPath.toOSString());
        this.browseButton.setEnabled(true);
        this.group.layout();
    }

    public void setContainerType(SWTContainer.ContainerType containerType) {
        this.containerType = containerType;
        if (containerType.isPDEPath()) {
            this.setPDE(true);
            this.platformVersion.setText(containerType.getPlatformVersion());
        } else if (containerType.isPlatformPath()) {
            this.setPlatform(true);
            this.pdeVersion.setText(containerType.getPdeVersion());
        } else {
            this.setCustom(true);
            this.pdeVersion.setText(containerType.getPdeVersion());
            this.platformVersion.setText(containerType.getPlatformVersion());
        }
        this.jFaceCheckButton.setSelection(containerType.includeJFace());
    }
}

