/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.ContentPaneFigure;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.EditPartRunnable;
import org.eclipse.ve.internal.cde.core.FlowLayoutEditPolicy;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.emf.EditPartAdapterRunnable;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.ControlGraphicalEditPart;
import org.eclipse.ve.internal.swt.SWTConstants;
import org.eclipse.ve.internal.swt.TableColumnGraphicalEditPart;
import org.eclipse.ve.internal.swt.TableContainerPolicy;

public class TableGraphicalEditPart
extends ControlGraphicalEditPart {
    private IBeanProxyHost beanProxyProxyAdapter;
    private EStructuralFeature sfColumns;
    private TableImageListener fImageListener;
    protected FigureListener hostFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            TableGraphicalEditPart.this.refreshColumns();
        }
    };
    private Adapter tableAdapter = new EditPartAdapterRunnable((EditPart)this){

        protected void doRun() {
            TableGraphicalEditPart.this.refreshChildren();
        }

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == TableGraphicalEditPart.this.sfColumns) {
                this.queueExec((EditPart)TableGraphicalEditPart.this, "COLUMNS");
            }
        }
    };
    private Runnable fRefreshColumnsRunnable = new EditPartRunnable((EditPart)this){

        protected void doRun() {
            if (TableGraphicalEditPart.this.getBeanProxyAdapter().isBeanProxyInstantiated()) {
                IArrayBeanProxy columnRectsProxy = BeanSWTUtilities.invoke_Table_getAllColumnRects(TableGraphicalEditPart.this.getBeanProxyAdapter().getBeanProxy());
                if (columnRectsProxy != null) {
                    try {
                        IBeanProxy[] columnRects = columnRectsProxy.getSnapshot();
                        List children = TableGraphicalEditPart.this.getChildren();
                        int i = 0;
                        while (i < children.size()) {
                            TableColumnGraphicalEditPart columnEP = (TableColumnGraphicalEditPart)((Object)children.get(i));
                            IBeanProxyHost columnProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)columnEP.getModel()));
                            if (!columnProxyHost.isBeanProxyInstantiated()) {
                                columnEP.getFigure().setVisible(false);
                            } else {
                                IBeanProxy cpProxy = columnProxyHost.getBeanProxy();
                                boolean found = false;
                                int cpi = 0;
                                while (cpi < columnRects.length) {
                                    if (columnRects[cpi].sameAs(cpProxy)) {
                                        int ii = cpi;
                                        Rectangle bounds = new Rectangle();
                                        bounds.x = ((IIntegerBeanProxy)columnRects[++ii]).intValue();
                                        bounds.y = ((IIntegerBeanProxy)columnRects[++ii]).intValue();
                                        bounds.width = ((IIntegerBeanProxy)columnRects[++ii]).intValue();
                                        bounds.height = ((IIntegerBeanProxy)columnRects[++ii]).intValue();
                                        TableGraphicalEditPart.this.setLayoutConstraint((EditPart)columnEP, columnEP.getFigure(), bounds);
                                        found = true;
                                        break;
                                    }
                                    cpi += 5;
                                }
                                columnEP.getFigure().setVisible(found);
                            }
                            ++i;
                        }
                    }
                    catch (ThrowableProxy e) {
                        JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                    }
                } else {
                    List children = TableGraphicalEditPart.this.getChildren();
                    int i = 0;
                    while (i < children.size()) {
                        ((TableColumnGraphicalEditPart)((Object)children.get(i))).getFigure().setVisible(false);
                        ++i;
                    }
                }
            }
        }
    };

    public TableGraphicalEditPart(Object aModel) {
        super(aModel);
    }

    protected TableImageListener getTableImageListener() {
        if (this.fImageListener == null) {
            this.fImageListener = new TableImageListener();
        }
        return this.fImageListener;
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.refreshColumns();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshColumns();
    }

    public void activate() {
        super.activate();
        ((EObject)this.getModel()).eAdapters().add((Object)this.tableAdapter);
        this.getFigure().addFigureListener(this.hostFigureListener);
        this.getVisualComponent().addImageListener((IImageListener)this.getTableImageListener());
    }

    public void deactivate() {
        super.deactivate();
        ((EObject)this.getModel()).eAdapters().remove((Object)this.tableAdapter);
        this.getFigure().removeFigureListener(this.hostFigureListener);
        this.getVisualComponent().removeImageListener((IImageListener)this.getTableImageListener());
        this.beanProxyProxyAdapter = null;
    }

    protected IFigure createFigure() {
        ContentPaneFigure cfig = (ContentPaneFigure)super.createFigure();
        cfig.getContentPane().setLayoutManager((LayoutManager)new XYLayout());
        return cfig;
    }

    protected void createEditPolicies() {
        EditDomain domain = EditDomain.getEditDomain((EditPart)this);
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new FlowLayoutEditPolicy((ContainerPolicy)new TableContainerPolicy(domain), Boolean.TRUE));
    }

    protected List getModelChildren() {
        return (List)this.getBean().eGet(this.sfColumns);
    }

    protected EditPart createChild(Object child) {
        TableColumnGraphicalEditPart result = new TableColumnGraphicalEditPart();
        result.setModel(child);
        return result;
    }

    protected IBeanProxyHost getBeanProxyAdapter() {
        if (this.beanProxyProxyAdapter == null) {
            this.beanProxyProxyAdapter = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaObjectInstance)this.getModel()));
        }
        return this.beanProxyProxyAdapter;
    }

    private void refreshColumns() {
        if (this.getChildren().size() == 0) {
            return;
        }
        CDEUtilities.displayExec((EditPart)this, (Object)"REFRESH_COLUMNS", (Runnable)this.fRefreshColumnsRunnable);
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.sfColumns = JavaInstantiation.getSFeature((ResourceSet)((EObject)model).eClass().eResource().getResourceSet(), (URI)SWTConstants.SF_TABLE_COLUMNS);
    }

    protected class TableImageListener
    implements IImageListener {
        protected TableImageListener() {
        }

        public void imageChanged(ImageData imageData) {
            TableGraphicalEditPart.this.refreshColumns();
        }
    }
}

