/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.swt.CompositeContainerPolicy;
import org.eclipse.ve.internal.swt.SWTConstants;

public class ViewFormContainerPolicy
extends CompositeContainerPolicy {
    EReference sfLeftControl;
    EReference sfRightControl;
    EReference sfCenterControl;
    EReference sfContentControl;

    public ViewFormContainerPolicy(EditDomain domain) {
        super(domain);
        ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)domain);
        this.sfLeftControl = JavaInstantiation.getReference((ResourceSet)rset, (URI)SWTConstants.SF_VIEWFORM_TOPLEFT);
        this.sfRightControl = JavaInstantiation.getReference((ResourceSet)rset, (URI)SWTConstants.SF_VIEWFORM_TOPRIGHT);
        this.sfCenterControl = JavaInstantiation.getReference((ResourceSet)rset, (URI)SWTConstants.SF_VIEWFORM_TOPCENTER);
        this.sfContentControl = JavaInstantiation.getReference((ResourceSet)rset, (URI)SWTConstants.SF_VIEWFORM_CONTENT);
    }

    protected boolean isValidChild(Object child, EStructuralFeature containmentSF) {
        if (!super.isValidChild(child, containmentSF)) {
            return false;
        }
        IJavaObjectInstance viewFormBean = (IJavaObjectInstance)this.getContainer();
        IJavaInstance left = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfLeftControl);
        IJavaInstance right = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfRightControl);
        IJavaInstance center = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfCenterControl);
        IJavaInstance content = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfContentControl);
        return left == null || right == null || center == null || content == null;
    }

    protected Command getDeleteDependentCommand(Object child, EStructuralFeature containmentSF) {
        IJavaObjectInstance viewFormBean = (IJavaObjectInstance)this.getContainer();
        IJavaInstance left = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfLeftControl);
        IJavaInstance right = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfRightControl);
        IJavaInstance center = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfCenterControl);
        IJavaInstance content = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfContentControl);
        EObject parent = (EObject)this.getContainer();
        CommandBuilder cBld = new CommandBuilder("");
        if (left != null && left.equals(child)) {
            cBld.applyAttributeSetting(parent, (EStructuralFeature)this.sfLeftControl, null);
        } else if (center != null && center.equals(child)) {
            cBld.applyAttributeSetting(parent, (EStructuralFeature)this.sfCenterControl, null);
        } else if (right != null && right.equals(child)) {
            cBld.applyAttributeSetting(parent, (EStructuralFeature)this.sfRightControl, null);
        } else if (content != null && content.equals(child)) {
            cBld.applyAttributeSetting(parent, (EStructuralFeature)this.sfContentControl, null);
        }
        Command removeContent = cBld.getCommand();
        if (removeContent != null) {
            return removeContent.chain(super.getDeleteDependentCommand(child, containmentSF));
        }
        return super.getDeleteDependentCommand(child, containmentSF);
    }

    protected Command getOrphanTheChildrenCommand(List children) {
        Command orphanCmd = super.getOrphanTheChildrenCommand(children);
        if (orphanCmd == null || !orphanCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        IJavaObjectInstance viewFormBean = (IJavaObjectInstance)this.getContainer();
        IJavaInstance left = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfLeftControl);
        IJavaInstance right = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfRightControl);
        IJavaInstance center = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfCenterControl);
        IJavaInstance content = (IJavaInstance)viewFormBean.eGet((EStructuralFeature)this.sfContentControl);
        EObject parent = (EObject)this.getContainer();
        CommandBuilder cBld = new CommandBuilder("");
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (left != null && left.equals(child)) {
                cBld.cancelAttributeSetting(parent, (EStructuralFeature)this.sfLeftControl);
                continue;
            }
            if (center != null && center.equals(child)) {
                cBld.cancelAttributeSetting(parent, (EStructuralFeature)this.sfCenterControl);
                continue;
            }
            if (right != null && right.equals(child)) {
                cBld.cancelAttributeSetting(parent, (EStructuralFeature)this.sfRightControl);
                continue;
            }
            if (content == null || !content.equals(child)) continue;
            cBld.cancelAttributeSetting(parent, (EStructuralFeature)this.sfContentControl);
        }
        if (!cBld.isEmpty()) {
            cBld.append(orphanCmd);
            return cBld.getCommand();
        }
        return orphanCmd;
    }
}

