/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ve.internal.swt.ViewFormLayoutPolicyHelper;

public class ViewFormLayoutFeedback
extends RectangleFigure {
    protected int fLineWidth = 1;
    protected int fLineStyle = 4;
    private String[] filledRegions;
    private static final String TOP_LEFT_CONTROL = "Top Left";
    private static final String TOP_RIGHT_CONTROL = "Top Right";
    private static final String TOP_CENTER_CONTROL = "Top Center";
    private static final String CONTENT_CONTROL = "Content";

    public void fillShape(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        if (this.getFilledRegions() != null) {
            Rectangle leftRect = new Rectangle(r.x, r.y, r.width / 3, r.height / 3);
            Rectangle centerRect = new Rectangle(r.x + r.width / 3, r.y, r.width / 3, r.height / 3);
            Rectangle rightRect = new Rectangle(r.x + 2 * r.width / 3, r.y, r.width / 3, r.height / 3);
            Rectangle contentRect = new Rectangle(r.x, r.y + r.height / 3, r.width, 2 * r.height / 3);
            g.setBackgroundColor(ColorConstants.gray);
            g.setXORMode(true);
            int i = 0;
            while (i < this.getFilledRegions().length) {
                if (this.getFilledRegions()[i].equals(ViewFormLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(0))) {
                    g.fillRectangle(leftRect);
                }
                if (this.getFilledRegions()[i].equals(ViewFormLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(2))) {
                    g.fillRectangle(centerRect);
                }
                if (this.getFilledRegions()[i].equals(ViewFormLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(1))) {
                    g.fillRectangle(rightRect);
                }
                if (this.getFilledRegions()[i].equals(ViewFormLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(3))) {
                    g.fillRectangle(contentRect);
                }
                ++i;
            }
        }
        g.setForegroundColor(ColorConstants.green);
        g.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
        g.drawLine(r.x, r.y + r.height / 3, r.x + r.width - 1, r.y + r.height / 3);
        g.drawLine(r.x + r.width / 3 - 1, r.y, r.x + r.width / 3 - 1, r.y + r.height / 3);
        g.drawLine(r.x + 2 * r.width / 3 - 1, r.y, r.x + 2 * r.width / 3 - 1, r.y + r.height / 3);
    }

    public String getCurrentConstraint(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.getBounds().getCopy();
        Rectangle leftRect = new Rectangle(r.x, r.y, r.width / 3, r.height / 3);
        Rectangle centerRect = new Rectangle(r.x + r.width / 3, r.y, r.width / 3, r.height / 3);
        Rectangle rightRect = new Rectangle(r.x + 2 * r.width / 3, r.y, r.width / 3, r.height / 3);
        Rectangle contentRect = new Rectangle(r.x, r.y + r.height / 3, r.width, 2 * r.height / 3);
        if (leftRect.contains(p)) {
            return TOP_LEFT_CONTROL;
        }
        if (centerRect.contains(p)) {
            return TOP_CENTER_CONTROL;
        }
        if (rightRect.contains(p)) {
            return TOP_RIGHT_CONTROL;
        }
        if (contentRect.contains(p)) {
            return CONTENT_CONTROL;
        }
        return null;
    }

    public Rectangle getCurrentRectangle(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.getBounds().getCopy();
        Rectangle leftRect = new Rectangle(r.x, r.y, r.width / 3, r.height / 3);
        Rectangle centerRect = new Rectangle(r.x + r.width / 3, r.y, r.width / 3, r.height / 3);
        Rectangle rightRect = new Rectangle(r.x + 2 * r.width / 3, r.y, r.width / 3, r.height / 3);
        Rectangle contentRect = new Rectangle(r.x, r.y + r.height / 3, r.width, 2 * r.height / 3);
        if (leftRect.contains(p)) {
            return leftRect;
        }
        if (centerRect.contains(p)) {
            return centerRect;
        }
        if (rightRect.contains(p)) {
            return rightRect;
        }
        if (contentRect.contains(p)) {
            return contentRect;
        }
        return null;
    }

    public static String getDisplayConstraint(String constraint) {
        int ndx = ViewFormLayoutPolicyHelper.REAL_INTERNAL_TAGS.indexOf(constraint);
        return ndx > -1 ? (String)ViewFormLayoutPolicyHelper.DISPLAY_TAGS.get(ndx) : "";
    }

    protected String[] getFilledRegions() {
        return this.filledRegions;
    }

    public int getLineWidth() {
        return this.fLineWidth;
    }

    public void setFilledRegions(String[] newFilledRegions) {
        this.filledRegions = newFilledRegions;
        this.invalidate();
    }

    public void setLineStyle(int newLineStyle) {
        this.fLineStyle = newLineStyle;
    }

    public void setLineWidth(int newLineWidth) {
        this.fLineWidth = newLineWidth;
    }
}

