/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.internal.beaninfo.BeanDecorator;
import org.eclipse.jem.internal.beaninfo.common.FeatureAttributeValue;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.ImplicitAllocation;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTInfixExpression;
import org.eclipse.jem.internal.instantiation.PTInfixOperator;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ve.internal.java.core.BasicAllocationProcesser;
import org.eclipse.ve.internal.java.core.BeanPropertySourceAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.EnumeratedIntValueCellEditor;
import org.eclipse.ve.internal.java.core.EnumeratedIntValueLabelProvider;
import org.eclipse.ve.internal.java.core.IAllocationProcesser;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.JCMPackage;
import org.eclipse.ve.internal.propertysheet.EToolsPropertyDescriptor;
import org.eclipse.ve.internal.swt.SWTMessages;
import org.eclipse.ve.internal.swt.SwtPlugin;
import org.eclipse.ve.internal.swt.WidgetProxyAdapter;

public class WidgetPropertySourceAdapter
extends BeanPropertySourceAdapter {
    private static String[] EXPERT_FILTER_FLAGS = new String[]{"org.eclipse.ui.views.properties.expert"};
    private static final Object SWEET_STYLE_ID = "org.eclipse.ve.sweet.stylebits";
    protected static final String SWT_TYPE_ID = "org.eclipse.swt.SWT";
    protected static final String STYLE_NONE = "NONE";
    protected static final int STYLE_NOT_SET = -1;
    protected static final Integer STYLE_NOT_SET_INTEGER = new Integer(-1);
    private static final String STYLE_NOT_SET_INITSTRING = String.valueOf(-1);
    static final String[] UNKNOWN = new String[]{"???", "???"};
    private WidgetProxyAdapter widgetProxyAdapter;
    private int explicitStyle = -1;

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] propertyDescriptors = super.getPropertyDescriptors();
        ArrayList<IPropertyDescriptor> descriptorsList = new ArrayList<IPropertyDescriptor>(propertyDescriptors.length + 5);
        int i = 0;
        while (i < propertyDescriptors.length) {
            descriptorsList.add(propertyDescriptors[i]);
            ++i;
        }
        if (((EObject)this.getTarget()).eContainmentFeature() != JCMPackage.eINSTANCE.getBeanSubclassComposition_ThisPart() && !(((IJavaInstance)this.getTarget()).getAllocation() instanceof ImplicitAllocation)) {
            this.mergeStyleBits(descriptorsList, (JavaClass)this.getBean().getJavaType());
        }
        return descriptorsList.toArray(new IPropertyDescriptor[descriptorsList.size()]);
    }

    protected void mergeStyleBits(List propertyDescriptors, JavaClass jClass) {
        StyleBitPropertyDescriptor[] styleDescriptors = WidgetPropertySourceAdapter.getStyleDescriptors((JavaHelpers)jClass);
        while (styleDescriptors == null || styleDescriptors.length == 0) {
            if ((jClass = jClass.getSupertype()) == null) {
                return;
            }
            styleDescriptors = WidgetPropertySourceAdapter.getStyleDescriptors((JavaHelpers)jClass);
        }
        if (styleDescriptors != null) {
            int i = 0;
            while (i < styleDescriptors.length) {
                propertyDescriptors.add(styleDescriptors[i]);
                ++i;
            }
        }
    }

    public static StyleBitPropertyDescriptor[] getStyleDescriptors(JavaHelpers jType) {
        BeanDecorator beanDecorator = Utilities.getBeanDecorator((EModelElement)jType);
        if (beanDecorator != null) {
            FeatureAttributeValue value = (FeatureAttributeValue)beanDecorator.getAttributes().get(SWEET_STYLE_ID);
            try {
                if (value != null) {
                    if (value.getInternalValue() != null) {
                        return (StyleBitPropertyDescriptor[])value.getInternalValue();
                    }
                    if (value.getValue() != null) {
                        Object[] outerArray = (Object[])value.getValue();
                        StyleBitPropertyDescriptor[] styleDescriptors = new StyleBitPropertyDescriptor[outerArray.length];
                        int i = 0;
                        while (i < outerArray.length) {
                            Object[] innerArray = (Object[])outerArray[i];
                            String propertyName = (String)innerArray[0];
                            String displayName = (String)innerArray[1];
                            boolean expert = (Boolean)innerArray[2];
                            Object[] triplicateArray = (Object[])innerArray[3];
                            int numberOfValues = triplicateArray.length / 3;
                            String[] names = new String[numberOfValues];
                            String[] initStrings = new String[numberOfValues];
                            Number[] values = new Number[numberOfValues];
                            int j = 0;
                            int index = 0;
                            while (j < triplicateArray.length) {
                                names[index] = (String)triplicateArray[j];
                                initStrings[index] = (String)triplicateArray[j + 1];
                                values[index] = (Number)triplicateArray[j + 2];
                                j += 3;
                                ++index;
                            }
                            SweetStyleBits styleBits = new SweetStyleBits(propertyName, displayName, expert, names, initStrings, values);
                            styleDescriptors[i] = new StyleBitPropertyDescriptor(styleBits);
                            ++i;
                        }
                        value.setInternalValue((Object)styleDescriptors);
                        return styleDescriptors;
                    }
                }
            }
            catch (ClassCastException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
            }
        }
        return null;
    }

    protected WidgetProxyAdapter getWidgetProxyAdapter() {
        if (this.widgetProxyAdapter == null) {
            this.widgetProxyAdapter = (WidgetProxyAdapter)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.getBean());
        }
        return this.widgetProxyAdapter;
    }

    public Object getPropertyValue(Object descriptorID) {
        if (descriptorID instanceof EStructuralFeature) {
            return super.getPropertyValue(descriptorID);
        }
        if (descriptorID instanceof StyleBitPropertyID) {
            int currentStyleValue = this.getWidgetProxyAdapter().getStyle();
            Number[] availableValues = ((StyleBitPropertyID)((StyleBitPropertyID)descriptorID)).propertyDescriptor.fValues;
            int i = 0;
            while (i < availableValues.length) {
                if ((availableValues[i].intValue() & currentStyleValue) == availableValues[i].intValue()) {
                    return availableValues[i];
                }
                ++i;
            }
            return STYLE_NOT_SET_INTEGER;
        }
        return "???";
    }

    public boolean isPropertySet(Object descriptorID) {
        if (descriptorID instanceof EStructuralFeature) {
            return super.isPropertySet(descriptorID);
        }
        if (descriptorID instanceof StyleBitPropertyID) {
            int currentValue = ((Number)this.getPropertyValue(descriptorID)).intValue();
            if (currentValue == -1) {
                return false;
            }
            return (currentValue & this.getExplicitStyle()) != 0;
        }
        return false;
    }

    protected int getExplicitStyle() {
        if (this.explicitStyle == -1) {
            PTExpression styleExpression;
            IBeanProxy styleBeanProxy = null;
            if (this.getBean().getAllocation() instanceof ParseTreeAllocation && (styleExpression = this.getStyleExpression(((ParseTreeAllocation)this.getBean().getAllocation()).getExpression())) != null) {
                try {
                    styleBeanProxy = BasicAllocationProcesser.instantiateWithExpression((PTExpression)styleExpression, (IBeanProxyDomain)this.getWidgetProxyAdapter().getBeanProxyDomain());
                    if (styleBeanProxy != null && !(styleBeanProxy instanceof INumberBeanProxy)) {
                        styleBeanProxy.getProxyFactoryRegistry().releaseProxy(styleBeanProxy);
                        styleBeanProxy = null;
                    }
                }
                catch (IAllocationProcesser.AllocationException e) {
                    SwtPlugin.getDefault().getLogger().log(e.getCause(), Level.INFO);
                }
            }
            this.explicitStyle = styleBeanProxy != null ? ((INumberBeanProxy)styleBeanProxy).intValue() : 0;
        }
        return this.explicitStyle;
    }

    protected PTExpression getStyleExpression(PTExpression allocationExp) {
        PTClassInstanceCreation classInstanceCreation;
        if (allocationExp instanceof PTClassInstanceCreation && (classInstanceCreation = (PTClassInstanceCreation)allocationExp).getArguments().size() == 2) {
            return (PTExpression)classInstanceCreation.getArguments().get(1);
        }
        return null;
    }

    public void resetPropertyValue(Object descriptorID) {
        if (!(descriptorID instanceof StyleBitPropertyID)) {
            super.resetPropertyValue(descriptorID);
        } else {
            this.setPropertyValue(descriptorID, null);
        }
    }

    protected boolean updateStyleBit(PTExpression current, StyleBitPropertyID id, int style) {
        PTInfixExpression infix;
        if (current instanceof PTFieldAccess) {
            PTFieldAccess field = (PTFieldAccess)current;
            if (this.isSameStyleFamily(field, id)) {
                this.updateField(field, id.getInitString(style));
                return true;
            }
            return false;
        }
        if (current instanceof PTInfixExpression && (infix = (PTInfixExpression)current).getOperator() == PTInfixOperator.OR_LITERAL) {
            if (this.updateStyleBit(infix.getLeftOperand(), id, style) || this.updateStyleBit(infix.getRightOperand(), id, style)) {
                return true;
            }
            if (!infix.getExtendedOperands().isEmpty()) {
                EList ext = infix.getExtendedOperands();
                int i = 0;
                while (i < ext.size()) {
                    if (this.updateStyleBit((PTExpression)ext.get(i), id, style)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected PTFieldAccess updateField(PTFieldAccess current, String[] updateTo) {
        if (current == null) {
            current = InstantiationFactory.eINSTANCE.createPTFieldAccess();
        }
        if (current.getReceiver() == null || !(current.getReceiver() instanceof PTName) || !((PTName)current.getReceiver()).getName().equals(updateTo[0])) {
            current.setReceiver((PTExpression)InstantiationFactory.eINSTANCE.createPTName(updateTo[0]));
        }
        current.setField(updateTo[1]);
        return current;
    }

    protected PTExpression addStyleBit(PTExpression current, StyleBitPropertyID id, int style) {
        if (this.updateStyleBit(current, id, style)) {
            return current;
        }
        PTFieldAccess field = this.updateField(null, id.getInitString(style));
        if (current == null) {
            return field;
        }
        if (current instanceof PTFieldAccess) {
            return InstantiationFactory.eINSTANCE.createPTInfixExpression(current, PTInfixOperator.OR_LITERAL, (PTExpression)field, null);
        }
        if (current instanceof PTInfixExpression) {
            if (((PTInfixExpression)current).getOperator() == PTInfixOperator.OR_LITERAL) {
                ((PTInfixExpression)current).getExtendedOperands().add((Object)field);
                return current;
            }
            return InstantiationFactory.eINSTANCE.createPTInfixExpression(current, PTInfixOperator.OR_LITERAL, (PTExpression)field, null);
        }
        return current;
    }

    protected PTExpression removeStyleBit(PTExpression styleExpression, StyleBitPropertyID id, int style) {
        if (styleExpression instanceof PTFieldAccess) {
            if (this.isSameStyleFamily((PTFieldAccess)styleExpression, id)) {
                return null;
            }
            return styleExpression;
        }
        if (styleExpression instanceof PTInfixExpression && ((PTInfixExpression)styleExpression).getOperator() == PTInfixOperator.OR_LITERAL) {
            int i;
            EList ext;
            PTInfixExpression infixExpression = (PTInfixExpression)styleExpression;
            if (infixExpression.getLeftOperand() instanceof PTFieldAccess && this.isSameStyleFamily((PTFieldAccess)infixExpression.getLeftOperand(), id)) {
                if (infixExpression.getExtendedOperands().isEmpty()) {
                    return infixExpression.getRightOperand();
                }
                infixExpression.setLeftOperand(infixExpression.getRightOperand());
                infixExpression.setRightOperand((PTExpression)infixExpression.getExtendedOperands().remove(0));
                return infixExpression;
            }
            if (infixExpression.getRightOperand() instanceof PTFieldAccess && this.isSameStyleFamily((PTFieldAccess)infixExpression.getRightOperand(), id)) {
                if (infixExpression.getExtendedOperands().isEmpty()) {
                    return infixExpression.getLeftOperand();
                }
                infixExpression.setRightOperand((PTExpression)infixExpression.getExtendedOperands().remove(0));
                return infixExpression;
            }
            if (!infixExpression.getExtendedOperands().isEmpty()) {
                ext = infixExpression.getExtendedOperands();
                i = 0;
                while (i < ext.size()) {
                    if (ext.get(i) instanceof PTFieldAccess && this.isSameStyleFamily((PTFieldAccess)ext.get(i), id)) {
                        ext.remove(i);
                        return infixExpression;
                    }
                    ++i;
                }
            }
            infixExpression.setLeftOperand(this.removeStyleBit(infixExpression.getLeftOperand(), id, style));
            infixExpression.setRightOperand(this.removeStyleBit(infixExpression.getRightOperand(), id, style));
            if (!infixExpression.getExtendedOperands().isEmpty()) {
                ext = infixExpression.getExtendedOperands();
                i = 0;
                while (i < ext.size()) {
                    ext.set(i, this.removeStyleBit((PTExpression)ext.get(i), id, style));
                    ++i;
                }
            }
            return infixExpression;
        }
        return styleExpression;
    }

    public void setPropertyValue(Object feature, Object val) {
        if (feature instanceof EStructuralFeature) {
            super.setPropertyValue(feature, val);
        } else if (feature instanceof StyleBitPropertyID) {
            PTExpression newAllocation;
            int intValue;
            StyleBitPropertyID propertyID = (StyleBitPropertyID)feature;
            int n = intValue = val != null ? ((INumberBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)val))).intValue() : -1;
            if (((Number)this.getPropertyValue(feature)).intValue() == intValue) {
                return;
            }
            JavaAllocation alloc = this.getBean().getAllocation();
            if (alloc instanceof ParseTreeAllocation && (newAllocation = this.getChangedAllocation(((ParseTreeAllocation)alloc).getExpression(), propertyID, intValue)) != null) {
                ParseTreeAllocation newParseTreeAlloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation();
                newParseTreeAlloc.setExpression(newAllocation);
                this.getBean().setAllocation((JavaAllocation)newParseTreeAlloc);
            }
        }
    }

    protected PTExpression getChangedAllocation(PTExpression allocationExpression, StyleBitPropertyID propertyID, int styleBit) {
        PTClassInstanceCreation classInstanceCreation;
        if (allocationExpression instanceof PTClassInstanceCreation && (classInstanceCreation = (PTClassInstanceCreation)allocationExpression).getArguments().size() >= 2) {
            PTExpression currentArg = (PTExpression)classInstanceCreation.getArguments().set(1, (Object)InstantiationFactory.eINSTANCE.createPTNullLiteral());
            PTExpression newArg = this.getChangedStyleExpression(currentArg, propertyID, styleBit);
            if (newArg == null) {
                PTName name = InstantiationFactory.eINSTANCE.createPTName(SWT_TYPE_ID);
                newArg = InstantiationFactory.eINSTANCE.createPTFieldAccess((PTExpression)name, STYLE_NONE);
            }
            classInstanceCreation.getArguments().set(1, (Object)newArg);
            return classInstanceCreation;
        }
        return null;
    }

    protected PTExpression getChangedStyleExpression(PTExpression styleExpression, StyleBitPropertyID propertyID, int style) {
        return style != -1 ? this.addStyleBit(styleExpression, propertyID, style) : this.removeStyleBit(styleExpression, propertyID, style);
    }

    private boolean isSameStyleFamily(PTFieldAccess existingField, StyleBitPropertyID propertyID) {
        if (existingField.getReceiver() instanceof PTName && SWT_TYPE_ID.equals(((PTName)existingField.getReceiver()).getName()) && STYLE_NONE.equals(existingField.getField())) {
            return true;
        }
        return propertyID.includeInitString(existingField);
    }

    protected boolean isSameStyleFamilySet(PTExpression expression, StyleBitPropertyID propertyID) {
        if (expression instanceof PTFieldAccess) {
            return this.isSameStyleFamily((PTFieldAccess)expression, propertyID);
        }
        if (expression instanceof PTInfixExpression && ((PTInfixExpression)expression).getOperator() == PTInfixOperator.OR_LITERAL) {
            PTInfixExpression infix = (PTInfixExpression)expression;
            if (this.isSameStyleFamily((PTFieldAccess)infix.getLeftOperand(), propertyID) || this.isSameStyleFamily((PTFieldAccess)infix.getRightOperand(), propertyID)) {
                return true;
            }
            if (!infix.getExtendedOperands().isEmpty()) {
                EList ext = infix.getExtendedOperands();
                int i = 0;
                while (i < ext.size()) {
                    if (this.isSameStyleFamily((PTFieldAccess)ext.get(i), propertyID)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected StyleBitPropertyID findFamily(String familyName) {
        IPropertyDescriptor[] properties = this.getPropertyDescriptors();
        int i = 0;
        while (i < properties.length) {
            StyleBitPropertyID id;
            if (properties[i].getId() instanceof StyleBitPropertyID && (id = (StyleBitPropertyID)properties[i].getId()).getFamilyName().equals(familyName)) {
                return id;
            }
            ++i;
        }
        return null;
    }

    public void notifyChanged(Notification msg) {
        if (msg.getFeature() == JavaInstantiation.getAllocationFeature((IJavaInstance)this.getBean())) {
            this.explicitStyle = -1;
        }
        super.notifyChanged(msg);
    }

    static class StyleBitPropertyID {
        private String[][] packagedInitStrings;
        private StyleBitPropertyDescriptor propertyDescriptor;

        StyleBitPropertyID() {
        }

        void setPropertyDescriptor(StyleBitPropertyDescriptor propertyDescriptor) {
            this.propertyDescriptor = propertyDescriptor;
        }

        public String getFamilyName() {
            return ((StyleBitPropertyDescriptor)this.propertyDescriptor).styleBits.fPropertyName;
        }

        public boolean includeInitString(PTFieldAccess existingField) {
            if (!(existingField.getReceiver() instanceof PTName)) {
                return false;
            }
            return this.getStyle(((PTName)existingField.getReceiver()).getName(), existingField.getField()) != -1;
        }

        public String[] getInitString(int val) {
            this.initializepackagedInitStrings();
            int i = 0;
            while (i < this.propertyDescriptor.fValues.length) {
                if (this.propertyDescriptor.fValues[i].intValue() == val) {
                    return this.packagedInitStrings[i];
                }
                ++i;
            }
            return UNKNOWN;
        }

        public int getStyle(String className, String fieldName) {
            this.initializepackagedInitStrings();
            int i = 0;
            while (i < this.packagedInitStrings.length) {
                if (this.packagedInitStrings[i][1].equals(fieldName) && this.packagedInitStrings[i][0].equals(className)) {
                    return this.propertyDescriptor.fValues[i].intValue();
                }
                ++i;
            }
            return -1;
        }

        private void initializepackagedInitStrings() {
            if (this.packagedInitStrings == null) {
                this.packagedInitStrings = new String[this.propertyDescriptor.fInitStrings.length][2];
                int i = 0;
                while (i < this.propertyDescriptor.fInitStrings.length) {
                    int lastDot = this.propertyDescriptor.fInitStrings[i].lastIndexOf(46);
                    if (lastDot != -1) {
                        this.packagedInitStrings[i][0] = this.propertyDescriptor.fInitStrings[i].substring(0, lastDot);
                        this.packagedInitStrings[i][1] = this.propertyDescriptor.fInitStrings[i].substring(lastDot + 1);
                    } else {
                        this.packagedInitStrings[i][0] = "";
                        this.packagedInitStrings[i][1] = this.propertyDescriptor.fInitStrings[i];
                    }
                    ++i;
                }
            }
        }
    }

    public static class StyleBitPropertyDescriptor
    extends EToolsPropertyDescriptor {
        String[] fNames;
        String[] fInitStrings;
        Number[] fValues;
        private ILabelProvider labelProvider;
        private final SweetStyleBits styleBits;

        public StyleBitPropertyDescriptor(SweetStyleBits styleBits) {
            super((Object)new StyleBitPropertyID(), styleBits.fPropertyName);
            ((StyleBitPropertyID)this.getId()).setPropertyDescriptor(this);
            this.styleBits = styleBits;
            if (styleBits.fNames.length != 1) {
                this.fNames = styleBits.fNames;
                this.fInitStrings = styleBits.fInitStrings;
                this.fValues = styleBits.fValues;
            } else {
                this.fNames = new String[]{styleBits.fNames[0], SWTMessages.WidgetPropertySourceAdapter_NotSet};
                this.fInitStrings = new String[]{styleBits.fInitStrings[0], STYLE_NOT_SET_INITSTRING};
                this.fValues = new Number[]{styleBits.fValues[0], STYLE_NOT_SET_INTEGER};
            }
        }

        public CellEditor createPropertyEditor(Composite parent) {
            return new EnumeratedIntValueCellEditor(parent, this.fNames, this.fValues, this.fInitStrings);
        }

        public ILabelProvider getLabelProvider() {
            if (this.labelProvider == null) {
                return new EnumeratedIntValueLabelProvider(this.fNames, this.fValues);
            }
            return this.labelProvider;
        }

        public String[] getFilterFlags() {
            return this.styleBits.fIsExpert ? EXPERT_FILTER_FLAGS : null;
        }

        public String getDisplayName() {
            return this.styleBits.fDisplayName;
        }
    }

    public static class SweetStyleBits {
        public String fPropertyName;
        public String fDisplayName;
        public boolean fIsExpert;
        public String[] fNames;
        public String[] fInitStrings;
        public Number[] fValues;

        public SweetStyleBits(String propertyName, String displayName, boolean isExpert, String[] names, String[] initStrings, Number[] values) {
            this.fPropertyName = propertyName;
            this.fDisplayName = displayName;
            this.fIsExpert = isExpert;
            this.fNames = names;
            this.fInitStrings = initStrings;
            this.fValues = values;
        }
    }
}

