/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.text.MessageFormat;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.eclipse.ve.internal.jfc.beaninfo.NamedColorChooserPanel;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class ColorPropertyEditor
extends JPanel {
    private static final long serialVersionUID = -8120038443381231652L;
    private boolean initialized = false;
    private JColorChooser colorChooser = null;
    private NamedColorChooserPanel namedPanel = null;
    private boolean previewEnabled = true;
    private JPanel emptyPanel = new JPanel();
    private Color value = null;
    private int namedTabPosition = 0;

    public void addChangeListener(ChangeListener listener) {
        this.getColorChooser().getSelectionModel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getColorChooser().getSelectionModel().removeChangeListener(listener);
    }

    private JColorChooser getColorChooser() {
        if (this.colorChooser == null) {
            Color oldSelected = (Color)UIManager.get("TabbedPane.selected");
            UIManager.put("TabbedPane.selected", SystemColor.control);
            this.colorChooser = this.value != null ? new JColorChooser(this.value) : new JColorChooser();
            UIManager.put("TabbedPane.selected", oldSelected);
            AbstractColorChooserPanel[] defaults = this.colorChooser.getChooserPanels();
            AbstractColorChooserPanel[] panels = new AbstractColorChooserPanel[defaults.length + 1];
            panels[this.namedTabPosition] = this.getNamedPanel();
            System.arraycopy(defaults, 0, panels, 1, defaults.length);
            this.colorChooser.setChooserPanels(panels);
            this.getNamedPanel().updateListSelection(this.value);
        }
        return this.colorChooser;
    }

    private NamedColorChooserPanel getNamedPanel() {
        if (this.namedPanel == null) {
            this.namedPanel = new NamedColorChooserPanel();
        }
        return this.namedPanel;
    }

    public void initialize() {
        if (!this.initialized) {
            LookAndFeel lnf = null;
            if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
                lnf = UIManager.getLookAndFeel();
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.getColorChooser();
            this.autoSelectTab();
            if (lnf != null) {
                try {
                    UIManager.setLookAndFeel(lnf);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.setLayout(new BorderLayout());
            this.add((Component)this.colorChooser, "Center");
            this.recursiveSetBackground(this, SystemColor.control);
            this.initialized = true;
        }
    }

    public void autoSelectTab() {
        JTabbedPane tp = this.findChildTabbedPane(this.getColorChooser());
        if (this.value == null || NamedColorChooserPanel.isBasicColor(this.value) || NamedColorChooserPanel.isSystemColor(this.value)) {
            tp.setSelectedIndex(this.namedTabPosition);
        } else {
            tp.setSelectedIndex(tp.getTabCount() - 1);
        }
    }

    public String getAsText() {
        if (this.value == null) {
            return "";
        }
        if (NamedColorChooserPanel.isBasicColor(this.value)) {
            return MessageFormat.format(VisualBeanInfoMessages.getString("ColorEditor.Color(String)"), NamedColorChooserPanel.getColorName(this.value));
        }
        if (NamedColorChooserPanel.isSystemColor(this.value)) {
            return MessageFormat.format(VisualBeanInfoMessages.getString("ColorEditor.SystemColor(String)"), NamedColorChooserPanel.getColorName(this.value));
        }
        return MessageFormat.format(VisualBeanInfoMessages.getString("ColorEditor.Color(int,int,int)"), new Integer(this.value.getRed()), new Integer(this.value.getGreen()), new Integer(this.value.getBlue()));
    }

    public String getJavaInitializationString() {
        if (this.value == null) {
            return "null";
        }
        if (NamedColorChooserPanel.isBasicColor(this.value)) {
            return this.getNamedPanel().getConstant(this.value);
        }
        if (NamedColorChooserPanel.isSystemColor(this.value)) {
            return this.getNamedPanel().getConstant(this.value);
        }
        int r = this.value.getRed();
        int g = this.value.getGreen();
        int b = this.value.getBlue();
        return "new java.awt.Color(" + r + "," + g + "," + b + ")";
    }

    public Object getValue() {
        if (this.colorChooser != null) {
            this.value = this.getColorChooser().getColor();
        }
        return this.value;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.getValue() != null) {
            gfx.drawRect(box.x, box.y, box.width, box.height);
            gfx.setColor((Color)this.getValue());
            gfx.fillRect(box.x, box.y, box.width, box.height);
        }
    }

    public void setValue(Object newValue) {
        if (newValue instanceof Color) {
            this.value = (Color)newValue;
            if (this.colorChooser != null) {
                this.getColorChooser().setColor(this.value);
                this.getNamedPanel().updateListSelection(this.value);
            }
        }
    }

    public void setPreviewEnabled(boolean doPreview) {
        if (doPreview) {
            this.getColorChooser().setPreviewPanel(null);
        } else {
            this.getColorChooser().setPreviewPanel(this.emptyPanel);
        }
        this.previewEnabled = doPreview;
    }

    public boolean getPreviewEnabled() {
        return this.previewEnabled;
    }

    private void recursiveSetBackground(Container parent, Color bgColor) {
        if (parent instanceof JList || parent instanceof JTextComponent) {
            return;
        }
        parent.setBackground(bgColor);
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container) {
                this.recursiveSetBackground((Container)children[i], bgColor);
            } else {
                children[i].setBackground(bgColor);
            }
            ++i;
        }
    }

    private JTabbedPane findChildTabbedPane(Container parent) {
        JTabbedPane retval = null;
        if (parent instanceof JTabbedPane) {
            return (JTabbedPane)parent;
        }
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length && retval == null) {
            if (children[i] instanceof Container) {
                retval = this.findChildTabbedPane((Container)children[i]);
            }
            ++i;
        }
        return retval;
    }
}

