/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;
import org.eclipse.ve.internal.jfc.beaninfo.FontPropertyEditor;

public class FontEditor
extends PropertyEditorSupport {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("org.eclipse.ve.internal.jfc.beaninfo.vceedit");
    FontPropertyEditor customEditor = null;

    public String getAsText() {
        Font font = null;
        try {
            font = (Font)this.getValue();
        }
        catch (ClassCastException exc) {
            System.err.print("Value not a font = " + this.getValue());
            exc.printStackTrace();
        }
        if (font == null) {
            return "";
        }
        String strStyle = font.isBold() ? (font.isItalic() ? resabtedit.getString("bolditalic") : resabtedit.getString("bold")) : (font.isItalic() ? resabtedit.getString("italic") : resabtedit.getString("plain"));
        return String.valueOf(font.getName()) + ", " + strStyle + ", " + font.getSize();
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            Font aFont = (Font)this.getValue();
            this.customEditor = aFont == null ? new FontPropertyEditor() : new FontPropertyEditor(aFont);
        }
        return this.customEditor;
    }

    public String getStyleNamedConstant(int style) {
        String constant = String.valueOf(style);
        switch (style) {
            case 0: {
                constant = "java.awt.Font.PLAIN";
                break;
            }
            case 1: {
                constant = "java.awt.Font.BOLD";
                break;
            }
            case 2: {
                constant = "java.awt.Font.ITALIC";
                break;
            }
            case 3: {
                constant = "java.awt.Font.BOLD | java.awt.Font.ITALIC";
            }
        }
        return constant;
    }

    public String getJavaInitializationString() {
        Font font = (Font)this.getValue();
        if (font != null) {
            return "new java.awt.Font(\"" + font.getName() + "\", " + this.getStyleNamedConstant(font.getStyle()) + ", " + font.getSize() + ")";
        }
        return "null";
    }

    public Object getValue() {
        if (this.customEditor != null) {
            return this.customEditor.getFontValue();
        }
        return super.getValue();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    public void setValue(Object newValue) {
        if (this.customEditor != null) {
            this.customEditor.setFontValue((Font)newValue);
        }
        super.setValue(newValue);
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

