/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class KeyStrokePropertyEditor
extends JPanel {
    private static final long serialVersionUID = -4909155071277619589L;
    private JList constantsList = null;
    private JTextField constantField = null;
    private JTextField descriptionField = null;
    private JCheckBox altCheck = null;
    private JCheckBox controlCheck = null;
    private JCheckBox metaCheck = null;
    private JCheckBox shiftCheck = null;
    private ButtonGroup actionGroup = null;
    private JRadioButton pressedRadio = null;
    private JRadioButton releasedRadio = null;
    private static TreeMap constantsToValue = null;
    private static HashMap valueToConstants = null;
    private boolean initialized = false;
    private Integer keyValue = new Integer(0);
    private int modifiersValue;
    private boolean releasedValue = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public KeyStrokePropertyEditor() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent e) {
                Container topParent;
                Container parent = e.getAncestorParent();
                if (parent instanceof JComponent && (topParent = ((JComponent)parent).getTopLevelAncestor()) instanceof Window) {
                    ((Window)topParent).addWindowListener(new WindowAdapter(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void windowOpened(WindowEvent e) {
                            KeyStrokePropertyEditor.access$0(1.access$0(this.this$1)).requestFocus();
                        }

                        public void windowActivated(WindowEvent e) {
                            KeyStrokePropertyEditor.access$0(1.access$0(this.this$1)).requestFocus();
                        }
                    });
                }
            }

            public void ancestorMoved(AncestorEvent e) {
            }

            public void ancestorRemoved(AncestorEvent e) {
            }

            static /* synthetic */ KeyStrokePropertyEditor access$0(1 var0) {
                return var0.KeyStrokePropertyEditor.this;
            }
        });
    }

    private TreeMap getConstantsToValue() {
        if (constantsToValue == null) {
            this.initializeMaps();
        }
        return constantsToValue;
    }

    private HashMap getValueToConstants() {
        if (valueToConstants == null) {
            this.initializeMaps();
        }
        return valueToConstants;
    }

    private void initializeMaps() {
        constantsToValue = new TreeMap();
        valueToConstants = new HashMap();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.KeyEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> cClass = clazz;
        Field[] fields = cClass.getFields();
        int i = 0;
        while (i < fields.length) {
            String name = fields[i].getName();
            if (name.startsWith("VK_")) {
                name = name.substring(3);
                try {
                    Integer value = new Integer(fields[i].getInt(fields[i]));
                    constantsToValue.put(name, value);
                    valueToConstants.put(value, name);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    public void initialize() {
        if (!this.initialized) {
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)this.getKeyPanel(), "Center");
            this.add((Component)this.getModifiersAndActionPanel(), "South");
            this.recursiveSetBackground(this, SystemColor.control);
            this.initialized = true;
        }
        this.updateSelection();
        this.setModifiers(this.modifiersValue);
        this.getReleasedRadio().setSelected(this.releasedValue);
        this.getPressedRadio().setSelected(!this.releasedValue);
        this.getConstantsList().requestFocus();
    }

    private JPanel getKeyPanel() {
        JPanel keyPanel = new JPanel();
        keyPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.KeyTitle")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        keyPanel.setLayout(gb);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 17;
        keyPanel.add((Component)new JLabel(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.PressKey")), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 5, 0);
        JScrollPane listScroll = new JScrollPane(this.getConstantsList());
        this.removeKeyboardActions(listScroll);
        this.removeKeyboardActions(listScroll.getVerticalScrollBar());
        this.removeKeyboardActions(listScroll.getHorizontalScrollBar());
        keyPanel.add((Component)listScroll, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 5, 5);
        keyPanel.add((Component)new JLabel(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Constant")), c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 0);
        keyPanel.add((Component)this.getConstantField(), c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 5, 5);
        keyPanel.add((Component)new JLabel(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Description")), c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 0);
        keyPanel.add((Component)this.getDescriptionField(), c);
        return keyPanel;
    }

    private JPanel getModifiersAndActionPanel() {
        JPanel maPanel = new JPanel();
        maPanel.setLayout(new GridLayout(1, 2, 5, 0));
        JPanel modPanel = new JPanel();
        modPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.ModifiersTitle")), BorderFactory.createEmptyBorder(0, 5, 5, 0)));
        modPanel.setLayout(new GridLayout(2, 2, 5, 5));
        modPanel.add(this.getAltCheck());
        modPanel.add(this.getControlCheck());
        modPanel.add(this.getMetaCheck());
        modPanel.add(this.getShiftCheck());
        maPanel.add(modPanel);
        JPanel actionPanel = new JPanel();
        actionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.ActionTitle")), BorderFactory.createEmptyBorder(0, 5, 5, 0)));
        actionPanel.setLayout(new GridLayout(2, 1, 5, 5));
        actionPanel.add((Component)this.getPressedRadio(), null);
        actionPanel.add((Component)this.getReleasedRadio(), null);
        this.actionGroup = new ButtonGroup();
        this.actionGroup.add(this.getPressedRadio());
        this.actionGroup.add(this.getReleasedRadio());
        maPanel.add(actionPanel);
        return maPanel;
    }

    private JList getConstantsList() {
        if (this.constantsList == null) {
            this.constantsList = new JList();
            this.constantsList.setSelectionMode(0);
            this.constantsList.setListData(this.getConstantsToValue().keySet().toArray());
            this.constantsList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    String constant = (String)KeyStrokePropertyEditor.this.getConstantsList().getSelectedValue();
                    if (constant != null) {
                        KeyStrokePropertyEditor.this.keyValue = (Integer)KeyStrokePropertyEditor.this.getConstantsToValue().get(constant);
                        KeyStrokePropertyEditor.this.updateFields();
                    } else {
                        KeyStrokePropertyEditor.this.getConstantField().setText("");
                        KeyStrokePropertyEditor.this.getDescriptionField().setText("");
                    }
                }
            });
            this.removeKeyboardActions(this.constantsList);
            this.constantsList.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (!KeyStrokePropertyEditor.this.isModifierKey(e.getKeyCode()) && e.getKeyCode() != 10) {
                        KeyStrokePropertyEditor.this.getConstantsList().setSelectedValue(KeyStrokePropertyEditor.this.getValueToConstants().get(new Integer(e.getKeyCode())), true);
                        KeyStrokePropertyEditor.this.setModifiers(0);
                    }
                }

                public void keyTyped(KeyEvent e) {
                    KeyStrokePropertyEditor.this.setModifiers(e.getModifiers());
                }
            });
        }
        return this.constantsList;
    }

    public void updateSelection() {
        this.getConstantsList().setSelectedValue(this.getValueToConstants().get(this.keyValue), true);
    }

    public void updateFields() {
        this.getConstantField().setText("VK_" + this.getValueToConstants().get(this.keyValue));
        this.getDescriptionField().setText(KeyEvent.getKeyText(this.keyValue));
    }

    private JTextField getConstantField() {
        if (this.constantField == null) {
            this.constantField = new JTextField();
            this.constantField.setText("");
            this.constantField.setEditable(false);
        }
        return this.constantField;
    }

    private JTextField getDescriptionField() {
        if (this.descriptionField == null) {
            this.descriptionField = new JTextField();
            this.descriptionField.setText("");
            this.descriptionField.setEditable(false);
        }
        return this.descriptionField;
    }

    private JCheckBox getAltCheck() {
        if (this.altCheck == null) {
            this.altCheck = new JCheckBox();
            this.altCheck.setText(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Alt_Modifier"));
        }
        return this.altCheck;
    }

    private JCheckBox getControlCheck() {
        if (this.controlCheck == null) {
            this.controlCheck = new JCheckBox();
            this.controlCheck.setText(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Control_Modifier"));
        }
        return this.controlCheck;
    }

    private JCheckBox getMetaCheck() {
        if (this.metaCheck == null) {
            this.metaCheck = new JCheckBox();
            this.metaCheck.setText(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Meta_Modifier"));
        }
        return this.metaCheck;
    }

    private JCheckBox getShiftCheck() {
        if (this.shiftCheck == null) {
            this.shiftCheck = new JCheckBox();
            this.shiftCheck.setText(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Shift_Modifier"));
        }
        return this.shiftCheck;
    }

    private JRadioButton getPressedRadio() {
        if (this.pressedRadio == null) {
            this.pressedRadio = new JRadioButton();
            this.pressedRadio.setText(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Pressed_Action"));
            this.pressedRadio.setSelected(!this.releasedValue);
        }
        return this.pressedRadio;
    }

    private JRadioButton getReleasedRadio() {
        if (this.releasedRadio == null) {
            this.releasedRadio = new JRadioButton();
            this.releasedRadio.setText(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Released_Action"));
            this.releasedRadio.setSelected(this.releasedValue);
        }
        return this.releasedRadio;
    }

    private void removeKeyboardActions(JComponent c) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.KeyListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KeyListener[] existing = (KeyListener[])c.getListeners(clazz);
        int i = 0;
        while (i < existing.length) {
            c.removeKeyListener(existing[i]);
            ++i;
        }
        c.resetKeyboardActions();
        c.setInputMap(0, null);
        c.setInputMap(1, null);
    }

    private void recursiveSetBackground(Container parent, Color bgColor) {
        if (parent instanceof JList) {
            return;
        }
        parent.setBackground(bgColor);
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container) {
                this.recursiveSetBackground((Container)children[i], bgColor);
            } else {
                children[i].setBackground(bgColor);
            }
            ++i;
        }
    }

    public String getAsText() {
        if (this.keyValue == 0) {
            return "";
        }
        String modifiersText = KeyEvent.getKeyModifiersText(this.getModifiers());
        String spacer = modifiersText.length() > 0 ? VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Spacer") : "";
        String keyText = KeyEvent.getKeyText(this.keyValue);
        String actionText = this.getReleasedValue() ? VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Released") : VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.Pressed");
        return MessageFormat.format(VisualBeanInfoMessages.getString("KeyStrokePropertyEditor.DisplayName(modifiers,spacer,key,action)"), modifiersText, spacer, keyText, actionText);
    }

    public String getJavaInitializationString() {
        String constant = "java.awt.event.KeyEvent.VK_" + this.getValueToConstants().get(this.keyValue);
        StringBuffer value = new StringBuffer("javax.swing.KeyStroke.getKeyStroke(");
        value.append(constant);
        value.append(", ");
        int mods = this.getModifiers();
        boolean first = true;
        if ((mods & 8) != 0) {
            if (!first) {
                value.append(" | ");
            } else {
                first = false;
            }
            value.append("java.awt.Event.ALT_MASK");
        }
        if ((mods & 2) != 0) {
            if (!first) {
                value.append(" | ");
            } else {
                first = false;
            }
            value.append("java.awt.Event.CTRL_MASK");
        }
        if ((mods & 4) != 0) {
            if (!first) {
                value.append(" | ");
            } else {
                first = false;
            }
            value.append("java.awt.Event.META_MASK");
        }
        if ((mods & 1) != 0) {
            if (!first) {
                value.append(" | ");
            } else {
                first = false;
            }
            value.append("java.awt.Event.SHIFT_MASK");
        }
        if (first) {
            value.append("0");
        }
        value.append(", ");
        value.append(this.getReleasedValue() ? "true" : "false");
        value.append(")");
        return value.toString();
    }

    private boolean isModifierKey(int keyCode) {
        return keyCode == 18 || keyCode == 17 || keyCode == 157 || keyCode == 16;
    }

    private void setModifiers(int mod) {
        this.getAltCheck().setSelected((mod & 8) != 0);
        this.getControlCheck().setSelected((mod & 2) != 0);
        this.getMetaCheck().setSelected((mod & 4) != 0);
        this.getShiftCheck().setSelected((mod & 1) != 0);
    }

    private int getModifiers() {
        if (this.initialized) {
            this.modifiersValue = 0;
            if (this.getAltCheck().isSelected()) {
                this.modifiersValue |= 8;
            }
            if (this.getControlCheck().isSelected()) {
                this.modifiersValue |= 2;
            }
            if (this.getMetaCheck().isSelected()) {
                this.modifiersValue |= 4;
            }
            if (this.getShiftCheck().isSelected()) {
                this.modifiersValue |= 1;
            }
        }
        return this.modifiersValue;
    }

    private boolean getReleasedValue() {
        if (this.initialized) {
            this.releasedValue = this.getReleasedRadio().isSelected();
        }
        return this.releasedValue;
    }

    public Object getValue() {
        return KeyStroke.getKeyStroke(this.keyValue, this.getModifiers(), this.getReleasedValue());
    }

    public void setValue(Object o) {
        if (o != null && o instanceof KeyStroke) {
            KeyStroke ks = (KeyStroke)o;
            this.keyValue = new Integer(ks.getKeyCode());
            this.modifiersValue = ks.getModifiers();
            this.releasedValue = ks.isOnKeyRelease();
        }
    }
}

