/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.ve.internal.jfc.beaninfo.LocaleCountry;
import org.eclipse.ve.internal.jfc.beaninfo.LocaleVariant;

public class LocaleLanguage {
    private String id = null;
    private String name = null;
    private LocaleCountry[] countries = null;
    private Vector fCountries = new Vector();

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public LocaleCountry[] getCountries() {
        int fSize = this.fCountries.size();
        this.countries = new LocaleCountry[fSize];
        Enumeration enumer = this.fCountries.elements();
        int i = 0;
        while (i < fSize && enumer.hasMoreElements()) {
            this.countries[i] = (LocaleCountry)enumer.nextElement();
            ++i;
        }
        this.sortCountries();
        return this.countries;
    }

    public void sortCountries() {
        int i = 0;
        while (i < this.countries.length) {
            int min = i;
            String s = this.countries[min].getName();
            if (s != null && !s.equals(" ")) {
                int j = i;
                while (j < this.countries.length) {
                    String newString = this.countries[j].getName();
                    if (newString.compareTo(s) < 0) {
                        min = j;
                        s = this.countries[min].getName();
                    }
                    ++j;
                }
            }
            LocaleCountry swap = this.countries[i];
            this.countries[i] = this.countries[min];
            this.countries[min] = swap;
            ++i;
        }
    }

    public void setID(String anID) {
        this.id = anID;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void addCountry(LocaleCountry aCountry) {
        boolean shouldNotAddCountry = false;
        int i = 0;
        while (i < this.fCountries.size()) {
            LocaleCountry fCountry = (LocaleCountry)this.fCountries.elementAt(i);
            if (fCountry == aCountry || aCountry.getName().equals(" ") || aCountry.getName() == null) {
                shouldNotAddCountry = true;
            }
            if (fCountry.getName() == aCountry.getName() && fCountry.getVariants() != aCountry.getVariants()) {
                LocaleVariant[] fVariants = aCountry.getVariants();
                int j = 0;
                while (j < fVariants.length) {
                    ((LocaleCountry)this.fCountries.elementAt(i)).addVariant(fVariants[j]);
                    ++j;
                }
                shouldNotAddCountry = true;
            }
            ++i;
        }
        if (!shouldNotAddCountry) {
            this.fCountries.addElement(aCountry);
        }
    }
}

