/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.ve.internal.jfc.beaninfo.AbstractBorderPropertyPage;
import org.eclipse.ve.internal.jfc.beaninfo.BorderEditor;
import org.eclipse.ve.internal.jfc.beaninfo.ColorEditor;
import org.eclipse.ve.internal.jfc.beaninfo.FontEditor;
import org.eclipse.ve.internal.jfc.beaninfo.SubEditorJDialog;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class TitledBorderPropertyPage
extends AbstractBorderPropertyPage
implements DocumentListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 3133841974545596757L;
    private static final String NULL = "null";
    private boolean built = false;
    private String titleTitle = "";
    private int titleJustification = 0;
    private int titlePosition = 0;
    private JTextField titleField = null;
    private JComboBox justificationCombo = null;
    private JComboBox positionCombo = null;
    private int[] justificationValues;
    private int[] positionValues;
    private Color titleColor = null;
    private Font titleFont = null;
    private Border titleBorder = null;
    private ColorEditor colorEditor = null;
    private FontEditor fontEditor = null;
    private BorderEditor borderEditor = null;
    private JPanel colorEditPanel = null;
    private JPanel fontEditPanel = null;
    private JPanel borderEditPanel = null;
    private JTextField colorField = null;
    private JTextField fontField = null;
    private JTextField borderField = null;
    private JButton colorButton = null;
    private JButton fontButton = null;
    private JButton borderButton = null;

    public TitledBorderPropertyPage() {
        this.initialize();
    }

    private void initialize() {
        this.setName("TitledBorderPropertyPage");
        Dimension size = new Dimension(200, 395);
        this.setMinimumSize(size);
    }

    public void buildPropertyPage() {
        if (!this.built) {
            this.setBackground(SystemColor.control);
            Insets labelInsets = new Insets(0, 5, 5, 5);
            Insets compInsets = new Insets(0, 5, 10, 5);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 18;
            c.gridx = 0;
            this.setLayout(gb);
            c.gridy = 0;
            c.insets = labelInsets;
            JLabel titleLabel = new JLabel(VisualBeanInfoMessages.getString("TitleBorder.Title"));
            this.add((Component)titleLabel, c);
            c.gridy = 1;
            c.insets = compInsets;
            this.add((Component)this.getTitleField(), c);
            c.gridy = 2;
            c.insets = labelInsets;
            JLabel titleJustificationLabel = new JLabel(VisualBeanInfoMessages.getString("TitledBorder.TitleJustification"));
            this.add((Component)titleJustificationLabel, c);
            c.gridy = 3;
            c.insets = compInsets;
            this.add((Component)this.getJustificationCombo(), c);
            c.gridy = 4;
            c.insets = labelInsets;
            JLabel titlePositionLabel = new JLabel(VisualBeanInfoMessages.getString("TitledBorder.TitlePosition"));
            this.add((Component)titlePositionLabel, c);
            c.gridy = 5;
            c.insets = compInsets;
            this.add((Component)this.getPositionCombo(), c);
            c.gridy = 6;
            c.insets = labelInsets;
            JLabel fontLabel = new JLabel(VisualBeanInfoMessages.getString("TitledBorder.Font"));
            this.add((Component)fontLabel, c);
            c.gridy = 7;
            c.insets = compInsets;
            this.add((Component)this.getFontEditPanel(), c);
            c.gridy = 8;
            c.insets = labelInsets;
            JLabel colorLabel = new JLabel(VisualBeanInfoMessages.getString("TitledBorder.Color"));
            this.add((Component)colorLabel, c);
            c.gridy = 9;
            c.insets = compInsets;
            this.add((Component)this.getColorEditPanel(), c);
            c.gridy = 10;
            c.insets = labelInsets;
            JLabel borderLabel = new JLabel(VisualBeanInfoMessages.getString("TitledBorder.Border"));
            this.add((Component)borderLabel, c);
            c.gridy = 11;
            c.insets = compInsets;
            this.add((Component)this.getBorderEditPanel(), c);
            this.updateFields();
            this.built = true;
        }
    }

    private JTextField getTitleField() {
        if (this.titleField == null) {
            this.titleField = new JTextField();
            this.titleField.getDocument().addDocumentListener(this);
        }
        return this.titleField;
    }

    public String getTitleJustificationLabel(int constant) {
        String label = String.valueOf(constant);
        switch (constant) {
            case 0: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.DefaultJustification");
                break;
            }
            case 1: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.Left");
                break;
            }
            case 2: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.Center");
                break;
            }
            case 3: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.Right");
                break;
            }
            case 4: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.Leading");
                break;
            }
            case 5: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.Trailing");
            }
        }
        return label;
    }

    public String getTitleJustificationNamedConstant(int constant) {
        String name = String.valueOf(constant);
        switch (constant) {
            case 0: {
                name = "javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION";
                break;
            }
            case 1: {
                name = "javax.swing.border.TitledBorder.LEFT";
                break;
            }
            case 2: {
                name = "javax.swing.border.TitledBorder.CENTER";
                break;
            }
            case 3: {
                name = "javax.swing.border.TitledBorder.RIGHT";
                break;
            }
            case 4: {
                name = "javax.swing.border.TitledBorder.LEADING";
                break;
            }
            case 5: {
                name = "javax.swing.border.TitledBorder.TRAILING";
            }
        }
        return name;
    }

    public String getTitlePositionLabel(int constant) {
        String label = String.valueOf(constant);
        switch (constant) {
            case 0: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.DefaultPosition");
                break;
            }
            case 1: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.AboveTop");
                break;
            }
            case 2: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.Top");
                break;
            }
            case 3: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.BelowTop");
                break;
            }
            case 4: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.AboveBottom");
                break;
            }
            case 5: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.Bottom");
                break;
            }
            case 6: {
                label = VisualBeanInfoMessages.getString("TitledBorder.DisplayName.BelowBottom");
            }
        }
        return label;
    }

    public String getTitlePositionNamedConstant(int constant) {
        String name = String.valueOf(constant);
        switch (constant) {
            case 0: {
                name = "javax.swing.border.TitledBorder.DEFAULT_POSITION";
                break;
            }
            case 1: {
                name = "javax.swing.border.TitledBorder.ABOVE_TOP";
                break;
            }
            case 2: {
                name = "javax.swing.border.TitledBorder.TOP";
                break;
            }
            case 3: {
                name = "javax.swing.border.TitledBorder.BELOW_TOP";
                break;
            }
            case 4: {
                name = "javax.swing.border.TitledBorder.ABOVE_BOTTOM";
                break;
            }
            case 5: {
                name = "javax.swing.border.TitledBorder.BOTTOM";
                break;
            }
            case 6: {
                name = "javax.swing.border.TitledBorder.BELOW_BOTTOM";
            }
        }
        return name;
    }

    private JComboBox getJustificationCombo() {
        if (this.justificationCombo == null) {
            this.justificationCombo = new JComboBox();
            this.justificationCombo.setBackground(SystemColor.control);
            this.justificationCombo.addItem(this.getTitleJustificationLabel(0));
            this.justificationCombo.addItem(this.getTitleJustificationLabel(1));
            this.justificationCombo.addItem(this.getTitleJustificationLabel(2));
            this.justificationCombo.addItem(this.getTitleJustificationLabel(3));
            this.justificationCombo.addItem(this.getTitleJustificationLabel(4));
            this.justificationCombo.addItem(this.getTitleJustificationLabel(5));
            this.justificationValues = new int[this.justificationCombo.getItemCount()];
            this.justificationValues[0] = 0;
            this.justificationValues[1] = 1;
            this.justificationValues[2] = 2;
            this.justificationValues[3] = 3;
            this.justificationValues[4] = 4;
            this.justificationValues[5] = 5;
            this.justificationCombo.addItemListener(this);
        }
        return this.justificationCombo;
    }

    private JComboBox getPositionCombo() {
        if (this.positionCombo == null) {
            this.positionCombo = new JComboBox();
            this.positionCombo.setBackground(SystemColor.control);
            this.positionCombo.addItem(this.getTitlePositionLabel(0));
            this.positionCombo.addItem(this.getTitlePositionLabel(1));
            this.positionCombo.addItem(this.getTitlePositionLabel(2));
            this.positionCombo.addItem(this.getTitlePositionLabel(3));
            this.positionCombo.addItem(this.getTitlePositionLabel(4));
            this.positionCombo.addItem(this.getTitlePositionLabel(5));
            this.positionCombo.addItem(this.getTitlePositionLabel(6));
            this.positionValues = new int[this.positionCombo.getItemCount()];
            this.positionValues[0] = 0;
            this.positionValues[1] = 1;
            this.positionValues[2] = 2;
            this.positionValues[3] = 3;
            this.positionValues[4] = 4;
            this.positionValues[5] = 5;
            this.positionValues[6] = 6;
            this.positionCombo.addItemListener(this);
        }
        return this.positionCombo;
    }

    private FontEditor getFontEditor() {
        if (this.fontEditor == null) {
            this.fontEditor = new FontEditor();
            this.fontEditor.setValue(this.titleFont);
        }
        return this.fontEditor;
    }

    private JPanel getFontEditPanel() {
        if (this.fontEditPanel == null) {
            this.fontEditPanel = new JPanel();
            this.fontEditPanel.setBackground(SystemColor.control);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 18;
            c.gridy = 0;
            this.fontEditPanel.setLayout(gb);
            c.insets = new Insets(0, 0, 0, 5);
            c.weightx = 1.0;
            c.gridx = 0;
            this.fontField = new JTextField();
            this.fontField.setText(this.getFontEditor().getAsText());
            this.fontField.setEditable(false);
            this.fontField.setBackground(SystemColor.control);
            gb.setConstraints(this.fontField, c);
            this.fontEditPanel.add(this.fontField);
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 0.0;
            c.gridx = 1;
            this.fontButton = new JButton();
            this.fontButton.setText(VisualBeanInfoMessages.getString("TitledBorder.ChooseButton"));
            this.fontButton.setMargin(new Insets(0, 5, 0, 5));
            this.fontButton.setBackground(SystemColor.control);
            this.fontButton.addActionListener(this);
            gb.setConstraints(this.fontButton, c);
            this.fontEditPanel.add(this.fontButton);
        }
        return this.fontEditPanel;
    }

    private ColorEditor getColorEditor() {
        if (this.colorEditor == null) {
            this.colorEditor = new ColorEditor();
            this.colorEditor.setValue(this.titleColor);
        }
        return this.colorEditor;
    }

    private JPanel getColorEditPanel() {
        if (this.colorEditPanel == null) {
            this.colorEditPanel = new JPanel();
            this.colorEditPanel.setBackground(SystemColor.control);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 18;
            c.gridy = 0;
            this.colorEditPanel.setLayout(gb);
            c.insets = new Insets(0, 0, 0, 5);
            c.weightx = 1.0;
            c.gridx = 0;
            this.colorField = new JTextField();
            this.colorField.setText(this.getColorEditor().getAsText());
            this.colorField.setEditable(false);
            this.colorField.setBackground(SystemColor.control);
            gb.setConstraints(this.colorField, c);
            this.colorEditPanel.add(this.colorField);
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 0.0;
            c.gridx = 1;
            this.colorButton = new JButton();
            this.colorButton.setText(VisualBeanInfoMessages.getString("TitledBorder.ChooseButton"));
            this.colorButton.setMargin(new Insets(0, 5, 0, 5));
            this.colorButton.setBackground(SystemColor.control);
            this.colorButton.addActionListener(this);
            gb.setConstraints(this.colorButton, c);
            this.colorEditPanel.add(this.colorButton);
        }
        return this.colorEditPanel;
    }

    private BorderEditor getBorderEditor() {
        if (this.borderEditor == null) {
            this.borderEditor = new BorderEditor();
            this.borderEditor.setValue(this.titleBorder);
        }
        return this.borderEditor;
    }

    private JPanel getBorderEditPanel() {
        if (this.borderEditPanel == null) {
            this.borderEditPanel = new JPanel();
            this.borderEditPanel.setBackground(SystemColor.control);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 18;
            c.gridy = 0;
            this.borderEditPanel.setLayout(gb);
            c.insets = new Insets(0, 0, 0, 5);
            c.weightx = 1.0;
            c.gridx = 0;
            this.borderField = new JTextField();
            this.borderField.setEditable(false);
            this.borderField.setBackground(SystemColor.control);
            this.borderEditPanel.add((Component)this.borderField, c);
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 0.0;
            c.gridx = 1;
            this.borderButton = new JButton();
            this.borderButton.setText(VisualBeanInfoMessages.getString("TitledBorder.ChooseButton"));
            this.borderButton.setMargin(new Insets(0, 5, 0, 5));
            this.borderButton.setBackground(SystemColor.control);
            this.borderButton.addActionListener(this);
            this.borderEditPanel.add((Component)this.borderButton, c);
        }
        return this.borderEditPanel;
    }

    private void updateFields() {
        this.titleField.setText(this.titleTitle);
        this.getJustificationCombo().setSelectedItem(this.getTitleJustificationLabel(this.titleJustification));
        this.getPositionCombo().setSelectedItem(this.getTitlePositionLabel(this.titlePosition));
        this.fontField.setText(this.getFontEditor().getAsText());
        this.colorField.setText(this.getColorEditor().getAsText());
        this.borderField.setText(this.getBorderEditor().getAsText());
    }

    private void updateFont() {
        this.titleFont = (Font)this.getFontEditor().getValue();
        this.fontField.setText(this.getFontEditor().getAsText());
        this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
    }

    private void updateColor() {
        this.titleColor = (Color)this.getColorEditor().getValue();
        this.colorField.setText(this.getColorEditor().getAsText());
        this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
    }

    private void updateBorder() {
        this.titleBorder = (Border)this.getBorderEditor().getValue();
        this.borderField.setText(this.getBorderEditor().getAsText());
        this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
    }

    public String escapeString(String str) {
        StringBuffer s = new StringBuffer(str);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\"' || c == '\\') {
                s.insert(i, '\\');
                ++i;
            }
            ++i;
        }
        return s.toString();
    }

    public void actionPerformed(ActionEvent e) {
        int state;
        Object source = e.getSource();
        if (source == this.fontButton) {
            int state2 = SubEditorJDialog.showSubEditorJDialog(this.getTopLevelAncestor(), this.getFontEditor().getCustomEditor());
            if (state2 == 0) {
                this.updateFont();
            }
        } else if (source == this.colorButton) {
            int state3 = SubEditorJDialog.showSubEditorJDialog(this.getTopLevelAncestor(), this.getColorEditor().getCustomEditor());
            if (state3 == 0) {
                this.updateColor();
            }
        } else if (source == this.borderButton && (state = SubEditorJDialog.showSubEditorJDialog(this.getTopLevelAncestor(), this.getBorderEditor().getCustomEditor())) == 0) {
            this.updateBorder();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        int index;
        if (e.getSource() == this.getJustificationCombo()) {
            int index2 = this.getJustificationCombo().getSelectedIndex();
            if (index2 >= 0 && index2 <= this.justificationValues.length) {
                this.titleJustification = this.justificationValues[index2];
            }
        } else if (e.getSource() == this.getPositionCombo() && (index = this.getPositionCombo().getSelectedIndex()) >= 0 && index <= this.positionValues.length) {
            this.titlePosition = this.positionValues[index];
        }
        this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
    }

    private void updateHandle(DocumentEvent e) {
        if (e.getDocument() == this.titleField.getDocument()) {
            this.titleTitle = this.titleField.getText();
            this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public boolean okToSetBorder(Border aBorder) {
        if (aBorder instanceof TitledBorder) {
            TitledBorder fBorder = (TitledBorder)aBorder;
            this.titleTitle = fBorder.getTitle();
            this.titleJustification = fBorder.getTitleJustification();
            this.titlePosition = fBorder.getTitlePosition();
            this.titleColor = fBorder.getTitleColor();
            this.titleFont = fBorder.getTitleFont();
            this.titleBorder = fBorder.getBorder();
            if (this.titleColor != null) {
                this.getColorEditor().setValue(this.titleColor);
            }
            if (this.titleFont != null) {
                this.getFontEditor().setValue(this.titleFont);
            }
            if (this.titleBorder != null) {
                this.getBorderEditor().setValue(this.titleBorder);
            }
            return true;
        }
        return false;
    }

    public Border getBorderValue() {
        TitledBorder aBorder = BorderFactory.createTitledBorder(this.titleBorder, this.titleTitle, this.titleJustification, this.titlePosition, this.titleFont, this.titleColor);
        return aBorder;
    }

    public String getDisplayName() {
        return MessageFormat.format(VisualBeanInfoMessages.getString("TitledBorder.DisplayName.Title(TitleString,JustificationString,TitlePositionString,TitleFont,TitleColor)"), this.titleTitle, this.getTitleJustificationLabel(this.titleJustification), this.getTitlePositionLabel(this.titlePosition), this.getFontEditor().getAsText(), this.getColorEditor().getAsText());
    }

    public String getJavaInitializationString() {
        StringBuffer sb = new StringBuffer("javax.swing.BorderFactory.createTitledBorder(");
        sb.append(this.getBorderEditor().getValue() == null ? NULL : this.getBorderEditor().getJavaInitializationString());
        sb.append(", \"");
        sb.append(this.escapeString(this.titleTitle));
        sb.append("\", ");
        sb.append(this.getTitleJustificationNamedConstant(this.titleJustification));
        sb.append(", ");
        sb.append(this.getTitlePositionNamedConstant(this.titlePosition));
        sb.append(", ");
        sb.append(this.getFontEditor().getValue() == null ? NULL : this.getFontEditor().getJavaInitializationString());
        sb.append(", ");
        sb.append(this.getColorEditor().getValue() == null ? NULL : this.getColorEditor().getJavaInitializationString());
        sb.append(")");
        return sb.toString();
    }
}

