/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;
import org.eclipse.ve.internal.propertysheet.IDescriptorPropertySheetEntry;
import org.eclipse.ve.internal.propertysheet.SetToNullAction;
import org.eclipse.ve.internal.propertysheet.ShowNullsAction;
import org.eclipse.ve.internal.propertysheet.ShowReadOnlyAction;
import org.eclipse.ve.internal.propertysheet.ShowSetValuesAction;

public class EToolsPropertySheetPage
extends PropertySheetPage
implements ISelectionProvider {
    protected ShowNullsAction fShowNullsAction;
    protected ShowSetValuesAction fShowSetValuesAction;
    protected SetToNullAction fSetToNullAction;
    protected ShowReadOnlyAction fShowReadOnlyAction;
    protected ListenerList fSelectionListeners = new ListenerList(1);
    protected Viewer propertySheetViewer;
    protected Method deactivateCellEditorMethod;
    protected IDescriptorPropertySheetEntry rootEntry;
    protected ListenerList fListeners = new ListenerList(1);
    private ISelection selectionQueued;
    static /* synthetic */ Class class$0;

    public void addListener(Listener aListener) {
        this.fListeners.add((Object)aListener);
    }

    public void removeListener(Listener aListener) {
        this.fListeners.remove((Object)aListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener selListener) {
        this.fSelectionListeners.add((Object)selListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener selListener) {
        this.fSelectionListeners.remove((Object)selListener);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
        this.setSorter(new EToolsPropertySheetSorter());
    }

    public void handleEntrySelection(ISelection selection) {
        super.handleEntrySelection(selection);
        if (this.fSetToNullAction != null) {
            this.fSetToNullAction.selectionChanged(selection);
        }
        if (!this.fSelectionListeners.isEmpty()) {
            Object[] listeners = this.fSelectionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ISelectionChangedListener)listeners[i]).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                ++i;
            }
        }
    }

    public void setSelection(ISelection selection) {
    }

    public IPropertySheetEntry getRootEntry() {
        Control tree = this.getControl();
        return tree != null ? (IPropertySheetEntry)tree.getData() : null;
    }

    public ISelection getSelection() {
        Control tree = this.getControl();
        if (tree == null || ((Tree)tree).getSelectionCount() == 0) {
            return StructuredSelection.EMPTY;
        }
        TreeItem[] sel = ((Tree)tree).getSelection();
        ArrayList<Object> entries = new ArrayList<Object>(sel.length);
        int i = 0;
        while (i < sel.length) {
            TreeItem ti = sel[i];
            Object data = ti.getData();
            if (data instanceof IPropertySheetEntry) {
                entries.add(data);
            }
            ++i;
        }
        return new StructuredSelection(entries);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.PropertySheetPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field viewerField = clazz.getDeclaredField("viewer");
            viewerField.setAccessible(true);
            this.propertySheetViewer = (Viewer)viewerField.get((Object)this);
            this.deactivateCellEditorMethod = this.propertySheetViewer.getClass().getDeclaredMethod("deactivateCellEditor", null);
            this.deactivateCellEditorMethod.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        Control tree = this.getControl();
        if (!this.fListeners.isEmpty()) {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((Listener)listeners[i]).controlCreated(tree);
                ++i;
            }
            this.fListeners.clear();
        }
    }

    public void deactivateCellEditor() {
        try {
            this.deactivateCellEditorMethod.invoke((Object)this.propertySheetViewer, null);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    protected void makeActions() {
        this.fShowNullsAction = new ShowNullsAction(this);
        this.fShowSetValuesAction = new ShowSetValuesAction(this, true);
        this.fSetToNullAction = new SetToNullAction(this);
        this.fShowReadOnlyAction = new ShowReadOnlyAction(this);
        this.fShowNullsAction.run();
        this.fShowSetValuesAction.run();
        this.fShowReadOnlyAction.run();
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        this.makeActions();
        menuManager.add((IAction)this.fShowNullsAction);
        menuManager.add((IAction)this.fShowSetValuesAction);
        menuManager.add((IAction)this.fShowReadOnlyAction);
        toolBarManager.add((IAction)this.fSetToNullAction);
    }

    public void setRootEntry(IPropertySheetEntry entry) {
        super.setRootEntry(entry);
        IDescriptorPropertySheetEntry iDescriptorPropertySheetEntry = this.rootEntry = entry instanceof IDescriptorPropertySheetEntry ? (IDescriptorPropertySheetEntry)entry : null;
        if (this.fShowNullsAction != null) {
            this.fShowNullsAction.run();
        }
        if (this.fShowSetValuesAction != null) {
            this.fShowSetValuesAction.run();
        }
        if (this.fShowReadOnlyAction != null) {
            this.fShowReadOnlyAction.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(final IWorkbenchPart part, final ISelection selection) {
        if (this.rootEntry == null || !(selection instanceof IStructuredSelection)) {
            super.selectionChanged(part, selection);
        } else {
            EToolsPropertySheetPage eToolsPropertySheetPage = this;
            synchronized (eToolsPropertySheetPage) {
                if (selection.equals(this.selectionQueued)) {
                    return;
                }
                this.selectionQueued = selection;
                this.rootEntry.markStale();
            }
            Display d = Display.getCurrent();
            if (d == null) {
                d = Display.getDefault();
            }
            d.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Control ctrl = EToolsPropertySheetPage.this.getControl();
                    if (ctrl != null && !ctrl.isDisposed()) {
                        EToolsPropertySheetPage eToolsPropertySheetPage = EToolsPropertySheetPage.this;
                        synchronized (eToolsPropertySheetPage) {
                            if (!selection.equals(EToolsPropertySheetPage.this.selectionQueued)) {
                                return;
                            }
                            EToolsPropertySheetPage.this.selectionQueued = null;
                        }
                        EToolsPropertySheetPage.this.superSelectionChanged(part, selection);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void superSelectionChanged(IWorkbenchPart part, ISelection selection) {
        Control tree = this.getControl();
        if (tree == null) {
            super.selectionChanged(part, selection);
            return;
        }
        tree.setRedraw(false);
        try {
            super.selectionChanged(part, selection);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            tree.setRedraw(true);
            throw throwable;
        }
        {
            Object var4_6 = null;
            tree.setRedraw(true);
            return;
        }
    }

    public static class EToolsPropertySheetSorter
    extends PropertySheetSorter {
        public void sort(IPropertySheetEntry[] entries) {
        }
    }

    public static interface Listener {
        public void controlCreated(Control var1);
    }
}

