/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets.beaninfo;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.widgets.beaninfo.TableBeanInfo;

public class SweetHelper {
    public static final String STYLE_BITS_ID = "org.eclipse.ve.sweet.stylebits";

    public static void mergeSuperclassStyleBits(BeanDescriptor descriptor) {
        Map styleBitsMap = SweetHelper.getStyleBitsMap(descriptor);
        Class<?> superclass = descriptor.getBeanClass().getSuperclass();
        if (superclass != null) {
            try {
                BeanInfo superclassBeanInfo = Introspector.getBeanInfo(superclass, superclass.getSuperclass());
                while (superclassBeanInfo.getBeanDescriptor().getValue(STYLE_BITS_ID) == null) {
                    if ((superclass = superclass.getSuperclass()) == null) break;
                    superclassBeanInfo = Introspector.getBeanInfo(superclass);
                }
                if (superclass != null) {
                    SweetHelper.mergeStyleBits(styleBitsMap, superclassBeanInfo);
                    SweetHelper.setStyleBits(descriptor, styleBitsMap);
                }
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
    }

    private static void setStyleBits(BeanDescriptor descriptor, Map styleBitsMap) {
        Object[][] newStyleBits = new Object[styleBitsMap.size()][4];
        Iterator iter = styleBitsMap.keySet().iterator();
        int index = 0;
        while (iter.hasNext()) {
            Object styleName = iter.next();
            newStyleBits[index][0] = styleName;
            Object[] nameInitStringValues = (Object[])styleBitsMap.get(styleName);
            System.arraycopy(nameInitStringValues, 0, newStyleBits[index], 1, 3);
            ++index;
        }
        descriptor.setValue(STYLE_BITS_ID, newStyleBits);
    }

    private static void mergeStyleBits(Map styleBitsMap, BeanInfo superclassBeanInfo) {
        Object[][] superclassStyleBits = (Object[][])superclassBeanInfo.getBeanDescriptor().getValue(STYLE_BITS_ID);
        if (superclassStyleBits == null) {
            return;
        }
        int i = 0;
        while (i < superclassStyleBits.length) {
            String canonnicalName = (String)superclassStyleBits[i][0];
            String displayName = (String)superclassStyleBits[i][1];
            Boolean expert = (Boolean)superclassStyleBits[i][2];
            Object[] values = (Object[])superclassStyleBits[i][3];
            if (styleBitsMap.get(canonnicalName) == null) {
                styleBitsMap.put(canonnicalName, new Object[]{displayName, expert, values});
            }
            ++i;
        }
    }

    private static Map getStyleBitsMap(BeanDescriptor descriptor) {
        Object[][] currentStyleBits = (Object[][])descriptor.getValue(STYLE_BITS_ID);
        HashMap<Object, Object[]> styleBitsMap = new HashMap<Object, Object[]>(currentStyleBits.length + 5);
        int i = 0;
        while (i < currentStyleBits.length) {
            styleBitsMap.put(currentStyleBits[i][0], new Object[]{currentStyleBits[i][1], currentStyleBits[i][2], currentStyleBits[i][3]});
            ++i;
        }
        return styleBitsMap;
    }

    public static void mergeStyleBits(BeanDescriptor descriptor, Class[] namedClasses) {
        Map styleBitsMap = SweetHelper.getStyleBitsMap(descriptor);
        int i = 0;
        while (i < namedClasses.length) {
            try {
                BeanInfo namedBeanInfo = Introspector.getBeanInfo(namedClasses[i], namedClasses[i].getSuperclass());
                SweetHelper.mergeStyleBits(styleBitsMap, namedBeanInfo);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            ++i;
        }
        SweetHelper.setStyleBits(descriptor, styleBitsMap);
    }

    public static void mergeNamedStyleBits(BeanDescriptor descriptor, Class namedClass, String[] styleBits) {
    }

    public static void main(String[] args) {
        Introspector.setBeanInfoSearchPath(new String[]{"org.eclipse.swt.widgets.beaninfo"});
        SweetHelper.mergeSuperclassStyleBits(new TableBeanInfo().getBeanDescriptor());
    }
}

