/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher.remotevm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.ILauncher;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.VCELauncherMessages;

public class JavaBeansLauncher {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        block19: {
            String nameOfClassToLaunch = System.getProperty("vce.launcher.class");
            String localeArg = System.getProperty("locale");
            if (localeArg != null && !localeArg.equals("")) {
                StringTokenizer tokenizer = new StringTokenizer(localeArg, "_");
                String language = "";
                String country = "";
                String variant = "";
                if (tokenizer.hasMoreElements()) {
                    language = tokenizer.nextToken();
                }
                if (tokenizer.hasMoreElements()) {
                    country = tokenizer.nextToken();
                }
                if (tokenizer.hasMoreElements()) {
                    country = tokenizer.nextToken();
                }
                Locale locale = new Locale(language, country, variant);
                Locale.setDefault(locale);
            }
            try {
                Class<?> aClass = Class.forName(nameOfClassToLaunch);
                List launchers = JavaBeansLauncher.getLaunchers();
                ILauncher selected = null;
                ILauncher current = null;
                Iterator itr = launchers.iterator();
                while (itr.hasNext()) {
                    current = (ILauncher)itr.next();
                    if (!current.supportsLaunching(aClass)) continue;
                    selected = current;
                    break;
                }
                if (selected != null) {
                    selected.launch(aClass, args);
                    break block19;
                }
                Method mainMethod = null;
                try {
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("[Ljava.lang.String;");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    mainMethod = aClass.getDeclaredMethod("main", classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (mainMethod != null && Modifier.isStatic(mainMethod.getModifiers())) {
                    System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.BeanWithMain_INFO_"), nameOfClassToLaunch));
                    mainMethod.invoke(null, new Object[]{args});
                } else {
                    System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.BeanWithNullConstructor_INFO_"), nameOfClassToLaunch));
                    Constructor<?> ctor = aClass.getDeclaredConstructor(null);
                    ctor.setAccessible(true);
                    ctor.newInstance(null);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.UnableToLoad_ERROR_"), nameOfClassToLaunch));
                System.exit(0);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.NoDefaultConstructor_ERROR_"), nameOfClassToLaunch));
                System.exit(0);
            }
            catch (InstantiationException exc) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InstantiationException_ERROR_"), nameOfClassToLaunch));
                exc.printStackTrace();
                System.exit(0);
            }
            catch (InvocationTargetException exc) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), nameOfClassToLaunch));
                exc.printStackTrace();
                System.exit(0);
            }
            catch (IllegalAccessException exc) {
                System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), nameOfClassToLaunch));
                exc.printStackTrace();
                System.exit(0);
            }
        }
    }

    private static List getLaunchers() {
        ArrayList launchers = new ArrayList();
        String launcherprop = System.getProperty("vce.launchers");
        if (launcherprop != null) {
            String[] classes = launcherprop.split(",");
            int i = 0;
            while (i < classes.length) {
                try {
                    Class<?> aClass = Class.forName(classes[i]);
                    Constructor<?> ctor = aClass.getDeclaredConstructor(null);
                    ctor.setAccessible(true);
                    Object launcherObj = ctor.newInstance(null);
                    if (launcherObj instanceof ILauncher) {
                        launchers.add(launcherObj);
                    } else {
                        System.err.println(MessageFormat.format(VCELauncherMessages.getString("JavaBeansLauncher.InvalidLauncherClass_ERROR_"), classes[i]));
                    }
                }
                catch (Exception e) {
                    System.err.println(MessageFormat.format(VCELauncherMessages.getString("JavaBeansLauncher.ErrorCreatingLauncherClass_ERROR_"), classes[i], e.getMessage()));
                }
                ++i;
            }
        }
        return launchers;
    }
}

