/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher.remotevm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.ILauncher;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.VCELauncherMessages;
import org.eclipse.ve.internal.java.vce.launcher.remotevm.ViewPartHost;

public class RCPLauncher
implements ILauncher {
    private String viewName;
    private String iconPath;
    static /* synthetic */ Class class$0;

    public boolean supportsLaunching(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.WorkbenchPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public void launch(Class clazz, String[] args) {
        Display display = Display.getDefault();
        Object javaBean = null;
        try {
            this.setupColorPreferences(display);
            this.setupFontPreferences(display);
            this.viewName = System.getProperty("rcp.launcher.viewName");
            this.iconPath = System.getProperty("rcp.launcher.iconPath");
            Constructor ctor = clazz.getDeclaredConstructor(null);
            ctor.setAccessible(true);
            javaBean = ctor.newInstance(null);
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Msg.ViewPartHost_INFO_"), clazz.getName()));
        }
        catch (SecurityException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        catch (NoSuchMethodException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        catch (InstantiationException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        catch (IllegalAccessException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.IllegalAccessException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        catch (InvocationTargetException e1) {
            System.out.println(MessageFormat.format(VCELauncherMessages.getString("BeansLauncher.Err.InvocationException_ERROR_"), clazz.getName()));
            e1.printStackTrace();
            System.exit(0);
        }
        int fTabPosition = 0;
        boolean fTraditionalTabs = false;
        try {
            fTabPosition = Integer.parseInt(System.getProperty("rcp.launcher.tabPosition"));
            if ("true".equalsIgnoreCase(System.getProperty("rcp.launcher.traditionalTabs"))) {
                fTraditionalTabs = true;
            }
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
            System.exit(0);
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
            System.exit(0);
        }
        catch (NullPointerException e1) {
            e1.printStackTrace();
            System.exit(0);
        }
        WorkbenchPart workbenchPart = javaBean;
        ViewPartHost viewPartHost = new ViewPartHost();
        String className = workbenchPart.getClass().getName();
        if (className.indexOf(".") != -1) {
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        viewPartHost.setDetails(fTraditionalTabs, fTabPosition, clazz.getName());
        String title = this.viewName == null ? className : this.viewName;
        viewPartHost.addViewPart(workbenchPart, title, this.iconPath);
        this.runEventLoop((Shell)viewPartHost.getWorkbenchShell());
    }

    private RGB stringToRGB(String str) {
        str = str.substring(str.indexOf("{") + 1, str.indexOf("}"));
        StringTokenizer tokens = new StringTokenizer(str, ",");
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            red = Integer.parseInt(tokens.nextToken().trim());
            green = Integer.parseInt(tokens.nextToken().trim());
            blue = Integer.parseInt(tokens.nextToken().trim());
        }
        catch (Exception exception) {
            return null;
        }
        return new RGB(red, green, blue);
    }

    private void setupColorPreferences(Display display) {
        String activeLinkPref = "";
        String errorPref = "";
        String linkPref = "";
        RGB activeLinkRGB = null;
        RGB errorRGB = null;
        RGB linkRGB = null;
        try {
            activeLinkPref = System.getProperty("rcp.launcher.activeLink");
            errorPref = System.getProperty("rcp.launcher.error");
            linkPref = System.getProperty("rcp.launcher.link");
            activeLinkRGB = this.stringToRGB(activeLinkPref);
            errorRGB = this.stringToRGB(errorPref);
            linkRGB = this.stringToRGB(linkPref);
            if (activeLinkRGB != null) {
                JFaceResources.getColorRegistry().put("ACTIVE_HYPERLINK_COLOR", activeLinkRGB);
            }
            if (errorRGB != null) {
                JFaceResources.getColorRegistry().put("ERROR_COLOR", errorRGB);
            }
            if (linkRGB != null) {
                JFaceResources.getColorRegistry().put("HYPERLINK_COLOR", linkRGB);
            }
            display.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupFontPreferences(Display display) {
        String defaultFont = "";
        String dialogFont = "";
        String bannerFont = "";
        String headerFont = "";
        String textFont = "";
        try {
            defaultFont = System.getProperty("rcp.launcher.defaultFont");
            dialogFont = System.getProperty("rcp.launcher.dialogFont");
            bannerFont = System.getProperty("rcp.launcher.bannerFont");
            headerFont = System.getProperty("rcp.launcher.headerFont");
            textFont = System.getProperty("rcp.launcher.textFont");
            FontData[] defaultFontData = new FontData[]{new FontData(defaultFont)};
            FontData[] dialogFontData = new FontData[]{new FontData(dialogFont)};
            FontData[] bannerFontData = new FontData[]{new FontData(bannerFont)};
            FontData[] headerFontData = new FontData[]{new FontData(headerFont)};
            FontData[] textFontData = new FontData[]{new FontData(textFont)};
            if (defaultFontData != null) {
                JFaceResources.getFontRegistry().put("org.eclipse.jface.defaultfont", defaultFontData);
            }
            if (dialogFontData != null) {
                JFaceResources.getFontRegistry().put("org.eclipse.jface.dialogfont", dialogFontData);
            }
            if (bannerFontData != null) {
                JFaceResources.getFontRegistry().put("org.eclipse.jface.bannerfont", bannerFontData);
            }
            if (headerFontData != null) {
                JFaceResources.getFontRegistry().put("org.eclipse.jface.headerfont", headerFontData);
            }
            if (textFontData != null) {
                JFaceResources.getFontRegistry().put("org.eclipse.jface.textfont", textFontData);
            }
            display.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runEventLoop(Shell beanShell) {
        Display display = beanShell.getDisplay();
        beanShell.pack();
        beanShell.open();
        try {
            while (!beanShell.isDisposed()) {
                try {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        display.dispose();
    }
}

