/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ve.internal.cde.commands.AddAnnotationsCommand;
import org.eclipse.ve.internal.cde.commands.ApplyAnnotationCommand;
import org.eclipse.ve.internal.cde.commands.ApplyModelToAnnotationCommand;
import org.eclipse.ve.internal.cde.commands.CancelKeyedValueCommand;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.GenericAnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.KeyedValueNotificationHelper;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.AnnotationEMF;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.cdm.CDMPackage;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.cdm.KeyedValueHolder;
import org.eclipse.ve.internal.cdm.VisualInfo;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class AnnotationPolicy {
    public static final EObject SF_PARENT_ANNOTATION = CDMPackage.eINSTANCE.getEObject_ParentAnnotation();

    public static Annotation createAnnotation(Object modelObject) {
        CDMFactory fact = CDMPackage.eINSTANCE.getCDMFactory();
        if (modelObject instanceof EObject) {
            return fact.createAnnotationEMF();
        }
        return fact.createAnnotationGeneric();
    }

    public static Command getDefaultAddAnnotationsCommand(List annotations, EditDomain domain) {
        if (annotations.isEmpty()) {
            return null;
        }
        try {
            AddAnnotationsCommand applyCmd = (AddAnnotationsCommand)((Object)domain.getDefaultAddAnnotationsCommandClass().newInstance());
            applyCmd.setDomain(domain);
            applyCmd.setAnnotations(annotations);
            return applyCmd;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Command getApplyModelToAnnotationCommand(Object modelObject, Annotation annotation, AnnotationLinkagePolicy linkage) {
        return new ApplyModelToAnnotationCommand(modelObject, annotation, linkage);
    }

    public static Command getDeleteCommand(List annotations, DiagramData diagramData) {
        if (annotations.isEmpty()) {
            return null;
        }
        CommandBuilder cBldr = new CommandBuilder("");
        ArrayList vis = new ArrayList();
        Iterator itr = annotations.iterator();
        while (itr.hasNext()) {
            Annotation annotation = (Annotation)itr.next();
            if (annotation instanceof AnnotationEMF) {
                cBldr.cancelAttributeSetting((EObject)annotation, (EStructuralFeature)CDMPackage.eINSTANCE.getAnnotationEMF_Annotates());
            }
            vis.addAll(annotation.getVisualInfos());
        }
        cBldr.cancelAttributeSettings((EObject)diagramData, (EStructuralFeature)CDMPackage.eINSTANCE.getDiagramData_Annotations(), annotations);
        cBldr.cancelGroupAttributeSetting(vis, (EStructuralFeature)CDMPackage.eINSTANCE.getVisualInfo_Diagram());
        return cBldr.getCommand();
    }

    public static Command getDeleteDependentCommand(List annotations, Command deleteDependentCommand, DiagramData diagramData) {
        CompoundCommand c = new CompoundCommand();
        c.append(deleteDependentCommand);
        c.append(AnnotationPolicy.getDeleteCommand(annotations, diagramData));
        return c.unwrap();
    }

    public static List getAllAnnotations(List annotations, Object modelObject, AnnotationLinkagePolicy policy) {
        Annotation ann = policy.getAnnotation(modelObject);
        if (ann != null) {
            annotations.add(ann);
        }
        if (modelObject instanceof EObject) {
            EObject eo = (EObject)modelObject;
            Iterator itr = eo.eContents().iterator();
            while (itr.hasNext()) {
                Object n = itr.next();
                if (!(n instanceof EObject)) continue;
                AnnotationPolicy.getAllAnnotations(annotations, n, policy);
            }
        } else {
            GenericAnnotationLinkagePolicy gPolicy = (GenericAnnotationLinkagePolicy)policy;
            Iterator itr = gPolicy.getContainedChildren(modelObject).iterator();
            while (itr.hasNext()) {
                AnnotationPolicy.getAllAnnotations(annotations, itr.next(), policy);
            }
        }
        return annotations;
    }

    public static Command getCreateRequestCommand(List annotations, Command childCreateCommand, EditDomain domain) {
        CompoundCommand c = new CompoundCommand(childCreateCommand.getLabel());
        c.append(AnnotationPolicy.getDefaultAddAnnotationsCommand(annotations, domain));
        c.append(childCreateCommand);
        return c.unwrap();
    }

    public static Command cancelVisualInfo(VisualInfo vi) {
        Annotation annotation = (Annotation)vi.eContainer();
        if (annotation.getVisualInfos().size() == 1 && annotation.getKeyedValues().size() == 0) {
            return AnnotationPolicy.getDeleteCommand(Collections.singletonList(annotation), (DiagramData)annotation.eContainer());
        }
        CommandBuilder cmdBldr = new CommandBuilder(null);
        cmdBldr.cancelAttributeSetting((EObject)annotation, (EStructuralFeature)CDMPackage.eINSTANCE.getAnnotation_VisualInfos(), vi);
        cmdBldr.cancelAttributeSetting((EObject)vi, (EStructuralFeature)CDMPackage.eINSTANCE.getVisualInfo_Diagram());
        return cmdBldr.getCommand();
    }

    public static Command cancelAnnotationSetting(Annotation ann, String key) {
        if (!ann.getKeyedValues().containsKey((Object)key)) {
            return null;
        }
        if (ann.getKeyedValues().size() == 1) {
            return AnnotationPolicy.getDeleteCommand(Collections.singletonList(ann), (DiagramData)ann.eContainer());
        }
        CancelKeyedValueCommand cmd = new CancelKeyedValueCommand();
        cmd.setTarget((KeyedValueHolder)ann);
        cmd.setKey(key);
        return cmd;
    }

    public static Command applyAnnotationSetting(Object modelObject, BasicEMap.Entry newValue, EditDomain domain) {
        return new ApplyAnnotationCommand(modelObject, newValue, domain);
    }

    public static List getAnnotationPropertyDescriptors(Object modelObject, EditDomain domain) {
        Annotation annotation;
        AnnotationLinkagePolicy annotationLinkagePolicy = domain.getAnnotationLinkagePolicy();
        if (annotationLinkagePolicy != null && (annotation = annotationLinkagePolicy.getAnnotation(modelObject)) != null) {
            ArrayList<IPropertyDescriptor> descs = new ArrayList<IPropertyDescriptor>(2);
            Iterator itr = annotation.getKeyedValues().iterator();
            while (itr.hasNext()) {
                BasicEMap.Entry kv = (BasicEMap.Entry)itr.next();
                IPropertyDescriptor desc = domain.getKeyedPropertyDescriptor(kv.getKey());
                if (desc == null) continue;
                descs.add(desc);
            }
            return descs;
        }
        return Collections.EMPTY_LIST;
    }

    public static abstract class AnnotationListener
    implements GenericAnnotationLinkagePolicy.AnnotationLinkageListener {
        protected Object model;
        protected String modelID;
        protected GenericAnnotationLinkagePolicy linkage;
        protected Annotation annotation;
        protected Adapter modelAdapter;
        protected Adapter annotationAdapter;

        public AnnotationListener(Object model, EditDomain domain) {
            this.model = model;
            if (model instanceof EObject) {
                this.setupModelAdapter(domain.getAnnotationLinkagePolicy());
            } else {
                this.setupModelListener((GenericAnnotationLinkagePolicy)domain.getAnnotationLinkagePolicy());
            }
        }

        public abstract void notifyAnnotation(int var1, Annotation var2, Annotation var3);

        public abstract void notifyAnnotationChanges(Notification var1);

        public void removeListening() {
            if (this.model != null) {
                if (this.model instanceof EObject) {
                    ((EObject)this.model).eAdapters().remove((Object)this.modelAdapter);
                    this.modelAdapter = null;
                } else {
                    this.linkage.removeAnnotationLinkageListener(this.modelID, this);
                    this.modelID = null;
                    this.linkage = null;
                }
                this.removeAnnotationAdapter();
                this.model = null;
            }
        }

        private void setupModelAdapter(AnnotationLinkagePolicy link) {
            Notifier ro = (Notifier)this.model;
            this.modelAdapter = new AdapterImpl(this){
                final /* synthetic */ AnnotationListener this$1;
                {
                    this.this$1 = annotationListener;
                }

                public void notifyChanged(Notification msg) {
                    if (msg.getEventType() == 8) {
                        this.this$1.removeListening();
                    } else if (msg.getEventType() == -500 && msg.getFeature() == SF_PARENT_ANNOTATION) {
                        switch (msg.getPosition()) {
                            case 1: {
                                if (!msg.isReset()) {
                                    if (!msg.isTouch()) {
                                        AnnotationListener.access$0(this.this$1, (Annotation)msg.getNewValue());
                                    }
                                    this.this$1.notifyAnnotation(1, (Annotation)msg.getOldValue(), (Annotation)msg.getNewValue());
                                    break;
                                }
                            }
                            case 2: {
                                AnnotationListener.access$0(this.this$1, null);
                                this.this$1.notifyAnnotation(2, (Annotation)msg.getOldValue(), (Annotation)msg.getNewValue());
                            }
                        }
                    }
                }
            };
            ro.eAdapters().add((Object)this.modelAdapter);
            this.setupAnnotationAdapter(link.getAnnotation(this.model));
        }

        private void setupModelListener(GenericAnnotationLinkagePolicy linkage) {
            this.linkage = linkage;
            this.modelID = linkage.getIDFromModel(this.model);
            linkage.addAnnotationLinkageListener(this.modelID, this);
            this.setupAnnotationAdapter(linkage.getAnnotation(this.model));
        }

        private void setupAnnotationAdapter(Annotation annotation) {
            if (this.annotationAdapter != null) {
                this.removeAnnotationAdapter();
            }
            this.annotation = annotation;
            if (annotation != null) {
                this.annotationAdapter = new AdapterImpl(this){
                    final /* synthetic */ AnnotationListener this$1;
                    {
                        this.this$1 = annotationListener;
                    }

                    public void notifyChanged(Notification msg) {
                        if (msg.getEventType() == 8) {
                            AnnotationListener.access$1(this.this$1);
                        } else {
                            AnnotationListener.access$2(this.this$1, msg);
                        }
                    }
                };
                annotation.eAdapters().add((Object)this.annotationAdapter);
            }
        }

        private void processAnnotationChanges(Notification msg) {
            Notification[] keyedMsgs = KeyedValueNotificationHelper.notifyChanged(msg);
            if (keyedMsgs == null) {
                this.notifyAnnotationChanges(msg);
            } else {
                int i = 0;
                while (i < keyedMsgs.length) {
                    this.notifyAnnotationChanges(keyedMsgs[i]);
                    ++i;
                }
            }
        }

        private void removeAnnotationAdapter() {
            if (this.annotationAdapter != null) {
                Adapter a = this.annotationAdapter;
                this.annotationAdapter = null;
                this.annotation.eAdapters().remove((Object)a);
                this.annotation = null;
            }
        }

        public void annotationLinkageChanged(GenericAnnotationLinkagePolicy.AnnotationLinkageEvent event) {
            if (event.getType() == 4) {
                this.removeListening();
            } else {
                switch (event.getType()) {
                    case 0: {
                        this.setupAnnotationAdapter(((GenericAnnotationLinkagePolicy.AnnotationLinkageChangeEvent)event).getNewAnnotation());
                    }
                    case 2: {
                        this.notifyAnnotation(1, ((GenericAnnotationLinkagePolicy.AnnotationLinkageChangeEvent)event).getOldAnnotation(), ((GenericAnnotationLinkagePolicy.AnnotationLinkageChangeEvent)event).getNewAnnotation());
                        break;
                    }
                    case 1: {
                        this.setupAnnotationAdapter(null);
                        this.notifyAnnotation(2, ((GenericAnnotationLinkagePolicy.AnnotationLinkageChangeEvent)event).getOldAnnotation(), ((GenericAnnotationLinkagePolicy.AnnotationLinkageChangeEvent)event).getNewAnnotation());
                        break;
                    }
                    case 3: {
                        this.modelID = (String)event.getSource();
                    }
                }
            }
        }

        static /* synthetic */ void access$0(AnnotationListener annotationListener, Annotation annotation) {
            annotationListener.setupAnnotationAdapter(annotation);
        }

        static /* synthetic */ void access$1(AnnotationListener annotationListener) {
            annotationListener.removeAnnotationAdapter();
        }

        static /* synthetic */ void access$2(AnnotationListener annotationListener, Notification notification) {
            annotationListener.processAnnotationChanges(notification);
        }
    }
}

