/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.CustomizeLayoutWindow;
import org.eclipse.ve.internal.cde.core.EditDomain;

public class CustomizeLayoutWindowAction
extends Action {
    public static String ACTION_ID = "CustomizeLayoutWindowAction";
    protected static Point fDialogLoc;
    protected CustomizeLayoutWindow fDialog;
    protected IWorkbenchWindow workbenchWindow;
    protected IEditorPart editorPart;
    protected IEditorActionBarContributor contributor;
    protected static final String WINDOW_TITLE;
    protected static final String CUSTOMIZE_LAYOUT_PAGE_KEY = "customizeLayoutPage_Key";
    public static final ImageDescriptor IMG_CUSTOMIZE_LAYOUT_BEAN_DISABLED;
    public static final ImageDescriptor IMG_CUSTOMIZE_LAYOUT_BEAN;
    private IPartListener alignmentWindowPartListener = new IPartListener(){
        private boolean currentEPBeingClosed = false;

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                this.currentEPBeingClosed = false;
                CustomizeLayoutWindowAction.this.setEditorPart((IEditorPart)part);
            } else if (this.currentEPBeingClosed) {
                this.currentEPBeingClosed = false;
                CustomizeLayoutWindowAction.this.setEditorPart(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == CustomizeLayoutWindowAction.this.editorPart) {
                this.currentEPBeingClosed = true;
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ISelectionListener selListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (CustomizeLayoutWindowAction.this.fDialog != null && !CustomizeLayoutWindowAction.this.fDialog.isHidden()) {
                CustomizeLayoutWindowAction.this.update(selection);
            }
        }
    };
    private ISelectionProvider selectionProvider = new ISelectionProvider(){
        private ISelection selection = StructuredSelection.EMPTY;

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }
    };
    static /* synthetic */ Class class$0;

    static {
        WINDOW_TITLE = CDEMessages.CustomizeLayoutWindow_title;
        IMG_CUSTOMIZE_LAYOUT_BEAN_DISABLED = CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/dlcl16/aligndialog_obj.gif");
        IMG_CUSTOMIZE_LAYOUT_BEAN = CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/elcl16/aligndialog_obj.gif");
    }

    public static void addLayoutCustomizationPage(EditPartViewer viewer, Class layoutPage) {
        org.eclipse.gef.EditDomain odom = viewer.getEditDomain();
        if (odom instanceof EditDomain) {
            EditDomain dom = (EditDomain)odom;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.CustomizeLayoutPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(layoutPage)) {
                throw new IllegalArgumentException(layoutPage.toString());
            }
            CustomizeLayoutPageController pages = (CustomizeLayoutPageController)dom.getViewerData(viewer, CUSTOMIZE_LAYOUT_PAGE_KEY);
            if (pages == null) {
                pages = new CustomizeLayoutPageController();
                dom.setViewerData(viewer, CUSTOMIZE_LAYOUT_PAGE_KEY, pages);
            }
            pages.addLayoutPage(layoutPage);
        }
    }

    public static void addComponentCustomizationPage(EditPartViewer viewer, Class componentPage) {
        org.eclipse.gef.EditDomain odom = viewer.getEditDomain();
        if (odom instanceof EditDomain) {
            EditDomain dom = (EditDomain)odom;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.CustomizeLayoutPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(componentPage)) {
                throw new IllegalArgumentException(componentPage.toString());
            }
            CustomizeLayoutPageController pages = (CustomizeLayoutPageController)dom.getViewerData(viewer, CUSTOMIZE_LAYOUT_PAGE_KEY);
            if (pages == null) {
                pages = new CustomizeLayoutPageController();
                dom.setViewerData(viewer, CUSTOMIZE_LAYOUT_PAGE_KEY, pages);
            }
            pages.addComponentPage(componentPage);
        }
    }

    void showCustomizeLayoutWindow() {
        if (!this.isChecked()) {
            this.setChecked(true);
            this.run();
        } else {
            this.fDialog.getShell().forceActive();
        }
    }

    public CustomizeLayoutWindowAction(IWorkbenchWindow workbenchWindow, IEditorActionBarContributor contributor) {
        super(CDEMessages.CustomizeLayoutWindowAction_label, 2);
        this.setId(ACTION_ID);
        this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/elcl16/aligndialog_obj.gif"));
        this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/dlcl16/aligndialog_obj.gif"));
        this.setHoverImageDescriptor(this.getImageDescriptor());
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty())) {
                    CustomizeLayoutWindowAction.this.setTooltip();
                }
            }
        });
        this.setTooltip();
        this.workbenchWindow = workbenchWindow;
        this.contributor = contributor;
        workbenchWindow.getSelectionService().addSelectionListener(this.selListener);
        workbenchWindow.getPartService().addPartListener(this.alignmentWindowPartListener);
    }

    private void setTooltip() {
        this.setToolTipText(this.isChecked() ? CDEMessages.CustomizeLayoutWindowAction_tooltip_hide : CDEMessages.CustomizeLayoutWindowAction_tooltip_show);
    }

    protected void updateLayoutTab(final Class layoutPageClass) {
        this.workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (CustomizeLayoutWindowAction.this.fDialog != null) {
                    CustomizeLayoutWindowAction.this.fDialog.addLayoutCustomizationPage(layoutPageClass);
                }
            }
        });
    }

    protected void updateComponentTab(final Class componentPageClass) {
        this.workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (CustomizeLayoutWindowAction.this.fDialog != null) {
                    CustomizeLayoutWindowAction.this.fDialog.addComponentCustomizationPage(componentPageClass);
                }
            }
        });
    }

    protected void setEditorPart(IEditorPart anEditorPart) {
        if (this.editorPart == anEditorPart) {
            return;
        }
        this.editorPart = anEditorPart;
        if (this.editorPart != null && this.editorPart.getEditorSite().getActionBarContributor() == this.contributor) {
            this.runWithoutUpdate();
        } else if (this.fDialog != null) {
            this.fDialog.hide();
            this.fDialog.setEditorPart(null);
            this.update((ISelection)StructuredSelection.EMPTY);
        }
    }

    ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void dispose() {
        this.workbenchWindow.getSelectionService().removeSelectionListener(this.selListener);
        this.workbenchWindow.getPartService().removePartListener(this.alignmentWindowPartListener);
        this.editorPart = null;
        this.contributor = null;
        this.workbenchWindow = null;
        if (this.fDialog != null) {
            this.fDialog.close();
            this.fDialog = null;
        }
    }

    public void run() {
        this.runWithoutUpdate();
        this.update(this.workbenchWindow.getSelectionService().getSelection());
    }

    protected void runWithoutUpdate() {
        if (!this.isChecked()) {
            if (this.fDialog != null) {
                this.fDialog.close();
                this.fDialog = null;
            }
        } else {
            if (this.fDialog == null) {
                this.fDialog = new CustomizeLayoutWindow(this.workbenchWindow.getShell(), this);
                if (fDialogLoc == null) {
                    Preferences preferences = CDEPlugin.getPlugin().getPluginPreferences();
                    int x = preferences.getInt(CDEPlugin.CUSTOMIZELAYOUTWINDOW_X);
                    int y = preferences.getInt(CDEPlugin.CUSTOMIZELAYOUTWINDOW_Y);
                    this.fDialog.setLocation(new Point(x, y));
                    fDialogLoc = this.fDialog.getLocation();
                } else {
                    this.fDialog.setLocation(fDialogLoc);
                }
                this.fDialog.open();
                this.fDialog.getShell().addControlListener(new ControlListener(){

                    public void controlMoved(ControlEvent event) {
                        fDialogLoc = CustomizeLayoutWindowAction.this.fDialog.getShell().getLocation();
                        CustomizeLayoutWindowAction.this.fDialog.setLocation(fDialogLoc);
                    }

                    public void controlResized(ControlEvent event) {
                    }
                });
                this.fDialog.getShell().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        CustomizeLayoutWindowAction.this.persistPreferences();
                        CustomizeLayoutWindowAction.this.setChecked(false);
                        CustomizeLayoutWindowAction.this.fDialog = null;
                        CustomizeLayoutWindowAction.this.update((ISelection)StructuredSelection.EMPTY);
                    }
                });
            } else {
                this.fDialog.open();
            }
            this.fDialog.setEditorPart(this.editorPart);
        }
    }

    protected void persistPreferences() {
        if (fDialogLoc != null) {
            Preferences preferences = CDEPlugin.getPlugin().getPluginPreferences();
            preferences.setValue(CDEPlugin.CUSTOMIZELAYOUTWINDOW_X, CustomizeLayoutWindowAction.fDialogLoc.x);
            preferences.setValue(CDEPlugin.CUSTOMIZELAYOUTWINDOW_Y, CustomizeLayoutWindowAction.fDialogLoc.y);
        }
    }

    protected void update(ISelection selection) {
        this.selectionProvider.setSelection(selection);
        if (this.fDialog != null) {
            this.fDialog.update(selection);
        }
    }

    protected static class CustomizeLayoutPageController {
        private CustomizeLayoutWindowAction customizeLayoutWindowAction;
        private List layoutClasses = new ArrayList(1);
        private List componentClasses = new ArrayList(1);

        protected CustomizeLayoutPageController() {
        }

        public void setCustomizeLayoutWindowAction(CustomizeLayoutWindowAction alignWindowAction) {
            this.customizeLayoutWindowAction = alignWindowAction;
        }

        public CustomizeLayoutWindowAction getCustomizeLayoutWindowAction() {
            return this.customizeLayoutWindowAction;
        }

        public List getLayoutClasses() {
            return this.layoutClasses;
        }

        public List getComponentClasses() {
            return this.componentClasses;
        }

        public void addLayoutPage(Class layoutClass) {
            if (layoutClass != null && !this.layoutClasses.contains(layoutClass)) {
                this.layoutClasses.add(layoutClass);
                if (this.getCustomizeLayoutWindowAction() != null) {
                    this.getCustomizeLayoutWindowAction().updateLayoutTab(layoutClass);
                }
            }
        }

        public void addComponentPage(Class componentClass) {
            if (componentClass != null && !this.componentClasses.contains(componentClass)) {
                this.componentClasses.add(componentClass);
                if (this.getCustomizeLayoutWindowAction() != null) {
                    this.getCustomizeLayoutWindowAction().updateComponentTab(componentClass);
                }
            }
        }
    }
}

