/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ve.internal.cde.core.IErrorHolder;
import org.eclipse.ve.internal.cde.core.IErrorNotifier;

public class ErrorNotifier
implements IErrorNotifier {
    protected Map keyedErrors;
    protected ListenerList errorListeners;
    protected static final Object NOT_PROPERTY = new Object();

    public int getErrorStatus() {
        if (this.keyedErrors == null || this.keyedErrors.isEmpty()) {
            return 0;
        }
        Iterator errors = this.keyedErrors.values().iterator();
        int maxStatus = 0;
        while (errors.hasNext()) {
            Object error = errors.next();
            if (error instanceof List) {
                List eList = (List)error;
                int i = 0;
                while (i < eList.size()) {
                    IErrorHolder.ErrorType eType = (IErrorHolder.ErrorType)eList.get(i);
                    if ((maxStatus = Math.max(maxStatus, eType.getSeverity())) == 3) {
                        return 3;
                    }
                    ++i;
                }
                continue;
            }
            IErrorHolder.ErrorType eType = (IErrorHolder.ErrorType)error;
            if ((maxStatus = Math.max(maxStatus, eType.getSeverity())) != 3) continue;
            return 3;
        }
        return maxStatus;
    }

    public List getErrors() {
        if (this.keyedErrors == null || this.keyedErrors.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        Iterator iter = this.keyedErrors.values().iterator();
        while (iter.hasNext()) {
            Object v = iter.next();
            if (v instanceof List) {
                result.addAll((List)v);
                continue;
            }
            result.add(v);
        }
        return result;
    }

    public void processError(IErrorHolder.ErrorType error, Object key) {
        if (error instanceof IErrorHolder.PropertyError) {
            IErrorHolder.PropertyError pe = (IErrorHolder.PropertyError)error;
            this.putToKey(pe.getFeature(), error, !pe.getFeature().isMany());
        } else {
            this.putToKey(key != null ? key : NOT_PROPERTY, error, false);
        }
        this.fireAddedError(error);
        this.fireErrorStatusChanged();
    }

    public void processError(IErrorHolder.ErrorType error) {
        this.processError(error, null);
    }

    public void clearError(Object key) {
        if (this.keyedErrors != null) {
            Object v = this.keyedErrors.remove(key);
            if (v instanceof IErrorHolder.ErrorType) {
                this.fireClearedError((IErrorHolder.ErrorType)v);
                this.fireErrorStatusChanged();
            } else if (v instanceof List) {
                List errors = (List)v;
                int i = 0;
                while (i < errors.size()) {
                    this.fireClearedError((IErrorHolder.ErrorType)errors.get(i));
                    ++i;
                }
                this.fireErrorStatusChanged();
            }
        }
    }

    public void clearError(EStructuralFeature sf, Object errorObject) {
        Object errors;
        if (this.keyedErrors != null && (errors = this.keyedErrors.get(sf)) != null) {
            if (errors instanceof List) {
                Iterator itr = ((List)errors).iterator();
                while (itr.hasNext()) {
                    IErrorHolder.PropertyError merr = (IErrorHolder.PropertyError)itr.next();
                    if (errorObject != merr.getErrorObject()) continue;
                    itr.remove();
                    this.fireClearedError(merr);
                    this.fireErrorStatusChanged();
                    break;
                }
                if (((List)errors).isEmpty()) {
                    this.keyedErrors.remove(sf);
                }
            } else if (!(errors instanceof IErrorHolder.PropertyError) || ((IErrorHolder.PropertyError)errors).getErrorObject() == errorObject) {
                this.clearError(sf);
            }
        }
    }

    protected void putToKey(Object key, IErrorHolder.ErrorType error, boolean mustBeSingle) {
        Object value;
        if (this.keyedErrors == null) {
            this.keyedErrors = new HashMap();
        }
        if ((value = this.keyedErrors.get(key)) == null || mustBeSingle) {
            this.keyedErrors.put(key, error);
        } else if (value instanceof List) {
            ((List)value).add(error);
        } else {
            ArrayList<Object> newValue = new ArrayList<Object>(2);
            newValue.add(value);
            newValue.add(error);
            this.keyedErrors.put(key, newValue);
        }
    }

    public boolean hasErrorsOfKey(Object key) {
        return this.keyedErrors != null && this.keyedErrors.containsKey(key);
    }

    public Object getErrorsOfKey(Object key) {
        if (this.keyedErrors == null) {
            return null;
        }
        return this.keyedErrors.get(key);
    }

    public boolean hasErrorsOfKeyObject(EStructuralFeature feature, Object objectData) {
        Object errors;
        if (this.keyedErrors != null && (errors = this.keyedErrors.get(feature)) != null) {
            if (errors instanceof List) {
                List l = (List)errors;
                int len = l.size();
                int i = 0;
                while (i < len) {
                    if (this.isErrorOfObject((IErrorHolder.ErrorType)l.get(i), objectData)) {
                        return true;
                    }
                    ++i;
                }
            } else {
                if (feature.isMany()) {
                    return this.isErrorOfObject((IErrorHolder.ErrorType)errors, objectData);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isErrorOfObject(IErrorHolder.ErrorType error, Object objectData) {
        try {
            return ((IErrorHolder.PropertyError)error).getErrorObject() == objectData;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void clearAllErrors() {
        if (this.keyedErrors != null && !this.keyedErrors.isEmpty()) {
            List errors = this.getErrors();
            this.keyedErrors = null;
            Iterator iter = errors.iterator();
            while (iter.hasNext()) {
                IErrorHolder.ErrorType error = (IErrorHolder.ErrorType)iter.next();
                this.fireClearedError(error);
            }
            this.fireErrorStatusChanged();
        }
    }

    public void addErrorListener(IErrorNotifier.ErrorListener aListener) {
        if (this.errorListeners == null) {
            this.errorListeners = new ListenerList(2);
        }
        this.errorListeners.add((Object)aListener);
    }

    public void removeErrorListener(IErrorNotifier.ErrorListener aListener) {
        if (this.errorListeners != null) {
            this.errorListeners.remove((Object)aListener);
        }
    }

    protected void fireErrorStatusChanged() {
        if (this.errorListeners != null) {
            Object[] listeners = this.errorListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IErrorNotifier.ErrorListener)listeners[i]).errorStatusChanged();
                ++i;
            }
        }
    }

    protected void fireAddedError(IErrorHolder.ErrorType e) {
        if (this.errorListeners != null) {
            Object[] listeners = this.errorListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IErrorNotifier.ErrorListener)listeners[i]).errorAdded(e);
                ++i;
            }
        }
    }

    protected void fireClearedError(IErrorHolder.ErrorType e) {
        if (this.errorListeners != null) {
            Object[] listeners = this.errorListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IErrorNotifier.ErrorListener)listeners[i]).errorCleared(e);
                ++i;
            }
        }
    }

    public static class ErrorNotifierAdapter
    extends ErrorNotifier
    implements Adapter {
        private Notifier target;

        public void notifyChanged(Notification notification) {
        }

        public Notifier getTarget() {
            return this.target;
        }

        public void setTarget(Notifier newTarget) {
            this.target = newTarget;
        }

        public boolean isAdapterForType(Object type) {
            return type == ERROR_NOTIFIER_TYPE || type == ERROR_HOLDER_TYPE;
        }
    }
}

