/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.ModelChangeController;
import org.eclipse.ve.internal.propertysheet.IDescriptorPropertySheetEntry;

public abstract class ModelChangeController {
    public static final String MODEL_CHANGE_CONTROLLER_KEY = "org.eclipse.ve.internal.cde.core.ModelChangeController";
    public static final String SETUP_PHASE = "SETUP_PHASE".intern();
    public static final String INIT_VIEWERS_PHASE = "INIT_VIEWERS_PHASE".intern();
    public static final String MODEL_CHANGES_PHASE = "MODEL_CHANGES_PHASE".intern();
    protected int compoundChangeCount = 0;
    private Map uniqueRunnables;
    private boolean inRunnables = false;
    private List phases = new ArrayList();
    protected String holdMsg;
    protected Display display;
    protected int holdState = 0;
    public static final int READY_STATE = 0;
    public static final int BUSY_STATE = 1;
    public static final int NO_UPDATE_STATE = 2;

    public static HashKey createHashKey(Object firstObject, Object secondObject) {
        return new HashKey(firstObject, secondObject);
    }

    public ModelChangeController() {
    }

    public ModelChangeController(Display display) {
        this.display = display;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doModelChanges(Runnable runnable, boolean updatePS) {
        if (this.getHoldState() != 0) {
            return false;
        }
        boolean nested = this.phases.contains(MODEL_CHANGES_PHASE);
        try {
            IDescriptorPropertySheetEntry ps;
            this.transactionBeginning(MODEL_CHANGES_PHASE);
            this.startChange(nested);
            runnable.run();
            if (updatePS && (ps = this.getRootPropertySheetEntry()) != null) {
                ps.refreshFromRoot();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.stopChange(nested);
            this.transactionEnded(MODEL_CHANGES_PHASE);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.stopChange(nested);
            this.transactionEnded(MODEL_CHANGES_PHASE);
            return true;
        }
    }

    protected abstract IDescriptorPropertySheetEntry getRootPropertySheetEntry();

    public synchronized void setHoldState(int stateFlag, String msg) {
        this.holdState = stateFlag;
        this.holdMsg = this.holdState != 0 ? (msg != null ? msg : CDEMessages.ModelChangeController_EditorCannotBeChangedNow) : null;
    }

    public abstract int getHoldState();

    public abstract String getHoldMsg();

    public synchronized boolean inTransaction() {
        return this.compoundChangeCount > 0;
    }

    public synchronized void transactionBeginning(Object phase) {
        ++this.compoundChangeCount;
        if (phase != null) {
            this.phases.add(phase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionEnded(Object phase) {
        boolean executeRunnables = false;
        ModelChangeController modelChangeController = this;
        synchronized (modelChangeController) {
            if (phase == null || this.phases.remove(phase)) {
                --this.compoundChangeCount;
                if (this.compoundChangeCount <= 0) {
                    this.compoundChangeCount = 0;
                    this.phases.clear();
                    executeRunnables = this.uniqueRunnables != null && !this.uniqueRunnables.isEmpty();
                }
            }
        }
        if (executeRunnables) {
            if (this.display != null && Display.getCurrent() != this.display) {
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        ModelChangeController.this.executeAsyncRunnables();
                    }
                });
            } else {
                this.executeAsyncRunnables();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAsyncRunnables() {
        class SafeRunnable
        implements ISafeRunnable {
            public Runnable runnable;
            final /* synthetic */ ModelChangeController this$0;

            SafeRunnable(ModelChangeController modelChangeController) {
                this.this$0 = modelChangeController;
            }

            public void handleException(Throwable exception) {
                CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", exception));
            }

            public void run() {
                this.runnable.run();
            }
        }
        SafeRunnable sr = new SafeRunnable(this);
        while (true) {
            Runnable[] runnables;
            ModelChangeController modelChangeController = this;
            synchronized (modelChangeController) {
                Collection ur = this.getUniqueRunnables().values();
                runnables = ur.toArray(new Runnable[ur.size()]);
                ur.clear();
                this.inRunnables = true;
            }
            int i = 0;
            while (i < runnables.length) {
                sr.runnable = runnables[i];
                Platform.run((ISafeRunnable)sr);
                ++i;
            }
            modelChangeController = this;
            synchronized (modelChangeController) {
                if (this.inTransaction() || this.getUniqueRunnables().isEmpty()) {
                    this.inRunnables = false;
                    break;
                }
            }
        }
    }

    protected Map getUniqueRunnables() {
        if (this.uniqueRunnables == null) {
            this.uniqueRunnables = new LinkedHashMap(50);
        }
        return this.uniqueRunnables;
    }

    public synchronized void execAtEndOfTransaction(Runnable aRunnable) {
        this.execAtEndOfTransaction(aRunnable, new Object());
    }

    public synchronized void execAtEndOfTransaction(Runnable aRunnable, Object once) {
        if (this.inTransaction() || this.inRunnables) {
            if (!this.getUniqueRunnables().containsKey(once)) {
                this.getUniqueRunnables().put(once, aRunnable);
            }
        } else {
            Display.getDefault().asyncExec(aRunnable);
        }
    }

    public synchronized boolean execAtEndOfTransaction(Runnable aRunnable, Object once, Object excludingPhase) {
        if (!this.phases.contains(excludingPhase)) {
            this.execAtEndOfTransaction(aRunnable, once);
            return true;
        }
        return false;
    }

    public synchronized boolean execAtEndOfTransaction(Runnable aRunnable, Object once, Object[] excludingPhases) {
        if (excludingPhases != null) {
            int i = 0;
            while (i < excludingPhases.length) {
                if (this.phases.contains(excludingPhases[i])) {
                    return false;
                }
                ++i;
            }
        }
        this.execAtEndOfTransaction(aRunnable, once);
        return true;
    }

    protected abstract void startChange(boolean var1);

    protected abstract void stopChange(boolean var1);

    public void setHoldChanges(boolean flag, String reasonMsg) {
    }

    public boolean isHoldChanges() {
        return false;
    }

    protected static class HashKey {
        Object firstObject;
        Object secondObject;

        public HashKey(Object aFirstObject, Object aSecondObject) {
            this.firstObject = aFirstObject;
            this.secondObject = aSecondObject;
        }

        public boolean equals(Object anotherObject) {
            if (anotherObject instanceof HashKey) {
                HashKey parm = (HashKey)anotherObject;
                return parm.firstObject.equals(this.firstObject) && parm.secondObject.equals(this.secondObject);
            }
            return super.equals(anotherObject);
        }

        public int hashCode() {
            return this.firstObject.hashCode() + this.secondObject.hashCode();
        }
    }
}

