/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class RestorePreferredSizeAction
extends SelectionAction {
    public static final String ACTION_ID = "cde.RESTOREPREFERREDSIZE";

    public RestorePreferredSizeAction() {
        super(null);
        this.setText(CDEMessages.RestorePreferredSizeAction_label);
        this.setToolTipText(CDEMessages.RestorePreferredSizeAction_tooltip);
        this.setId(ACTION_ID);
        String graphicName = "resetsize_obj.gif";
        this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/elcl16/" + graphicName));
        this.setHoverImageDescriptor(this.getImageDescriptor());
        this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/dlcl16/" + graphicName));
    }

    protected Command createResetToPreferredSizeCommand(List objects) {
        if (objects.size() < 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Request resizeRequest = new Request((Object)"restore preferred");
        CompoundCommand compoundCmd = new CompoundCommand();
        Iterator itr = objects.iterator();
        while (itr.hasNext()) {
            Command cmd;
            Object next = itr.next();
            if (!(next instanceof EditPart) || (cmd = ((EditPart)next).getCommand(resizeRequest)) == null) continue;
            compoundCmd.append(cmd);
        }
        return compoundCmd;
    }

    public void run() {
        this.execute(this.createResetToPreferredSizeCommand(this.getSelectedObjects()));
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createResetToPreferredSizeCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void setWorkbenchPart(IWorkbenchPart part) {
        super.setWorkbenchPart(part);
    }
}

