/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ve.internal.cde.commands.NoOpCommand;
import org.eclipse.ve.internal.cde.core.AlignmentChildCommandRequest;
import org.eclipse.ve.internal.cde.core.AlignmentCommandRequest;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.ChildRequest;
import org.eclipse.ve.internal.cde.core.CursorHelper;
import org.eclipse.ve.internal.cde.core.CustomizeLayoutWindowAction;
import org.eclipse.ve.internal.cde.core.DistributeChildCommandRequest;
import org.eclipse.ve.internal.cde.core.DistributeCommandRequest;
import org.eclipse.ve.internal.cde.core.GridController;
import org.eclipse.ve.internal.cde.core.GridFigure;
import org.eclipse.ve.internal.cde.core.IGridListener;
import org.eclipse.ve.internal.cde.core.IZoomListener;
import org.eclipse.ve.internal.cde.core.PrimaryDragRoleEditPolicy;
import org.eclipse.ve.internal.cde.core.ZoomController;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public abstract class XYLayoutEditPolicy
extends org.eclipse.gef.editpolicies.XYLayoutEditPolicy
implements IZoomListener,
IGridListener,
IActionFilter {
    public static final String LAYOUT_ID = "org.eclipse.ve.internal.cde.core.XYLayout";
    private ZoomController zoomController;
    private GridController gridController;
    private GridFigure gridFigure;
    private IFigure targetFeedback;
    protected IFigure fCursorFigure = null;
    protected Cursor currentFeedbackCursor;
    protected CursorHelper fCursorHelper = null;
    private Label cursorLabel = null;
    private Label yCursorLabel = null;
    ArrayList feedbackList;
    protected boolean allowZooming = false;
    protected boolean allowGridding = true;
    private IFigure sizeOnDropFeedback = null;
    private EditPartListener editPartListener;
    private boolean fShowGrid = false;
    protected boolean fSnapToGrid = false;
    private PropertyChangeListener fPropertyChangeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void setGriddable(boolean allowGridding) {
        this.allowGridding = allowGridding;
    }

    protected abstract Object modelToFigureConstraint(Object var1);

    public void setZoomable(boolean allowZooming) {
        this.allowZooming = allowZooming;
    }

    public void activate() {
        super.activate();
        if (this.allowZooming) {
            this.zoomController = ZoomController.getZoomController(this.getHost());
            if (this.zoomController != null) {
                this.zoomController.addZoomListener(this);
                this.zoomChanged(this.zoomController.getZoomValue(), 0);
            }
        }
        if (this.allowGridding) {
            this.gridController = new GridController();
            if (this.gridController != null) {
                this.gridFigure = this.createGridFigure();
                this.gridFigure.setVisible(false);
                IFigure fig = ((GraphicalEditPart)this.getHost()).getFigure();
                fig.add((IFigure)this.gridFigure);
                this.gridController.addGridListener(this);
                GridController.registerEditPart(this.getHost(), this.gridController);
                if (CDEPlugin.getPlugin().getPluginPreferences().getBoolean("SHOW_GRID_WHEN_SELECTED") && (this.getHost().getSelected() == 1 || this.getHost().getSelected() == 2)) {
                    this.gridController.setGridShowing(true);
                }
                this.editPartListener = this.createEditPartListener();
                this.getHost().addEditPartListener(this.editPartListener);
                List children = this.getHost().getChildren();
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    ((EditPart)iterator.next()).addEditPartListener(this.editPartListener);
                }
            }
        }
        EditPartViewer editPartViewer = this.getHost().getViewer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.AlignmentXYGridPropertiesPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CustomizeLayoutWindowAction.addLayoutCustomizationPage(editPartViewer, clazz);
        EditPartViewer editPartViewer2 = this.getHost().getViewer();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ve.internal.cde.core.AlignmentXYComponentPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CustomizeLayoutWindowAction.addComponentCustomizationPage(editPartViewer2, clazz2);
    }

    public void deactivate() {
        if (this.zoomController != null) {
            this.zoomController.removeZoomListener(this);
            this.zoomController = null;
        }
        if (this.gridController != null) {
            this.gridController.removeGridListener(this);
            GridController.unregisterEditPart(this.getHost());
            this.gridController = null;
            IFigure fig = ((GraphicalEditPart)this.getHost()).getFigure();
            fig.remove((IFigure)this.gridFigure);
            this.gridFigure = null;
        }
        this.undecorateChildren();
        if (this.editPartListener != null) {
            this.getHost().removeEditPartListener(this.editPartListener);
            List children = this.getHost().getChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                ((EditPart)iterator.next()).removeEditPartListener(this.editPartListener);
            }
            this.editPartListener = null;
        }
        if (this.fPropertyChangeListener != null) {
            this.getHost().getRoot().getViewer().removePropertyChangeListener(this.fPropertyChangeListener);
        }
        super.deactivate();
    }

    public void zoomChanged(int newValue, int oldValue) {
        Iterator iter = this.getHost().getChildren().iterator();
        while (iter.hasNext()) {
            EditPart child = (EditPart)iter.next();
            Object modelConstraint = this.getChildConstraint(child);
            Rectangle figureConstraint = (Rectangle)this.modelToFigureConstraint(modelConstraint);
            this.setConstraintToFigure(child, figureConstraint);
        }
        if (this.gridController != null) {
            this.gridFigure.repaint();
        }
    }

    public void gridWidthChanged(int newWidth, int oldWidth) {
        if (this.gridController.isGridShowing()) {
            this.gridFigure.repaint();
        }
    }

    public void gridHeightChanged(int newHeight, int oldHeight) {
        if (this.gridController.isGridShowing()) {
            this.gridFigure.repaint();
        }
    }

    public void gridMarginChanged(int newMargin, int oldMargin) {
        if (this.gridController.isGridShowing()) {
            this.gridFigure.repaint();
        }
    }

    public void gridVisibilityChanged(boolean showGrid) {
        if (showGrid) {
            this.showGridFigure();
        } else {
            this.eraseGridFigure();
        }
        this.fShowGrid = showGrid;
    }

    private void showGridFigure() {
        if (!this.fShowGrid && this.gridFigure != null) {
            this.gridFigure.setVisible(true);
        }
    }

    private void eraseGridFigure() {
        if (this.gridFigure != null) {
            this.gridFigure.setVisible(false);
        }
    }

    public Command getCommand(Request request) {
        if ("distribute child".equals(request.getType())) {
            return this.getDistributeChildCommand(request);
        }
        if ("cde align child".equals(request.getType())) {
            return this.getAlignmentChildCommand(request);
        }
        if ("restore preferred child".equals(request.getType())) {
            return this.getRestorePreferredSizeChildCommand(request);
        }
        return super.getCommand(request);
    }

    protected abstract boolean isChildResizeable(EditPart var1);

    protected abstract Object getChildConstraint(EditPart var1);

    protected abstract void setConstraintToFigure(EditPart var1, Rectangle var2);

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint) {
        return this.createChangeConstraintCommand(childEditPart, constraint, false, true);
    }

    protected abstract Command createChangeConstraintCommand(EditPart var1, Object var2, boolean var3, boolean var4);

    protected Command getResizeChildrenCommand(ChangeBoundsRequest req) {
        CompoundCommand changeConstraintCmd = new CompoundCommand();
        List children = req.getEditParts();
        boolean move = req.getMoveDelta().x != 0 || req.getMoveDelta().y != 0;
        boolean resize = req.getSizeDelta().width != 0 || req.getSizeDelta().height != 0;
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            Rectangle constraint = (Rectangle)this.getConstraintFor(req, child);
            if (!resize || constraint.width >= 0 && constraint.height >= 0) {
                Command c = this.createChangeConstraintCommand((EditPart)child, this.translateToModelConstraint(constraint), move, resize);
                changeConstraintCmd.append(c);
            }
            ++i;
        }
        return changeConstraintCmd.isEmpty() ? null : changeConstraintCmd.unwrap();
    }

    protected EditPolicy createChildEditPolicy(EditPart aPart) {
        ResizableEditPolicy dragRolePolicy = this.isChildResizeable(aPart) ? new ResizableEditPolicy() : new NonResizableEditPolicy();
        return new PrimaryDragRoleEditPolicy((EditPolicy)dragRolePolicy, true);
    }

    protected Command getAlignmentChildCommand(Request request) {
        AlignmentCommandRequest alignReq = ((AlignmentChildCommandRequest)request).getAlignmentRequest();
        Point clientAreaOffset = this.getHostFigure().getClientArea().getLocation().negate();
        Rectangle anchorRect = new Rectangle(((GraphicalEditPart)alignReq.getAnchorObject()).getFigure().getBounds());
        anchorRect.translate(clientAreaOffset);
        anchorRect = (Rectangle)this.getConstraintFor(anchorRect);
        EditPart child = ((AlignmentChildCommandRequest)request).getChildEditPart();
        Rectangle currRect = new Rectangle(((GraphicalEditPart)child).getFigure().getBounds());
        currRect.translate(clientAreaOffset);
        currRect = (Rectangle)this.getConstraintFor(currRect);
        Rectangle newRect = this.getNewPosition(alignReq.getAlignType(), anchorRect, currRect);
        if (this.isAlignmentResize(alignReq.getAlignType()) && !this.isChildResizeable(child)) {
            return UnexecutableCommand.INSTANCE;
        }
        Command cmd = this.createChangeConstraintCommand(child, this.translateToModelConstraint(newRect), this.isAlignmentMove(alignReq.getAlignType()), this.isAlignmentResize(alignReq.getAlignType()));
        return cmd != null ? cmd : NoOpCommand.INSTANCE;
    }

    protected boolean isAlignmentResize(int alignType) {
        return alignType == 6 || alignType == 7;
    }

    protected boolean isAlignmentMove(int alignType) {
        return !this.isAlignmentResize(alignType);
    }

    protected Rectangle getNewPosition(int alignType, Rectangle anchorRect, Rectangle currRect) {
        switch (alignType) {
            case 0: {
                return new Rectangle(anchorRect.x, currRect.y, currRect.width, currRect.height);
            }
            case 1: {
                int delta = anchorRect.x + anchorRect.width / 2 - (currRect.x + currRect.width / 2);
                return new Rectangle(currRect.x + delta, currRect.y, currRect.width, currRect.height);
            }
            case 2: {
                int delta = anchorRect.x + anchorRect.width - (currRect.x + currRect.width);
                return new Rectangle(currRect.x + delta, currRect.y, currRect.width, currRect.height);
            }
            case 3: {
                return new Rectangle(currRect.x, anchorRect.y, currRect.width, currRect.height);
            }
            case 4: {
                int delta = anchorRect.y + anchorRect.height / 2 - (currRect.y + currRect.height / 2);
                return new Rectangle(currRect.x, currRect.y + delta, currRect.width, currRect.height);
            }
            case 5: {
                int delta = anchorRect.y + anchorRect.height - (currRect.y + currRect.height);
                return new Rectangle(currRect.x, currRect.y + delta, currRect.width, currRect.height);
            }
            case 6: {
                return new Rectangle(currRect.x, currRect.y, anchorRect.width, currRect.height);
            }
            case 7: {
                return new Rectangle(currRect.x, currRect.y, currRect.width, anchorRect.height);
            }
        }
        return new Rectangle(anchorRect.x, currRect.y, currRect.width, currRect.height);
    }

    protected Command getDistributeChildCommand(Request request) {
        DistributeCommandRequest distReq = ((DistributeChildCommandRequest)request).getDistributeRequest();
        EditPart child = ((DistributeChildCommandRequest)request).getChildEditPart();
        Rectangle newRect = distReq.getBounds();
        newRect.translate(this.getHostFigure().getClientArea().getLocation().negate());
        Rectangle relativeRect = (Rectangle)this.getConstraintFor(newRect);
        newRect.x = relativeRect.x;
        newRect.y = relativeRect.y;
        Command cmd = this.createChangeConstraintCommand(child, this.translateToModelConstraint(newRect), true, false);
        return cmd != null ? cmd : NoOpCommand.INSTANCE;
    }

    protected Command getRestorePreferredSizeChildCommand(Request request) {
        GraphicalEditPart child = (GraphicalEditPart)((ChildRequest)request).getChildEditPart();
        Point clientAreaOffset = this.getHostFigure().getClientArea().getLocation().negate();
        Rectangle currRect = new Rectangle(child.getFigure().getBounds());
        currRect.translate(clientAreaOffset);
        currRect = (Rectangle)this.getConstraintFor(currRect);
        currRect.height = -1;
        currRect.width = -1;
        Command cmd = this.createChangeConstraintCommand((EditPart)child, this.translateToModelConstraint(currRect), false, true);
        return cmd != null ? cmd : NoOpCommand.INSTANCE;
    }

    protected Command getResetToPreferredSizeChildCommand(Request request) {
        return null;
    }

    public Object getConstraintFor(Point p) {
        Rectangle rect = (Rectangle)super.getConstraintFor(p);
        if (this.zoomController != null) {
            rect.setLocation(this.zoomController.unzoomCoordinate(rect.x), this.zoomController.unzoomCoordinate(rect.y));
        }
        return rect;
    }

    public Object getConstraintFor(Rectangle r) {
        Rectangle rect = (Rectangle)super.getConstraintFor(r);
        if (this.zoomController != null) {
            rect.setLocation(this.zoomController.unzoomCoordinate(rect.x), this.zoomController.unzoomCoordinate(rect.y));
        }
        return rect;
    }

    protected IFigure createDragTargetFeedbackFigure(Rectangle rect) {
        RectangleFigure r = new RectangleFigure();
        FigureUtilities.makeGhostShape((Shape)r);
        r.setForegroundColor(ColorConstants.darkGray);
        r.setBounds(rect);
        return r;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (!this.fShowGrid) {
            this.eraseGridFigure();
        }
        super.eraseLayoutTargetFeedback(request);
        if (this.cursorLabel != null) {
            this.cursorLabel = null;
        }
        if (this.yCursorLabel != null) {
            this.yCursorLabel = null;
        }
        if (this.fCursorFigure != null) {
            this.fCursorFigure = null;
        }
        if (this.fCursorHelper != null) {
            this.fCursorHelper.dispose();
            this.fCursorHelper = null;
        }
        if (this.feedbackList != null) {
            int i = 0;
            while (i < this.feedbackList.size()) {
                this.removeFeedback((IFigure)this.feedbackList.get(i));
                ++i;
            }
            this.feedbackList = null;
        }
        if (this.sizeOnDropFeedback != null) {
            this.removeFeedback(this.sizeOnDropFeedback);
            this.sizeOnDropFeedback = null;
        }
        if (this.targetFeedback != null) {
            this.removeFeedback(this.targetFeedback);
            this.targetFeedback = null;
        }
    }

    protected void showCursorFeedback(Request aRequest) {
        Point position = this.getLocationFromRequest(aRequest).getCopy();
        org.eclipse.swt.graphics.Point absolutePosition = this.getHost().getViewer().getControl().toDisplay(position.x, position.y);
        absolutePosition.x += 13;
        absolutePosition.y += 6;
        position.translate(-this.getHostFigure().getBounds().x, -this.getHostFigure().getBounds().y);
        if (this.cursorLabel == null) {
            this.cursorLabel = new Label();
            this.cursorLabel.setOpaque(true);
            this.cursorLabel.setBorder((Border)new MarginBorder(new Insets(0, 2, 0, 0)));
            this.cursorLabel.setBackgroundColor(Display.getDefault().getSystemColor(29));
            this.cursorLabel.setFont(new Font((Device)Display.getDefault(), "Tahoma", 8, 0));
        }
        this.cursorLabel.setText(MessageFormat.format(CDEMessages.XYLayoutEditPolicy_CursorFeedback_X_Y, String.valueOf(position.x), String.valueOf(position.y)));
        if (this.fCursorFigure == null) {
            this.fCursorFigure = new Figure();
            FlowLayout fl = new FlowLayout();
            fl.setMinorSpacing(1);
            this.fCursorFigure.setLayoutManager((LayoutManager)fl);
            this.fCursorFigure.setBorder((Border)new LineBorder());
            this.fCursorFigure.setOpaque(true);
            this.fCursorFigure.setBackgroundColor(ColorConstants.black);
        }
        this.fCursorFigure.add((IFigure)this.cursorLabel);
        if (this.fCursorHelper == null) {
            this.fCursorHelper = new CursorHelper(this.getHost().getViewer().getControl());
        }
        this.fCursorHelper.showCursorFigure(this.fCursorFigure, absolutePosition.x, absolutePosition.y);
    }

    protected Point getLocationFromRequest(Request request) {
        if (request instanceof CreateRequest) {
            return ((CreateRequest)request).getLocation();
        }
        if (request instanceof ChangeBoundsRequest) {
            return ((ChangeBoundsRequest)request).getLocation();
        }
        return null;
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        Rectangle rect = (Rectangle)super.getConstraintFor(request, child);
        return rect;
    }

    protected ZoomController getZoomController() {
        return this.zoomController;
    }

    protected GridController getGridController() {
        return this.gridController;
    }

    protected GridFigure getGridFigure() {
        return this.gridFigure;
    }

    protected GridFigure createGridFigure() {
        return new GridFigure(this.gridController, this.zoomController);
    }

    protected void showLayoutTargetFeedback(Request request) {
        this.showCursorFeedback(request);
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.startsWith("showgrid") && value.equals("false") && !this.gridController.isGridShowing()) {
            return true;
        }
        if (name.startsWith("showgrid") && value.equals("true") && this.gridController.isGridShowing()) {
            return true;
        }
        if (name.startsWith("LAYOUTPOLICY") && value.equals(LAYOUT_ID)) {
            return true;
        }
        return name.startsWith("snaptogrid");
    }

    protected void undecorateChildren() {
        Iterator children = this.getHost().getChildren().iterator();
        while (children.hasNext()) {
            this.undecorateChild((EditPart)children.next());
        }
    }

    protected void undecorateChild(EditPart child) {
        child.removeEditPolicy((Object)"PrimaryDrag Policy");
    }

    protected void decorateChild(EditPart child) {
        super.decorateChild(child);
    }

    private EditPartListener createEditPartListener() {
        return new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart editpart) {
                if (CDEPlugin.getPlugin().getPluginPreferences().getBoolean("SHOW_GRID_WHEN_SELECTED")) {
                    if (!(editpart != null && editpart != XYLayoutEditPolicy.this.getHost() && !XYLayoutEditPolicy.this.isChildEditPart(editpart) || editpart.getSelected() != 1 && editpart.getSelected() != 2)) {
                        if (XYLayoutEditPolicy.this.gridController != null) {
                            XYLayoutEditPolicy.this.gridController.setGridShowing(true);
                        }
                    } else if (XYLayoutEditPolicy.this.gridController != null) {
                        XYLayoutEditPolicy.this.gridController.setGridShowing(false);
                    }
                } else if (XYLayoutEditPolicy.this.gridController != null && XYLayoutEditPolicy.this.gridController.isGridShowing()) {
                    XYLayoutEditPolicy.this.gridController.setGridShowing(false);
                }
            }

            public void childAdded(EditPart editpart, int index) {
                if (XYLayoutEditPolicy.this.editPartListener != null) {
                    editpart.addEditPartListener(XYLayoutEditPolicy.this.editPartListener);
                }
            }

            public void removingChild(EditPart editpart, int index) {
                if (XYLayoutEditPolicy.this.editPartListener != null) {
                    editpart.removeEditPartListener(XYLayoutEditPolicy.this.editPartListener);
                }
            }
        };
    }

    private boolean isChildEditPart(EditPart ep) {
        List children;
        if (ep != null && !(children = this.getHost().getChildren()).isEmpty()) {
            return children.indexOf(ep) != -1;
        }
        return false;
    }
}

