/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IContainmentHandler;
import org.eclipse.ve.internal.cde.core.IModelAdapterFactory;

public abstract class AbstractEMFContainerPolicy
extends ContainerPolicy {
    protected static final int ADD_REQ = 0;
    protected static final int CREATE_REQ = 1;
    protected static final int MOVE_REQ = 2;
    protected static final int DELETE_REQ = 3;
    protected static final int ORPHAN_REQ = 4;
    protected EStructuralFeature containmentSF;
    static /* synthetic */ Class class$0;

    public AbstractEMFContainerPolicy(EditDomain domain) {
        this(null, domain);
    }

    public AbstractEMFContainerPolicy(EStructuralFeature feature, EditDomain domain) {
        super(domain);
        this.setContainerFeature(feature);
    }

    protected void setContainerFeature(EStructuralFeature containmentSF) {
        this.containmentSF = containmentSF;
    }

    protected EStructuralFeature getContainmentSF(Object child, Object positionBeforeChild, int requestType) {
        return this.containmentSF;
    }

    protected EStructuralFeature getContainmentSF(List children, Object positionBeforeChild, int requestType) {
        return this.containmentSF;
    }

    protected boolean isValidChild(Object child, EStructuralFeature containmentSF) {
        return containmentSF.getEType().isInstance(child);
    }

    protected boolean isParentAcceptable(Object child) {
        IModelAdapterFactory fact = CDEUtilities.getModelAdapterFactory(this.domain);
        if (fact != null) {
            IContainmentHandler handler;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.IContainmentHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((handler = (IContainmentHandler)fact.getAdapter(child, clazz)) != null) {
                return handler.isParentValid(this.container);
            }
        }
        return true;
    }

    public Command getCreateCommand(Object child, Object positionBeforeChild) {
        EStructuralFeature containmentSF = this.getContainmentSF(child, positionBeforeChild, 1);
        if (containmentSF == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getCreateCommand(child, positionBeforeChild, containmentSF);
    }

    public Command getAddCommand(List children, Object positionBeforeChild) {
        EStructuralFeature containmentSF = this.getContainmentSF(children, positionBeforeChild, 0);
        if (containmentSF == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getAddCommand(children, positionBeforeChild, containmentSF);
    }

    public Command getDeleteDependentCommand(Object child) {
        EStructuralFeature containmentSF = this.getContainmentSF(child, null, 3);
        if (containmentSF == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getDeleteDependentCommand(child, containmentSF);
    }

    public Command getMoveChildrenCommand(List children, Object positionBeforeChild) {
        EStructuralFeature containmentSF = this.getContainmentSF(children, positionBeforeChild, 2);
        if (containmentSF == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getMoveChildrenCommand(children, positionBeforeChild, containmentSF);
    }

    protected Command getOrphanTheChildrenCommand(List children) {
        EStructuralFeature containmentSF = this.getContainmentSF(children, null, 4);
        if (containmentSF == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getOrphanChildrenCommand(children, containmentSF);
    }

    protected Command getCreateCommand(Object child, Object positionBeforeChild, EStructuralFeature containmentSF) {
        if (!this.isValidChild(child, containmentSF) || !this.isParentAcceptable(child)) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.primCreateCommand(child, positionBeforeChild, containmentSF);
    }

    protected Command primCreateCommand(Object child, Object positionBeforeChild, EStructuralFeature containmentSF) {
        if (!containmentSF.isMany() && ((EObject)this.container).eIsSet(containmentSF)) {
            return UnexecutableCommand.INSTANCE;
        }
        CommandBuilder cBld = new CommandBuilder("");
        cBld.applyAttributeSetting((EObject)this.container, containmentSF, child, positionBeforeChild);
        List annotations = AnnotationPolicy.getAllAnnotations(new ArrayList(), child, this.domain.getAnnotationLinkagePolicy());
        return AnnotationPolicy.getCreateRequestCommand(annotations, cBld.getCommand(), this.domain);
    }

    protected Command getAddCommand(List children, Object positionBeforeChild, EStructuralFeature containmentSF) {
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (this.isValidChild(child, containmentSF) && this.isParentAcceptable(child)) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return this.primAddCommand(children, positionBeforeChild, containmentSF);
    }

    protected Command primAddCommand(List children, Object positionBeforeChild, EStructuralFeature containmentSF) {
        if (!containmentSF.isMany() && (((EObject)this.container).eIsSet(containmentSF) || children.size() > 1)) {
            return UnexecutableCommand.INSTANCE;
        }
        CommandBuilder cBld = new CommandBuilder("");
        cBld.applyAttributeSettings((EObject)this.container, containmentSF, children, positionBeforeChild);
        return cBld.getCommand();
    }

    protected Command getDeleteDependentCommand(Object child, EStructuralFeature containmentSF) {
        CommandBuilder cBld = new CommandBuilder("");
        cBld.cancelAttributeSetting((EObject)this.container, containmentSF, child);
        if (containmentSF instanceof EReference && ((EReference)containmentSF).isContainment()) {
            List annotations = AnnotationPolicy.getAllAnnotations(new ArrayList(), child, this.domain.getAnnotationLinkagePolicy());
            return AnnotationPolicy.getDeleteDependentCommand(annotations, cBld.getCommand(), this.domain.getDiagramData());
        }
        return cBld.getCommand();
    }

    protected Command getOrphanChildrenCommand(List children, EStructuralFeature containmentSF) {
        CommandBuilder cBld = new CommandBuilder("");
        cBld.cancelAttributeSettings((EObject)this.container, containmentSF, children);
        return cBld.getCommand();
    }

    protected Command getMoveChildrenCommand(List children, Object positionBeforeChild, EStructuralFeature containmentSF) {
        CommandBuilder cBld = new CommandBuilder("");
        if (children.contains(positionBeforeChild)) {
            return UnexecutableCommand.INSTANCE;
        }
        cBld.cancelAttributeSettings((EObject)this.container, containmentSF, new ArrayList(children));
        cBld.applyAttributeSettings((EObject)this.container, containmentSF, children, positionBeforeChild);
        return cBld.getCommand();
    }
}

