/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import java.util.Iterator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.ve.internal.cde.commands.ApplyVisualConstraintCommand;
import org.eclipse.ve.internal.cde.commands.CancelVisualConstraintCommand;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.IConstraintHandler;
import org.eclipse.ve.internal.cde.core.IModelAdapterFactory;
import org.eclipse.ve.internal.cde.core.KeyedValueNotificationHelper;
import org.eclipse.ve.internal.cde.core.XYLayoutEditPolicy;
import org.eclipse.ve.internal.cde.core.XYLayoutUtility;
import org.eclipse.ve.internal.cde.core.ZoomController;
import org.eclipse.ve.internal.cdm.DiagramFigure;
import org.eclipse.ve.internal.cdm.KeyedValueHolder;
import org.eclipse.ve.internal.cdm.model.Dimension;
import org.eclipse.ve.internal.cdm.model.Point;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class DiagramFigureXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected ContainerPolicy containerPolicy;
    public static final String VISUAL_CONSTRAINT_REFRESH_POLICY = "org.eclipse.ve.internal.cde.core.visualConstraintRefreshPolicy";
    static /* synthetic */ Class class$0;

    public DiagramFigureXYLayoutEditPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public void activate() {
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.containerPolicy.setContainer(null);
    }

    protected Command createAddCommand(EditPart childEditPart, Object constraint) {
        KeyedValueHolder child = (KeyedValueHolder)childEditPart.getModel();
        GroupRequest grpReq = new GroupRequest((Object)"add children");
        grpReq.setEditParts(childEditPart);
        Command addContributionCmd = this.containerPolicy.getCommand((Request)grpReq);
        if (addContributionCmd == null || !addContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand("");
        command.append(this.primChangeConstraintCommand(child, (org.eclipse.ve.internal.cdm.model.Rectangle)constraint, true, true));
        command.append(addContributionCmd);
        return command.unwrap();
    }

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint, boolean moved, boolean resized) {
        return this.primChangeConstraintCommand((KeyedValueHolder)childEditPart.getModel(), (org.eclipse.ve.internal.cdm.model.Rectangle)constraint, moved, resized);
    }

    protected Command getCreateCommand(CreateRequest aRequest) {
        DiagramFigure child = (DiagramFigure)aRequest.getNewObject();
        Command createContributionCmd = this.containerPolicy.getCommand((Request)aRequest);
        if (createContributionCmd == null || !createContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        org.eclipse.ve.internal.cdm.model.Rectangle constraint = (org.eclipse.ve.internal.cdm.model.Rectangle)this.translateToModelConstraint(this.getConstraintFor(aRequest));
        CompoundCommand command = new CompoundCommand("");
        command.append(this.primChangeConstraintCommand((KeyedValueHolder)child, constraint, true, this.isChildResizeable(this.getCreateConstraintHandler(child))));
        command.append(createContributionCmd);
        return command.unwrap();
    }

    protected IConstraintHandler getCreateConstraintHandler(Object child) {
        IConstraintHandler iConstraintHandler;
        IModelAdapterFactory factory = CDEUtilities.getModelAdapterFactory(this.getHost());
        if (factory != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.IConstraintHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iConstraintHandler = (IConstraintHandler)factory.getAdapter(child, clazz);
        } else {
            iConstraintHandler = null;
        }
        return iConstraintHandler;
    }

    protected IConstraintHandler getConstraintHandler(EditPart editpart) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.IConstraintHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IConstraintHandler)editpart.getAdapter((Class)clazz);
    }

    protected Command getDeleteDependantCommand(Request aRequest) {
        Command deleteContributionCmd = this.containerPolicy.getCommand(aRequest);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Command getOrphanChildrenCommand(Request aRequest) {
        Command orphanContributionCmd = this.containerPolicy.getCommand(aRequest);
        if (orphanContributionCmd == null || !orphanContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand("");
        GroupRequest gr = (GroupRequest)aRequest;
        Iterator children = gr.getEditParts().iterator();
        while (children.hasNext()) {
            EditPart childEditPart = (EditPart)children.next();
            DiagramFigure child = (DiagramFigure)childEditPart.getModel();
            CancelVisualConstraintCommand delCommand = new CancelVisualConstraintCommand();
            delCommand.setTarget((KeyedValueHolder)child);
            command.append((Command)delCommand);
        }
        command.append(orphanContributionCmd);
        return command;
    }

    protected Command primChangeConstraintCommand(KeyedValueHolder info, org.eclipse.ve.internal.cdm.model.Rectangle constraint, boolean pointChanged, boolean sizeChanged) {
        Object constraintKV = info.getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey");
        org.eclipse.ve.internal.cdm.model.Rectangle lConstraint = constraintKV instanceof org.eclipse.ve.internal.cdm.model.Rectangle ? (org.eclipse.ve.internal.cdm.model.Rectangle)constraintKV : null;
        if ((pointChanged |= lConstraint == null) || (sizeChanged |= lConstraint == null)) {
            ApplyVisualConstraintCommand viUpdate = new ApplyVisualConstraintCommand("");
            viUpdate.setTarget(info);
            if (pointChanged && sizeChanged) {
                viUpdate.setRectangle(constraint);
            } else if (pointChanged) {
                viUpdate.setLocation(new Point(constraint.x, constraint.y));
            } else {
                viUpdate.setSize(new Dimension(constraint.width, constraint.height));
            }
            return viUpdate;
        }
        return null;
    }

    public Command getCommand(Request request) {
        if ("delete".equals(request.getType())) {
            return this.containerPolicy.getCommand(request);
        }
        return super.getCommand(request);
    }

    protected void refreshFromEditPart(EditPart child, Object constraintValue) {
        Rectangle rect = null;
        org.eclipse.ve.internal.cdm.model.Rectangle constraint = constraintValue instanceof org.eclipse.ve.internal.cdm.model.Rectangle ? (org.eclipse.ve.internal.cdm.model.Rectangle)constraintValue : null;
        rect = constraint == null ? XYLayoutUtility.modifyPreferredRectangle(new Rectangle(), true, true, true) : (Rectangle)this.modelToFigureConstraint(constraint);
        this.setConstraintToFigure(child, rect);
    }

    protected void setConstraintToFigure(EditPart child, Rectangle figureConstraint) {
        IConstraintHandler handler = this.getConstraintHandler(child);
        if (handler != null) {
            int x = figureConstraint.x;
            int y = figureConstraint.y;
            handler.contributeFigureSize(figureConstraint);
            figureConstraint.setLocation(x, y);
        }
        ((GraphicalEditPart)this.getHost()).setLayoutConstraint(child, ((GraphicalEditPart)child).getFigure(), (Object)figureConstraint);
    }

    protected Object translateToModelConstraint(Object figureConstraint) {
        Rectangle r = (Rectangle)figureConstraint;
        return new org.eclipse.ve.internal.cdm.model.Rectangle(r.x, r.y, r.width, r.height);
    }

    protected Object modelToFigureConstraint(Object modelConstraint) {
        if (modelConstraint == null) {
            return null;
        }
        org.eclipse.ve.internal.cdm.model.Rectangle r = (org.eclipse.ve.internal.cdm.model.Rectangle)modelConstraint;
        Rectangle figureConstraint = new Rectangle(r.x, r.y, r.width, r.height);
        ZoomController zoomController = this.getZoomController();
        if (zoomController != null) {
            if (figureConstraint.x != Integer.MIN_VALUE) {
                figureConstraint.x = zoomController.zoomCoordinate(figureConstraint.x);
            }
            if (figureConstraint.y != Integer.MIN_VALUE) {
                figureConstraint.y = zoomController.zoomCoordinate(figureConstraint.y);
            }
        }
        return figureConstraint;
    }

    protected boolean isChildResizeable(EditPart childEditpart) {
        return this.isChildResizeable(this.getConstraintHandler(childEditpart));
    }

    protected boolean isChildResizeable(IConstraintHandler handler) {
        return handler != null ? handler.isResizeable() : false;
    }

    protected Object getChildConstraint(EditPart child) {
        return this.getChildConstraint(child, ((KeyedValueHolder)child.getModel()).getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey"));
    }

    protected Object getChildConstraint(EditPart child, Object kv) {
        return kv instanceof org.eclipse.ve.internal.cdm.model.Rectangle ? new org.eclipse.ve.internal.cdm.model.Rectangle((org.eclipse.ve.internal.cdm.model.Rectangle)kv) : XYLayoutUtility.modifyPreferredCDMRectangle(new org.eclipse.ve.internal.cdm.model.Rectangle(), true, true, true);
    }

    protected void decorateChild(EditPart child) {
        super.decorateChild(child);
        child.installEditPolicy((Object)VISUAL_CONSTRAINT_REFRESH_POLICY, (EditPolicy)new VisualConstraintRefreshPolicy());
    }

    protected class VisualConstraintRefreshPolicy
    extends AbstractEditPolicy {
        private Adapter adapter;

        protected VisualConstraintRefreshPolicy() {
        }

        public void activate() {
            super.activate();
            this.adapter = this.getAdapter();
            KeyedValueHolder target = (KeyedValueHolder)this.getHost().getModel();
            target.eAdapters().add((Object)this.adapter);
            DiagramFigureXYLayoutEditPolicy.this.refreshFromEditPart(this.getHost(), target.getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey"));
        }

        public void deactivate() {
            super.deactivate();
            if (this.adapter != null) {
                this.adapter.getTarget().eAdapters().remove((Object)this.adapter);
            }
            this.adapter = null;
        }

        public EditPart getTargetEditPart(Request request) {
            return null;
        }

        protected Adapter getAdapter() {
            if (this.adapter == null) {
                this.adapter = new AdapterImpl(this){
                    final /* synthetic */ VisualConstraintRefreshPolicy this$1;
                    {
                        this.this$1 = visualConstraintRefreshPolicy;
                    }

                    public void notifyChanged(Notification msg) {
                        Notification keyMsg = KeyedValueNotificationHelper.notifyChanged(msg, "org.eclipse.ve.internal.cdm.model.visualconstraintkey");
                        if (keyMsg != null) {
                            switch (keyMsg.getEventType()) {
                                case 1: {
                                    VisualConstraintRefreshPolicy.access$0(this.this$1).refreshFromEditPart(this.this$1.getHost(), ((BasicEMap.Entry)keyMsg.getNewValue()).getValue());
                                    break;
                                }
                                case 2: {
                                    VisualConstraintRefreshPolicy.access$0(this.this$1).refreshFromEditPart(this.this$1.getHost(), null);
                                }
                            }
                        }
                    }
                };
            }
            return this.adapter;
        }

        static /* synthetic */ DiagramFigureXYLayoutEditPolicy access$0(VisualConstraintRefreshPolicy visualConstraintRefreshPolicy) {
            return visualConstraintRefreshPolicy.DiagramFigureXYLayoutEditPolicy.this;
        }
    }
}

